/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.Dbug;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionServiceImpl;
import com.mysql.ndbjtie.mysql.Utils;
import java.nio.ByteBuffer;

public class DbugImpl
implements Dbug {
    static final I18NHelper local = I18NHelper.getInstance(DbugImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DbugImpl.class);
    private static final int DBUG_SIZE = 256;
    boolean propertyTrace = false;
    String fileName = "";
    Character fileStrategy = Character.valueOf('o');
    String debugList;

    public DbugImpl() {
        ClusterConnectionServiceImpl.loadSystemLibrary("ndbclient");
    }

    @Override
    public String get() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(256);
        String string = Utils.dbugExplain(byteBuffer, 256);
        return string;
    }

    @Override
    public void pop() {
        Utils.dbugPop();
    }

    @Override
    public void push(String string) {
        Utils.dbugPush(string);
    }

    @Override
    public void set(String string) {
        Utils.dbugSet(string);
    }

    @Override
    public void set() {
        this.set(this.toState());
    }

    @Override
    public void push() {
        this.push(this.toState());
    }

    @Override
    public void print(String string, String string2) {
        Utils.dbugPrint(string, string2);
    }

    public Dbug trace(boolean bl) {
        this.propertyTrace = bl;
        return this;
    }

    @Override
    public Dbug trace() {
        return this.trace(true);
    }

    @Override
    public Dbug output(String string) {
        this.fileName = string;
        this.fileStrategy = Character.valueOf('o');
        return this;
    }

    @Override
    public Dbug append(String string) {
        this.fileName = string;
        this.fileStrategy = Character.valueOf('a');
        return this;
    }

    @Override
    public Dbug flush() {
        this.fileStrategy = Character.valueOf(Character.toUpperCase(this.fileStrategy.charValue()));
        return this;
    }

    @Override
    public Dbug debug(String string) {
        this.debugList = string;
        return this;
    }

    @Override
    public Dbug debug(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (String string2 : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append(string2);
            string = ",";
        }
        this.debugList = stringBuilder.toString();
        return this;
    }

    private String toState() {
        String string = "";
        StringBuilder stringBuilder = new StringBuilder();
        if (this.propertyTrace) {
            stringBuilder.append("t");
            string = ":";
        }
        if (this.fileName != null) {
            stringBuilder.append(string);
            stringBuilder.append(this.fileStrategy);
            stringBuilder.append(',');
            stringBuilder.append(this.fileName);
            string = ":";
        }
        if (this.debugList != null) {
            stringBuilder.append(string);
            stringBuilder.append("d,");
            stringBuilder.append(this.debugList);
            string = ":";
        }
        return stringBuilder.toString();
    }
}

