/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.NotPersistentTypes;

public class NotPersistentTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 5;
    protected List<NotPersistentTypes> notPersistentTypes = new ArrayList<NotPersistentTypes>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createNotPersistentTypesInstances(5);
        int n = this.session.deletePersistentAll(NotPersistentTypes.class);
        this.addTearDownClasses(NotPersistentTypes.class);
    }

    public void test() {
        this.defaultValues();
        this.setValues();
        this.insert();
        this.find();
        this.query();
        this.badQuery();
        this.delete();
        this.failOnError();
    }

    protected void defaultValues() {
        NotPersistentTypes notPersistentTypes = (NotPersistentTypes)this.session.newInstance(NotPersistentTypes.class);
        this.errorIfNotEqual("NotPersistentInteger default value.", null, notPersistentTypes.getNotPersistentInteger());
        this.errorIfNotEqual("NotPersistentChildren default value.", null, notPersistentTypes.getNotPersistentChildren());
        this.errorIfNotEqual("NotPersistentInt default value.", 0, notPersistentTypes.getNotPersistentInt());
        this.errorIfNotEqual("Id default value.", 0, notPersistentTypes.getId());
        this.errorIfNotEqual("Name default value.", null, notPersistentTypes.getName());
        this.errorIfNotEqual("Magic default value.", 0, notPersistentTypes.getMagic());
        this.errorIfNotEqual("Age default value.", null, notPersistentTypes.getAge());
    }

    protected void setValues() {
        NotPersistentTypes notPersistentTypes = this.notPersistentTypes.get(0);
        ArrayList<NotPersistentTypes> arrayList = new ArrayList<NotPersistentTypes>();
        arrayList.add(this.notPersistentTypes.get(1));
        arrayList.add(this.notPersistentTypes.get(2));
        notPersistentTypes.setNotPersistentChildren(arrayList);
        this.errorIfNotEqual("NotPersistentInteger default value.", arrayList, notPersistentTypes.getNotPersistentChildren());
        int n = 666;
        notPersistentTypes.setNotPersistentInt(n);
        this.errorIfNotEqual("NotPersistentChildren default value.", n, notPersistentTypes.getNotPersistentInt());
        Integer n2 = n;
        notPersistentTypes.setNotPersistentInteger(n2);
        this.errorIfNotEqual("NotPersistentInt default value.", n2, notPersistentTypes.getNotPersistentInteger());
    }

    protected void insert() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        for (int i = 0; i < 5; ++i) {
            this.session.makePersistent((Object)this.notPersistentTypes.get(i));
        }
        this.tx.commit();
    }

    protected void find() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        for (int i = 0; i < 5; ++i) {
            NotPersistentTypes notPersistentTypes = (NotPersistentTypes)this.session.find(NotPersistentTypes.class, (Object)i);
            this.errorIfNotEqual("Wrong instance", i, notPersistentTypes.getId());
        }
        this.tx.commit();
    }

    protected void query() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(NotPersistentTypes.class);
        queryDomainType.where(queryDomainType.get("id").equal(queryDomainType.param("id")));
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("id", (Object)0);
        List list = query.getResultList();
        int n = list.size();
        this.errorIfNotEqual("Wrong query result size", 1, n);
        NotPersistentTypes notPersistentTypes = (NotPersistentTypes)list.get(0);
        int n2 = notPersistentTypes.getId();
        this.tx.commit();
        this.errorIfNotEqual("Wrong query result instance id 0", 0, n2);
    }

    protected void badQuery() {
        try {
            QueryBuilder queryBuilder = this.session.getQueryBuilder();
            QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(NotPersistentTypes.class);
            queryDomainType.where(queryDomainType.get("notPersistentChildren").equal(queryDomainType.param("id")));
            this.error("Failed to catch user exception for not-persistent query field");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
    }

    protected void delete() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        for (int i = 0; i < 5; ++i) {
            this.session.deletePersistent((Object)this.notPersistentTypes.get(i));
        }
        this.tx.commit();
    }

    protected void createNotPersistentTypesInstances(int n) {
        this.notPersistentTypes = new ArrayList<NotPersistentTypes>(n);
        for (int i = 0; i < n; ++i) {
            NotPersistentTypes notPersistentTypes = (NotPersistentTypes)this.session.newInstance(NotPersistentTypes.class);
            notPersistentTypes.setId(i);
            notPersistentTypes.setName("Employee number " + i);
            notPersistentTypes.setAge(i);
            notPersistentTypes.setMagic(i);
            this.notPersistentTypes.add(notPersistentTypes);
        }
    }
}

