/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.BitTypes;
import testsuite.clusterj.model.IdBase;

public class BitTypesTest
extends AbstractClusterJModelTest {
    static int NUMBER_OF_INSTANCES = 10;
    static AbstractClusterJModelTest.ColumnDescriptor bit1 = new AbstractClusterJModelTest.ColumnDescriptor("bit1", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase idBase, Object object) {
            ((BitTypes)idBase).setBit1((Boolean)object);
        }

        @Override
        public Object getFieldValue(IdBase idBase) {
            return ((BitTypes)idBase).getBit1();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            preparedStatement.setBoolean(n, (Boolean)object);
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBoolean(n);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit2 = new AbstractClusterJModelTest.ColumnDescriptor("bit2", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase idBase, Object object) {
            ((BitTypes)idBase).setBit2((Byte)object);
        }

        @Override
        public Object getFieldValue(IdBase idBase) {
            return ((BitTypes)idBase).getBit2();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            preparedStatement.setByte(n, (Byte)object);
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getByte(n);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit4 = new AbstractClusterJModelTest.ColumnDescriptor("bit4", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase idBase, Object object) {
            ((BitTypes)idBase).setBit4((Short)object);
        }

        @Override
        public Object getFieldValue(IdBase idBase) {
            return ((BitTypes)idBase).getBit4();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            preparedStatement.setShort(n, (Short)object);
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getShort(n);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit8 = new AbstractClusterJModelTest.ColumnDescriptor("bit8", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase idBase, Object object) {
            ((BitTypes)idBase).setBit8((Integer)object);
        }

        @Override
        public Object getFieldValue(IdBase idBase) {
            return ((BitTypes)idBase).getBit8();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            preparedStatement.setInt(n, (Integer)object);
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getInt(n);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit16 = new AbstractClusterJModelTest.ColumnDescriptor("bit16", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase idBase, Object object) {
            ((BitTypes)idBase).setBit16((Long)object);
        }

        @Override
        public Object getFieldValue(IdBase idBase) {
            return ((BitTypes)idBase).getBit16();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            preparedStatement.setLong(n, (Long)object);
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getLong(n);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit32 = new AbstractClusterJModelTest.ColumnDescriptor("bit32", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase idBase, Object object) {
            ((BitTypes)idBase).setBit32((Integer)object);
        }

        @Override
        public Object getFieldValue(IdBase idBase) {
            return ((BitTypes)idBase).getBit32();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            preparedStatement.setInt(n, (Integer)object);
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getInt(n);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit64 = new AbstractClusterJModelTest.ColumnDescriptor("bit64", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase idBase, Object object) {
            ((BitTypes)idBase).setBit64((Long)object);
        }

        @Override
        public Object getFieldValue(IdBase idBase) {
            return ((BitTypes)idBase).getBit64();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            preparedStatement.setLong(n, (Long)object);
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getLong(n);
        }
    });
    protected static AbstractClusterJModelTest.ColumnDescriptor[] columnDescriptors = new AbstractClusterJModelTest.ColumnDescriptor[]{bit1, bit2, bit4, bit8, bit16, bit32, bit64};

    @Override
    protected boolean getDebug() {
        return false;
    }

    @Override
    protected int getNumberOfInstances() {
        return NUMBER_OF_INSTANCES;
    }

    @Override
    protected String getTableName() {
        return "bittypes";
    }

    @Override
    protected boolean getCleanupAfterTest() {
        return false;
    }

    @Override
    Class<? extends IdBase> getModelClass() {
        return BitTypes.class;
    }

    @Override
    protected Object getColumnValue(int n, int n2) {
        int n3 = (int)Math.pow(2.0, n2);
        switch (n3) {
            case 1: {
                boolean bl;
                boolean bl2 = bl = n % 2 == 0;
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + n + ", " + n2 + " " + columnDescriptors[n2].getColumnName() + "  is (boolean)" + bl);
                }
                return bl;
            }
            case 2: {
                int n4 = 0;
                for (int i = 0; i < n3; ++i) {
                    n4 = 3 & n4 * 2 + (int)(Math.random() * 2.0);
                }
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + n + ", " + n2 + " " + columnDescriptors[n2].getColumnName() + "  is (byte)" + n4);
                }
                return (byte)n4;
            }
            case 4: {
                int n5 = 0;
                for (int i = 0; i < n3; ++i) {
                    n5 = 0xF & n5 * 2 + (int)(Math.random() * 2.0);
                }
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + n + ", " + n2 + " " + columnDescriptors[n2].getColumnName() + "  is (short)" + n5);
                }
                return (short)n5;
            }
            case 8: 
            case 32: {
                int n6 = n3 == 8 ? 255 : -1;
                int n7 = 0;
                for (int i = 0; i < n3; ++i) {
                    n7 = n7 * 2 + (int)(Math.random() * 2.0);
                }
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + n + ", " + n2 + " " + columnDescriptors[n2].getColumnName() + "  is (int)" + n7);
                }
                n7 = Math.abs(n7);
                return n6 & n7;
            }
            case 16: 
            case 64: {
                long l = n3 == 16 ? 65535L : -1L;
                long l2 = 0L;
                for (int i = 0; i < n3 / 8; ++i) {
                    l2 = l2 * 256L + (long)(n * 16) + (long)i;
                }
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + n + ", " + n2 + " " + columnDescriptors[n2].getColumnName() + "  is (long)" + l2);
                }
                return l & l2;
            }
        }
        BitTypesTest.fail("Bad length: " + n3);
        return null;
    }

    @Override
    protected void verify(String string, List<Object[]> list, List<Object[]> list2) {
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray = list.get(i);
            Object[] objectArray2 = list2.get(i);
            this.errorIfNotEqual(string + " got failure on id for row " + i, i, objectArray2[0]);
            block8: for (int j = 1; j < objectArray.length; ++j) {
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.verify for " + i + ", " + j + " " + columnDescriptors[j - 1].getColumnName() + "  is (" + objectArray2[j].getClass().getName() + ")" + objectArray2[j]);
                }
                switch (j) {
                    case 1: {
                        Boolean bl = (Boolean)objectArray[j];
                        Boolean bl2 = (Boolean)objectArray2[j];
                        this.errorIfNotEqual(string + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), bl, bl2);
                        continue block8;
                    }
                    case 2: {
                        byte by = (Byte)objectArray[j];
                        byte by2 = (Byte)objectArray2[j];
                        this.errorIfNotEqual(string + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), Integer.toHexString(by), Integer.toHexString(by2));
                        continue block8;
                    }
                    case 3: {
                        short s = (Short)objectArray[j];
                        short s2 = (Short)objectArray2[j];
                        this.errorIfNotEqual(string + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), Integer.toHexString(s), Integer.toHexString(s2));
                        continue block8;
                    }
                    case 4: 
                    case 6: {
                        int n = (Integer)objectArray[j];
                        int n2 = (Integer)objectArray2[j];
                        this.errorIfNotEqual(string + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), Integer.toHexString(n), Integer.toHexString(n2));
                        continue block8;
                    }
                    case 5: 
                    case 7: {
                        long l = (Long)objectArray[j];
                        long l2 = (Long)objectArray2[j];
                        this.errorIfNotEqual(string + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), Long.toHexString(l), Long.toHexString(l2));
                        continue block8;
                    }
                    default: {
                        BitTypesTest.fail("Bad value for j: " + j);
                    }
                }
            }
        }
    }

    public void testWriteJDBCReadNDB() {
        this.writeJDBCreadNDB();
        this.failOnError();
    }

    public void testWriteNDBReadJDBC() {
        this.writeNDBreadJDBC();
        this.failOnError();
    }

    public void testWriteNDBReadNDB() {
        this.writeNDBreadNDB();
        this.failOnError();
    }

    public void testWriteJDBCReadJDBC() {
        this.writeJDBCreadJDBC();
        this.failOnError();
    }

    protected void complexQuery(Boolean bl, Byte by, Short s, Integer n, Long l, Integer n2, Long l2, int n3) {
        Object object2;
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(BitTypes.class);
        Predicate predicate = queryDomainType.get("id").greaterEqual(queryDomainType.param("pid"));
        HashMap<String, Comparable<Boolean>> hashMap = new HashMap<String, Comparable<Boolean>>(8);
        if (bl != null) {
            predicate = predicate.and(queryDomainType.get("bit1").equal(queryDomainType.param("param1")));
            hashMap.put("param1", bl);
        }
        if (by != null) {
            predicate = predicate.and(queryDomainType.get("bit2").equal(queryDomainType.param("param2")));
            hashMap.put("param2", by);
        }
        if (s != null) {
            predicate = predicate.and(queryDomainType.get("bit4").equal(queryDomainType.param("param4")));
            hashMap.put("param4", s);
        }
        if (n != null) {
            predicate = predicate.and(queryDomainType.get("bit8").equal(queryDomainType.param("param8")));
            hashMap.put("param8", n);
        }
        if (l != null) {
            predicate = predicate.and(queryDomainType.get("bit16").equal(queryDomainType.param("param16")));
            hashMap.put("param16", l);
        }
        if (n2 != null) {
            predicate = predicate.and(queryDomainType.get("bit32").equal(queryDomainType.param("param32")));
            hashMap.put("param32", n2);
        }
        if (l2 != null) {
            predicate = predicate.and(queryDomainType.get("bit64").equal(queryDomainType.param("param64")));
            hashMap.put("param64", l2);
        }
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("pid", (Object)0);
        for (Object object2 : hashMap.keySet()) {
            query.setParameter((String)object2, hashMap.get(object2));
        }
        List list = query.getResultList();
        if (this.getDebug()) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                BitTypes bitTypes = (BitTypes)object2.next();
                System.out.println("result id " + bitTypes.getId() + " bit1: " + bitTypes.getBit1() + " bit2: " + Integer.toHexString(bitTypes.getBit2()) + " bit4: " + Integer.toHexString(bitTypes.getBit4()) + " bit8: " + Integer.toHexString(bitTypes.getBit8()) + " bit16: " + Long.toHexString(bitTypes.getBit16()) + " bit32: " + Integer.toHexString(bitTypes.getBit32()) + " bit64: " + Long.toHexString(bitTypes.getBit64()));
            }
        }
        if (list.size() != 1) {
            this.error("complexQuery mismatch result.size(): expected 1, actual " + list.size());
            return;
        }
        object2 = (BitTypes)list.get(0);
        this.errorIfNotEqual("complexQuery mismatch result id", n3, object2.getId());
    }

    public void testQuery() {
        this.generateInstances(this.getColumnDescriptors());
        this.removeAll(this.getModelClass());
        this.writeToNDB(columnDescriptors, this.instances);
        Byte by = (Byte)this.getExpected().get(3)[2];
        Short s = (Short)this.getExpected().get(4)[3];
        Integer n = (Integer)this.getExpected().get(5)[4];
        Integer n2 = (Integer)this.getExpected().get(7)[6];
        this.complexQuery(false, null, null, null, 4113L, null, null, 1);
        this.complexQuery(false, by, null, null, 12337L, null, null, 3);
        this.complexQuery(true, null, s, null, 16449L, null, null, 4);
        this.complexQuery(false, null, null, n, 20561L, null, null, 5);
        this.complexQuery(true, null, null, null, 24673L, null, null, 6);
        this.complexQuery(false, null, null, null, null, n2, null, 7);
        this.complexQuery(false, null, null, null, null, null, -8029475498074204521L, 9);
        this.failOnError();
    }

    @Override
    protected AbstractClusterJModelTest.ColumnDescriptor[] getColumnDescriptors() {
        return columnDescriptors;
    }
}

