/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJDatastoreException;
import java.io.IOException;
import org.junit.DebugTest;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;
import testsuite.clusterj.util.MgmClient;

@DebugTest(value="Test uses an error insert")
public class FindByPrimaryKeyErrorHandlingTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 50;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        try {
            this.session.deletePersistentAll(Employee.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createEmployeeInstances(50);
        this.session.makePersistentAll((Iterable)this.employees);
        this.addTearDownClasses(Employee.class);
    }

    public void test() {
        this.testErrorHandling();
        this.failOnError();
    }

    private void testErrorHandling() {
        try (MgmClient mgmClient = new MgmClient(props);){
            if (!mgmClient.insertErrorOnAllDataNodes(5098)) {
                this.error("Failed to insert error on data nodes");
                mgmClient.insertErrorOnAllDataNodes(0);
                return;
            }
            try {
                this.session.find(Employee.class, (Object)5);
                this.error("session.find() failed to throw a proper exception on temporary error");
            }
            catch (ClusterJDatastoreException clusterJDatastoreException) {
                this.verifyException("Simulating temporary read error in session.find()", (Exception)((Object)clusterJDatastoreException), ".*Error code: 1,218.*");
            }
            catch (Exception exception) {
                this.error("Caught exception : " + exception.getMessage());
            }
            if (!mgmClient.insertErrorOnAllDataNodes(0)) {
                this.error("Failed to reset error on data nodes");
            }
        }
        catch (IOException iOException) {
            this.error("Failed to connect to Management Server. Caught exception : " + iOException.getMessage());
            return;
        }
    }
}

