# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostEndpointProtectionScanResultEndpointProtection(object):
    """
    An endpoint protection found in a host scan
    """

    #: A constant which can be used with the severity property of a HostEndpointProtectionScanResultEndpointProtection.
    #: This constant has a value of "NONE"
    SEVERITY_NONE = "NONE"

    #: A constant which can be used with the severity property of a HostEndpointProtectionScanResultEndpointProtection.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a HostEndpointProtectionScanResultEndpointProtection.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a HostEndpointProtectionScanResultEndpointProtection.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a HostEndpointProtectionScanResultEndpointProtection.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    def __init__(self, **kwargs):
        """
        Initializes a new HostEndpointProtectionScanResultEndpointProtection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param service:
            The value to assign to the service property of this HostEndpointProtectionScanResultEndpointProtection.
        :type service: str

        :param configuration_finding:
            The value to assign to the configuration_finding property of this HostEndpointProtectionScanResultEndpointProtection.
        :type configuration_finding: str

        :param time_signature_updated:
            The value to assign to the time_signature_updated property of this HostEndpointProtectionScanResultEndpointProtection.
        :type time_signature_updated: datetime

        :param severity:
            The value to assign to the severity property of this HostEndpointProtectionScanResultEndpointProtection.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        """
        self.swagger_types = {
            'service': 'str',
            'configuration_finding': 'str',
            'time_signature_updated': 'datetime',
            'severity': 'str'
        }

        self.attribute_map = {
            'service': 'service',
            'configuration_finding': 'configurationFinding',
            'time_signature_updated': 'timeSignatureUpdated',
            'severity': 'severity'
        }

        self._service = None
        self._configuration_finding = None
        self._time_signature_updated = None
        self._severity = None

    @property
    def service(self):
        """
        **[Required]** Gets the service of this HostEndpointProtectionScanResultEndpointProtection.
        Name of endpoint protection service


        :return: The service of this HostEndpointProtectionScanResultEndpointProtection.
        :rtype: str
        """
        return self._service

    @service.setter
    def service(self, service):
        """
        Sets the service of this HostEndpointProtectionScanResultEndpointProtection.
        Name of endpoint protection service


        :param service: The service of this HostEndpointProtectionScanResultEndpointProtection.
        :type: str
        """
        self._service = service

    @property
    def configuration_finding(self):
        """
        **[Required]** Gets the configuration_finding of this HostEndpointProtectionScanResultEndpointProtection.
        Configuration information for endpoint protection service at the time of scan


        :return: The configuration_finding of this HostEndpointProtectionScanResultEndpointProtection.
        :rtype: str
        """
        return self._configuration_finding

    @configuration_finding.setter
    def configuration_finding(self, configuration_finding):
        """
        Sets the configuration_finding of this HostEndpointProtectionScanResultEndpointProtection.
        Configuration information for endpoint protection service at the time of scan


        :param configuration_finding: The configuration_finding of this HostEndpointProtectionScanResultEndpointProtection.
        :type: str
        """
        self._configuration_finding = configuration_finding

    @property
    def time_signature_updated(self):
        """
        **[Required]** Gets the time_signature_updated of this HostEndpointProtectionScanResultEndpointProtection.
        Date and time endpoint protection signature was updated, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_signature_updated of this HostEndpointProtectionScanResultEndpointProtection.
        :rtype: datetime
        """
        return self._time_signature_updated

    @time_signature_updated.setter
    def time_signature_updated(self, time_signature_updated):
        """
        Sets the time_signature_updated of this HostEndpointProtectionScanResultEndpointProtection.
        Date and time endpoint protection signature was updated, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_signature_updated: The time_signature_updated of this HostEndpointProtectionScanResultEndpointProtection.
        :type: datetime
        """
        self._time_signature_updated = time_signature_updated

    @property
    def severity(self):
        """
        **[Required]** Gets the severity of this HostEndpointProtectionScanResultEndpointProtection.
        Problem severity

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this HostEndpointProtectionScanResultEndpointProtection.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this HostEndpointProtectionScanResultEndpointProtection.
        Problem severity


        :param severity: The severity of this HostEndpointProtectionScanResultEndpointProtection.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
