# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportHostVulnerabilityCsvDetails(object):
    """
    Details for a Host Vulnerability list export to CSV action
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExportHostVulnerabilityCsvDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this ExportHostVulnerabilityCsvDetails.
        :type compartment_id: str

        :param time_last_detected_greater_than_or_equal_to:
            The value to assign to the time_last_detected_greater_than_or_equal_to property of this ExportHostVulnerabilityCsvDetails.
        :type time_last_detected_greater_than_or_equal_to: datetime

        :param time_last_detected_less_than_or_equal_to:
            The value to assign to the time_last_detected_less_than_or_equal_to property of this ExportHostVulnerabilityCsvDetails.
        :type time_last_detected_less_than_or_equal_to: datetime

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'time_last_detected_greater_than_or_equal_to': 'datetime',
            'time_last_detected_less_than_or_equal_to': 'datetime'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'time_last_detected_greater_than_or_equal_to': 'timeLastDetectedGreaterThanOrEqualTo',
            'time_last_detected_less_than_or_equal_to': 'timeLastDetectedLessThanOrEqualTo'
        }

        self._compartment_id = None
        self._time_last_detected_greater_than_or_equal_to = None
        self._time_last_detected_less_than_or_equal_to = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ExportHostVulnerabilityCsvDetails.
        The `OCID`__ of the compartment to list vulnerabilities in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ExportHostVulnerabilityCsvDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ExportHostVulnerabilityCsvDetails.
        The `OCID`__ of the compartment to list vulnerabilities in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ExportHostVulnerabilityCsvDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_last_detected_greater_than_or_equal_to(self):
        """
        **[Required]** Gets the time_last_detected_greater_than_or_equal_to of this ExportHostVulnerabilityCsvDetails.
        Date and time on or after which this vulnerability was last detected, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_last_detected_greater_than_or_equal_to of this ExportHostVulnerabilityCsvDetails.
        :rtype: datetime
        """
        return self._time_last_detected_greater_than_or_equal_to

    @time_last_detected_greater_than_or_equal_to.setter
    def time_last_detected_greater_than_or_equal_to(self, time_last_detected_greater_than_or_equal_to):
        """
        Sets the time_last_detected_greater_than_or_equal_to of this ExportHostVulnerabilityCsvDetails.
        Date and time on or after which this vulnerability was last detected, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_last_detected_greater_than_or_equal_to: The time_last_detected_greater_than_or_equal_to of this ExportHostVulnerabilityCsvDetails.
        :type: datetime
        """
        self._time_last_detected_greater_than_or_equal_to = time_last_detected_greater_than_or_equal_to

    @property
    def time_last_detected_less_than_or_equal_to(self):
        """
        **[Required]** Gets the time_last_detected_less_than_or_equal_to of this ExportHostVulnerabilityCsvDetails.
        Date and time on or before which this vulnerability was last detected, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_last_detected_less_than_or_equal_to of this ExportHostVulnerabilityCsvDetails.
        :rtype: datetime
        """
        return self._time_last_detected_less_than_or_equal_to

    @time_last_detected_less_than_or_equal_to.setter
    def time_last_detected_less_than_or_equal_to(self, time_last_detected_less_than_or_equal_to):
        """
        Sets the time_last_detected_less_than_or_equal_to of this ExportHostVulnerabilityCsvDetails.
        Date and time on or before which this vulnerability was last detected, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_last_detected_less_than_or_equal_to: The time_last_detected_less_than_or_equal_to of this ExportHostVulnerabilityCsvDetails.
        :type: datetime
        """
        self._time_last_detected_less_than_or_equal_to = time_last_detected_less_than_or_equal_to

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
