# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

from .update_container_scan_registry_details import UpdateContainerScanRegistryDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOcirContainerScanRegistryDetails(UpdateContainerScanRegistryDetails):
    """
    Registry information for a OCI Registry target
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOcirContainerScanRegistryDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vulnerability_scanning.models.UpdateOcirContainerScanRegistryDetails.type` attribute
        of this class is ``OCIR`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this UpdateOcirContainerScanRegistryDetails.
        :type type: str

        :param url:
            The value to assign to the url property of this UpdateOcirContainerScanRegistryDetails.
        :type url: str

        :param compartment_id:
            The value to assign to the compartment_id property of this UpdateOcirContainerScanRegistryDetails.
        :type compartment_id: str

        :param repositories:
            The value to assign to the repositories property of this UpdateOcirContainerScanRegistryDetails.
        :type repositories: list[str]

        """
        self.swagger_types = {
            'type': 'str',
            'url': 'str',
            'compartment_id': 'str',
            'repositories': 'list[str]'
        }

        self.attribute_map = {
            'type': 'type',
            'url': 'url',
            'compartment_id': 'compartmentId',
            'repositories': 'repositories'
        }

        self._type = None
        self._url = None
        self._compartment_id = None
        self._repositories = None
        self._type = 'OCIR'

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this UpdateOcirContainerScanRegistryDetails.
        The `OCID`__ of the compartment to perform the scans in. All listed repositories must be in the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this UpdateOcirContainerScanRegistryDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this UpdateOcirContainerScanRegistryDetails.
        The `OCID`__ of the compartment to perform the scans in. All listed repositories must be in the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this UpdateOcirContainerScanRegistryDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def repositories(self):
        """
        Gets the repositories of this UpdateOcirContainerScanRegistryDetails.
        List of repositories to scan images in. If left empty, the target defaults to scanning all repos in the compartmentId


        :return: The repositories of this UpdateOcirContainerScanRegistryDetails.
        :rtype: list[str]
        """
        return self._repositories

    @repositories.setter
    def repositories(self, repositories):
        """
        Sets the repositories of this UpdateOcirContainerScanRegistryDetails.
        List of repositories to scan images in. If left empty, the target defaults to scanning all repos in the compartmentId


        :param repositories: The repositories of this UpdateOcirContainerScanRegistryDetails.
        :type: list[str]
        """
        self._repositories = repositories

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
