/*
 * Copyright (c) 2011, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import "TabViewDockingDelegate.h"
#include "NSString_extras.h"
#include "mforms/appview.h"

TabViewDockingPointDelegate::TabViewDockingPointDelegate(NSTabView *tabView, const std::string &type) : _tabView(tabView), _type(type)
{
}


mforms::AppView *TabViewDockingPointDelegate::appview_for_view(NSView *view)
{
  if (_views.find(view) != _views.end())
    return _views[view];
  return NULL;
}


bool TabViewDockingPointDelegate::handle_close_clicked(mforms::AppView *view)
{
  if (view->on_close())
  {
    undock_view(view);
    return true;
  }
  return false;
}


bool TabViewDockingPointDelegate::close_all()
{
  for (NSTabViewItem *item in [_tabView tabViewItems])
  {
    mforms::AppView *aview = appview_for_view([item view]);
    if (aview && !handle_close_clicked(aview))
      return false;
  }
  return true;
}


void TabViewDockingPointDelegate::dock_view(mforms::AppView *view, const std::string &arg1, int arg2)
{
  id v = view->get_data();
  NSTabViewItem *tabItem = [[NSTabViewItem alloc] initWithIdentifier: [NSString stringWithFormat: @"appview:%p", view]];
  [tabItem setView: v];

  if (arg1 == "" || arg1 == "append")
    [_tabView addTabViewItem: tabItem];
  else if (arg1 == "prepend")
    [_tabView insertTabViewItem: tabItem atIndex: 0];

  [tabItem release];

  _views[v] = view;

  if ([[_tabView delegate] respondsToSelector: @selector(tabView:didSelectTabViewItem:)])
    [[_tabView delegate] tabView:_tabView didSelectTabViewItem: tabItem];
}

bool TabViewDockingPointDelegate::select_view(mforms::AppView *view)
{
  NSInteger i = [_tabView indexOfTabViewItemWithIdentifier: [NSString stringWithFormat: @"appview:%p", view]];
  if (i >= 0)
  {
    NSTabViewItem *item = [_tabView tabViewItemAtIndex: i];
    if (item)
    {
      [_tabView selectTabViewItem: item];
      return true;
    }
  }
  return false;
}


void TabViewDockingPointDelegate::undock_view(mforms::AppView *view)
{
  NSInteger i = [_tabView indexOfTabViewItemWithIdentifier: [NSString stringWithFormat: @"appview:%p", view]];
  if (i >= 0)
  {
    NSTabViewItem *item = [_tabView tabViewItemAtIndex: i];
    if (item)
    {
      [_tabView removeTabViewItem: item];
      _views.erase(view->get_data());
    }
  }
}


void TabViewDockingPointDelegate::set_view_title(mforms::AppView *view, const std::string &title)
{
  NSInteger i = [_tabView indexOfTabViewItemWithIdentifier: [NSString stringWithFormat: @"appview:%p", view]];
  if (i >= 0)
  {
    NSTabViewItem *item = [_tabView tabViewItemAtIndex: i];
    if (item)
    {
      [item setLabel: [NSString stringWithCPPString: title]];
      [[_tabView superview] setNeedsDisplay: YES];
    }
  }
}


void TabViewDockingPointDelegate::get_size(int *w, int *h)
{
  NSRect frame = [_tabView contentRect];
  *w = (int)NSWidth(frame);
  *h = (int)NSHeight(frame);
}

