using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MySQL.Workbench;

namespace MySQL.GUI.Workbench
{
  public partial class ObjectFindForm : Form
  {
    WbContext wbContext;
    FindDialogBE findDialogBE;

    public ObjectFindForm()
    {
      InitializeComponent();
    }

    public ObjectFindForm(WbContext wb)
    {
      InitializeComponent();

      wbContext = wb;
      findDialogBE = wb.get_find_dialog();
    }

    private void setupArguments()
    {
      findDialogBE.set_text(findText.Text);
      findDialogBE.set_match_case(matchCaseCheck.Checked);
      findDialogBE.set_search_in_comments(searchCommentsCheck.Checked);
    }

    private void nextButton_Click(object sender, EventArgs e)
    {
      statusLabel.Text = "Searching...";
      Update();
      setupArguments();

      switch (findDialogBE.find_next())
      {
      case FindResult.NotFound:
        statusLabel.Text = "Not Found";
        break;
      case FindResult.FoundMatch:
        statusLabel.Text = "Found Match";
        break;
      case FindResult.NoMoreMatches:
        statusLabel.Text = "No More Matches";
        break;
      }
    }

    private void previousButton_Click(object sender, EventArgs e)
    {
      statusLabel.Text = "Searching...";
      Update();
      setupArguments();

      switch (findDialogBE.find_previous())
      {
        case FindResult.NotFound:
          statusLabel.Text = "Not Found";
          break;
        case FindResult.FoundMatch:
          statusLabel.Text = "Found Match";
          break;
        case FindResult.NoMoreMatches:
          statusLabel.Text = "No More Matches";
          break;
      }
    }

    private void ObjectFindForm_Shown(object sender, EventArgs e)
    {
      findText.Focus();
      statusLabel.Text = "";
    }

    private void ObjectFindForm_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
    {
      if (e.KeyCode == Keys.Escape)
        Hide();
    }
  }
}