/* 
 * Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _MFORMS_POPUP_H_
#define _MFORMS_POPUP_H_

#include <mforms/base.h>
#include <mforms/view.h>

#include "cairo/cairo.h"
#include "base/geometry.h"

/**
 * This class implements a popup window class which can be used for context menus or drop down menus.
 * A popup is always a modal window and cannot be used to embed other controls nor can itself be embedded.
 */
namespace mforms 
{
  enum PopupStyle
  {
    PopupPlain, // A simple popup window, similar to context menus.
    PopupBezel, // A semi-transparent black window with rounded corners and a white border.
  };

  class Popup;
 
#ifndef DOXYGEN_SHOULD_SKIP_THIS 
#ifndef SWIG
  struct PopupImplPtrs
  {
    bool (__stdcall *create)(Popup *, PopupStyle);
    void (__stdcall *set_needs_repaint)(Popup *);
    void (__stdcall *set_size)(Popup *, int, int);
    int (__stdcall *show)(Popup *, int, int);
    base::Rect (__stdcall *get_content_rect)(Popup *);
    void (__stdcall *set_modal_result)(Popup *, int result);
  };
#endif
#endif
  
  class MFORMS_EXPORT Popup : public Object
  {
  public:
    Popup(PopupStyle style);

    void set_needs_repaint();
    void set_size(int width, int height);
    int show(int spot_x, int spot_y);
    base::Rect get_content_rect();
    void set_modal_result(int result);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#ifndef SWIG
    virtual void repaint(cairo_t *cr, int x, int y, int w, int h) {}

    virtual void mouse_down(int button, int x, int y) {}
    virtual void mouse_up(int button, int x, int y) {}
    virtual void mouse_click(int button, int x, int y) {}
    virtual void mouse_double_click(int button, int x, int y) {}
    virtual void mouse_enter() {}
    virtual void mouse_leave() {}
    virtual void mouse_move(int x, int y) {}
#endif
#endif
  protected:
    PopupImplPtrs *_popup_impl;
  };
};

#endif // _MFORMS_POPUP_H_
