/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __MYSQL_SCHEMA_EDITOR_H__
#define __MYSQL_SCHEMA_EDITOR_H__

#include "mysql_schema_editor.h"
#include "GrtTemplates.h"
#include "grtdb/db_object_helpers.h"

namespace MySQL {
namespace Grt {
namespace Db {

public ref class MySQLSchemaEditorBE : public SchemaEditorWrapper
{
protected:
  MySQLSchemaEditorBE(::MySQLSchemaEditorBE *inn)
    : SchemaEditorWrapper(inn)
  {}

public:
  MySQLSchemaEditorBE::MySQLSchemaEditorBE(GrtManager^ grtm, GrtValue^ arglist)
  : SchemaEditorWrapper(
      new ::MySQLSchemaEditorBE(grtm->get_unmanaged_object(), 
      db_mysql_SchemaRef::cast_from(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0)),
      get_rdbms_for_db_object(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0))
        )
      )
  {}

  ::MySQLSchemaEditorBE *get_unmanaged_object()
  { return static_cast<::MySQLSchemaEditorBE *>(inner); }

  bool is_new_object() { return get_unmanaged_object()->get_schema()->oldName() == ""; }

  void refactor_catalog_upon_schema_rename(String^ old_name, String^ new_name)
  { get_unmanaged_object()->refactor_catalog_upon_schema_rename(NativeToCppString(old_name), NativeToCppString(new_name)); }
};

} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif // __MYSQL_SCHEMA_EDITOR_H__
