/* 
 * Copyright © 2010, Oracle and/or its affiliates. All rights reserved.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#import <Cocoa/Cocoa.h>
#import "WBSplitPanel.h"
#include "workbench/wb_context_ui.h"

#import "MTableView.h"

@class WBOverviewPanel;
@class WBModelSidebarController;
@class WBObjectDescriptionController;
@class GRTTreeDataSource;
@class GRTListDataSource;


@interface WBModelOverviewPanel : WBSplitPanel
{
  IBOutlet WBSplitView *topView;
  IBOutlet NSView *sidebar;
  IBOutlet WBOverviewPanel *overview;
  IBOutlet NSSplitView *sideSplitview;
  IBOutlet WBModelSidebarController *sidebarController;
  IBOutlet WBObjectDescriptionController *descriptionController;
  
  wb::WBContextUI* _wbui;
  BOOL sidebarHidden;
  BOOL sidebarAtRight;
  CGFloat lastSidebarWidth;
}

- (void)setupWithWBContextUI:(wb::WBContextUI*)wbui;

- (NSString*)identifier;

- (WBOverviewPanel*)overview;

- (void)selectionChanged;

- (WBModelSidebarController*)sidebarController;
- (void) performCommand: (const std::string) command;

- (void)setRightSidebar:(BOOL)flag;
@end
