/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//Definitions for extended error info support

//Clear error object
void ClearError();
//Add new error to error object
HRESULT Error(HRESULT hrError, DWORD dwError, const char *pszText = NULL);


//Forward declaration
class	CImpIErrorLookup;
typedef CImpIErrorLookup*			PIMPIERRORLOOKUP;


// Classes -------------------------------------------------------------------

//----------------------------------------------------------------------------
// @class CError | Containing class for all interfaces on the Error 
// Object
//
class CError : public IUnknown				//@base public | IUnknown
{
	START_CLASS(); 

// contained interfaces are friends
friend class CImpIErrorLookup;

protected: //@access protected
	//@cmember Reference count
	ULONG					m_cRef;						

	//Interfaces

    //@member contained IErrorLookup
    PIMPIERRORLOOKUP            m_pIErrorLookup;
	
public: //@access public
	//@cmember Constructor		 
	 CError(void);
	//@cmember Destructor
	~CError(void);

	//	Object's base IUnknown
	//@cmember Request an Interface
	STDMETHODIMP			QueryInterface(REFIID, LPVOID *);
	//@cmember Increments the Reference count
	STDMETHODIMP_(ULONG)	AddRef(void);
	//@cmember Decrements the Reference count
	STDMETHODIMP_(ULONG)	Release(void);

	FINISH_CLASS(); 
};


//----------------------------------------------------------------------------------------
// @class CImpIErrorLookup  | contained IErrorLookup class


class CImpIErrorLookup : public IErrorLookup      //@base public | IErrorLookup
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIErrorLookup(IUnknown *pUnkOuter)					
		{																	
			CLEAR_CONSTRUCT( CImpIErrorLookup );
			
			DEBUGCODE(m_cRef = 0L);	
			m_pUnkOuter	= pUnkOuter;													
		}																	
		
		~CImpIErrorLookup()	
		{																	
		}


		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}

       
        // IErrorLookup methods

        //@cmember GetErrorDesription
		STDMETHODIMP GetErrorDescription(HRESULT, DWORD, DISPPARAMS*, LCID, BSTR*, BSTR*);
        //@cmember GetHelpInfo
		STDMETHODIMP GetHelpInfo(HRESULT, DWORD, LCID, BSTR*, DWORD*);
		//@cmember ReleaseErrors
		STDMETHODIMP ReleaseErrors(const DWORD);
	
		FINISH_CLASS(); 
};
