/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

#pragma once

////////////////////  ATTENTION /////////////////////////////////////////////////////
// Customers should increase *ALL* Communication Buffer Size settings to 32767 or 32K depending on scale of values. 
// They should increase Setup->MKDE | Memory Resources | Extended Operations Buffer Size to 33 (33K)
// There changes should be applied both to server and client parts
/////////////////////////////////////////////////////////////////////////////////////

//#define SIZEOF_CBUFFER_BUFFER	(32767) // 32K - 1
#define SIZEOF_CBUFFER_BUFFER	(16*1024) // 16K

// Large buffer for extended  operations
struct CBuffer
{
	HRESULT m_hr;
	int		m_nRows;
	BYTE    m_buffer[ SIZEOF_CBUFFER_BUFFER ];	
	
	CBuffer() { m_hr=0; m_nRows=0; memset(m_buffer, 0, SIZEOF_CBUFFER_BUFFER); }

	static LONG RowsPerTime( LONG lRowSize )
	{
		return (SIZEOF_CBUFFER_BUFFER - 2) / (6 + lRowSize);
	}
};


// Array of large buffers for extended  operations
class CBufferHolder
{
	START_CLASS(); 

public:
	CBufferHolder( int base = 20 );

	~CBufferHolder();

	// Get elem at position with #. S_OK if elem is got; S_FALSE if NULL is got; E_ if other errors
	HRESULT At(int i, CBuffer** ppMeta );

	// Get maximum element number
	HRESULT GetMaxNumber( int* puiMaxNumber );

	// Get first free slot
	HRESULT GetFreeSlotNumber( CBuffer** ppBuffer, int* pnSlot );
	
	//Release slot
	HRESULT ReleaseSlot(int slot);

public: 
	LONG	m_nTotalRows;		// Total number of obtained rows
	BOOL	m_bEndReached;		// Reached end of rowset
	short	m_iDirectionSign;	// +1 for forward and -1 for backward
	struct
	{
		BYTE*	m_pszBuf;		// Buffer of current row. 
		HRESULT m_hr;				// Determines of bookmark is valid
		DWORD	m_dwBmk;			// Bookmark
	}		m_currentRow;			// Information about current row. It is not used if m_currentBuf == NULL
	bool UseCurrentRow() { return m_currentRow.m_pszBuf != NULL; }
	struct
	{
		BYTE*	m_pszBuf;			// Buffer of last row. 
	}		m_lastRow;				// Information about last row. It is not used if m_currentBuf == NULL
	bool UseLastRow() { return m_lastRow.m_pszBuf != NULL; }

protected:
	CBuffer**	m_holder;		// Holder of CBuffer pointers
	int	m_nMaxElems;			// Current array size
	int	m_nMaxElemsBase;		// Size to enlarge
	int	m_uiFirstFree;			// First free elem (at the end of array)

	FINISH_CLASS(); 
};
