/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

//Definitions for extended error info support

//Clear error object
void ClearError();
//Add new error to error object
HRESULT Error(HRESULT hrError, DWORD dwError, const char *pszText = NULL);


//Forward declaration
class	CImpIErrorLookup;
typedef CImpIErrorLookup*			PIMPIERRORLOOKUP;


// Classes -------------------------------------------------------------------

//----------------------------------------------------------------------------
// @class CError | Containing class for all interfaces on the Error 
// Object
//
class CError : public IUnknown				//@base public | IUnknown
{
	START_CLASS(); 

// contained interfaces are friends
friend class CImpIErrorLookup;

protected: //@access protected
	//@cmember Reference count
	ULONG					m_cRef;						

	//Interfaces

    //@member contained IErrorLookup
    PIMPIERRORLOOKUP            m_pIErrorLookup;
	
public: //@access public
	//@cmember Constructor		 
	 CError(void);
	//@cmember Destructor
	~CError(void);

	//	Object's base IUnknown
	//@cmember Request an Interface
	STDMETHODIMP			QueryInterface(REFIID, LPVOID *);
	//@cmember Increments the Reference count
	STDMETHODIMP_(ULONG)	AddRef(void);
	//@cmember Decrements the Reference count
	STDMETHODIMP_(ULONG)	Release(void);

	FINISH_CLASS(); 
};


//----------------------------------------------------------------------------------------
// @class CImpIErrorLookup  | contained IErrorLookup class


class CImpIErrorLookup : public IErrorLookup      //@base public | IErrorLookup
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIErrorLookup(IUnknown *pUnkOuter)					
		{																	
			CLEAR_CONSTRUCT( CImpIErrorLookup );
			
			DEBUGCODE(m_cRef = 0L);	
			m_pUnkOuter	= pUnkOuter;													
		}																	
		
		~CImpIErrorLookup()	
		{																	
		}


		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}

       
        // IErrorLookup methods

        //@cmember GetErrorDesription
		STDMETHODIMP GetErrorDescription(HRESULT, DWORD, DISPPARAMS*, LCID, BSTR*, BSTR*);
        //@cmember GetHelpInfo
		STDMETHODIMP GetHelpInfo(HRESULT, DWORD, LCID, BSTR*, DWORD*);
		//@cmember ReleaseErrors
		STDMETHODIMP ReleaseErrors(const DWORD);
	
		FINISH_CLASS(); 
};
