/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

//metadata for MySQL: tables & fields


#ifndef _SWSTMETA_H_
#define _SWSTMETA_H_

/* Don't pad our structures */
#if defined(__BORLANDC__)
  #pragma option -a-
#else
  #if defined(_MSC_VER) || defined(__WATCOMC__)
    #pragma pack(1)
  #endif
#endif


#define MAX_NAME_SIZE sizeof(WCHAR) * 255
#define MAX_COLUMN_NAME_CHARS 50

struct SWSTFILEtag;
struct SWSTRELATEtag;

struct CatalogOwner
{
	// Name of database
	WCHAR			m_wszCatalog[ MAXDATASOURCENAME + 1 ];
	// Name of database
	WCHAR			m_wszOwner[ MAXOWNERNAME + 1 ];
	// Type of data source
	DATASOURCE_TYPE m_type;
};
	

/***************************************************************************
  Definition of record from 'field.ddf'
****************************************************************************/

typedef struct
{
	MT_WORD	m_wID;		// Xe$Id UNSIGNED 2 N/A Internal ID Scalable SQL assigns.
	MT_WORD	m_wFile;	// Xe$File UNSIGNED 2 N/A ID of table to which this column 
								// or named index belongs. It corresponds to Xf$Id in X$File.
	MT_CHAR	m_szName[20];	// Xe$Name CHARACTER 20 Yes Column name or index name.
	MT_BYTE	m_btDataType;	// Xe$DataType UNSIGNED 1 N/A Column data type (range 020), or 
								// 0xFF for a named index.
	MT_WORD	m_wOffset;	// Xe$Offset UNSIGNED 2 N/A Column offset in table; index number 
								// if named index.
	MT_WORD	m_wSize;		// Xe$Size UNSIGNED 2 N/A Column size.
	MT_BYTE	m_btDec;		// Xe$Dec UNSIGNED 1 N/A Column decimal place (for DECIMAL,
								// NUMERIC, NUMERICSA, NUMERICSTS, MONEY, or CURRENCY types). 
								// Relative bit positions for contiguous bit columns. Fractional
								// seconds for TIMESTAMP data type.
	MT_WORD	m_wFlags;		// Xe$Flags UNSIGNED 2 N/A Flags word. Bit 0 is the case flag for 
								// string data types.

	// Additional fields
	SWSTFILEtag* 	m_pSwstFile;
	WORD		m_bNullable;	// Used for MySQL only
	
	void Clean() { m_pSwstFile = NULL; }

} SWSTFIELD;

/***************************************************************************
  Definition of record from 'index.ddf'
****************************************************************************/
typedef struct SWSTINDEXtag
{
	MT_WORD	m_wFile;	// Xi$File
	MT_WORD	m_wField;	// Xi$Field
	MT_WORD	m_wNumber;		// Xi$Number 
	MT_WORD	m_wPart;	// Xi$Part
	MT_WORD	m_wFlags;	// Xi$Flags
	
	/// Additional fields
	SWSTFIELD*		m_pSwstField;		// Pointer to a referred field
	SWSTFIELD*		m_pSwstFieldName;	// Pointer to a name for named indexes
	SWSTRELATEtag*	m_pSwstRelateName;	// Pointer to a name for foreign keys (dependent index)

	void Clean() { m_pSwstField = m_pSwstFieldName = NULL; m_pSwstRelateName = NULL; }
	BOOL IsUnique() { return !(m_wFlags & 0x1); }
	BOOL IsModificable() { return m_wFlags & 0x2; }
	BOOL IsBinary() { return m_wFlags & 0x4; }
	BOOL IsAllSegmentNullKey() { return m_wFlags & 0x8; }
	BOOL HasAnotherSegment() { return m_wFlags & 0x10; }
	BOOL IsSortedViaASC() { return m_wFlags & 0x20; }
	BOOL IsDescending() { return m_wFlags & 0x40; }
	BOOL RepeatingDup() { return m_wFlags & 0x80; }
	BOOL IsExtendedDataType() { return m_wFlags & 0x100; }
	BOOL IsAnySegmentNullKey() { return m_wFlags & 0x200; }
	BOOL SortIgnoreCase() { return m_wFlags & 0x400; }
	BOOL IsForeignKey() { return m_wFlags & 0x2000; }
	BOOL IsPrimaryKey() { return m_wFlags & 0x4000; }

} SWSTINDEX;

/***************************************************************************
  Definition of record from 'file.ddf'
****************************************************************************/
typedef struct SWSTFILEtag
{
	MT_WORD	m_wID;				// Xf$Id UNSIGNED 2 N/A Internal ID Scalable SQL assigns.
	MT_CHAR	m_szName[20];		// Xf$Name CHARACTER 20 Yes Table name.
	MT_CHAR	m_szLocation[64];	// Xf$Loc CHARACTER 64 No File location (pathname).
	MT_BYTE	m_btFlags;			// Xf$Flags UNSIGNED 1 N/A File flags. If bit 4 =1, the file 
										// is a dictionary file. If bit 4 =0, the file is user-defined.
	MT_CHAR	m_szReserved[10];	// Xf$Reserved CHARACTER 10 No Reserved.

	//The following members are calculated in CSwstMeta::LoadMetaData()

	//Number of columns in the table
	MT_WORD	m_wFields;
	//Array of pointers to table fields
	SWSTFIELD** m_pFields; 
	//Number of index segments in the table
	MT_WORD	m_wIndexes;
	//Array of pointers to table indexes
	SWSTINDEX** m_pIndexes; 

	/// Additional fields
	CatalogOwner*	m_pCatalogOwner;	// Cross reference to CSwstMeta's field (CSwstMeta holds SWSTFILE)

	BOOL HasVariableLength() { return m_btFlags & 0x1; }
	BOOL TrunkateTralingBlanks() { return m_btFlags & 0x2; }
	BOOL PreAllocatePages() { return m_btFlags & 0x4; }
	BOOL CompressData() { return m_btFlags & 0x8; }
	BOOL IsKeyOnlyFile() { return m_btFlags & 0x10; }
	BOOL UseIndexBalancing() { return m_btFlags & 0x20; }
	BOOL Keep10PercentsFree() { return m_btFlags & 0x40; }
	BOOL Keep20PercentsFree() { return m_btFlags & 0x80; }
	BOOL Keep30PercentsFree() { return m_btFlags & 0xC0; }
	BOOL ExtraDuplicatePointers() { return m_btFlags & 0x100; }
	BOOL PreAssignKeyNumbers() { return m_btFlags & 0x400; }
	BOOL UseVAT() { return m_btFlags & 0x800; }
} SWSTFILE;


typedef struct SWSTRELATEtag
{
	MT_WORD	m_wParentTableID;	// Xr$PID
	MT_WORD	m_wParentIdxNumber;	// Xr$PIndex
	MT_WORD	m_wDependTableID;	// Xr$FID
	MT_WORD	m_wDependIdxNumber;	// Xr$FIndex
	MT_CHAR	m_szName[20];		// Xr$Name
	MT_BYTE	m_btUpdateRule;		// Xr$UpdateRule
	MT_BYTE	m_btDeleteRule;		// Xr$DeleteRule
	MT_CHAR	m_szReserved[30];	// Xr$Reserved

	/// Additional fields
	// Number of segments in parent index
	MT_WORD	m_wParentIndexes; 
	// All segments of parent index
	SWSTINDEX**	m_ppParentIndex;	 
	// Number of segments in dependent index
	MT_WORD	m_wDependIndexes; 
	// All segments of dependent index
	SWSTINDEX**	m_ppDependIndex;	 
} SWSTRELATE;


/* restore structure packing */
#if defined(__BORLANDC__)
  #pragma option -a.
#else
  #if defined(_MSC_VER) || defined(__WATCOMC__)
    #pragma pack()
  #endif
#endif

class TempODBC;

class CSwstMeta
{
	START_CLASS(); 

	// Creates temporary Named DB name and/or ODBC DSN name if they are necessary (P.SQL 2000 )
	HRESULT CreateTemporaryStorageNames(CSwstMeta* pSwstMetaINFORMATION_SCHEMA, LPCSTR lpszDDPath, LPCSTR lpszDataPath, LPCOLESTR lpwszDatabaseName, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverType, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword );
	// Drops temporary Named DB name and/or ODBC DSN name if they were used
	void DropTemporaryStorageNames();

protected:	
	void Destroy(); // called from a destructor

public:
	CSwstMeta();
	~CSwstMeta();

    //copy operations
    CSwstMeta& operator=(const CSwstMeta& cpy);
    CSwstMeta(const CSwstMeta& cpy);

	//Loads data from file.ddf and field.ddf
	HRESULT LoadMetaData_Slow(CSwstMeta* pSwstMetaINFORMATION_SCHEMA, LPCSTR szDDPath, LPCSTR szDataPath, LPCOLESTR szDatabaseName, LPCOLESTR szOwner, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverID, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword, LPOLESTR pwszMySqlStr );

    //cached version
	HRESULT LoadMetaData(CSwstMeta* pSwstMetaINFORMATION_SCHEMA, LPCSTR szDDPath, LPCSTR szDataPath, LPCOLESTR szDatabaseName, LPCOLESTR szOwner, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverID, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword, LPOLESTR pwszMySqlStr );

	// Returns pointer to the file description with specified name
	SWSTFILE* FindFile(LPCSTR pszName);
	//Convert SQL type to OLEDB type
	static HRESULT SwstType2OledbType(MT_BYTE, WORD, MT_BYTE, WORD*, DWORD*, DWORD*, WORD*, WORD*);
	static HRESULT SwstType2OledbTypeHelper(WORD, DWORD, WORD, BOOL, BOOL, WORD*, DWORD*, DWORD*, WORD*, WORD*);
	//Retrieve  version 
	HRESULT GetVersion(float* pfltVersion);

public:
	//Number of tables
	MT_LONG		m_siFiles;
	//Array of table descriptions
	SWSTFILE*		m_pFiles;

	//Number of columns through all tables
	MT_LONG		m_siFields;
	//Array of column descriptions
	SWSTFIELD*		m_pFields;

	//Number of indexes through all tables
	MT_LONG		m_siIndexes;
	//Array of column descriptions
	SWSTINDEX*		m_pIndexes;

	//Number of relations through all tables
	MT_LONG		m_siRelations;
	//Array of column descriptions
	SWSTRELATE*		m_pRelations;

	//Path to DDF dictionary
	char			m_szDdfPath[_MAX_PATH];
	//Path to data dictionary
	char			m_szDataPath[_MAX_PATH];
	//Name of temporary ODBC data source. No temporary ODBC data source if it is empty
	char			m_szTempODBC[MAXDATASOURCENAME+1];
	//Name of computer where temporary ODBC name is placed
	char			m_szServerName[MAXSERVERNAME+1];
	// ID of ODBC driver . 
	int			    m_iDriverID;
	// User ID
	char			m_szUser[MAXUSERNAME+1];
	// Password
	char			m_szPassword[MAXPASSWORD+1];
	// Catalog and owner information
	CatalogOwner 	m_CatalogOwner;
	// MySQL ODBC connection string
	char			m_szMySqlStr[ MYSQL_MAXDATASOURCENAME+1]; 

    /** realeses DSN (virtual DSN deletion) */
    void release();

protected:
	//int		m_cRef;
	float	m_fltVersion;

    //pointer to created ODBC DSN, You should close DSN only via this object,
    //since the DSN may be used after (obtained from local cache)
    TempODBC* m_pTempODBC;

	FINISH_CLASS(); 
};

class CSwstMetaHolder 
{
	START_CLASS(); 

public:
	CSwstMetaHolder( int base = 20 );

	~CSwstMetaHolder();

	// Get elem at position with #. S_OK if elem is got; S_FALSE if NULL is got; E_ if other errors
	HRESULT At(int i, CSwstMeta** ppMeta );

	// Get elem at position with catalogue. S_OK if elem is got, E_FAIL else. ppMeta may be NULL
	HRESULT At( LPCOLESTR szCatalogPath, LPCOLESTR szOwner, CSwstMeta** ppMeta );

	// Get maximum element number
	HRESULT GetMaxNumber( int* puiMaxNumber );

	// Get first free slot
	HRESULT GetFreeSlotNumber( int* pnSlot );
	
	//Loads data from file.ddf and field.ddf
	HRESULT LoadMetaData(LPCSTR szDDPath, LPCSTR szDataPath, LPCOLESTR szDatabaseName, LPCOLESTR szOwner, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverID, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword, LPOLESTR pwszMySqlStr );

	//Release slot
	HRESULT ReleaseSlot(int slot);

	// Returns pointer to the file description with specified name
	SWSTFILE* FindFile(int i, LPCSTR pszName);

	//Retrieve  version 
	HRESULT GetVersion(int i, float* pfltVersion);


protected:
	int				m_cRef;					// References counter
	CSwstMeta**		m_holder;				// Holder of CSwstMeta pointers
	int	m_nMaxMetas;			// Current array size
	int	m_nMaxMetasBase;		// Size to enlarge
	int	m_uiFirstFree;			// First free elem (at the end of array)

	FINISH_CLASS(); 
};


// Length convertion
HRESULT SwstTypeLen2OleDbTypeLen
	(
	SWORD  swType,				//@parm IN	|  Type's name	
	UDWORD udwSwstTypeLength,	//@parm IN	|  Type's length	
	UDWORD *udwOleDbTypeLength	//@parm OUT	|  Type's length	
	);

// Is OLE DB data type nullable?
bool IsNullable( DBTYPE );

#endif