/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

//This file contains definition of class that is responsible
//for data management. 


#ifndef _SCHEMA_H_
#define _SCHEMA_H_

#include "MySQLMeta.h"  // for some typedefs

enum SCHEMA
{
	TABLES_SCHEMA,
	COLUMNS_SCHEMA,
	TYPES_SCHEMA,
	CATALOGS_SCHEMA,
	SCHEMATA_SCHEMA,
	STATISTICS_SCHEMA,
	INDEXES_SCHEMA,
	CONSTRAINT_COLUMN_USAGE_SCHEMA,
	CONSTRAINT_TABLE_USAGE_SCHEMA,
	TABLE_CONSTRAINTS_SCHEMA,
	REFERENTIAL_CONSTRAINTS_SCHEMA,
	PRIMARY_KEYS_SCHEMA,
	FOREIGN_KEYS_SCHEMA
};

typedef struct {
	SWSTFILE*	pFile;
	DWORD		dwRows;
} STATINFO;

typedef struct {
	SWSTRELATE*  pRelate;
	DWORD        iIdx;
} FOREIGNKEYINFO;

typedef struct {
	LPOLESTR	wszName;
	WORD		wType;
	ULONG		ulSize;
	DWORD		dwFlags;
} COLINFO;

typedef struct {
	LPOLESTR		wszTypeName;
	float			fltVersion;
	WORD			wDataType;
	ULONG			ulColumnSize;
	LPOLESTR		wszLiteralPrefix;
	LPOLESTR		wszLiteralSuffix;
	LPOLESTR		wszCreateParams;
	VARIANT_BOOL	bUnsignedAttribute;
	VARIANT_BOOL	bFixedPrecScale;
	VARIANT_BOOL	bAutoUniqueValue;
	VARIANT_BOOL	bBestMatch;
	VARIANT_BOOL	bFixedLength;
	VARIANT_BOOL	bIsLong;
} TYPEINFO;

typedef struct {
	SWSTFILE*	m_pFile;
	SWSTFIELD*	m_pField;
	ULONG		m_ulPosition;
} FIELDINFO;

typedef struct {
	WCHAR		m_wszCatalog[ MAXDATASOURCENAME+1 ];
	WCHAR		m_wszDescription[ MAXDESCRIPTION+1 ];
} CATALOGINFO;


class CRowInfo
{
	START_CLASS()
public:
	LONG		m_lRowPos;
	HRESULT		m_hr;
	CRowInfo() { CLEAR_CONSTRUCT(CRowInfo); }
	
	FINISH_CLASS()
};

class CSchema : public CData
{
	START_CLASS(); 

public: // virtual overrides
	// Invalidate buffers
	HRESULT SetMoveInfo( HRESULT hr );
	//@cmember Move relative
	HRESULT MovePending(LONG lRows, BOOL bSaveCurrentPosition);
	//@cmember Move relative
	HRESULT GetFetchedData(LONG lRow, DWORD* pdwBmk);
	//@cmember Move to first row
	HRESULT MoveFirst();
	//@cmember Move to last row
	HRESULT MoveLast();
	//@cmember Move to specified bookmark
	HRESULT MoveBookmark(ULONG* pulBookmark);

	//@cmember Find row from current position
	HRESULT Find(ULONG icol, PCOLUMNDATA pDst/*void* pvValue*/,	DBCOMPAREOP	CompareOp, DBTYPE dbType, bool bForward);

	//@cmember Return the number of rows in the table	
	HRESULT GetRowCnt(DWORD* pdwRows);
	//@cmember Get relative position (by percentage) of the row in  table
	HRESULT GetPercentage(ULONG* pulBookmark, double *pdfPPos);
	//@cmember Get bookmark for current row
	HRESULT GetBookmark(ULONG *pulBookmark);
	//@cmember Retrieve number of columns
	HRESULT GetColumnCnt(DWORD* pdwCount);
	//@cmember Retrieve column information
	HRESULT GetColumnInfo(DWORD dwCol, DBCOLUMNINFO* pInfo);
	
	//@cmember Fetch row data
	HRESULT GetRow(ULONG* ulOffset, BYTE* pbProvRow);

	//@cmember Update the current rows values
	HRESULT UpdateRow(ULONG* pulBookmark, ULONG* ulOffset, BYTE* pbProvRow, PACCESSOR	pAccessor, BYTE* pbProvRowOld);
	//@cmember Insert new row
	HRESULT InsertRow(ULONG* ulOffset, BYTE* pbProvRow, PACCESSOR pAccessor);
	//@cmember Remove row with the bmk
	HRESULT DeleteRow(ULONG* pulBookmark);

public:
	CSchema::CSchema( CDBSession* pSession );
	CSchema::~CSchema();

	//Initialize object with schema data
	HRESULT Init(REFGUID pguidSchema, CSwstMetaHolder* pSwstMetaHolder, ULONG cRestrictions, const VARIANT rgRestrictions[]);

protected:
	//Initialize object with columns schema
	HRESULT InitColumns(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with provider types schema
	HRESULT InitProviderTypes(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with columns schema
	HRESULT InitTables(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with catalogs schema
	HRESULT InitCatalogs(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with schemata schema
	HRESULT InitSchemata(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with statistics schema
	HRESULT InitStatistics(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with indexes schema
	HRESULT InitIndexes(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with constraint columns schema
	HRESULT InitConstraintColumns(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with constraint tables schema
	HRESULT InitConstraintTables(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with table constraints schema
	HRESULT InitTableConstraints(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with referential constraints schema
	HRESULT InitReferentialConstraints(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with primary keys schema
	HRESULT InitPrimaryKeys(ULONG cRestrictions, const VARIANT rgRestrictions[]);
	//Initialize object with foreign keys schema
	HRESULT InitForeignKeys(ULONG cRestrictions, const VARIANT rgRestrictions[]);

	//Get row for TABLES schema
	HRESULT GetTablesRow(ULONG* pulOffset, BYTE* pbProvRow);	
	//Get row for COLUMNS schema
	HRESULT GetColumnsRow(ULONG* pulOffset, BYTE* pbProvRow);	
	//Get row for PROVIDER_TYPES schema
	HRESULT GetTypesRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for CATALOGS schema
	HRESULT GetCatalogsRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for SCHEMATA schema
	HRESULT GetSchemataRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for STATISTICS schema
	HRESULT GetStatisticsRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for INDEXES schema
	HRESULT GetIndexesRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for CONSTRAINT_COLUMN_USAGE schema
	HRESULT GetConstraintColumnsRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for CONSTRAINT_TABLE_USAGE schema
	HRESULT GetConstraintTablesRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for TABLE_CONSTRAINTS schema
	HRESULT GetTableConstraintsRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for REFERENTIAL_CONSTRAINTS schema
	HRESULT GetReferentialConstraintsRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for PRIMARY_KEYS schema
	HRESULT GetPrimaryKeysRow(ULONG* pulOffset, BYTE* pbProvRow);
	//Get row for FOREIGN_KEYS schema
	HRESULT GetForeignKeysRow(ULONG* pulOffset, BYTE* pbProvRow);

	//@cmember Converts position to bookmark
	inline ULONG Pos2Bmk(ULONG ulPos) { return (ulPos + NUM_OF_RESERVED_BOOKMARKS); }
	//@cmember Converts bookmark to position  
	inline ULONG Bmk2Pos(ULONG ulBmk) { return (ulBmk - NUM_OF_RESERVED_BOOKMARKS); }

	//Number of columns
	ULONG m_cCols;
	//Information about columns
	COLINFO* m_pColumns;
	
	//Current row
	LONG m_lCurrentRow;
	//Number of rows
	LONG m_cRows;
	//Information about types
	TYPEINFO**		m_ppTypes;
	SWSTFILE**		m_ppFiles;
	FIELDINFO*		m_pFieldInfos;
	CATALOGINFO*	m_pCatalogInfos;
	CatalogOwner**   m_pSchemataInfos;
	STATINFO*		m_pStatistics;
	SWSTINDEX**		m_ppIndexes;
	SWSTRELATE**	m_ppRelations;
	FOREIGNKEYINFO* m_pForeignKeyInfo;

	//Meta data descriptions
	CSwstMetaHolder* m_pSwstMetaHolder;

	//Current schema
	SCHEMA m_enumSchema;

	// Data source 
	CDataSource*	m_pCDataSource;

	// Multirow fetching
	CRowInfo*		m_plRowPositions;

	FINISH_CLASS(); 
};


#endif