/* Copyright (C) 2000 MySQL AB & MySQL Finland AB & TCX DataKonsult AB
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA */

/* This file is for Chinese character sets GBK, created by Wei He 
   (hewei@mail.ied.ac.cn)
*/

/*
 * This comment is parsed by configure to create ctype.c,
 * so don't change it unless you know what you are doing.
 *
 * .configure. strxfrm_multiply_gbk=1
 * .configure. mbmaxlen_gbk=2
 */


#include <global.h>
#include "m_string.h"
#include "m_ctype.h"

/* Support for Chinese(GBK) characters, by hewei@mail.ied.ac.cn */

#define isgbkhead(c) (0x81<=(uchar)(c) && (uchar)(c)<=0xfe)
#define isgbktail(c) ((0x40<=(uchar)(c) && (uchar)(c)<=0x7e) || \
                          (0x80<=(uchar)(c) && (uchar)(c)<=0xfe))

#define isgbkcode(c,d) (isgbkhead(c) && isgbktail(d))
#define gbkcode(c,d)   ((((uint) (uchar) (c)) <<8) | (uchar)(d))
#define gbkhead(e)     ((uchar)(e>>8))
#define gbktail(e)     ((uchar)(e&0xff))

uchar NEAR ctype_gbk[257] =
{
  0,				/* For standard library */
  32,32,32,32,32,32,32,32,32,40,40,40,40,40,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  72,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
  132,132,132,132,132,132,132,132,132,132,16,16,16,16,16,16,
  16,129,129,129,129,129,129,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,16,16,16,16,16,
  16,130,130,130,130,130,130,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,16,16,16,16,32,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
};

uchar NEAR to_lower_gbk[]=
{
  '\000','\001','\002','\003','\004','\005','\006','\007',
  '\010','\011','\012','\013','\014','\015','\016','\017',
  '\020','\021','\022','\023','\024','\025','\026','\027',
  '\030','\031','\032','\033','\034','\035','\036','\037',
  ' ',	 '!',	'"',   '#',   '$',   '%',   '&',   '\'',
  '(',	 ')',	'*',   '+',   ',',   '-',   '.',   '/',
  '0',	 '1',	'2',   '3',   '4',   '5',   '6',   '7',
  '8',	 '9',	':',   ';',   '<',   '=',   '>',   '?',
  '@',	 'a',	'b',   'c',   'd',   'e',   'f',   'g',
  'h',	 'i',	'j',   'k',   'l',   'm',   'n',   'o',
  'p',	 'q',	'r',   's',   't',   'u',   'v',   'w',
  'x',	 'y',	'z',   '[',   '\\',  ']',   '^',   '_',
  '`',	 'a',	'b',   'c',   'd',   'e',   'f',   'g',
  'h',	 'i',	'j',   'k',   'l',   'm',   'n',   'o',
  'p',	 'q',	'r',   's',   't',   'u',   'v',   'w',
  'x',	 'y',	'z',   '{',   '|',   '}',   '~',   '\177',
  (uchar) '\200',(uchar) '\201',(uchar) '\202',(uchar) '\203',(uchar) '\204',(uchar) '\205',(uchar) '\206',(uchar) '\207',
  (uchar) '\210',(uchar) '\211',(uchar) '\212',(uchar) '\213',(uchar) '\214',(uchar) '\215',(uchar) '\216',(uchar) '\217',
  (uchar) '\220',(uchar) '\221',(uchar) '\222',(uchar) '\223',(uchar) '\224',(uchar) '\225',(uchar) '\226',(uchar) '\227',
  (uchar) '\230',(uchar) '\231',(uchar) '\232',(uchar) '\233',(uchar) '\234',(uchar) '\235',(uchar) '\236',(uchar) '\237',
  (uchar) '\240',(uchar) '\241',(uchar) '\242',(uchar) '\243',(uchar) '\244',(uchar) '\245',(uchar) '\246',(uchar) '\247',
  (uchar) '\250',(uchar) '\251',(uchar) '\252',(uchar) '\253',(uchar) '\254',(uchar) '\255',(uchar) '\256',(uchar) '\257',
  (uchar) '\260',(uchar) '\261',(uchar) '\262',(uchar) '\263',(uchar) '\264',(uchar) '\265',(uchar) '\266',(uchar) '\267',
  (uchar) '\270',(uchar) '\271',(uchar) '\272',(uchar) '\273',(uchar) '\274',(uchar) '\275',(uchar) '\276',(uchar) '\277',
  (uchar) '\300',(uchar) '\301',(uchar) '\302',(uchar) '\303',(uchar) '\304',(uchar) '\305',(uchar) '\306',(uchar) '\307',
  (uchar) '\310',(uchar) '\311',(uchar) '\312',(uchar) '\313',(uchar) '\314',(uchar) '\315',(uchar) '\316',(uchar) '\317',
  (uchar) '\320',(uchar) '\321',(uchar) '\322',(uchar) '\323',(uchar) '\324',(uchar) '\325',(uchar) '\326',(uchar) '\327',
  (uchar) '\330',(uchar) '\331',(uchar) '\332',(uchar) '\333',(uchar) '\334',(uchar) '\335',(uchar) '\336',(uchar) '\337',
  (uchar) '\340',(uchar) '\341',(uchar) '\342',(uchar) '\343',(uchar) '\344',(uchar) '\345',(uchar) '\346',(uchar) '\347',
  (uchar) '\350',(uchar) '\351',(uchar) '\352',(uchar) '\353',(uchar) '\354',(uchar) '\355',(uchar) '\356',(uchar) '\357',
  (uchar) '\360',(uchar) '\361',(uchar) '\362',(uchar) '\363',(uchar) '\364',(uchar) '\365',(uchar) '\366',(uchar) '\367',
  (uchar) '\370',(uchar) '\371',(uchar) '\372',(uchar) '\373',(uchar) '\374',(uchar) '\375',(uchar) '\376',(uchar) '\377',
};

uchar NEAR to_upper_gbk[]=
{
  '\000','\001','\002','\003','\004','\005','\006','\007',
  '\010','\011','\012','\013','\014','\015','\016','\017',
  '\020','\021','\022','\023','\024','\025','\026','\027',
  '\030','\031','\032','\033','\034','\035','\036','\037',
  ' ',	 '!',	'"',   '#',   '$',   '%',   '&',   '\'',
  '(',	 ')',	'*',   '+',   ',',   '-',   '.',   '/',
  '0',	 '1',	'2',   '3',   '4',   '5',   '6',   '7',
  '8',	 '9',	':',   ';',   '<',   '=',   '>',   '?',
  '@',	 'A',	'B',   'C',   'D',   'E',   'F',   'G',
  'H',	 'I',	'J',   'K',   'L',   'M',   'N',   'O',
  'P',	 'Q',	'R',   'S',   'T',   'U',   'V',   'W',
  'X',	 'Y',	'Z',   '[',   '\\',  ']',   '^',   '_',
  '`',	 'A',	'B',   'C',   'D',   'E',   'F',   'G',
  'H',	 'I',	'J',   'K',   'L',   'M',   'N',   'O',
  'P',	 'Q',	'R',   'S',   'T',   'U',   'V',   'W',
  'X',	 'Y',	'Z',   '{',   '|',   '}',   '~',   '\177',
  (uchar) '\200',(uchar) '\201',(uchar) '\202',(uchar) '\203',(uchar) '\204',(uchar) '\205',(uchar) '\206',(uchar) '\207',
  (uchar) '\210',(uchar) '\211',(uchar) '\212',(uchar) '\213',(uchar) '\214',(uchar) '\215',(uchar) '\216',(uchar) '\217',
  (uchar) '\220',(uchar) '\221',(uchar) '\222',(uchar) '\223',(uchar) '\224',(uchar) '\225',(uchar) '\226',(uchar) '\227',
  (uchar) '\230',(uchar) '\231',(uchar) '\232',(uchar) '\233',(uchar) '\234',(uchar) '\235',(uchar) '\236',(uchar) '\237',
  (uchar) '\240',(uchar) '\241',(uchar) '\242',(uchar) '\243',(uchar) '\244',(uchar) '\245',(uchar) '\246',(uchar) '\247',
  (uchar) '\250',(uchar) '\251',(uchar) '\252',(uchar) '\253',(uchar) '\254',(uchar) '\255',(uchar) '\256',(uchar) '\257',
  (uchar) '\260',(uchar) '\261',(uchar) '\262',(uchar) '\263',(uchar) '\264',(uchar) '\265',(uchar) '\266',(uchar) '\267',
  (uchar) '\270',(uchar) '\271',(uchar) '\272',(uchar) '\273',(uchar) '\274',(uchar) '\275',(uchar) '\276',(uchar) '\277',
  (uchar) '\300',(uchar) '\301',(uchar) '\302',(uchar) '\303',(uchar) '\304',(uchar) '\305',(uchar) '\306',(uchar) '\307',
  (uchar) '\310',(uchar) '\311',(uchar) '\312',(uchar) '\313',(uchar) '\314',(uchar) '\315',(uchar) '\316',(uchar) '\317',
  (uchar) '\320',(uchar) '\321',(uchar) '\322',(uchar) '\323',(uchar) '\324',(uchar) '\325',(uchar) '\326',(uchar) '\327',
  (uchar) '\330',(uchar) '\331',(uchar) '\332',(uchar) '\333',(uchar) '\334',(uchar) '\335',(uchar) '\336',(uchar) '\337',
  (uchar) '\340',(uchar) '\341',(uchar) '\342',(uchar) '\343',(uchar) '\344',(uchar) '\345',(uchar) '\346',(uchar) '\347',
  (uchar) '\350',(uchar) '\351',(uchar) '\352',(uchar) '\353',(uchar) '\354',(uchar) '\355',(uchar) '\356',(uchar) '\357',
  (uchar) '\360',(uchar) '\361',(uchar) '\362',(uchar) '\363',(uchar) '\364',(uchar) '\365',(uchar) '\366',(uchar) '\367',
  (uchar) '\370',(uchar) '\371',(uchar) '\372',(uchar) '\373',(uchar) '\374',(uchar) '\375',(uchar) '\376',(uchar) '\377',
};

uchar NEAR sort_order_gbk[]=
{
  '\000','\001','\002','\003','\004','\005','\006','\007',
  '\010','\011','\012','\013','\014','\015','\016','\017',
  '\020','\021','\022','\023','\024','\025','\026','\027',
  '\030','\031','\032','\033','\034','\035','\036','\037',
  ' ',	 '!',	'"',   '#',   '$',   '%',   '&',   '\'',
  '(',	 ')',	'*',   '+',   ',',   '-',   '.',   '/',
  '0',	 '1',	'2',   '3',   '4',   '5',   '6',   '7',
  '8',	 '9',	':',   ';',   '<',   '=',   '>',   '?',
  '@',	 'A',	'B',   'C',   'D',   'E',   'F',   'G',
  'H',	 'I',	'J',   'K',   'L',   'M',   'N',   'O',
  'P',	 'Q',	'R',   'S',   'T',   'U',   'V',   'W',
  'X',	 'Y',	'Z',   '\\',  ']',   '[',   '^',   '_',
  '`',	 'A',	'B',   'C',   'D',   'E',   'F',   'G',
  'H',	 'I',	'J',   'K',   'L',   'M',   'N',   'O',
  'P',	 'Q',	'R',   'S',   'T',   'U',   'V',   'W',
  'X',	 'Y',	'Z',   '{',   '|',   '}',   'Y',   '\177',
  (uchar) '\200',(uchar) '\201',(uchar) '\202',(uchar) '\203',(uchar) '\204',(uchar) '\205',(uchar) '\206',(uchar) '\207',
  (uchar) '\210',(uchar) '\211',(uchar) '\212',(uchar) '\213',(uchar) '\214',(uchar) '\215',(uchar) '\216',(uchar) '\217',
  (uchar) '\220',(uchar) '\221',(uchar) '\222',(uchar) '\223',(uchar) '\224',(uchar) '\225',(uchar) '\226',(uchar) '\227',
  (uchar) '\230',(uchar) '\231',(uchar) '\232',(uchar) '\233',(uchar) '\234',(uchar) '\235',(uchar) '\236',(uchar) '\237',
  (uchar) '\240',(uchar) '\241',(uchar) '\242',(uchar) '\243',(uchar) '\244',(uchar) '\245',(uchar) '\246',(uchar) '\247',
  (uchar) '\250',(uchar) '\251',(uchar) '\252',(uchar) '\253',(uchar) '\254',(uchar) '\255',(uchar) '\256',(uchar) '\257',
  (uchar) '\260',(uchar) '\261',(uchar) '\262',(uchar) '\263',(uchar) '\264',(uchar) '\265',(uchar) '\266',(uchar) '\267',
  (uchar) '\270',(uchar) '\271',(uchar) '\272',(uchar) '\273',(uchar) '\274',(uchar) '\275',(uchar) '\276',(uchar) '\277',
  (uchar) '\300',(uchar) '\301',(uchar) '\302',(uchar) '\303',(uchar) '\304',(uchar) '\305',(uchar) '\306',(uchar) '\307',
  (uchar) '\310',(uchar) '\311',(uchar) '\312',(uchar) '\313',(uchar) '\314',(uchar) '\315',(uchar) '\316',(uchar) '\317',
  (uchar) '\320',(uchar) '\321',(uchar) '\322',(uchar) '\323',(uchar) '\324',(uchar) '\325',(uchar) '\326',(uchar) '\327',
  (uchar) '\330',(uchar) '\331',(uchar) '\332',(uchar) '\333',(uchar) '\334',(uchar) '\335',(uchar) '\336',(uchar) '\337',
  (uchar) '\340',(uchar) '\341',(uchar) '\342',(uchar) '\343',(uchar) '\344',(uchar) '\345',(uchar) '\346',(uchar) '\347',
  (uchar) '\350',(uchar) '\351',(uchar) '\352',(uchar) '\353',(uchar) '\354',(uchar) '\355',(uchar) '\356',(uchar) '\357',
  (uchar) '\360',(uchar) '\361',(uchar) '\362',(uchar) '\363',(uchar) '\364',(uchar) '\365',(uchar) '\366',(uchar) '\367',
  (uchar) '\370',(uchar) '\371',(uchar) '\372',(uchar) '\373',(uchar) '\374',(uchar) '\375',(uchar) '\376',(uchar) '\377',
};

static uint16 NEAR gbk_order[]=
{
8653,14277,17116,11482,11160,2751,14613,3913,13337,9827,
19496,1759,8105,7103,7836,5638,2223,21433,5878,8006,
4851,18766,18879,16728,8129,6200,19133,6389,2500,19084,
16228,5074,8130,5900,6201,3985,14597,11566,8588,8769,
15885,11411,11965,1961,18012,18303,12242,14118,11490,12911,
15015,4367,3184,2093,20937,5710,5108,10560,9993,18982,
8393,10697,14620,19558,14970,15193,5359,18189,12666,18192,
3310,18659,17358,7973,18673,19537,3404,9723,4221,16486,
7023,13648,16310,1049,1726,4799,15534,4366,17133,4192,
6219,5118,1804,2360,2279,14279,13740,4511,2361,12906,
16650,18590,4723,2001,16313,3594,21026,12146,19561,3800,
4161,16774,18892,17657,7025,892,7917,12245,3394,4813,
11902,3189,20002,2365,12964,18115,17660,20227,17182,11907,
11671,17562,17864,21131,13423,1361,12246,18897,14978,18848,
20727,5902,10726,21241,1906,13424,1408,20519,3038,18495,
20446,1431,17138,13464,14558,1221,6720,6137,17348,5268,
4448,11313,1760,6172,6870,5744,13541,3044,17701,14368,
16114,5051,9142,18776,5669,19089,11088,17867,925,10395,
4372,10578,2138,2554,18118,21087,13862,7461,14983,3322,
15305,11844,7924,8087,2542,20701,21772,2754,10490,8218,
14800,15869,14436,16119,1814,11543,17398,16069,19659,17020,
17844,5694,8833,16744,18925,4957,9812,6852,8036,12966,
14038,12145,16833,11165,17076,17756,3673,2367,20916,9143,
14927,6885,17486,7469,1661,2827,4627,18198,1307,19711,
17637,2595,2262,20807,1764,8150,18547,3192,9711,16262,
9144,2006,21629,5311,15743,14733,10991,15402,2916,17724,
12195,12622,5141,8039,15169,7780,4568,20835,21575,10580,
15022,9470,6853,3926,21563,1342,16745,8181,11526,1947,
7402,18641,14145,13149,19222,2468,12920,13916,21077,2968,
16438,19667,1768,15632,18374,4738,15517,16655,4309,2374,
14492,8602,3679,2103,1312,18681,6613,18604,20451,2755,
18218,19473,17854,20316,3003,4998,1391,20938,11169,7049,
18861,17577,18091,1937,4085,2059,20633,15948,1313,20138,
7785,16439,15081,20955,15117,17065,19924,13831,11913,20062,
7568,10703,3717,15480,6047,7790,16867,14223,12971,8429,
2008,2833,14026,1317,17493,19411,18551,15452,15257,18504,
4441,1769,7249,20128,5509,1970,9420,19365,20190,21617,
12202,15041,2871,19676,20388,21674,14258,2901,8058,5970,
20472,13257,18226,3694,17591,10279,1318,12409,7901,9794,
10416,10769,12876,17154,15455,19298,3970,21327,14228,13095,
8096,16072,21748,12581,9326,2311,5683,12641,3583,2184,
16464,6969,1795,6778,2880,15819,3433,7674,4713,17297,
8231,4333,9995,1841,5558,17155,17298,11283,18694,7946,
7311,13129,4753,21149,905,14010,18821,8532,11873,2190,
19006,3456,8874,7433,2841,7680,14143,20130,1993,1699,
976,15361,2736,2154,9202,11685,7951,12982,11008,16763,
11829,13327,11686,2299,9940,10507,8917,1277,19790,1636,
20143,21002,15011,19443,6026,13299,2455,9667,15612,16477,
10261,2811,2202,13674,14760,6818,9691,10624,20145,11940,
15524,18349,9437,11578,20132,17736,4121,4122,16023,2280,
4371,4373,7873,18307,14602,14695,13054,5410,6065,14389,
3979,1137,5411,6672,16311,11632,9829,19575,5901,15708,
12553,7165,18983,10860,13664,18242,10848,2049,8075,5579,
8083,10863,21136,5445,17851,19132,8597,18771,11054,14631,
10997,8292,8803,11246,4999,17559,11134,15369,5155,6407,
12054,4857,11265,12834,7322,15057,10937,15984,5544,8040,
13291,3961,5142,19101,869,9631,2009,11315,21404,3172,
14941,4204,7947,9997,16906,4035,4476,4477,8171,2818,
20725,4724,11453,20868,4725,4729,8565,5109,12490,8862,
5920,13737,2888,6930,12963,3223,6934,3395,16243,8397,
9475,4858,13515,3777,11266,10029,21028,1671,7765,7766,
14169,2221,5328,2907,8951,4225,4416,7770,3046,8014,
3975,10636,20236,19825,3248,8717,2140,2908,3249,9477,
4628,2225,12676,2909,21564,5167,1225,4186,13266,4017,
7471,7146,18214,6890,4195,16037,16688,5583,14497,7476,
3286,8566,2910,2862,2232,16038,10417,9492,12234,14190,
8793,5573,6486,20322,21455,9734,8317,10143,5781,7681,
5782,7500,7501,15466,7188,7511,7512,21003,2203,21693,
11350,9540,21212,18183,7918,8754,17511,20869,18899,21160,
11356,9315,8364,8798,18460,16189,17483,11415,8897,7771,
9917,8718,7926,5228,11270,2644,9269,19404,8719,8367,
13267,10400,1914,2157,8584,11171,3964,17881,16785,18951,
18052,16616,14500,9323,10418,12410,14661,6963,7570,7668,
13601,17386,18995,8437,4460,8346,15920,8318,3387,10734,
18057,18058,10525,9654,2390,13675,13603,20000,8106,1260,
10824,1426,5075,5076,18887,12175,8174,15558,5269,4304,
5380,3287,8156,5386,11605,8142,18768,7580,8641,6319,
13425,4478,13147,2019,8900,6331,19668,5756,6769,3381,
9009,9730,9735,15160,4036,8167,13489,17009,8667,18308,
13439,18112,11735,21667,14617,17010,16290,16291,17515,3368,
7050,14841,5636,16826,17573,7760,18493,13306,14312,2619,
17868,13609,8991,7038,4310,16881,14020,16422,20565,5941,
18174,3642,20346,12080,856,13144,18158,20908,10800,15630,
14340,15837,21707,4629,2060,19870,9632,3718,7902,994,
5762,18391,9647,2312,9199,9648,18281,18342,19911,5367,
9950,13834,13513,8771,9414,4057,21302,1963,1964,1967,
902,3349,14697,5602,1071,13959,14621,21428,7288,15079,
7039,16495,13949,3111,5580,13365,2615,4109,6202,11213,
10792,17918,21538,3226,18658,11985,6862,18734,2752,13232,
7838,1907,4252,6223,16703,11495,18037,3974,6301,5226,
8514,10487,5267,10892,12763,16706,7702,20003,2616,14457,
16083,16587,4296,14513,8355,12171,16590,10670,13651,3646,
14626,21132,15826,17015,18911,12792,12461,21545,17848,18912,
17396,3277,13516,5918,16115,12548,1673,4864,18438,6078,
5880,3263,16211,21784,1909,15296,17183,6884,12796,4417,
4299,17021,21137,14801,17484,8852,6512,15560,4300,17921,
5819,9342,15900,17742,19525,3869,11715,17703,12554,6040,
19865,10267,12549,10804,21670,6091,17277,9319,12531,9840,
1060,11215,10514,15170,4892,5904,14898,19534,5469,5470,
1128,5922,18937,7270,15971,17189,16263,9474,13382,2369,
20210,18177,3976,12767,3618,13236,10885,5397,15621,8770,
9830,9310,14121,21573,16634,19148,12803,4381,13051,956,
20237,3755,19551,15744,9169,16852,866,11893,21439,3680,
6197,17412,17324,16086,16747,16602,3834,5510,12770,12771,
3420,16198,21552,1421,3198,6097,18178,12772,20576,9831,
17200,19226,5584,20226,5822,10609,11641,3599,13550,15387,
5361,15481,952,3426,19731,20581,21103,2153,16223,19719,
20139,18533,11172,6356,20044,6584,6585,6954,21058,16397,
14150,17888,6618,4199,11775,9843,19732,14051,2564,13093,
18379,3377,12174,1968,19359,16350,19294,12243,1294,5362,
20214,6898,15645,18557,6146,13005,14084,19366,6272,17534,
10713,2104,5894,13900,16200,6964,12093,16692,12975,21496,
9358,16216,7314,15280,3056,14008,5363,11510,13001,1474,
997,9724,21709,20612,11383,15441,7715,2684,7622,8585,
15456,14192,872,17497,10281,17428,6338,6779,5831,11989,
17156,20245,2293,12512,3560,10705,6367,5040,15465,18663,
14003,7716,17498,6462,10721,13660,9327,17501,6973,9010,
17433,6024,10669,13098,2842,15393,3436,18133,4283,21749,
4461,2571,6707,1986,2900,3138,3434,19771,9090,16900,
12816,6022,9736,17830,6708,19167,18099,11781,14950,18337,
19249,3270,20404,21152,11875,6791,17596,7723,19933,884,
19376,8877,19687,12164,3544,17647,4150,3457,17648,12338,
19127,21715,11831,3635,9259,15329,6901,17127,18710,4191,
12352,21112,7195,7956,2300,18061,10887,15701,10319,6808,
1859,19445,11794,19170,6436,10969,6216,20594,9522,10157,
5898,11567,11326,18410,9674,10340,10229,11345,3447,2456,
12439,12340,17368,10889,17057,4224,8845,18285,2207,19263,
3872,9117,15331,17456,2995,6523,6919,21337,11803,17457,
1936,9533,2248,2161,9697,19072,10607,20163,15100,6199,
20287,7392,20107,21238,9225,11809,13650,10203,6717,19085,
11816,16035,8643,19823,8084,12359,20004,3059,6719,4253,
5838,15886,15982,5839,13638,13780,5840,15341,5842,19140,
6854,5923,10582,5843,2868,16398,19872,13534,8824,12598,
19879,19880,18208,16051,16004,16005,16039,10567,6783,19020,
10539,10550,18184,16018,15868,12573,10392,8863,8172,19697,
12845,12846,21424,3476,12833,17119,14167,11764,11357,7264,
20873,18048,18901,13220,4667,8756,16106,4705,1432,8009,
3665,7966,7128,2587,7967,12053,15477,13430,20832,5587,
15350,8076,18496,4801,10396,13339,5438,18013,1074,10032,
21247,4985,6322,20909,989,3323,12104,11235,7138,6138,
10512,3008,2621,19090,6306,4110,20541,4877,5674,18543,
4231,5748,2116,18465,17517,14702,1762,6233,3281,8548,
3479,6000,954,17677,17278,1186,4803,1097,18938,19207,
5954,17874,2917,13191,1374,4557,13610,19406,8518,7240,
3675,9306,8357,7882,20573,9913,6446,1915,8078,18661,
3600,18200,13551,15199,13252,16268,8298,10602,20739,8775,
2704,3928,15450,1948,2829,1375,8603,4214,18952,20841,
21403,12685,8299,11653,8726,9031,11701,7331,5169,19721,
4311,5546,9471,4548,18163,9032,972,14386,11607,15974,
2517,6540,1462,9789,5823,21324,1244,19595,10838,7744,
13909,18685,5360,21578,19596,6619,4318,18552,1268,3013,
10906,2309,16148,12551,4773,21079,7858,7887,6198,5174,
2935,8605,12479,9418,17729,6610,4093,16233,17928,17030,
7062,8871,19299,19417,8569,15122,14579,11123,16618,2526,
15997,13618,21060,9639,12203,1209,20185,4112,15728,16751,
20767,18053,20711,898,5381,18272,8607,16540,17592,10190,
5887,9300,2294,12204,1384,2426,10427,10374,11972,12978,
10920,11384,16040,14865,10301,1622,2072,20975,20512,8617,
3765,2439,20849,7172,5829,13045,7943,3700,3174,18392,
15307,20290,12928,16506,21383,13068,14230,14231,1088,12583,
8875,3942,4462,13626,4146,3217,3701,14505,4242,4245,
15413,3587,11432,4684,6631,15414,3271,18690,21282,7502,
1039,13032,13072,8748,19021,12316,3766,7551,18665,1852,
15419,9243,8322,6513,3492,13684,12987,18062,9260,16999,
906,18151,3529,13911,7957,9427,8940,10341,18286,15427,
16481,6514,10263,10264,13950,9675,9985,2208,18070,18291,
9406,1106,16240,14024,21355,18735,10727,21254,21358,6353,
9064,6357,17889,9070,14715,10820,4147,14718,18755,5496,
7582,4769,20373,1592,15166,13637,10033,3251,17753,17613,
11596,17130,19916,10850,4182,13264,11964,5447,12805,11003,
11047,2440,20269,5601,5209,15535,15370,18300,1406,6926,
20037,7229,1056,4359,3596,12118,8363,17518,3735,18497,
6573,8553,20360,1351,6662,4610,3780,18127,1363,1032,
16617,12536,16800,1037,7571,9731,4203,19993,7572,14677,
4715,6902,1527,10540,2376,3886,12847,8131,11926,2135,
17136,4517,7104,6221,3365,4816,8031,5875,16599,21029,
11997,5995,21069,20005,4807,2552,8400,21341,18361,11496,
17629,4669,4726,16292,4072,1075,21429,20521,11523,19918,
15958,17185,18913,4247,11358,1436,14370,4248,6080,17849,
4434,20728,11236,1173,4817,10034,21539,13666,14173,18439,
10741,21482,8275,13754,3952,7040,5056,17377,6456,8339,
5443,7327,7328,11738,20834,20673,17273,6182,5675,8491,
8847,18364,11314,9918,12150,4302,19527,18255,14375,14566,
5749,13543,15020,6234,17279,14316,2502,17574,10805,4827,
11443,8723,2979,2980,15870,17708,11546,19581,12503,11626,
20926,5924,21344,12472,16076,17280,16710,18256,16748,16841,
18260,19582,14989,9609,8190,21375,12628,17194,21440,3929,
10404,879,4249,10275,11146,3095,12550,8191,1949,10054,
17413,14766,12773,6692,5001,16647,16648,15405,4581,4582,
15709,11654,13552,8046,7979,12868,3756,17726,6421,16231,
9150,19109,21097,11614,5002,10583,973,9033,19149,18201,
8192,9622,3737,17195,6447,6480,3483,18605,11564,13964,
7294,15949,19734,16351,3689,13838,10941,3378,13918,13178,
6693,16657,12924,2936,11189,5005,7831,4086,18806,21080,
6620,11148,932,19228,17929,7745,16352,20747,13345,15635,
17584,16171,9790,10871,13670,14932,12361,16502,16199,3132,
6358,7791,1245,17817,15950,5715,21662,18558,19882,13796,
13901,10132,10944,12039,1026,10672,9002,13206,20689,19883,
7746,13800,11302,19235,15124,11752,15542,12085,9276,11609,
1235,12346,18996,19759,17966,10773,18749,8627,19370,11703,
5719,7905,21307,20246,5908,9361,20563,6426,6427,1034,
13922,10677,12423,5487,16758,13099,16174,20438,11193,17210,
17211,11392,9864,9712,6490,5723,3572,20852,17832,18753,
6482,16901,9011,13705,18396,2181,7625,10946,4534,4463,
17161,19022,6168,7724,4536,14680,15209,13033,9774,17945,
17649,11755,3943,19023,1971,907,11742,11832,10673,15800,
2738,7958,3028,19632,12437,13822,13876,11528,18236,15363,
19255,12988,19972,11154,1403,14431,17732,11711,4037,10186,
19849,9247,18411,10100,7696,11743,9249,17172,19264,14855,
6822,13579,11104,9538,10541,18292,21213,9251,8394,21477,
17662,14984,15342,19522,21318,15232,11216,3096,12869,18145,
11682,21506,9501,18022,1877,11517,11798,19265,10542,13830,
13303,7230,13858,18591,18772,8010,21395,21223,6229,14563,
18794,15793,14603,2503,13642,5375,17403,20364,3516,14419,
6659,11115,8804,1950,20141,19831,13343,6142,20637,7482,
11825,1770,6541,13226,14576,11826,7938,11847,20963,19677,
1247,8885,11827,8312,13229,6339,14584,11828,14425,16469,
17560,8886,6784,8533,19039,18830,1257,13187,2705,1258,
4762,10511,4124,12519,21303,4828,8724,7588,21305,18092,
14812,4131,3527,7762,4393,4394,14764,14280,11327,9907,
17242,17243,9046,16304,9904,10796,16305,16306,16307,18541,
4232,8998,21059,5110,5515,16061,5115,5116,17012,1390,
7844,15716,3798,14519,20669,17576,11649,16842,16843,10758,
10309,12474,15684,4631,17585,10500,2084,17597,8329,8391,
9883,8392,21237,17624,11692,16188,17134,9579,4288,3503,
6742,10206,13743,16775,5949,14364,2765,18725,19947,1157,
18592,981,16777,7768,4290,4670,16248,12907,12663,7839,
21769,21770,18498,8276,5161,18015,12501,9591,15773,13432,
4865,16137,12288,1030,8924,13433,12525,15774,10036,2589,
12463,2091,1185,15898,18016,1588,6083,8721,10649,4303,
4990,3826,10399,4363,4375,5057,13530,18786,11438,14567,
926,16386,6533,11113,9552,7139,3954,16387,19529,5502,
9919,18545,7610,4258,17519,1884,13639,4736,11585,9555,
19464,17281,13793,3517,14382,2504,15985,5349,5231,17082,
19141,19665,9307,8616,17234,13611,2695,15316,9955,6478,
8193,9151,11248,9034,9035,21671,5547,18164,5179,10584,
10585,10055,4187,20740,19151,3965,5926,20741,16440,12301,
7787,21672,8823,3930,19152,21490,20275,6621,19597,18474,
4742,13395,18475,15636,18862,20956,14654,4319,21271,8594,
10518,18318,10942,5932,6955,6586,15855,16795,19598,21579,
9193,8712,18267,18268,16447,21580,2121,15200,8679,13179,
12699,15998,4113,16882,16619,2010,15485,13801,7795,870,
10133,16801,13060,1368,3719,12950,19418,11778,3238,14580,
13968,15043,21588,7596,9858,8628,2233,3853,2076,3890,
15978,10302,20433,20434,998,2031,13447,13009,3175,21713,
3524,3525,16958,19760,12160,10221,17387,2085,1796,13182,
7626,18232,9328,20458,9866,9867,7890,4243,21738,7721,
8441,18574,7627,18575,8442,20405,19024,18023,11593,18705,
18706,18824,11788,17251,7074,17601,8707,5724,3710,1040,
21730,16369,13823,3530,10114,7818,19688,19975,19196,13859,
7823,9660,5732,10230,10231,19319,16937,8244,2209,19345,
8961,18287,11599,13580,2359,3159,10543,3729,3730,11805,
18293,18294,18354,8989,18295,8861,6605,7968,2341,9938,
8768,12561,12562,13406,20792,20522,18795,7897,15252,13598,
12240,4852,20087,3876,11763,4648,12010,20874,6409,3412,
3325,11359,4866,11367,18927,18928,12467,12835,8356,13863,
14839,14878,13123,20625,14523,13643,3336,5707,12475,20508,
7408,16232,3339,14148,12687,4061,6287,20780,17818,16400,
18969,1192,12480,3839,5382,12040,15543,11124,7309,15602,
6704,21044,14193,1623,5847,20247,11469,1193,8019,2236,
20985,6342,1492,1504,20496,11136,13073,2171,4685,11015,
1195,2739,11224,2793,7816,17258,9214,7318,1761,5147,
7112,15831,20270,5689,10886,13188,4163,18175,1124,7840,
21342,18140,3047,15899,18853,20918,15766,20919,17405,15986,
5754,8835,10998,19501,1885,1763,2547,9152,7051,15026,
14808,13284,19736,11210,15061,2064,17327,4633,8155,4327,
16448,10191,17124,15062,20964,1923,13258,8159,8160,10282,
19210,3348,10428,18997,2788,16006,14951,17645,11211,2313,
16759,4637,5691,8789,8878,1513,13034,9999,9884,10342,
7208,19346,17173,15845,19387,9539,15847,18074,3612,12524,
6721,11524,6722,4706,8251,18309,20183,18728,4413,14016,
4414,14663,3799,6402,16674,3664,7583,1095,14412,20469,
15536,4954,3649,2329,20674,18787,8365,14285,19827,8041,
3781,20470,7589,13024,12198,1463,14347,15407,7422,5256,
4428,1475,8794,7429,1682,17439,3437,5832,7552,6264,
11065,5836,16239,8476,7122,10397,6770,6771,18825,18826,
18836,19941,19942,16558,18365,19706,2556,3782,19419,12386,
2582,21425,16167,7028,21030,16314,3597,10037,4867,16320,
16834,16192,2543,20927,8042,3094,20798,3097,16984,7154,
20939,3065,21098,9153,17578,7857,7477,14656,7295,1595,
5007,16449,1210,16883,20750,12413,15649,3561,20754,1676,
2686,2387,18576,6792,10927,10271,17338,1280,13490,9371,
13717,3895,5069,13719,5093,18895,14619,16819,4457,19220,
11238,16588,16780,7029,17016,7841,16249,3061,19702,12664,
3190,15371,16092,12908,6842,17740,16318,17139,8623,8277,
18915,1238,11239,12128,8801,1174,11583,15810,5542,8283,
19457,3670,15969,19460,4821,17017,1437,19436,17979,3064,
1738,6656,18038,12251,14802,16835,15386,19400,11360,8772,
14633,17022,9344,6183,8902,11416,20884,17520,15767,3827,
6041,5750,12620,17485,14929,6328,13340,6723,2645,18788,
17743,5604,10010,2624,14282,13531,19953,12179,3554,6754,
17406,10801,19407,19828,12258,19955,19722,15988,7855,20577,
10011,6042,13150,15685,1916,12969,16845,10742,18954,6179,
2544,16786,9484,9295,3066,18955,9610,11603,4312,16788,
3098,3557,2322,10985,9623,5646,5641,12629,8777,15745,
10586,16868,8604,5796,11702,4142,5857,20398,19836,7885,
7161,9956,19723,6106,13553,15406,15689,11772,2981,6832,
17639,4282,15278,21613,7332,19412,3558,11608,20063,3840,
2970,13315,2065,1573,6835,21581,15637,1324,17930,16353,
5277,16450,1465,17931,6587,11173,19413,12806,14256,19110,
2421,10875,12840,8731,900,13156,18319,13919,21614,13998,
19229,13624,5383,20021,15132,12707,18560,15042,6665,7064,
5516,8313,2911,11704,17535,8570,20769,19420,2042,18131,
14446,1834,8586,17035,6859,19422,18507,9640,14053,15544,
19118,17896,15382,20067,11316,5407,3101,12414,11470,5848,
2665,1985,1980,1978,3176,11284,20476,15945,1035,14866,
5648,13627,20215,8161,9726,11995,15044,7944,19212,10523,
14260,16041,10744,12882,14352,13297,3707,20853,10283,8383,
12648,12643,19772,12491,9860,3115,19442,2687,20986,15946,
2474,12817,13449,12214,1335,13328,7628,2661,9737,12494,
9012,6786,2533,19214,19215,16992,16993,3438,15415,4244,
4177,15139,8454,2074,17434,4465,4714,9329,9362,17212,
11285,9868,16760,1987,8443,3139,17304,15442,14485,12280,
19025,17162,11876,3439,15443,8022,15032,6985,16515,6520,
13218,13213,8323,2043,8750,19256,19026,10001,14089,8534,
6504,908,18238,9098,17128,2669,19633,19217,3316,11048,
910,11016,4136,12731,11353,9205,10989,2740,21004,11955,
2792,18512,1860,21010,8942,8918,19446,4850,10158,11225,
2540,6809,2254,9248,6506,17972,13691,2256,7209,8336,
6524,14358,9808,11563,11076,15525,8477,21363,5186,19944,
5244,7323,3962,3835,1943,7276,20814,8973,20456,13010,
5259,7430,19761,18334,17044,20461,17050,17052,13492,6403,
6405,4289,14622,15676,10851,3752,14272,18796,18858,18320,
13367,9372,4512,13896,20126,20502,3797,19543,8815,5950,
14365,2095,16110,5497,16776,3566,13744,2096,12909,7265,
19564,1029,16825,20875,20905,3567,18301,8908,1583,8173,
16589,6347,19948,13234,14413,20763,20038,16250,11622,12542,
12543,1073,1020,20229,20006,1739,20880,11540,12559,18593,
20671,20312,18440,6068,11675,18672,2642,12253,7231,10952,
13434,2822,7233,20423,12100,11484,12910,16116,1125,3651,
8284,9079,12829,12861,6169,11818,5398,3221,2622,17521,
2054,6683,1109,20920,9081,4212,4213,11887,20702,5270,
7704,3956,11486,9920,20313,10367,3828,8407,9912,8256,
18196,17190,19661,16120,1820,5350,15671,2509,14122,8758,
10939,11888,8182,12193,7403,14178,13957,17523,2101,4770,
7655,8183,6886,15989,12544,20274,15038,18649,8414,16254,
1917,21752,18677,20375,10368,15058,16121,1188,16434,16294,
13198,14335,11249,10977,4962,3511,16649,8358,19962,21612,
15746,15973,1355,13958,21757,16656,12631,2512,14067,10572,
13292,5170,3655,6855,12688,14737,12872,10056,18202,20742,
9832,5590,11679,6891,18375,20766,1952,1731,15687,21643,
8751,12006,7737,11319,5333,10992,14052,12235,11944,7413,
20748,8118,7414,18273,11558,6209,12344,16354,13999,11761,
14657,21615,20712,18094,6624,1596,18476,6588,18321,21705,
17819,8705,7046,15690,9113,9121,2422,8120,15995,6694,
5325,2707,17426,17586,12922,2106,1289,18553,16355,3565,
16605,21616,5326,5451,13240,13802,13619,2711,15246,15234,
13803,12205,8685,18561,3522,20817,11914,9109,13419,17244,
7939,11219,4328,2922,14191,15318,20350,12042,9641,15545,
6359,20965,16202,17095,16606,13043,15730,20641,4329,11939,
13563,20368,16752,14349,8638,13804,13990,2234,15265,8122,
2685,2894,5849,4775,3702,12812,15070,9770,2475,2568,
5649,10429,10303,21619,5080,6428,20369,13046,15531,6487,
11516,7546,5720,19339,1004,20987,11782,10745,2253,8795,
2767,14353,16042,7675,2169,12884,1662,7594,18566,5458,
12885,6974,12417,9313,4151,17301,13910,5783,20142,19007,
17213,2477,11592,6276,5697,3272,11727,9998,20770,6709,
7682,7117,2025,15459,3406,1797,2375,8390,17435,1358,
4973,21451,16175,12569,13241,4148,6463,7683,15325,13131,
16643,7435,19378,11574,10380,21452,20254,12571,2992,6993,
3467,14090,13276,7756,8860,3388,17543,18699,1043,8324,
18700,4343,10993,11066,7118,15364,3531,9246,8267,18656,
13908,18715,18711,11688,6903,7819,1717,11833,5263,21005,
7817,9093,11343,7524,17550,9943,15396,1121,15086,10320,
10570,13706,21006,18513,9453,1932,14761,3157,11732,17259,
8542,9676,9130,6569,19320,10343,10265,12893,12894,12899,
9215,17174,19266,10930,2173,19321,3154,17554,14359,10645,
10933,11077,2580,20146,10544,15397,9698,3731,16207,3470,
7698,9252,9704,5767,5771,6957,18101,8654,18849,5096,
1140,12527,3715,8802,11271,16783,6092,2057,2828,5274,
17882,7710,2416,20634,4197,19671,1129,17883,4198,11776,
3738,4188,18970,8713,18381,6958,15960,17494,4200,18478,
17067,11280,873,874,3633,20715,14821,9870,13450,17754,
18870,7685,14235,7686,21462,19040,9775,1521,9528,17504,
17505,18011,12669,12677,8419,20377,20378,1147,19690,9221,
16487,14459,7291,7296,19678,7717,15962,4011,19137,12994,
13466,20429,21443,21447,21453,13211,9972,21463,2846,4106,
21215,7846,5998,12151,19461,11481,12678,12263,10127,4830,
4569,7982,20546,18863,14293,7483,4368,20996,4466,12391,
4467,20414,8881,15223,19646,7123,7156,6895,17513,15764,
15348,3667,17805,2222,18456,14564,11240,11241,16084,2931,
16740,1302,1158,7769,14460,6416,4564,5768,17920,4651,
13221,6324,18251,20273,4565,14437,8285,18467,1742,17981,
12528,20675,10041,6038,11368,1593,17872,6829,21627,14637,
4625,3870,16539,3924,878,1743,983,10210,8927,15794,
14574,6661,17923,8964,8848,7656,7929,20929,15903,6271,
5059,17362,5957,8521,17282,9030,21142,16846,14496,20578,
20579,5961,6045,16271,15748,21444,21722,21126,14210,11681,
16870,12775,20768,18971,961,16277,9958,2268,16325,17473,
4602,17975,18813,20068,6698,17857,11253,18643,19350,14773,
16456,13275,10876,11552,7423,18479,2937,18567,15281,12600,
7676,8573,5236,16622,2324,12813,6052,18393,9649,7183,
10986,20150,17598,6053,11393,3076,11708,20482,6787,5977,
17968,2874,9874,15444,8023,12418,9973,16994,19027,7189,
6675,3350,18695,18696,9655,15420,15927,17477,4639,14429,
20556,6027,19041,17388,17691,14198,7688,1278,8067,18405,
911,18712,13881,11019,9668,2434,8943,3863,3864,18635,
6920,10483,13827,10236,10646,10545,14163,15526,18355,21216,
19936,18904,6325,14734,2028,14470,20288,1984,17891,6772,
19191,13158,4664,12324,1141,10042,4606,13468,11921,15795,
9298,21708,11298,6609,16087,12635,19232,21586,16342,15928,
9305,9330,10237,12445,14794,15622,13718,1053,4209,3505,
9582,13370,8108,1407,2494,3042,13898,12854,19565,16680,
18079,4479,21541,13747,16113,3668,10797,2553,18905,5077,
5370,18773,7584,14171,16293,8133,10798,16977,19860,4621,
3922,17141,2932,14727,6475,17634,11859,2753,15018,19951,
7925,6942,10831,1438,984,4672,18918,4818,11541,6417,
18159,3988,17654,18530,4279,20540,20056,21718,14461,3671,
10325,15019,11542,17145,14990,16978,5598,4878,11369,18930,
18674,18679,14638,11766,1414,18789,11678,9105,6085,12036,
4480,21036,3332,3009,18518,4822,14731,14306,15021,14376,
11545,19408,20921,20314,3416,5467,12563,990,4879,1816,
4233,1400,20361,14991,21256,12130,14627,5599,2118,18599,
8149,10174,10898,9600,13786,20199,13996,19405,18087,12800,
20626,18797,17351,20707,9612,14076,8590,1730,13728,1115,
13729,1765,21485,2719,18941,3049,7472,21719,4379,4400,
19713,4440,5399,20394,9613,19097,18942,14643,4893,13865,
18798,8821,13311,14040,18042,4234,2918,11418,20093,11959,
19223,7782,10175,20449,18088,13977,20635,1287,15839,9083,
8048,1826,1356,13929,16855,9278,10177,4739,12632,16593,
8497,5125,15113,13389,19504,10268,12182,21359,3681,17925,
15994,20213,19535,1457,3622,5928,20813,13761,1314,7409,
6581,16272,11937,7244,15777,7157,17414,10492,8890,2079,
4675,15024,14993,4001,13223,19335,8195,9065,21441,2164,
16441,8049,9485,1732,17122,4802,15566,20941,9154,9720,
21415,9489,12807,1750,10589,3067,12973,12700,1958,2177,
20582,4613,12019,1206,6836,2519,20201,9633,19738,19739,
5551,5813,3967,5172,16326,3257,4489,2466,20454,12776,
19839,18322,19740,13535,18972,13732,12637,21417,4914,9159,
21645,21646,4658,2395,13272,11658,16278,10412,6019,7748,
2723,8257,8226,2520,21758,13002,18147,12304,21445,21499,
1690,12201,3903,2804,2269,10970,6448,7415,5716,17031,
3539,5774,3739,20815,13600,11483,4965,5335,12236,14225,
18807,14390,4216,5014,16457,16361,7297,21587,7347,18814,
16955,18388,18328,7348,19679,6110,16663,12369,1476,18535,
5825,17823,13967,18480,9122,18274,1353,6699,8975,7859,
8976,14937,4748,16173,7052,11471,10877,8831,6364,15860,
19611,19481,3070,17992,18505,20643,12370,18691,7796,18692,
14887,19602,16362,10915,15692,7058,7797,13854,6628,9380,
13564,17332,14606,15409,16542,14408,2779,12309,7300,18998,
20435,4929,11948,11127,5527,7497,15300,18609,14133,19889,
21557,11307,15133,7310,18568,7806,6674,5148,12929,10706,
19890,13809,14585,20820,16547,15861,13805,15490,20380,14943,
14506,8690,16890,5522,12644,5215,15238,12043,15547,5289,
2939,20652,11894,7070,5455,13011,12953,10921,17901,5184,
21420,16154,13096,18523,3721,7301,20976,3526,10222,14042,
16962,6975,9771,6788,19373,12983,5864,5087,5088,16043,
6488,14108,3179,12211,19513,7574,6431,6596,5784,11783,
19008,5199,8631,5725,5726,10747,20588,21351,9382,9302,
2427,3077,9502,17769,13277,14867,15892,5652,20250,15140,
9392,10377,9824,11135,10286,2347,15141,8693,1628,10435,
8123,20614,20325,14755,10748,11476,18525,15782,12212,21285,
14134,13572,7358,3078,6976,18233,18030,4423,18102,20856,
21710,3109,12603,14824,6489,9018,20659,14236,16908,2943,
3767,4430,11338,16764,13698,10016,10150,13104,17305,13956,
4494,20440,9353,20031,14892,4152,2480,15500,11009,15148,
8456,15421,6793,6986,11941,16176,11841,13935,15929,20295,
4689,13329,13672,6191,12935,5489,10184,9364,5200,16995,
14508,21558,14031,7083,3981,7995,7513,2845,3312,14758,
7555,10004,11581,19193,6801,14199,21731,17970,2484,5149,
8239,21734,19042,12606,4757,6738,3493,7196,15214,12496,
2537,2812,21294,6802,7084,7835,7303,14686,7436,13036,
3547,18872,1660,15033,14328,9661,19171,15580,15366,11155,
12734,16046,1734,6907,7202,12892,11690,11836,18759,5223,
7525,19218,11897,13288,18340,12735,11140,20559,5788,2945,
7000,8981,12517,3592,2794,5299,11156,19448,21012,6670,
12895,9430,9397,13995,10385,9669,3158,10527,11228,6814,
11979,10481,21007,5204,4039,19906,9677,4643,21465,15088,
9750,7602,2798,13302,21190,10348,18289,9683,21191,2458,
7824,4352,15099,6508,11800,19802,10238,9134,7646,17260,
5738,8268,17458,10103,19270,7384,19200,19492,19326,17341,
11884,1869,2211,9222,8270,14857,14362,21736,3113,13582,
13493,2022,8170,19809,10630,9701,3160,10546,3472,8481,
18296,9253,9228,21217,9411,9575,1108,11572,19816,10106,
5687,6517,12857,17808,2331,2825,12804,8582,18943,8415,
17025,17875,6069,9000,9273,8891,14905,862,17820,2629,
13239,8606,8893,8608,2873,5568,19113,19613,17429,18697,
16694,15460,7948,11973,6343,15695,6518,17833,12166,16996,
17502,17837,16910,9776,2847,19043,4350,19637,2994,6526,
1911,1912,8286,12915,2596,14082,2630,14086,21061,15203,
15204,9650,20251,19624,9656,5733,4287,20567,11361,11362,
18595,14464,17876,8421,12838,13390,15114,13269,18973,15961,
18686,1977,6837,3849,20653,20047,16543,2763,15696,7949,
14264,19168,3788,8162,9019,3165,3389,4080,7556,9803,
1719,4040,7378,7385,21257,13293,18956,14123,8704,13125,
18554,18129,6773,13628,6970,11974,6737,4103,18760,17463,
5637,10935,877,7830,12293,2197,10829,10830,12290,9911,
7237,13997,11460,16169,18089,4401,13794,17235,8221,13391,
4002,11963,12138,8227,4189,1392,14019,10878,14001,14749,
16184,6111,15323,14021,10479,11433,9507,15930,13816,20410,
14071,20411,11022,10386,3868,8398,12785,18461,11633,1712,
14377,12801,16847,13253,18205,3934,18508,20026,20762,1727,
3474,14876,9373,11693,4515,5741,1683,20271,11161,3776,
19946,2881,16244,4518,3320,16111,10794,13371,12447,12849,
16675,16676,16020,8132,20793,20876,12855,8011,8012,13939,
8490,6225,13589,1584,5137,21027,12072,8402,6390,11853,
17866,17869,20007,18302,3413,19454,6411,6881,11856,10893,
11109,2678,12073,1411,20877,12056,21372,20089,10122,20230,
4728,10953,20092,16118,9594,11089,18779,4425,15717,14926,
8925,8085,8177,18919,7234,21033,6746,1340,20232,21196,
19437,5466,6326,12178,3039,2590,15105,2462,14981,8217,
18039,14462,8404,4871,7106,5640,3414,19139,21089,18675,
6685,20127,2505,16388,6308,7465,14994,4376,17705,4881,
14075,20887,19205,16712,8657,10654,967,15679,11417,9442,
18739,11091,13545,12529,17465,17570,15107,8903,13152,8279,
12469,17744,20923,5676,11294,16683,13435,18931,8037,14521,
12239,2224,7927,9925,13383,16435,5925,10806,19465,1821,
3996,6240,18944,19334,9236,5943,9556,5331,9787,2951,
4771,18945,15905,9322,7242,2680,8090,15171,2467,12153,
17283,14440,9076,12453,5958,7977,11723,15972,17490,15872,
4259,16085,9614,14879,14995,9444,14880,4024,20015,6180,
17728,14711,2982,20493,8778,16273,16125,3931,16635,8196,
14343,9816,6833,15317,13154,3556,8372,5511,5858,5962,
21099,12232,6046,2264,12633,4546,2598,10405,8222,9445,
20611,12476,15747,19725,11655,10406,11118,8050,10058,10587,
13473,19726,11725,1619,6334,19837,9155,13254,12949,20890,
19184,1827,1343,19832,16603,13965,4583,19833,8711,7158,
14344,14079,12690,12343,16858,19835,13840,6589,7416,11927,
13397,15856,4743,16636,15639,16356,13868,2066,6099,18323,
6248,11097,10835,19230,18324,6210,14493,10943,20116,6845,
11533,5758,2653,4321,9791,12808,12809,10910,15727,3118,
16401,1969,6764,1831,17856,7060,7411,4788,18974,19208,
14577,7749,20638,15453,19603,1467,11277,14526,15975,14474,
19414,8228,3968,16054,7670,13398,15464,10220,6896,19874,
11559,1178,19508,13557,21347,9845,2178,17201,2956,6144,
21500,10759,19295,9119,4744,10277,16402,17092,19296,12506,
7940,5777,15282,19885,9727,18607,11004,21405,2527,15381,
3290,16203,5419,14055,20320,14581,10603,10688,16363,20117,
16802,16544,13006,20243,14529,871,20023,19114,15127,15290,
14530,863,12065,2837,16620,2011,11220,5286,6049,6673,
17036,3626,20966,19240,7798,5258,15176,7713,6775,19158,
5194,14849,2958,17495,19750,17782,6429,1478,1624,20977,
7595,8809,14451,14261,11128,1000,10375,6397,19441,2235,
4533,19372,5803,10762,13286,19619,7174,18171,2345,16989,
7175,10304,10223,7907,5850,3102,20854,5089,13030,7718,
3071,2961,16044,11996,15605,18664,16959,11129,15491,14262,
5975,9728,16204,2609,5113,12206,21572,8630,12187,20495,
2697,17902,6879,7499,18230,2902,9861,3185,15650,7549,
3103,19341,6258,17658,14820,5650,3104,9047,17903,20978,
12349,8444,7722,12508,3487,6789,7811,16761,12009,7075,
16410,15146,12956,17045,17046,15253,4178,11286,13955,15142,
20657,3105,18999,20988,16237,15394,18100,9013,18645,16007,
13982,6167,1505,2192,14780,12602,9969,16411,14095,14088,
2534,8099,6491,7629,9363,3218,6277,5938,20028,10192,
6278,4935,6054,6122,17214,7503,14197,17047,1038,10378,
11848,19634,10003,14486,3458,6599,20255,17604,19780,14681,
18024,10085,10782,21520,19379,6794,1994,9801,3768,18707,
6550,20660,10783,3407,19029,15210,12351,8325,15326,13215,
21459,11877,5833,7953,12165,14091,7085,16516,2810,15332,
15034,15884,14092,21234,9744,11102,14544,14825,11137,11849,
19312,19313,11017,7959,12732,7197,21716,16667,15553,19197,
19128,4133,3029,6904,13300,9261,8537,885,16413,1701,
5533,12941,19314,1702,9094,4642,2014,10888,7526,16478,
10666,20155,10454,9662,19447,18514,10384,15013,20997,19355,
4038,16334,6715,17614,12048,14432,1638,2200,11226,10159,
7375,14097,2539,5536,1706,6914,17311,10344,13242,13826,
9678,8070,17452,19323,15190,16484,6507,18047,21188,10232,
9181,4137,4537,6383,9182,14762,10097,19324,11103,7217,
9806,7528,19267,9986,19065,7382,2210,3359,13676,7450,
9216,4504,14870,19851,21470,4763,14360,9433,9217,3112,
13491,19388,12943,4452,8473,18429,19327,13983,20164,10547,
18419,9534,11105,14250,15398,3471,7699,2249,19329,6064,
21214,9266,9226,11577,16241,10551,18111,17265,18432,5152,
18436,19820,5668,17394,17395,6679,6203,21322,20357,17563,
2639,20109,12794,21034,4673,11860,16561,12560,18920,12254,
8580,12058,8581,12097,11457,9905,5670,17663,5671,5672,
1567,3282,17079,20734,21198,8710,20525,4882,1078,17571,
17572,10118,21411,12108,15354,18500,15887,14207,16389,6658,
21091,7657,17877,6186,13592,6579,17760,17761,17236,19142,
16686,21093,18548,14644,16345,15906,18043,20114,8583,17083,
17974,20736,12532,6727,5679,2381,6689,2412,6757,9927,
4902,8091,2382,12596,15840,21435,15874,5886,9299,14182,
17884,2650,13795,6355,16860,14740,6143,18051,8837,8422,
17415,16861,21360,8525,3682,17580,7053,16793,10493,18376,
8223,10013,9039,6857,16088,16871,3203,16719,6211,8304,
4966,16661,3068,4789,12481,13316,13966,16872,13317,17669,
18975,7618,19741,5182,12305,5517,16327,14475,5569,14290,
14291,11634,5336,16357,2424,6147,8993,21062,17068,6700,
4790,9796,17681,7671,1479,19233,21230,16458,16032,14211,
16885,11929,11930,2182,18227,8092,8097,10963,16505,20340,
7936,13322,13855,6591,4490,13402,15205,18481,9934,7752,
20216,5570,19990,11554,14664,9847,5456,15492,2357,4362,
1842,6667,17539,17041,16805,19992,6118,6149,16892,20027,
11515,14213,13323,18623,11130,9732,19304,16753,5408,18394,
13052,1494,1629,3079,10436,7359,10287,12213,15178,19011,
15893,8445,21592,6432,18822,20989,16509,10181,5978,11975,
13712,8098,9051,3163,20296,7366,16912,16913,19012,17503,
2668,6635,2240,18698,18103,18400,18104,13075,8536,3573,
4179,14399,7632,4690,14958,19781,9974,8100,14299,4691,
18105,9258,10947,15533,19030,8101,10987,8024,8025,19309,
19044,18025,9206,15383,1996,16919,13631,21622,9751,6739,
21208,10093,16371,19045,17549,20557,6803,3299,11934,1757,
13882,6156,18066,7961,2742,3549,18631,6157,9262,1641,
13824,9670,11406,13972,10528,9131,992,18071,8944,14917,
9891,9684,10349,8463,9900,18415,16939,17617,10239,18716,
1999,13688,19981,9263,3114,2702,5658,8338,2392,11075,
15527,9264,21218,9254,10107,19822,20533,20731,12109,2465,
16403,5936,8446,18652,21685,4404,2899,8671,20171,3850,
13012,19374,13037,12060,2338,7339,2893,19614,20341,1553,
1200,1843,2895,19515,4041,2471,11852,8109,15294,13748,
10790,4544,5162,18363,5246,1303,14992,19530,5248,11439,
3653,13599,13548,21566,10808,8760,12870,9490,12552,5173,
15593,1345,13558,2957,7254,4749,8686,8229,2786,17042,
1329,10661,7863,10679,14022,16510,9508,4153,15931,13105,
16920,9671,4042,9945,12024,12395,1866,16940,2714,16419,
13701,2715,1072,7105,2148,21426,5242,8645,1807,6302,
18190,19135,4458,21357,8910,21070,11455,12255,8219,18780,
17675,16139,10039,12256,11676,18596,19523,18040,3396,1811,
23007,23008,23009,23010,23011,23012,23013,23014,23015,23016,
23017,23018,23019,23020,23021,23022,23023,23024,23025,23026,
23027,23028,23029,23030,23031,23032,23033,23034,23035,23036,
23037,23038,23039,23040,23041,23042,23043,23044,23045,23046,
23047,23048,23049,23050,23051,23052,23053,23054,23055,23056,
23057,23058,23059,23060,23061,23062,23063,23064,23065,23066,
23067,23068,23069,23070,23071,23072,23073,23074,23075,23076,
23077,23078,23079,23080,23081,23082,23083,23084,23085,23086,
23087,23088,23089,23090,23091,23092,23093,23094,23095,23096,
23097,23098,23099,23100,23101,23102,11,34,37,328,
70,72,68,118,23934,6,66,74,330,75,
76,77,78,109,112,88,90,92,94,96,
98,100,102,114,115,104,106,131,132,133,
151,143,144,136,135,146,145,134,152,137,
165,142,140,167,124,147,148,158,155,154,
153,138,157,163,164,159,160,431,150,149,
339,338,327,79,80,443,18,323,321,322,
331,325,491,335,336,176,178,177,175,174,
169,168,171,170,332,185,189,183,187,334,
23103,23104,23105,23106,23107,23108,23109,23110,23111,23112,
23113,23114,23115,23116,23117,23118,23119,23120,23121,23122,
23123,23124,23125,23126,23127,23128,23129,23130,23131,23132,
23133,23134,23135,23136,23137,23138,23139,23140,23141,23142,
23143,23144,23145,23146,23147,23148,23149,23150,23151,23152,
23153,23154,23155,23156,23157,23158,23159,23160,23161,23162,
23163,23164,23165,23166,23167,23168,23169,23170,23171,23172,
23173,23174,23175,23176,23177,23178,23179,23180,23181,23182,
23183,23184,23185,23186,23187,23188,23189,23190,23191,23192,
23193,23194,23195,23196,23197,23198,345,352,359,366,
373,380,387,394,401,407,23679,23680,23681,23682,
23683,23684,344,351,358,365,372,379,386,393,
400,406,410,413,416,418,420,422,424,426,
428,430,343,350,357,364,371,378,385,392,
399,405,409,412,415,417,419,421,423,425,
427,429,342,349,356,363,370,377,384,391,
398,404,23685,23686,18727,4412,14015,14972,16730,10188,
12616,1048,8127,14553,23687,23688,346,353,360,367,
374,381,388,395,402,408,411,414,23689,23690,
23199,23200,23201,23202,23203,23204,23205,23206,23207,23208,
23209,23210,23211,23212,23213,23214,23215,23216,23217,23218,
23219,23220,23221,23222,23223,23224,23225,23226,23227,23228,
23229,23230,23231,23232,23233,23234,23235,23236,23237,23238,
23239,23240,23241,23242,23243,23244,23245,23246,23247,23248,
23249,23250,23251,23252,23253,23254,23255,23256,23257,23258,
23259,23260,23261,23262,23263,23264,23265,23266,23267,23268,
23269,23270,23271,23272,23273,23274,23275,23276,23277,23278,
23279,23280,23281,23282,23283,23284,23285,23286,23287,23288,
23289,23290,23291,23292,23293,23294,13,14,16,324,
20,22,1,24,27,30,121,32,3,36,
38,340,341,348,355,362,369,376,383,390,
397,40,43,126,128,130,45,47,432,439,
441,447,449,456,459,462,464,470,472,477,
481,487,492,498,500,502,504,506,509,520,
522,524,526,528,48,50,51,52,53,57,
433,440,442,448,450,457,460,463,465,471,
473,478,482,488,493,499,501,503,505,507,
510,521,523,525,527,529,60,62,64,69,
23295,23296,23297,23298,23299,23300,23301,23302,23303,23304,
23305,23306,23307,23308,23309,23310,23311,23312,23313,23314,
23315,23316,23317,23318,23319,23320,23321,23322,23323,23324,
23325,23326,23327,23328,23329,23330,23331,23332,23333,23334,
23335,23336,23337,23338,23339,23340,23341,23342,23343,23344,
23345,23346,23347,23348,23349,23350,23351,23352,23353,23354,
23355,23356,23357,23358,23359,23360,23361,23362,23363,23364,
23365,23366,23367,23368,23369,23370,23371,23372,23373,23374,
23375,23376,23377,23378,23379,23380,23381,23382,23383,23384,
23385,23386,23387,23388,23389,23390,645,647,649,651,
653,655,658,660,662,664,667,669,671,673,
675,677,680,682,684,686,688,690,692,694,
696,698,700,702,704,706,708,710,712,714,
716,718,720,722,724,726,728,730,732,734,
736,738,740,742,744,746,748,750,752,754,
756,758,760,762,764,766,768,770,772,774,
776,778,780,782,784,786,788,790,792,794,
796,798,800,802,804,806,808,810,812,23691,
23692,23693,23694,23695,23696,23697,23698,23699,23700,23701,
23391,23392,23393,23394,23395,23396,23397,23398,23399,23400,
23401,23402,23403,23404,23405,23406,23407,23408,23409,23410,
23411,23412,23413,23414,23415,23416,23417,23418,23419,23420,
23421,23422,23423,23424,23425,23426,23427,23428,23429,23430,
23431,23432,23433,23434,23435,23436,23437,23438,23439,23440,
23441,23442,23443,23444,23445,23446,23447,23448,23449,23450,
23451,23452,23453,23454,23455,23456,23457,23458,23459,23460,
23461,23462,23463,23464,23465,23466,23467,23468,23469,23470,
23471,23472,23473,23474,23475,23476,23477,23478,23479,23480,
23481,23482,23483,23484,23485,23486,644,646,648,650,
652,654,657,659,661,663,666,668,670,672,
674,676,679,681,683,685,687,689,691,693,
695,697,699,701,703,705,707,709,711,713,
715,717,719,721,723,725,727,729,731,733,
735,737,739,741,743,745,747,749,751,753,
755,757,759,761,763,765,767,769,771,773,
775,777,779,781,783,785,787,789,791,793,
795,797,799,801,803,805,807,809,811,656,
665,678,23702,23703,23704,23705,23706,23707,23708,23709,
23487,23488,23489,23490,23491,23492,23493,23494,23495,23496,
23497,23498,23499,23500,23501,23502,23503,23504,23505,23506,
23507,23508,23509,23510,23511,23512,23513,23514,23515,23516,
23517,23518,23519,23520,23521,23522,23523,23524,23525,23526,
23527,23528,23529,23530,23531,23532,23533,23534,23535,23536,
23537,23538,23539,23540,23541,23542,23543,23544,23545,23546,
23547,23548,23549,23550,23551,23552,23553,23554,23555,23556,
23557,23558,23559,23560,23561,23562,23563,23564,23565,23566,
23567,23568,23569,23570,23571,23572,23573,23574,23575,23576,
23577,23578,23579,23580,23581,23582,530,532,534,536,
538,540,542,544,546,548,550,552,554,556,
558,560,562,564,566,568,570,572,574,576,
23710,23711,23712,23713,23714,23715,23716,23717,531,533,
535,537,539,541,543,545,547,549,551,553,
555,557,559,561,563,565,567,569,571,573,
575,577,23718,23719,23720,23721,23722,23723,23724,25,
28,110,113,89,91,93,95,97,99,101,
103,23725,23726,105,107,61,65,8,23727,82,
87,23728,23729,23730,23731,23732,23733,23734,23735,23736,
23583,23584,23585,23586,23587,23588,23589,23590,23591,23592,
23593,23594,23595,23596,23597,23598,23599,23600,23601,23602,
23603,23604,23605,23606,23607,23608,23609,23610,23611,23612,
23613,23614,23615,23616,23617,23618,23619,23620,23621,23622,
23623,23624,23625,23626,23627,23628,23629,23630,23631,23632,
23633,23634,23635,23636,23637,23638,23639,23640,23641,23642,
23643,23644,23645,23646,23647,23648,23649,23650,23651,23652,
23653,23654,23655,23656,23657,23658,23659,23660,23661,23662,
23663,23664,23665,23666,23667,23668,23669,23670,23671,23672,
23673,23674,23675,23676,23677,23678,578,580,582,584,
586,588,590,592,594,596,598,600,602,604,
606,608,610,612,614,616,618,620,622,624,
626,628,630,632,634,636,638,640,642,23737,
23738,23739,23740,23741,23742,23743,23744,23745,23746,23747,
23748,23749,23750,23751,579,581,583,585,587,589,
591,593,595,597,599,601,603,605,607,609,
611,613,615,617,619,621,623,625,627,629,
631,633,635,637,639,641,643,23752,23753,23754,
23755,23756,23757,23758,23759,23760,23761,23762,23763,23764,
71,58,73,5,7,329,81,446,458,190,
184,186,188,123,139,141,156,161,162,166,
197,204,209,210,211,217,218,219,225,226,
227,233,234,235,245,246,247,256,257,258,
267,268,269,278,279,280,297,298,299,212,
220,236,228,300,301,302,303,307,309,311,
313,315,317,319,318,316,314,312,310,308,
304,320,305,306,172,173,179,180,181,182,
337,122,333,116,117,23765,23766,23767,23768,23769,
23770,23771,23772,23773,23774,23775,437,434,436,435,
455,451,454,452,469,466,468,467,497,494,
496,495,515,511,514,512,519,516,518,517,
513,453,438,23776,489,490,23777,461,23778,23779,
23780,23781,813,814,815,816,817,818,819,820,
821,822,823,824,825,826,827,828,829,830,
831,832,833,834,835,836,837,838,839,840,
841,842,843,844,845,846,847,848,849,23782,
23783,23784,23785,23786,23787,23788,23789,23790,23791,23792,
23793,23794,23795,23796,23797,23798,23799,23800,23801,23802,
347,354,361,368,375,382,389,396,403,20773,
484,474,486,445,475,483,444,476,479,480,
485,41,326,67,23803,508,21167,23804,4,23805,
23806,23807,23935,9,10,23936,23937,119,23938,23939,
83,84,85,86,54,55,56,31,33,35,
42,39,44,12,23,26,59,63,108,111,
15,21,29,120,2,125,129,127,49,17,
19,46,23808,23809,23810,23811,23812,23813,23814,23815,
23816,23817,23818,23819,23820,0,23821,23822,23823,23824,
23825,23826,23827,23828,23829,23830,23831,23832,23833,191,
192,198,199,193,194,200,201,195,196,202,
203,205,206,207,208,213,214,215,216,221,
222,223,224,229,230,231,232,237,238,239,
240,241,242,243,244,248,249,250,251,252,
253,254,255,259,260,261,262,263,264,265,
266,270,271,272,273,274,275,276,277,281,
282,283,284,285,286,287,288,289,290,291,
292,293,294,295,296,23834,23835,23836,23837,23838,
23839,23840,23841,23842,23843,23844,23845,23846,23847,23848,
8829,17231,6535,6086,20542,7042,18120,14179,15314,15901,
9317,10807,16850,17084,1310,20931,18257,14124,5959,7983,
12018,4587,17416,1130,12691,1620,19209,9156,7333,12998,
9036,18384,21630,20942,20743,18167,9930,2092,21583,5037,
4745,16637,19875,2869,16031,18206,17531,7250,1549,19478,
18563,15235,1836,11304,15065,10689,19887,3315,19763,14531,
6021,13003,18986,20644,2012,6025,10777,7575,11431,2185,
1002,5217,3180,1359,1506,1495,6633,1901,9970,17909,
15926,18626,14914,17436,14719,4149,7725,5316,8386,4033,
6795,8879,17252,17253,11834,1558,21785,21786,21787,21788,
21789,21790,21791,21792,21793,21794,21795,21796,21797,21798,
21799,21800,21801,21802,21803,21804,21805,21806,21807,21808,
21809,21810,21811,21812,21813,21814,21815,21816,21817,21818,
21819,21820,21821,21822,21823,21824,21825,21826,21827,21828,
21829,21830,21831,21832,21833,21834,21835,21836,21837,21838,
21839,21840,21841,21842,21843,21844,21845,21846,21847,21848,
21849,21850,21851,21852,21853,21854,21855,21856,21857,21858,
21859,21860,21861,21862,21863,21864,21865,21866,21867,21868,
21869,21870,21871,21872,21873,21874,21875,21876,21877,21878,
6905,11896,11018,9944,11594,5692,14720,10345,15311,17313,
11073,13677,11600,10627,17262,12754,8479,11208,21486,10333,
15102,13369,5048,9375,1054,6226,3669,2883,5098,19567,
12765,19568,2317,6231,16742,4819,7847,18193,10973,1202,
19952,8405,20040,8406,7324,3397,12430,12996,18932,951,
12470,4883,17960,3000,5431,7289,14307,3007,13669,14466,
14378,15344,21686,10176,1444,20623,7883,7706,7474,9616,
5680,17147,21094,18216,17786,18471,17853,15109,13192,19144,
18090,1242,17380,17085,5708,2681,17878,12154,9347,3452,
19224,16567,4261,2513,15633,16750,21879,21880,21881,21882,
21883,21884,21885,21886,21887,21888,21889,21890,21891,21892,
21893,21894,21895,21896,21897,21898,21899,21900,21901,21902,
21903,21904,21905,21906,21907,21908,21909,21910,21911,21912,
21913,21914,21915,21916,21917,21918,21919,21920,21921,21922,
21923,21924,21925,21926,21927,21928,21929,21930,21931,21932,
21933,21934,21935,21936,21937,21938,21939,21940,21941,21942,
21943,21944,21945,21946,21947,21948,21949,21950,21951,21952,
21953,21954,21955,21956,21957,21958,21959,21960,21961,21962,
21963,21964,21965,21966,21967,21968,21969,21970,21971,21972,
16716,2510,8526,10903,1315,15875,17286,2830,5964,17964,
18262,17987,17789,4903,16862,10059,9624,7886,15277,4741,
16257,3760,12433,20430,14083,11250,19742,9160,11251,14501,
16404,15749,2834,1377,2472,4330,2270,1378,10413,5626,
3784,1321,12999,21418,13200,4454,7888,4062,7860,6701,
19680,10917,2940,17937,15646,17682,3347,13842,11254,7350,
16459,13920,6592,17537,2863,7424,21326,2323,9797,13565,
4098,18168,6630,10141,14536,13811,15283,18569,16545,16756,
20654,7945,19306,10691,15548,10144,9651,9282,15761,13013,
3229,8438,20536,1694,14752,2296,21973,21974,21975,21976,
21977,21978,21979,21980,21981,21982,21983,21984,21985,21986,
21987,21988,21989,21990,21991,21992,21993,21994,21995,21996,
21997,21998,21999,22000,22001,22002,22003,22004,22005,22006,
22007,22008,22009,22010,22011,22012,22013,22014,22015,22016,
22017,22018,22019,22020,22021,22022,22023,22024,22025,22026,
22027,22028,22029,22030,22031,22032,22033,22034,22035,22036,
22037,22038,22039,22040,22041,22042,22043,22044,22045,22046,
22047,22048,22049,22050,22051,22052,22053,22054,22055,22056,
22057,22058,22059,22060,22061,22062,22063,22064,22065,22066,
9052,21308,3080,18756,12724,8021,20202,13409,1006,9772,
10979,19169,6464,16517,16723,3574,17793,20297,18106,13480,
3494,9975,9876,13330,15149,5727,8026,4496,7891,10151,
6988,6796,8027,912,20204,3459,7689,5816,15446,6804,
6553,14096,15216,15737,2813,19638,7962,10346,1705,14771,
21717,9211,17004,7203,17971,13927,16668,5090,9398,4043,
9679,21013,13850,9709,20158,13332,15702,5736,15188,9135,
10240,10350,9685,9265,19271,11078,17342,13335,5659,3552,
20166,6564,1812,1822,20848,9705,14696,17347,13055,1161,
12167,4566,3398,4797,11233,16212,22067,22068,22069,22070,
22071,22072,22073,22074,22075,22076,22077,22078,22079,22080,
22081,22082,22083,22084,22085,22086,22087,22088,22089,22090,
22091,22092,22093,22094,22095,22096,22097,22098,22099,22100,
22101,22102,22103,22104,22105,22106,22107,22108,22109,22110,
22111,22112,22113,22114,22115,22116,22117,22118,22119,22120,
22121,22122,22123,22124,22125,22126,22127,22128,22129,22130,
22131,22132,22133,22134,22135,22136,22137,22138,22139,22140,
22141,22142,22143,22144,22145,22146,22147,22148,22149,22150,
22151,22152,22153,22154,22155,22156,22157,22158,22159,22160,
6350,18790,1138,8373,2289,2560,10201,3484,11035,21378,
12482,1554,21148,10202,3018,19241,12814,17208,10305,3708,
11976,21309,10017,16765,3445,16627,19259,18343,15724,5934,
2291,13265,14383,2227,2228,13930,15091,14397,10393,4786,
20334,4856,12451,3878,13590,10995,1440,8146,15241,10123,
11440,20011,4884,5330,7849,4885,15720,11441,15587,7543,
16196,4895,11547,11444,11445,2058,15723,5061,1451,3266,
20943,10563,12032,18741,6481,19604,19605,11447,8527,18957,
10129,3842,6483,3455,21380,7592,2530,2325,16105,9393,
2111,10152,3859,10020,7559,2744,22161,22162,22163,22164,
22165,22166,22167,22168,22169,22170,22171,22172,22173,22174,
22175,22176,22177,22178,22179,22180,22181,22182,22183,22184,
22185,22186,22187,22188,22189,22190,22191,22192,22193,22194,
22195,22196,22197,22198,22199,22200,22201,22202,22203,22204,
22205,22206,22207,22208,22209,22210,22211,22212,22213,22214,
22215,22216,22217,22218,22219,22220,22221,22222,22223,22224,
22225,22226,22227,22228,22229,22230,22231,22232,22233,22234,
22235,22236,22237,22238,22239,22240,22241,22242,22243,22244,
22245,22246,22247,22248,22249,22250,22251,22252,22253,22254,
12354,3866,3867,7773,3417,14744,20979,11522,1412,5163,
21124,17120,17806,2446,18041,12674,17062,3191,1445,21628,
18004,20808,4436,20891,4630,8185,14183,11699,15601,15889,
7738,16442,6730,15388,2651,10960,8055,17418,15976,10812,
17419,15158,12565,4201,14713,18987,1369,20510,5627,10676,
9961,7166,15752,935,2656,1481,11255,4114,8681,18181,
3134,14449,21064,20980,19764,4751,18483,2428,15999,5830,
16571,6595,8842,19119,8448,16903,5616,19013,2896,6780,
11925,3722,20516,14453,3142,19031,21634,15089,14093,3815,
10313,10314,13216,4943,9879,13106,22255,22256,22257,22258,
22259,22260,22261,22262,22263,22264,22265,22266,22267,22268,
22269,22270,22271,22272,22273,22274,22275,22276,22277,22278,
22279,22280,22281,22282,22283,22284,22285,22286,22287,22288,
22289,22290,22291,22292,22293,22294,22295,22296,22297,22298,
22299,22300,22301,22302,22303,22304,22305,22306,22307,22308,
22309,22310,22311,22312,22313,22314,22315,22316,22317,22318,
22319,22320,22321,22322,22323,22324,22325,22326,22327,22328,
22329,22330,22331,22332,22333,22334,22335,22336,22337,22338,
22339,22340,22341,22342,22343,22344,22345,22346,22347,22348,
10154,9331,17220,4640,3390,19213,6155,17221,5617,16373,
11889,19795,16417,19383,9428,9663,14784,3446,10006,10007,
1681,7210,2577,18515,7757,20761,10891,9692,6922,9185,
7009,17978,19348,19201,19392,15399,3732,10647,10554,10555,
1775,1778,1079,4426,4427,13140,1389,20208,10861,11998,
3040,10047,11370,7043,12233,5191,4263,5968,1468,2727,
12976,875,17476,6055,6676,6056,20256,3188,6057,17480,
18701,6059,7691,916,17694,6671,9686,12406,6134,7731,
5119,12121,13399,13620,20323,5528,8503,8504,21150,20327,
20328,20443,4044,12766,19283,1286,852,851,860,861,
857,859,858,868,876,882,881,891,901,893,
896,941,928,924,955,966,974,965,970,969,
979,982,985,987,993,1005,1009,1023,1031,1033,
1042,1041,1058,1061,1052,1051,1055,1062,1047,1059,
1050,1076,1084,1093,1090,12005,1094,1105,1098,1096,
1111,1114,1112,1120,1113,1126,1127,1131,1145,1142,
1146,1139,1143,1144,1159,1160,1172,1175,1171,1183,
1170,1169,1176,1184,1187,1189,1199,1201,1197,1205,
1214,1203,1215,1204,1208,1223,1224,1220,1230,1780,
20526,6087,6094,1781,16266,19553,4527,4967,13400,3540,
10420,20432,9504,7908,17904,7356,12044,942,10339,17862,
21113,3495,947,5537,9687,5138,16340,12795,19913,15721,
17636,17023,4733,11245,11295,14640,20012,12031,4567,10866,
17275,14645,18444,20737,18600,14384,6887,3311,20680,8930,
8186,14441,10957,11371,21261,20628,14646,3832,11700,21568,
2356,1747,11093,10214,15909,3871,3683,11623,11299,17988,
20709,18472,11377,21078,11372,10912,13094,5969,6565,2548,
3240,8376,4264,10760,17289,16874,9077,14212,15753,5814,
16235,9473,14665,13324,9935,20751,1853,1236,1240,1243,
1239,1237,1262,1261,1273,1263,1270,1279,1285,1290,
1288,1284,1295,1323,1305,1297,1306,1308,1298,1301,
1319,1320,1311,1339,1350,1349,1357,1364,1365,1373,
1380,1387,1381,1393,1402,1405,1423,1417,1413,1496,
1483,1501,1429,1449,1443,1427,1433,1480,1430,1456,
1493,1428,1488,1511,1523,1519,1448,1563,1546,1550,
1568,1569,1590,1591,1580,1605,1606,1608,1598,1615,
1614,1630,1654,1666,1665,1672,1680,1687,1689,1700,
1691,1686,1713,1729,1728,1744,1735,1740,1746,1745,
9494,9172,15206,8380,12347,6839,10421,5195,21127,19620,
6840,10704,17125,17716,6705,5815,20118,2971,7351,10964,
6291,17939,15762,17905,4443,16666,5780,11053,16623,8812,
3489,2399,13325,11395,4702,20257,20518,19032,3789,8796,
11396,14893,3085,10290,2572,10750,5728,6600,14894,16921,
12586,14430,9909,2391,7518,18702,17913,11423,5785,7519,
18713,917,6810,7442,20560,10929,2758,14072,11842,18068,
18634,6910,11023,11157,12440,11158,9431,8945,17951,11159,
6923,10352,11028,10241,5660,10767,17006,15528,8622,21239,
13193,19743,14907,20244,8482,14416,1766,1758,1779,1791,
1798,1776,1785,1777,1829,1815,1835,1825,1844,1805,
1809,1828,1790,1845,1830,1810,1808,1898,1894,1897,
1896,1920,1904,1905,1908,1929,1919,1910,1931,1938,
1944,1940,1939,1941,1953,1956,1946,1951,1957,1959,
1972,1962,1975,1974,1976,1983,1991,2004,2007,2000,
2003,2021,2026,2027,2034,2029,2041,2052,2067,2051,
2050,2055,2083,2088,2105,2094,2119,2120,2117,2128,
2122,2127,2137,2142,2139,2145,2150,2152,2166,2165,
2186,2180,2175,2183,2229,2220,2230,2255,2261,2265,
6285,19332,21100,7690,20298,19940,1104,3897,12790,21542,
16782,20568,8817,5164,3370,8409,9603,4823,16562,4280,
8624,20888,7851,1685,4297,20569,15195,16213,7878,11373,
8187,19715,10638,16144,4306,11446,21225,11910,12454,10048,
12122,9378,1782,12534,19430,8931,8759,13555,21171,5682,
4313,12839,10408,16443,895,17287,18263,12184,9348,6244,
13270,16498,13091,2089,8761,13614,2252,9283,6212,19606,
17421,17093,1207,10269,19415,2371,2385,18385,14130,9067,
5518,2090,6449,10371,2437,11932,15030,21448,8763,18329,
21381,8779,2528,12708,21631,13294,2306,2285,2287,2278,
2286,2281,2305,2310,2318,2321,2319,2335,2328,2332,
2342,2346,2348,2340,2354,2355,2364,2373,2388,2384,
2378,2389,2394,2404,2407,2403,2417,2405,2406,2408,
2449,2445,2478,2447,2501,2536,2493,2495,2507,2521,
2518,2535,2498,2496,2545,2546,2550,2551,2569,2592,
2597,2585,2588,2584,2586,2625,2620,2618,2614,2640,
2648,2638,2646,2675,2676,2693,2694,2703,2709,2733,
2724,2735,2728,2726,2729,2716,2721,2756,2750,2760,
2766,2764,2791,2774,2796,2778,2785,2775,2772,2808,
9962,8501,1793,11256,7352,6148,13621,9465,19159,16754,
12709,10591,11591,13923,18276,3907,16152,19236,8734,16465,
14913,20655,4100,17099,3488,15648,11612,15732,12815,4175,
4752,13629,13069,10692,5387,15143,4269,10146,14954,15497,
6465,12273,8996,15734,17102,12649,9738,16511,20050,4115,
9114,12030,18577,21312,2195,12820,1008,12190,10193,10382,
8620,2903,2441,19121,9424,12390,12821,12822,3181,21599,
2993,10596,6994,14238,9332,20299,7520,17053,3911,3770,
1800,20104,13077,3608,9664,7521,16922,20497,13108,7443,
19791,21391,6128,8738,20260,9454,2803,2805,2851,2836,
2838,2819,2854,2859,2861,2872,2864,2867,2879,2882,
2890,2892,21361,2898,2444,2905,2912,2913,2920,2926,
2915,2933,2938,2963,2950,2954,2948,2974,2976,2983,
3001,3012,3021,3022,3019,3017,3014,3006,3037,3045,
3053,3043,3084,3069,2889,3058,3057,3093,3117,3123,
3141,3143,3130,3153,3164,3162,3177,3170,3171,3196,
3204,3205,3200,3207,3215,3220,3225,3231,3232,3228,
3255,3252,3260,3267,3274,3291,3295,3308,3309,3313,
3317,3318,3354,3329,3333,3319,3335,3342,3330,3344,
7820,2814,18717,13633,3496,18873,12281,12282,19642,12426,
12824,919,8701,7379,19796,13928,12125,3032,1861,18516,
10710,17224,8946,9400,9432,21017,9680,9688,4505,13636,
12126,19272,9693,10242,10243,11408,14858,5661,9223,1934,
18297,13775,19949,15295,10699,17566,18531,12671,1362,4125,
21071,21072,18737,14570,19531,20924,15776,4991,11114,15161,
10955,2151,10494,19666,16717,21262,5755,17086,20809,5232,
5233,14881,7934,14443,5062,9066,3684,15570,5552,5647,
21724,10070,10414,3520,20845,1469,2807,6702,19510,19115,
21507,6897,20646,19928,16720,17245,3331,3372,3367,3364,
3366,3373,3403,3399,3410,3427,3411,3422,3423,3415,
3421,3425,3451,3464,3465,3480,3481,3500,3518,3532,
3515,3513,3519,3512,3534,3545,3535,3541,3537,3562,
3555,3564,3579,3568,3569,3580,3589,3584,3582,3603,
3595,3606,3617,3619,3623,3613,3620,20383,3628,3650,
3648,3663,3693,3685,3674,3666,3677,3692,3723,3716,
3720,3740,3736,3734,3769,3751,3745,3746,3747,3750,
3757,3759,3758,3761,3786,3775,3790,3779,3774,3806,
3801,3802,3805,3821,3820,3854,3858,3824,3836,3848,
18482,20818,18748,10918,14938,3695,1326,20656,19424,7176,
5237,15494,14944,10707,15324,5018,17941,12725,19792,6989,
15008,2196,3441,5786,15217,9568,11879,11071,3533,9672,
19982,20829,20167,9459,13835,17581,15967,13720,21543,2115,
18921,17143,11714,13342,4709,6039,20013,20801,7974,20802,
19709,8836,1177,12259,11650,9619,19466,12260,1823,10049,
11716,21755,20810,8288,6872,15910,20945,6873,6101,19102,
21492,20946,13731,4075,21265,11871,5008,5212,20276,14882,
9068,5127,7987,15640,15996,18209,10599,10423,5555,21760,
21408,1211,6966,20967,9071,9466,3873,3880,3875,3881,
3887,3889,3906,3898,3894,3914,3918,3919,3941,3944,
3948,3957,3950,3955,3949,3958,3978,3987,3984,3990,
3994,3998,4005,3977,4020,4023,4029,4058,4025,4060,
4064,4063,4070,4078,4071,4073,4076,4069,4087,4090,
4101,4091,4092,4094,4111,4123,4119,4120,4145,4141,
4155,4143,4170,4162,4169,4166,4171,4196,4184,4181,
4193,4211,4219,4208,4240,4236,4226,4237,4235,4268,
4257,4267,4255,4273,4251,4256,4305,4286,4293,4326,
4316,4308,4360,4370,4369,4396,4395,4399,4398,4411,
12208,9994,21675,19752,10565,10566,18751,17043,1575,7177,
4930,1497,11949,7753,21065,21589,17827,2452,3542,9799,
21513,19773,17910,20990,5218,5529,13812,15211,13833,7190,
8632,1988,10980,21008,7178,10445,15095,6990,19343,16596,
13353,9102,19033,6642,13165,7119,17444,12587,7635,21421,
15934,21735,10508,15219,11881,14098,6811,13673,11957,19797,
12427,7211,16066,16597,2486,6911,8947,10510,1645,14100,
21422,9542,3161,18186,19547,14379,8015,18615,9318,18601,
1234,1748,16197,21202,7707,3803,16689,5712,2891,18619,
17422,2514,8807,3431,21449,17824,4418,4424,4437,4442,
4433,4432,4439,4449,4453,4469,4456,4459,4468,4492,
4481,4483,4499,4475,4485,4510,4514,4521,4522,4516,
4520,4519,4541,4542,4539,4556,4555,4553,4554,4560,
4561,4563,4575,4585,4578,4580,4576,4600,4608,4609,
4619,4624,4620,4622,4626,4650,4661,4647,4652,4646,
4649,4668,4680,4671,4701,4707,4704,4708,4711,4712,
4721,4731,4730,4750,4737,4747,4722,4732,4740,4772,
4768,4777,4780,4785,4784,4800,4806,4812,4843,4820,
4841,4860,4869,4924,4913,4880,4904,4854,4876,4870,
15094,5614,21419,16641,16205,18210,13326,18578,18579,15799,
2349,15735,3816,8326,9877,16914,16809,8957,2897,20531,
8894,8895,2485,3210,9880,20221,3168,13134,13333,4013,
20225,10266,13170,2820,14560,4986,12858,2826,6236,12675,
6016,14467,4654,11209,13505,21263,10050,10216,1767,1117,
15001,6249,8056,3810,18988,14815,8052,13509,12456,9505,
21320,2086,3575,3219,16224,8072,8612,8073,9377,12194,
2593,10802,21199,16252,7658,15162,13222,18161,21374,19867,
6002,2081,12295,18859,3932,14186,17088,21204,11505,5473,
13155,11275,1226,2061,12156,10060,4894,4901,4919,4912,
4853,4952,4951,4964,4959,4960,4956,4963,4968,4953,
4971,4994,5000,5034,5013,4989,5004,4980,4987,4978,
5016,4982,5006,4979,4983,4981,5015,4984,5045,5044,
5052,5070,5085,5078,5079,5081,5091,5092,5097,5103,
5104,5099,5123,5128,5120,5124,5150,5153,5156,5166,
5165,5160,5159,5158,5180,5181,5201,5187,5190,5198,
5188,5202,5213,5220,5219,5227,5250,5257,5255,5240,
5253,5251,5247,5254,5273,5279,5275,5281,5272,5283,
5313,5308,5309,5317,5319,5320,5332,5327,5329,5344,
11905,4905,4487,5126,4528,14605,10857,14651,13312,11276,
10656,5775,13442,2602,19111,18620,1422,9084,7665,15245,
13869,6960,6007,21081,9161,3454,2069,4838,16000,9495,
9286,8258,5628,7425,5935,15941,17098,20969,2522,15163,
21278,21761,15857,2070,5235,5112,8905,20024,11962,17475,
12547,9163,21648,12021,1499,5314,15358,5600,19556,7357,
20552,6398,20755,14154,21128,10431,9963,8529,4931,20324,
5486,12886,8530,2927,2073,21676,1875,17942,1555,15248,
17248,12492,17686,6371,14539,19939,2941,10524,16696,3945,
14915,7077,7800,17687,10967,4535,5348,5352,5354,5364,
5369,5368,5376,5379,5371,5378,5366,5374,5365,5394,
5395,5396,5404,5403,5415,5412,5414,5429,5428,5442,
5439,5441,5446,5481,5474,5462,5485,5461,5465,5464,
5463,5524,5495,5513,5504,5500,5501,5543,5545,5541,
5553,5564,5563,5582,5585,5589,5594,5596,5597,5603,
5612,5605,5607,5608,5606,5629,5625,5663,5642,5657,
5639,5667,5688,5695,5717,5702,5699,5711,5698,5701,
5706,5742,5753,5746,5751,5773,5769,5779,5772,5765,
5799,5800,5812,5828,5821,5841,5856,5868,5872,5879,
2875,4754,21288,6262,13163,13350,11202,12984,5488,14588,
20032,6124,15501,19974,2713,13971,20758,11789,12986,17478,
5388,12086,4067,21460,2789,14159,21289,13016,10227,7367,
1927,6805,1515,3634,3086,18237,14110,3166,12318,12404,
19798,16045,20258,14160,5787,18832,6434,2241,8813,12497,
20219,6995,10307,2075,11731,15268,3167,3793,15269,9383,
9810,17445,1862,11141,14161,3497,9885,3392,4975,7444,
11287,9022,3357,7639,15249,9333,17453,10460,14689,20135,
12781,12023,12736,12321,5133,8333,10461,10455,18288,3461,
14012,21296,5424,12896,9758,14690,5883,5882,5884,5893,
5890,5892,5891,5906,5910,5916,5933,5915,5929,5931,
5917,5944,5942,5983,5982,5956,5953,5981,5955,5963,
5951,5948,5993,5999,6003,6029,6028,6023,6018,6035,
6034,6044,6036,6043,6067,6070,6096,6102,6093,6074,
6079,6076,6075,6100,6114,6089,6081,6098,6151,6150,
6152,6139,6166,6165,6170,6173,6174,6176,6178,6177,
6190,6192,6184,6204,6205,6207,6239,6247,6235,6224,
6220,6222,6286,6284,6288,6300,6305,6310,6303,6321,
6318,6323,6366,6352,6363,6351,6373,6349,6372,6360,
9218,9024,19647,19977,6031,20667,15367,15704,11801,2745,
18839,12746,15615,21338,21157,4472,14789,21156,12944,21473,
15617,10469,10353,7389,16187,19328,19812,9187,10246,13171,
9764,9227,12904,19984,21054,13495,9765,1566,4108,21702,
9543,14550,10632,19331,19986,21475,19821,4482,14371,20570,
14380,11917,6088,11647,3227,20507,12863,20374,1418,1163,
16789,14125,8625,13837,1419,15197,19145,20574,11094,15377,
6420,5107,8294,11378,21145,2563,15115,6250,15913,2062,
9960,21348,1118,9312,4384,13443,6107,17294,4920,9561,
19968,10432,8232,12716,1132,20479,6348,6391,6393,6410,
6401,6412,6404,6444,6455,6454,6461,6460,6476,6474,
6473,6477,6501,6499,6498,6500,6511,6516,6531,6537,
6530,6566,6576,6580,6575,6590,6593,6582,6578,6574,
6570,6607,6611,6617,6641,6639,6644,6612,6614,6623,
6629,6660,6664,6657,6663,6678,6684,6696,6713,6682,
6731,6718,6774,6735,6785,6741,6763,6760,6758,6761,
6744,6756,6743,6745,6752,6749,6830,6828,6831,6846,
6843,6856,6867,6871,6875,6874,6888,6882,6894,6906,
6883,6892,6929,6935,6952,6936,6965,6978,6949,6971,
5865,6450,14029,15498,1577,11182,21633,7505,9509,17606,
4847,11952,1336,5531,17783,7259,21352,15505,14032,4717,
7598,11340,14033,14034,11956,2670,9826,8882,1880,6558,
14787,7212,17314,16048,11806,9689,21783,3638,11807,15809,
9267,14923,8111,5372,20764,8113,19524,7143,2143,21139,
18085,19938,6237,19549,5249,16253,13755,16564,13384,11502,
21487,15959,11862,4804,7147,14736,2952,12261,20708,14126,
6241,20892,7045,4656,20016,13758,3402,7884,4570,3193,
8138,20094,1064,4831,20948,12639,2710,6245,20095,17027,
4906,17582,14388,1788,21266,13507,6938,6932,6944,6987,
6928,6941,6947,6953,6961,7026,7033,7057,7069,7092,
7061,7024,7041,7047,7030,7032,7063,7031,7108,7101,
7109,7102,7168,7131,7187,7136,7126,7159,7135,7155,
7142,7153,7152,7124,7125,7140,7130,7134,7129,7148,
7127,7257,7236,7228,7232,7241,7227,7268,7278,7292,
7287,7293,7307,7312,7304,7306,7305,7308,7320,7330,
7319,7317,7334,7321,7349,7329,7325,7326,7316,7341,
7401,7410,7400,7432,7418,7397,7404,7426,7399,7407,
7406,7467,7498,7494,7491,7468,7458,7495,7504,7459,
10061,21267,14318,5144,18503,4907,16147,20682,3340,2831,
14524,21042,17196,21688,8079,1179,13475,11379,14809,21720,
8933,7984,13763,6008,17588,7792,21174,2725,5592,1119,
8431,8934,6362,3051,6542,5337,15540,17532,8840,7666,
13560,5071,10657,17991,1366,17290,4915,5318,15914,13798,
15804,19112,9419,17589,8377,5063,3843,15940,14934,7591,
17353,6765,8432,7427,8381,2570,16607,20713,10498,2523,
13403,14750,1198,15942,17427,6544,13180,5355,17781,15647,
17792,17538,6255,17038,4921,15841,15186,4130,9072,4839,
7991,6424,20819,18270,8095,4776,7470,7475,7464,7463,
7478,7486,7473,7462,7548,7539,7540,7542,7538,7561,
7569,7567,7566,7565,7581,7593,7585,7631,7616,7634,
7617,7615,7606,7607,7611,7614,7609,8468,7663,7662,
7660,7650,7661,7652,7648,7654,7687,7653,7667,7711,
7719,7708,7709,7701,7712,7747,7736,7735,7739,7751,
7733,7805,7767,7763,8220,7772,7788,7799,7808,7777,
7778,7832,7829,7842,7867,7843,7848,7854,7837,7850,
7853,7845,7869,7889,7871,7874,7870,7876,7894,7898,
7904,7895,7903,7923,7942,7930,7941,7922,7932,7931,
7167,17898,13734,21590,2398,4220,9652,10521,9822,2734,
13594,14319,12717,21406,12719,16283,12980,17299,14717,16407,
15572,16284,5175,16330,1371,21384,1955,5866,3206,10592,
10180,12779,20457,1500,2988,10080,11150,12647,13160,15733,
21591,5804,21649,16894,21514,17730,9835,7909,4590,13931,
11258,19765,21620,4491,10522,17906,19242,14284,12720,17911,
17335,7360,8735,17302,13924,11151,6979,4102,2699,3709,
11259,10841,19892,17599,1253,14955,13351,1556,6568,5340,
3082,11178,16512,5021,16470,15956,5421,11203,17544,9800,
21593,1601,5807,19122,15651,5574,7919,7920,7975,7992,
7972,7989,7986,7996,7969,7980,7993,7990,7971,8005,
8030,8017,8016,8064,8060,8054,8068,8034,8043,8059,
8051,8044,8032,8088,8093,8119,8110,8107,8135,8137,
8128,8134,8126,8139,8152,8153,8143,8144,8157,8145,
8154,8147,8213,8176,8178,8184,8175,8180,8224,8216,
8250,8254,8253,8252,8315,8278,8301,8273,8282,8303,
8320,8311,8290,8272,8300,8287,8293,8341,8345,8340,
8366,8374,8354,8370,8389,8478,8401,8418,8413,8458,
8412,8396,8399,8410,8489,8499,8494,8487,8488,8519,
20998,20073,2479,2194,3351,17103,19893,21621,17834,14484,
16366,5341,14114,19310,7954,19034,21386,11709,1194,5530,
12046,21153,7368,3004,13574,14868,20076,17105,3182,7191,
13817,15551,5027,20033,20693,5221,13907,6376,20131,15608,
17306,15147,20694,21635,15552,6668,1960,1516,4779,3144,
9516,15270,18339,17000,21637,9395,21332,12989,10785,20858,
10509,11400,12392,9745,18000,21623,6996,14200,15220,10526,
1372,18758,14058,11323,13047,6848,17166,7198,14144,17799,
13663,18001,15224,13080,20301,21765,20826,14241,14035,9981,
19799,4501,9886,2337,21741,7527,8515,8528,8522,8516,
8524,8545,8544,8546,10204,8552,8554,8571,8559,8567,
8589,8593,8591,8598,8600,8614,8626,8629,8633,8637,
8644,8639,8647,8655,8656,8659,8664,8668,8669,8670,
8680,8695,8692,8673,8702,8703,8708,8714,8715,8716,
8720,8725,8741,8745,8743,8744,8757,8755,8773,8786,
8785,8787,8790,8797,8800,8805,8819,8820,8826,8830,
8843,8832,8841,8846,8853,8855,8857,8856,8864,8872,
8866,8865,8884,8892,8896,8904,8909,8929,8926,8932,
8923,8922,8950,8954,8952,8955,8971,8963,8977,8992,
13709,2243,13936,17800,6812,6495,21698,16928,13049,20034,
3300,14487,6815,7213,14099,7445,7562,6559,13081,3089,
7868,7694,1531,2204,19057,11885,15225,19058,14141,13884,
7218,1708,12959,9219,12590,18072,12747,12225,18637,11409,
9457,17555,21701,8948,19449,17915,9401,17176,2212,7697,
10354,2213,19276,1945,13689,17180,21712,21703,10667,17007,
9255,9412,9809,6227,13749,21244,20700,3829,17026,19231,
15568,20065,17291,3173,17568,4808,4809,12626,1789,12483,
17382,20548,5176,19250,5654,21742,15425,2017,12825,16628,
19268,9402,15432,10355,14973,5154,9008,9004,9005,9028,
9029,9062,9075,9080,9078,9089,9088,9103,9104,9115,
9124,9120,9127,9106,9148,9141,9173,9196,9192,9191,
9190,9204,9195,9188,9200,9198,9237,9235,9244,9238,
9256,9257,9279,9281,9274,9277,9270,9296,9308,9311,
9314,9316,9340,9341,9343,9360,9357,9356,9379,9369,
9388,9396,9425,9422,9446,9426,9417,9451,9440,9443,
9441,9463,9464,9469,9476,9478,9486,9514,9515,9479,
9480,9493,9558,9549,9550,9566,9547,9482,9605,9581,
9611,9583,9578,9585,9618,9577,9584,9630,9590,9598,
13649,14373,5471,21226,8188,10999,11247,5591,15642,8378,
4916,14394,5593,21450,19753,962,4444,14945,10708,10182,
1101,4446,2350,16518,1507,7199,2690,10185,8387,11142,
20561,10621,12322,7014,7020,10548,11086,3283,18469,19502,
19500,4676,1065,18521,5506,12997,20172,5189,18958,21268,
18808,13799,13645,13044,6545,17295,18990,18509,13014,12933,
19625,5342,19899,4502,14203,4694,14204,9780,11891,13053,
5405,2682,4657,6242,2647,3194,4908,17089,12172,9107,
12264,10189,20949,13476,16951,17533,16878,8706,6767,6695,
17423,14153,6256,7547,3543,14155,9634,9580,9626,9588,
9597,9576,9503,9553,9710,9721,9718,9714,9757,9725,
9716,9717,9715,9766,9768,9793,9786,9785,9783,9819,
9813,9815,9820,9811,9828,9842,9846,9844,9839,9841,
9869,9855,9856,9854,9875,9857,9853,9352,9902,9908,
9881,9859,9906,9914,9933,9926,9915,9929,9959,9952,
9979,9977,9953,9951,9988,9957,9996,10012,10009,10027,
10044,10067,10078,10079,10051,10028,10063,10046,10030,10052,
10035,10112,10116,10115,10119,10128,10140,10130,10138,10126,
10121,10145,10125,10173,10187,10205,10218,10207,10217,10226,
2662,17943,2667,21594,16297,6710,6295,6153,12393,9746,
13485,1012,9982,12173,13135,1014,6816,17952,3550,9339,
5432,5435,5433,3833,13915,4377,4084,15836,12265,2599,
13519,7246,8295,2780,10600,7071,20259,10291,7001,9365,
6915,19450,6509,18906,13195,20018,3371,6243,20837,20838,
20683,2383,20745,19505,16215,15770,4385,18207,15813,14106,
6050,14504,9936,7994,1424,3660,5851,16572,17907,12484,
3072,3908,3909,15864,8264,3083,8956,9739,9740,16624,
9016,9747,9752,3087,14478,15045,15843,9023,11795,20859,
3393,11837,13142,7531,15844,15846,10219,10258,10260,10257,
10280,10273,10300,10306,10310,10308,10323,10321,10335,10322,
10327,10369,10365,10366,10372,10466,10422,10316,10425,10401,
10411,10444,10415,10398,10394,10434,10474,10486,10496,10488,
10491,10505,10497,10499,10515,10519,10513,10516,10419,10517,
10531,10532,10530,10536,10557,10558,10561,10562,10571,10579,
10574,10573,10576,10577,10601,10612,10620,10608,10613,10616,
10617,10618,10640,10658,10650,10653,10651,10671,10675,10684,
10685,10686,10682,10701,10714,10712,10715,10718,10728,10729,
10725,10730,10749,10746,10743,10761,10780,10768,10775,10776,
10247,20545,14996,15128,20554,18888,13372,8740,2045,5245,
3614,6572,2617,13750,13891,19917,2099,5919,4674,12129,
12074,19459,13652,16591,12673,12291,16831,16832,8742,3830,
1446,1080,1817,13469,15722,21544,4607,20803,11696,12180,
21570,4824,17192,11442,13437,8674,2623,18443,12075,2557,
17745,4380,6188,21571,5709,2511,15796,3195,10900,17524,
17525,10731,17526,11815,16604,16594,17764,8053,19506,6181,
9931,14184,15876,10904,2955,14444,7274,15592,8343,7054,
17763,17666,16126,2515,16070,4003,11606,12332,5512,9461,
20509,15201,7750,9833,14872,1621,10770,10795,10803,10799,
10994,10793,10817,10825,10833,10840,10827,10828,10856,10849,
10864,10865,10872,10881,10867,10890,10896,10895,10902,10922,
10926,10916,10894,10899,10907,10945,10936,10938,10954,10959,
10951,10958,10971,10983,10990,11001,11036,11021,11005,11037,
11034,11046,11045,11096,11064,11072,11067,11057,11060,11055,
11085,11116,11112,11111,11132,11117,11121,11149,11145,11147,
11170,11162,11166,11168,11175,11181,11188,11190,11191,11204,
11198,11200,11207,11206,11221,11217,11234,11268,11264,11274,
11273,11272,11292,11311,11293,11300,11291,11318,11321,11325,
10590,12368,5874,13561,2924,3428,11628,11514,13764,14445,
2985,8199,3969,12308,5846,16664,10919,13921,4173,2657,
10615,11988,3696,936,11611,14847,20069,21063,13843,16001,
16461,7672,7255,4099,1482,2292,12954,16218,14714,15495,
15134,21382,19001,9862,7072,12312,17540,10502,11977,2297,
10437,5853,12078,2853,7577,4844,21310,10438,7630,19353,
10480,18031,2077,15932,11710,9878,3209,5729,17440,15598,
4497,20857,7633,6344,3208,18724,17336,15189,4716,21295,
3409,8880,11880,8459,2848,8361,9129,9777,16103,12737,
3213,1720,18067,11618,16669,20188,11331,11346,11332,11333,
11339,11336,11349,11352,11355,11376,11391,11401,11364,11386,
11385,11366,11420,11413,11428,11437,11435,11434,11436,11429,
11467,11475,11468,11464,11474,11450,11452,11472,11458,11479,
11485,11491,11621,11501,11494,11499,11497,11521,11518,11519,
11531,11529,11544,11539,11549,11568,11584,11604,11602,11613,
11615,11625,11627,11493,11635,11636,11642,11665,11648,11646,
11643,11674,11673,11698,11707,11697,11705,18231,11712,11713,
11729,11728,11724,11737,11741,11744,11747,11758,11760,11769,
11799,11771,11786,11787,11768,11817,11823,11822,11830,11819,
17312,1642,17733,9056,9132,18239,10351,6921,20098,10644,
13496,20189,10549,11670,20099,12859,16654,5696,9980,5693,
7647,7162,5193,2761,11152,11790,5278,7488,3845,20816,
17766,15359,17271,2100,13616,19682,17688,8265,8163,17671,
14339,8136,15389,14673,15458,12611,12612,5631,6496,15763,
17100,3507,4484,12000,15378,4486,2866,10331,10066,17090,
13319,12084,8849,4922,20217,4778,9497,19616,9287,15880,
1846,11740,8205,6638,21595,1602,11477,3857,3983,1216,
2110,19035,2015,10292,3355,18032,18632,3577,3462,13039,
10387,18874,7091,7532,6916,12748,11821,11845,11851,11855,
11861,11858,11870,11869,11866,11886,11901,11908,11912,11915,
11928,11924,11923,11936,11954,11958,11942,11961,11968,11971,
11969,11992,11986,11987,11994,12001,11999,12004,12011,12012,
12007,12014,12017,12020,12016,12027,12026,12034,12033,12037,
12045,12061,12062,12055,12059,12071,12081,12083,12094,12098,
12099,12103,12102,12107,12110,12117,12119,12127,12131,12137,
12141,12139,12135,12155,12148,12147,12163,12168,12181,12177,
12183,12215,12199,12209,12200,12207,12217,12218,12192,12210,
12231,12237,12250,12257,12284,12247,12252,12272,12306,12292,
10389,10356,2216,14861,7370,12455,18412,18428,2040,9374,
15833,15771,7605,12191,18896,2097,11144,5094,19700,6408,
21561,6750,15167,20902,16093,16427,12791,16560,13721,4862,
21245,6445,8403,7133,1021,2773,10862,13776,5996,19136,
19498,18907,13139,12331,3672,3616,9596,19429,1304,18852,
21250,11677,1813,1741,17779,18597,17144,6232,20347,3923,
3823,11765,6327,10897,14463,5565,1441,16492,4875,21479,
20882,7144,3063,11749,18017,5271,9604,13789,2155,2410,
19710,6011,21562,9922,16714,4185,5705,3048,5444,5677,
7613,19579,21484,4438,10819,21073,12299,12307,12294,12285,
12327,12333,12350,12341,12355,12363,12360,12358,12381,12389,
12387,12399,12408,12416,12419,12425,12435,12431,12443,12449,
12450,12462,12464,12477,12458,12460,12473,12459,12466,12500,
12502,12505,12511,12533,12539,12526,12535,12540,12558,12566,
12555,12575,12578,12576,12580,12594,12592,12593,12597,12595,
12601,12614,12613,12636,12638,12624,12630,12619,12615,12623,
12646,12621,12618,12667,12701,12668,12670,12692,12686,12680,
12660,12715,12672,12659,12698,12769,12760,12756,12758,12762,
12797,12798,12818,12783,12787,12788,12789,12793,12784,12827,
12856,21200,6536,4825,5058,3284,2878,7976,4378,968,
13088,2594,12471,7879,9345,14805,21343,3285,2056,19580,
4074,16436,9481,3997,4829,13730,19146,1918,20042,15173,
2506,2413,16715,1674,16851,5353,21264,11375,21346,21756,
16122,13385,15256,2414,12196,11000,17725,7978,2370,8495,
18259,3253,5960,3254,7272,16315,19468,11863,14289,17284,
16601,7783,11548,11461,16026,11637,10818,3050,3686,13470,
3933,21644,9108,10409,16499,11773,9037,12577,20115,5211,
5860,10588,2722,2921,20453,10978,9487,1266,13237,8359,
13196,3656,7740,7900,13092,15355,12836,12837,12862,12848,
12860,12867,12842,12851,12878,12843,12873,12919,12937,12917,
12918,12912,12932,12952,12947,12957,12970,12972,12962,12979,
12995,12990,13004,12991,13026,13028,13025,13041,13074,13067,
13065,13056,13090,13107,13086,13087,13115,13132,13130,13126,
13122,13119,13124,13138,13141,13143,13146,13148,13174,13173,
13172,13194,13199,13204,13190,13210,13201,13228,13235,13245,
13247,13246,13248,13249,13255,13278,13271,13273,13268,13282,
13283,13290,13318,13308,13341,13336,13338,13392,13373,13366,
13381,13375,13446,13421,13440,13422,13441,13431,13429,13474,
5334,6458,13177,930,16324,1376,21125,7336,9992,15438,
15726,3538,6394,6103,2934,2290,6538,4632,9157,14149,
18315,18805,14308,7160,5611,2063,20684,16182,8116,1459,
18961,11002,1282,12123,3902,13346,8682,17383,16296,19673,
19674,5009,9792,17934,11560,2068,16638,2969,17424,1551,
11465,933,19297,9085,9086,7545,11176,21759,21780,21665,
13841,16985,18688,934,13477,7342,4917,10520,7343,12170,
6251,6252,6289,18386,15977,21503,13274,11098,6626,14391,
5082,21146,7489,16452,1832,16358,7163,4095,18621,15175,
13562,20639,6838,14528,9194,21585,13504,13506,13511,13522,
13514,13533,13585,13540,13575,13544,13539,13554,13547,13588,
13597,13596,13605,13604,13607,13608,13623,13625,13615,13613,
13644,13646,13658,13662,13665,13668,13680,13686,13687,13685,
13690,13695,13702,13707,13710,13711,13716,13715,13713,13726,
13752,13742,13738,13736,13746,13745,13772,13773,13778,13784,
13790,13807,13791,13818,13810,13806,13792,13788,13829,13839,
13836,13857,13864,13885,13873,13877,13861,13893,13892,13890,
13895,13906,13914,13912,13933,13944,13943,13951,13952,13960,
13962,13978,13979,13988,14002,14005,14000,14009,14014,14017,
18534,19838,10913,19989,14810,21325,5613,13671,18005,9007,
16453,19509,15066,19116,14532,2959,14582,19991,20647,13870,
9643,13606,19888,9644,8261,16887,2776,17846,16002,10135,
6899,3741,12977,21666,12537,3242,19840,2781,19754,12041,
12579,11511,16956,4681,20025,13969,2013,11061,15236,11305,
15067,10136,16957,5477,9280,5086,3259,15488,10639,17938,
18608,5778,21618,5801,21781,15779,2071,12157,9197,14395,
9301,10074,3811,15780,10858,15891,21207,938,9729,3073,
12485,13348,7910,2962,7809,16408,16057,2033,19774,19002,
8233,1484,10376,1924,20480,9391,14025,14027,14041,14043,
14050,14054,14056,14066,14068,14085,14074,14077,14107,14111,
14127,14120,14115,14119,14116,14117,14142,14147,14152,14158,
14162,14180,14218,14170,14164,14168,14194,14175,14205,14206,
14234,14240,14237,14224,14216,14220,14232,14259,14253,14255,
14274,14273,14278,14281,14270,14287,14286,14292,14288,14304,
14303,14309,14310,14315,14313,14314,14321,14323,14332,14329,
14334,14346,14350,14341,14348,14342,14338,14337,14385,14363,
14369,14366,14367,14387,14381,14372,14407,14414,14415,14422,
14438,14435,14447,14442,14458,14455,14476,14465,14454,14483,
13031,10779,18277,10081,7164,1625,5805,5945,3629,10433,
14354,14263,3630,18056,1883,3704,3243,14398,17996,6368,
1007,11100,10284,21045,12513,7573,11131,3074,11754,6781,
8384,19162,14195,19117,5852,2425,6430,14131,8810,12981,
10678,2020,20249,9510,16471,7078,12934,14507,11011,11991,
2237,3742,13934,9423,19626,13101,2787,6466,7361,10722,
20029,1229,19487,10446,13697,4337,15652,4616,8449,4638,
13872,4686,9017,14891,18182,17835,5022,3490,16722,3946,
14956,17441,17048,10224,20074,14298,7362,15239,10086,19783,
17104,15010,11878,17946,20077,19775,14490,14498,14499,14468,
14494,14512,14511,14522,14520,14527,14516,14510,14514,14552,
14556,14568,14559,14555,14572,14571,14562,14561,14595,14596,
14599,14604,14601,14600,14618,14616,14609,14612,14639,14623,
14635,14675,14649,14625,14636,14662,14679,14642,14614,14624,
14660,14630,14610,14615,14634,14632,14628,14629,14698,14699,
14703,14701,14705,14710,14709,14706,14716,14708,14756,14728,
14738,14735,14724,14751,14726,14746,14739,14745,14722,14768,
14767,14770,14782,14774,14783,14776,14779,14775,14777,21229,
14795,14799,14803,14797,14796,14804,14818,14807,14814,14819,
16964,6058,909,6797,6798,7192,3030,17333,16299,11222,
9468,7554,1995,14400,13035,9748,8691,19900,3297,15698,
15469,20407,15240,17163,4498,3892,17607,5532,14781,7514,
6015,13994,18059,18628,1134,4134,12438,16476,11835,2741,
10716,12400,12823,20205,2432,20662,4408,11689,19315,3110,
17446,12733,4447,7437,17912,8982,1579,3818,11138,9207,
7960,13331,13166,17249,17222,15151,10482,19052,17914,17561,
19053,9116,9429,7726,3636,20898,1292,18633,11403,6601,
1639,15087,15426,16058,13334,13109,16528,10160,6806,11980,
5224,20082,1256,9681,14785,21189,14806,14831,14833,14836,
14835,14837,14838,14845,14843,14851,14848,14864,14871,14875,
14885,14883,14886,14895,14888,14889,14897,14906,14903,14902,
14933,14952,14949,14928,14924,14922,14921,14968,15004,14974,
15003,14971,14976,14977,14986,14969,15017,15039,15036,15051,
15050,15048,15047,15049,15063,15072,15084,14911,15090,15092,
15101,15110,15111,15118,15131,15123,15126,15112,15104,15106,
15159,15164,15165,15168,15183,15184,15182,15192,15207,15194,
15218,15202,15208,15196,15229,15242,15243,15264,15260,15254,
15266,15276,15275,15279,15273,15299,15292,15293,7828,15306,
887,10021,17953,13243,9184,16186,16814,13937,13938,12741,
10347,15097,16067,10816,20085,12498,19692,18069,7214,8082,
17954,13359,15098,8104,4796,1882,13678,19066,17261,19804,
8245,9781,9782,19199,13040,19269,10233,15964,6453,19979,
10101,18587,10931,5991,8962,9220,7219,3498,10789,9458,
9403,6497,4764,20827,16533,8987,6510,9535,7221,9435,
6515,10628,7015,8988,10471,7393,14013,15618,9409,13595,
17464,19080,10552,10982,1669,14930,17409,2832,6335,17814,
3236,4911,17821,10373,6396,6051,7623,8309,1275,18279,
20462,20463,8958,1703,17054,14830,15308,15313,15333,15328,
15345,15352,15351,15347,15376,15379,15368,15373,15372,15384,
15391,15385,15395,15392,15400,15423,15410,15416,15412,15403,
15435,15439,15436,15457,15451,15448,15449,15462,15484,15486,
15479,15482,15499,15478,15502,15516,15521,15518,15532,15530,
15539,15537,15546,15538,15569,15563,15562,15567,15564,15584,
15585,15590,15613,15603,15600,15604,15624,15623,15626,15625,
15638,15654,15656,15634,15670,15691,15699,15686,15682,15678,
15677,15707,15710,15729,15715,15725,15718,15754,15750,15768,
15772,15775,15801,15807,15811,15816,15827,15830,15834,15838,
3778,13376,2463,14515,8411,20571,14331,19550,5921,21548,
17360,4547,4307,1066,2626,12865,16565,19957,19958,8496,
12681,15908,12682,19868,8416,6728,13197,12683,21076,11462,
16316,4677,4678,6004,4995,13655,12112,11657,3341,12478,
2600,8296,9628,5003,20338,5436,12302,1873,17198,3783,
1675,1749,20396,15817,5514,19293,5280,3052,6732,10813,
5010,9932,18747,17203,9635,18976,12486,7793,14333,18809,
16328,11381,13157,5759,13321,9350,17684,7861,13404,7279,
16078,2372,1328,5971,17965,20714,4970,17246,9288,1485,
19841,19511,7801,3429,3762,6733,15832,15849,15853,15850,
15851,15871,15878,15888,15904,15917,15933,15895,15911,15897,
15912,15938,15937,15939,15936,15944,15947,15954,15953,15965,
15966,15968,15970,15983,15987,15992,15990,15993,16017,16019,
16025,16030,16034,16056,16059,16071,16079,16080,16075,16082,
16091,16102,16117,16109,16127,16146,16134,16132,16141,16172,
16168,16179,16181,16193,16190,16201,16194,16191,16208,16214,
16222,16226,16238,16229,16234,16251,16255,16242,16256,16247,
16282,16264,16265,16280,16270,16261,16269,16289,16295,16308,
16312,16309,16321,16317,16319,16339,16341,16337,16336,16344,
15031,8206,12721,19766,8531,14946,10593,9653,3855,15573,
9048,5937,5976,1213,4604,16466,4144,19845,15291,12955,
13945,11661,16467,9836,3935,4334,1166,3705,16331,1979,
11099,2187,9125,7067,15865,10883,17836,11153,7755,14586,
17944,18335,13845,16367,5023,19894,10968,16513,13925,17546,
17071,19245,14540,2700,15468,21180,21596,15653,19895,11012,
9128,4032,13352,16963,16644,19994,13510,19307,7550,1150,
14959,3054,16917,16613,9749,1151,13819,7086,16697,17798,
5984,18827,1395,6467,18871,4079,11536,6126,6377,6736,
10693,19037,16577,19311,15609,21047,16374,16360,16343,16379,
16384,16391,16381,16393,16395,16378,16406,16396,16428,16444,
16429,16423,16424,16425,16426,16489,16507,16491,16493,16494,
16501,16527,16490,16503,16500,16497,16508,16488,16548,16541,
16566,16557,16563,16559,16586,16595,16592,16598,16611,16610,
16625,16630,16642,16632,16640,16646,16665,16653,16659,16651,
16681,16679,16685,16672,16677,16684,16682,16701,16707,16711,
16705,16704,16702,16741,16729,16746,16731,16757,16733,16743,
16734,16772,16803,16791,16781,16770,16771,16787,16784,16827,
16893,16828,16821,16863,16829,16869,16899,16823,16888,16849,
2016,15014,12728,15788,14266,3713,10452,16524,21009,2430,
13482,12319,19639,7522,10293,13231,19198,7557,16580,17447,
10786,20593,20616,10681,5837,10155,3088,9519,10765,17448,
2301,11404,21711,14961,13356,15597,20860,12222,7692,13486,
1678,9887,5764,17002,7120,21314,4605,9334,8461,8462,
19172,2201,7640,11595,17454,11427,2701,18108,14962,2795,
2487,3463,9570,14243,18875,8029,3301,12826,3033,17369,
14355,13219,19325,2160,9673,20280,17955,21209,20264,17510,
10823,17619,12749,13828,7451,6032,21471,7826,1709,6073,
4508,9434,7825,9138,11289,9690,16875,16844,16824,16853,
16904,16817,16854,16891,16859,16884,16820,16873,16966,16952,
16950,16948,16954,16983,16982,16979,17013,17034,17011,17018,
17070,17063,17073,17110,17101,17096,17077,17074,17080,17117,
17123,17121,17118,17149,17153,17135,17132,17158,17137,17188,
17187,17199,17197,17184,17191,17186,17206,17232,17233,17269,
17293,17266,17296,17288,17292,17274,17285,17272,17270,17320,
17323,17343,17321,17334,17337,17328,17318,17354,17352,17349,
17364,17359,17357,17379,17378,17389,17385,17376,17381,17417,
17420,17438,17399,17487,17451,17425,17407,17404,17468,17472,
13417,11808,10357,4082,17461,21194,10248,9537,10249,12092,
18646,12326,11569,5540,19277,14790,16944,1981,13498,13584,
1982,10757,7827,21219,21423,6608,11919,12132,21082,10733,
4420,8555,11230,17060,8615,19923,13471,10069,17989,14811,
15915,10270,17207,6374,16514,3546,2689,16519,3548,21401,
5121,19572,18781,4826,4655,7774,21038,3400,18935,21074,
7852,20805,17527,13653,20806,8492,2158,6687,13654,16145,
10111,1267,18618,21778,1452,14317,8297,6140,18019,20681,
18801,12013,1783,3598,4996,5798,20934,20950,13656,18947,
16123,11503,5416,17985,20575,13438,17471,17481,17489,17482,
17492,17491,17488,17507,17506,17508,17509,17547,17512,17522,
17536,17514,17529,17516,17530,17558,17579,17569,17618,17603,
17564,17565,17590,17575,17650,17631,17642,17635,17632,17643,
17630,17627,17664,17667,17676,17683,17680,17679,17674,17696,
17704,17699,17698,17697,17717,17721,17719,17722,17720,17735,
17734,17746,17737,17741,17749,17750,17755,17757,17762,17780,
17895,17790,17784,17788,17787,17831,17804,17828,17815,17826,
17811,17845,17847,17899,17887,17870,17863,17865,17879,17871,
17893,17890,17885,17886,17919,17927,17922,17962,17963,17959,
19727,11058,1784,1792,2631,2627,8838,13762,7590,7479,
11380,7789,4382,13866,21172,5713,19103,8550,17710,14105,
9038,11753,14813,7252,9069,9562,8344,14392,5282,20685,
10131,7169,18993,1899,21350,14884,13647,9559,17794,2168,
9042,15571,19930,10075,2632,2271,2730,9834,12142,4589,
5802,18331,4030,20981,12777,12710,5863,8753,12640,15694,
14674,4932,2698,17595,3856,9049,4088,17795,17796,19931,
5019,19623,16055,18333,6706,12115,3383,20048,15303,5422,
6502,13814,19932,11535,8102,2129,1152,14046,11756,19251,
7865,6505,8844,9741,9511,14542,17973,17977,17984,17983,
18006,18007,18014,18010,18029,18036,18049,18054,18093,18077,
18080,18075,18078,18076,18123,18116,18113,18114,18122,18117,
18138,18141,18142,18144,18139,18137,18157,18154,18162,18165,
18170,18166,18180,18176,18185,18188,18221,18212,18223,18215,
18220,18261,18245,18258,18271,18250,18243,18248,18278,18266,
18253,18252,18305,18313,18314,18310,18332,18371,18380,18401,
18360,18367,18387,18368,18366,18382,18369,18377,18373,18442,
18437,18446,18445,18457,18452,18459,18462,18453,18468,18455,
18501,18494,18502,18499,18520,18524,18538,18536,18529,18570,
10506,19038,3822,17611,17167,16525,1658,2035,7193,14109,
1232,1508,4944,7438,21333,7439,3211,7088,3391,20105,
4500,1857,17390,18107,1677,13699,10764,9208,1027,20261,
5789,2047,15221,11882,2172,9779,3460,14786,15447,1533,
9212,4947,20899,15340,14788,16219,14691,1122,17552,1870,
2459,9186,10244,16974,17178,9224,20600,3361,8271,20168,
14549,7456,19077,9231,18187,16822,4781,5011,4798,1103,
6132,7017,7022,7460,5609,1594,18372,5714,8423,12377,
10870,11119,11120,11218,14652,15002,2167,20686,8433,11125,
15805,9733,18624,20982,8505,16960,18562,18540,18565,18550,
18555,18544,18598,18603,18616,18617,18636,18642,18644,18648,
18647,18662,18660,18657,18669,18682,18666,18667,18668,18687,
18671,18683,18726,18744,18733,18745,18743,18736,18731,18732,
18818,18770,18812,18804,18767,18800,18820,18774,18777,18785,
18835,18864,18855,18857,18844,18843,18850,18845,18885,18903,
18917,18909,18893,18881,18902,19048,18966,18991,18933,18891,
18992,18984,19009,18884,18880,18946,18985,18923,18889,18948,
18908,18894,19047,18960,18922,19093,19094,19086,19098,19095,
19088,19091,19134,19155,19153,19150,19181,19178,19179,19183,
14214,16368,17049,15756,19635,9245,4344,4065,13183,12095,
7200,11312,19316,5459,13526,20464,7963,5618,3578,7529,
10622,13527,7380,16418,8470,13529,10625,9250,14433,3639,
5623,18362,15751,13378,7881,3124,20951,2363,7048,3430,
3657,6484,13566,5287,14667,5760,7833,6860,13407,17685,
11662,6980,10439,20326,1518,17692,14267,5390,21014,18026,
2850,16932,18840,10470,8475,16942,18422,16946,18249,3899,
4992,13379,13380,7705,7145,4524,18124,3804,6274,2102,
15586,17812,7784,3418,13759,18125,19147,14221,12802,16124,
7150,18126,19163,4262,4659,18203,19203,19221,19247,19227,
19261,19219,19243,19289,19290,19291,19288,19305,19284,19318,
19286,19340,19338,19351,19349,19357,19361,19360,19382,19362,
19364,19368,19423,19421,19399,19401,19409,19397,19410,19403,
19428,19438,19432,19439,19433,19452,19453,19456,19472,19455,
19458,19477,19499,19495,19494,19518,19520,19539,19532,19517,
19519,19545,19552,19557,19570,19612,19617,19610,19622,19562,
19574,19608,19573,19600,19554,19588,19592,19559,19583,19658,
19653,19656,19662,19655,19663,19657,19694,19720,19699,19705,
19696,19745,19733,19712,19737,19749,19724,19708,19704,19756,
18532,15052,14424,19154,17640,8425,17469,11624,2418,19475,
20893,17747,4572,17668,2333,14345,18264,13980,21407,17855,
18962,18963,15119,2565,6071,14393,6108,17894,20687,21273,
20781,5448,21556,20399,5519,5012,7420,3846,10071,3658,
18522,11590,12064,21147,5145,18977,8302,18622,20367,16149,
18810,13508,20549,12487,1471,17752,13445,1083,3292,21689,
15541,21232,3015,20584,19416,17858,18095,18994,6666,6112,
14668,2126,17496,14534,6175,2144,5452,5761,13567,6776,
7802,6485,5065,17355,16365,14396,2731,3971,11062,11320,
4332,6703,18275,17748,5595,4422,19714,19735,19744,19717,
19776,19695,19830,19834,19826,19854,19861,19869,19864,19873,
19891,19858,19857,19866,19886,19884,19876,19912,19919,19929,
19920,19921,19935,19937,19966,19964,19954,19950,19965,19943,
19956,19961,20017,19999,20014,20001,20041,20035,20055,20075,
20061,20059,20071,20054,20088,20101,20100,20113,20112,20110,
20120,20121,20124,20125,20137,20144,20149,20152,20173,20184,
20186,20191,20192,20195,20206,20198,20197,20203,20200,20224,
20218,20212,20209,20207,20220,20234,20231,20228,20233,20277,
20283,20292,20293,20289,20307,20332,20317,20319,20333,20335,
1772,15798,18815,9421,21176,8906,8850,16693,7179,20983,
13770,3136,9303,4270,8914,16896,15881,3432,1331,2188,
19541,8764,13127,13181,14834,939,19683,17499,2529,7864,
17300,16695,16806,5238,15054,1890,6782,8062,14899,20716,
14900,4031,6451,2326,14873,7813,8736,13451,3106,17470,
15212,16332,17215,4617,2573,15327,19014,11487,19164,3814,
12335,21456,2238,2400,21400,7185,12650,15417,21387,16472,
8207,13287,3947,20783,20252,21650,12887,21457,9849,7506,
2843,17126,10604,14426,1657,6492,12372,19628,3860,17838,
12380,14682,17947,14683,6861,6493,20339,20337,20348,20362,
20370,20311,20356,20363,20358,20379,20376,20382,20384,20386,
20389,20412,20392,20401,20395,20391,20427,20424,20436,20428,
20426,20466,20448,20445,20447,20450,20455,20452,20483,20471,
20475,20477,20468,20494,20492,20504,20500,20503,20506,20501,
20505,20517,20511,20523,20524,20534,20535,20543,20550,20551,
20538,20553,20537,20564,20566,20572,20583,20592,20602,20603,
20613,20607,20609,20622,20642,20629,20645,20630,20661,20618,
20619,20620,20672,20679,20670,20720,20705,20719,20699,20752,
20733,20744,20729,20735,20726,20730,20771,20765,20772,20778,
4345,21083,3711,17548,4939,12605,15866,7515,12780,19784,
21521,21313,16998,6799,19124,943,17217,11555,2431,4783,
21183,18484,18402,6643,17948,5296,11950,12652,11422,18708,
16520,17689,15611,21114,14239,12516,9020,6669,6908,5264,
19317,11063,17479,11139,17001,13038,2402,18046,15658,15152,
1217,2613,12890,14688,7578,19902,17612,17449,15554,18582,
18583,20824,19643,1640,3116,9520,11341,11342,14268,20595,
11324,7446,20262,21692,9755,10294,1998,11981,5817,16967,
21466,1013,1044,7915,20596,18837,6345,7603,10787,2353,
5988,6469,2245,17839,20302,14103,20777,20779,20776,20774,
20790,20794,20787,20791,20821,20795,20797,20811,20789,20786,
20796,20842,20833,20843,20844,20830,20836,20831,20872,20885,
20866,20894,20867,20870,20878,20903,20928,20940,20901,20933,
20970,20911,20917,20907,20958,20932,20968,20914,20913,20944,
20959,20912,20947,21025,21037,21032,21039,21041,21035,21056,
21055,21075,21067,21068,21085,21088,21084,21090,21086,21104,
21119,21122,21123,21133,21143,21134,21138,21154,21168,21166,
21175,21159,21170,21169,21162,21203,21195,21201,21231,21224,
21236,21233,21222,21269,21255,21243,21270,21251,21277,21272,
16933,20329,4138,20785,11597,9213,4278,19356,8464,7003,
21751,7695,1881,6817,21335,11347,20285,20345,14592,13110,
15428,20286,12608,14488,17956,20222,15431,3468,15227,17175,
7006,7730,9760,11892,18763,888,20415,6740,6819,19067,
19068,14244,13692,11900,12960,4140,15338,6438,21117,6033,
920,19273,7386,19805,7455,6826,4047,20599,17958,20165,
9436,14434,16535,2250,9702,18841,1611,20601,18423,4355,
2748,16537,2749,18639,2217,13693,19202,9229,2460,17556,
11810,6528,20169,19082,3473,20422,18433,4056,16108,13741,
17739,17751,1434,21092,14421,17816,21242,21249,21259,21253,
21293,21298,21299,21301,21304,21317,21329,21328,21330,21345,
21340,21349,21339,21362,21354,21356,21367,21368,21365,21385,
21373,21376,21399,21402,21413,21410,21409,21414,21446,21430,
21437,21438,21442,21427,21432,21480,21481,21489,21483,21501,
21491,21478,21553,21476,21536,21554,21537,21560,21567,21559,
21603,21582,21598,21574,21576,21610,21626,21638,21658,21660,
21661,21663,21668,21669,21673,21687,21681,21682,21683,21704,
21700,21714,21729,21723,21725,21737,21739,21754,21763,21764,
21773,21779,21766,21767,21777,23849,23850,23851,23852,23853,
12866,6246,17064,7055,6257,5909,6213,16924,16925,9888,
5946,4048,10251,12768,9563,3570,1394,14823,17309,4758,
21018,21024,18434,18435,2824,6691,16095,18964,18965,7337,
1068,6313,4323,2777,7355,8746,5066,8310,4842,16897,
1695,21184,7260,4692,16926,1858,16549,6554,3637,21600,
4696,19059,971,12303,11506,12266,5437,11508,19538,11382,
15005,6546,8747,6113,975,9506,11663,1425,19689,7261,
16033,10826,16927,19049,8332,2769,15429,6527,8484,1299,
20624,19863,4993,1942,5406,15591,18949,6006,16258,12432,
6893,4529,15390,5645,20242,20952,2817,6927,16768,5073,
11736,13984,12244,5322,2492,5276,11580,4342,5794,19576,
12420,1404,16107,18527,18539,20788,3641,17661,19206,8968,
19762,5197,15583,21221,7034,11534,11212,6933,12658,11087,
1806,14078,5526,20268,14336,3250,18312,8430,14942,18704,
18403,4538,12518,5745,8999,1571,20253,5586,19497,3501,
18883,16585,8008,8816,5766,8560,9118,6945,14219,16230,
8859,12385,8436,13064,6865,19019,8074,16322,13714,3874,
20491,9367,13976,18886,11451,13739,19654,12329,18155,16209,
16732,2260,2002,8640,21240,11843,8547,19434,18898,5413,
4419,21274,14659,1472,21509,4421,5776,12379,1572,10720,
3345,14502,8935,4634,15814,18811,2603,10873,6145,1346,
10424,10014,6777,5067,12371,21510,7298,17900,20278,7673,
5068,20174,7493,19246,18132,20717,14326,1696,1697,13408,
14327,2886,20176,21108,9174,20151,3055,2401,14275,15757,
12143,5343,17216,10735,7507,15213,5025,15461,3107,3108,
20993,6981,20515,4066,7955,11260,2972,20078,1255,20119,
9176,4795,2024,6998,14509,913,21334,5030,5460,14011,
20263,9889,19054,1135,2443,16301,21011,21392,1643,19998,
20308,3448,20159,18413,12589,14245,15896,16133,11672,5039,
7035,4415,19521,8851,8599,21161,18910,15765,2149,7649,
11867,11414,2717,18306,9599,13377,9551,19660,12452,19402,
14988,4787,12968,13961,12015,21412,14732,10637,16631,1416,
15680,5610,8774,8291,4710,18311,17528,7151,16346,21611,
10274,15519,1688,11938,2655,16889,8018,7496,7621,8158,
15919,17940,3386,15894,16104,14330,12852,21684,19976,3150,
3615,16818,18128,6267,5855,2242,8986,1219,12574,6206,
4899,4855,15103,14979,15952,18304,1819,5795,10869,17583,
10535,12546,1751,19308,10643,9399,1725,6406,9916,17230,
16303,19330,7964,5409,17225,20177,1540,4049,14772,18420,
18421,18003,10272,5151,20179,19855,1473,21105,4791,19995,
16865,15916,17039,2473,2482,17106,15507,21657,9606,14222,
13314,13224,17240,21495,8426,13225,2601,3002,2450,3847,
3604,17033,20400,8434,7068,2605,2783,5572,18045,15806,
4217,5130,15267,3137,16961,20555,15137,19192,8235,7508,
13630,2989,3187,10440,3491,13354,21522,15655,13456,2671,
6649,13111,13082,7727,20223,15706,4410,20148,16687,8677,
8427,2436,4549,19963,1099,12694,16183,18978,7490,10072,
10961,8825,3041,12830,21275,8201,15023,11106,21057,11297,
18241,7764,6273,14215,11967,8274,11620,5499,6066,3643,
20539,13427,18775,8898,9416,5588,7775,6680,14374,5440,
13542,20775,6851,17850,13120,5229,8911,16836,21640,21436,
16437,19585,14420,2226,15198,2419,7480,18044,18684,4314,
19728,17926,931,3687,21494,12378,11328,3466,15120,14658,
11122,20585,7428,20284,13097,8439,18397,20403,2457,7759,
7896,4977,16773,12844,8007,1155,3748,21768,1283,17700,
5054,20925,11767,21642,2919,12298,16349,6615,16445,16965,
5914,13307,8919,10791,16678,4540,1736,12249,1300,18670,
15815,12038,8306,11659,18816,7170,4238,4239,21177,13568,
21300,17356,2658,1383,20971,7280,1954,3294,8234,14753,
16008,2839,8063,11780,17432,1925,3222,11449,14754,7677,
13066,11051,7509,12727,16645,16473,7814,7080,11784,8208,
11785,10594,10441,9467,16286,13573,21677,13164,12651,3140,
21597,12238,20757,19636,4180,2973,19426,3712,20353,2442,
16156,15504,4940,21678,11951,2132,16073,13018,20441,3724,
15659,7089,10195,20156,1524,2692,10456,9890,15471,3358,
15153,17003,8997,7204,20861,13020,20862,12050,21601,9754,
20193,11733,16068,8242,17171,21052,3644,15349,7267,20915,
21163,8867,17019,6532,20057,9608,19333,5230,16837,4889,
12297,15404,18316,8375,18228,19160,20473,12514,14229,21651,
10098,4761,2771,6571,10724,13465,14311,6077,5306,11033,
17880,17541,15080,17610,8469,19177,12946,3475,2320,14919,
1581,1352,13396,1354,4301,4435,14769,6984,19377,6154,
16380,16673,5241,20698,8920,12330,18769,9587,12661,1156,
5100,10259,3749,10324,2379,3647,16136,11644,11456,988,
18194,3825,3951,8561,14177,14271,11601,5055,19138,2508,
14573,5820,18050,9924,19922,20840,957,18953,12300,11739,
1801,3148,8466,10022,15304,13083,13084,9852,4156,5634,
3303,1537,1538,8334,13137,4160,2746,7010,16767,19983,
11734,20864,9699,21021,2801,4107,16536,10252,10024,17179,
16538,9230,13682,17623,11811,15339,13500,7098,3155,21696,
17008,8990,8485,10025,3375,4660,15672,4218,5385,9291,
13735,10641,883,6982,8236,8781,8782,18338,10948,8634,
13458,10295,9366,4222,20863,18414,15674,3551,19279,19817,
2366,20336,5752,8493,19959,17665,3337,17924,4525,13760,
14185,8912,14742,16097,2420,3343,4315,11507,12695,10836,
13917,8913,12923,21319,6208,6336,12197,16027,14069,3338,
8822,3838,19108,9462,6312,5285,19881,10772,19369,9821,
2608,17651,12325,19076,2039,7604,11520,4068,12850,6939,
16246,17738,12761,17319,4861,18247,20009,4863,7132,9589,
4294,8280,12287,20879,13940,17268,2282,3060,13189,16779,
12965,12665,14172,1586,21246,8791,18851,11365,5102,12421,
10209,1077,11459,8179,13667,13281,2591,4874,10040,11748,
19204,10854,19285,13310,11243,14305,12967,18791,13694,1447,
3011,8255,15902,6725,21165,15852,13089,4888,13727,17723,
13546,6751,18086,11296,12799,7612,2679,7541,10652,19287,
13478,8936,3659,10073,3346,991,20688,4530,8907,18506,
12185,1322,5479,5480,12113,21276,13832,4324,1085,21120,
20895,18556,8683,18979,13256,14669,12488,4386,5401,8230,
7714,5684,10426,8572,13569,21106,20123,20972,14325,9848,
19768,14297,19485,6567,13641,20587,16285,4972,13260,21109,
11664,10082,20590,20459,9850,21518,6711,16333,2990,5869,
8609,18869,12216,12985,5808,11730,12493,5630,1333,10595,
12022,9825,13926,13847,7087,18485,17218,2876,3122,2944,
5297,19490,6215,14757,5028,21523,4941,16550,1360,20442,
19640,16551,8610,5492,20664,17108,12913,5324,7928,10719,
15231,6238,21141,8601,1401,14575,16633,19503,4260,10901,
19467,9620,15991,17148,4897,15172,19469,3621,17638,16267,
9275,19225,2953,7985,12693,16864,15028,7899,11532,12634,
1082,14741,2266,15812,19589,6539,1458,4910,16028,3424,
3201,18222,21664,3482,7335,16276,19292,5475,5965,12828,
4746,13765,17330,16359,2231,8568,12810,9006,16986,4322,
1246,12002,15858,10278,12028,17933,7251,20648,14533,13904,
11387,4361,1327,16621,6012,7066,9498,1212,7354,14910,
9309,19302,19755,15135,11007,3980,16990,9773,3135,10015,
19903,10457,7641,2351,21321,16529,6849,18033,20598,7728,
20465,1892,9355,4697,4470,9984,5302,14101,8613,6560,
18877,7093,21393,4392,19806,7533,6218,9405,12162,9700,
9703,10358,10026,3321,21095,9818,16546,3016,21726,1600,
9126,3025,18008,1182,1604,1607,1154,3034,1609,1610,
11872,11874,20695,2978,18729,13774,4513,14557,13897,2162,
5095,19546,18846,12617,20310,16338,16024,21396,3275,5997,
3276,4254,21031,2380,11694,2643,2409,21252,15559,16140,
13517,6726,3960,19533,11525,18793,7779,9923,18121,4168,
8089,19470,13386,3678,8045,18860,13479,8811,17917,9899,
6790,18134,8450,13932,21728,7079,11010,4493,12726,6265,
17608,6214,16370,19036,16626,15085,1517,6014,15365,13879,
18064,17254,5222,9523,6917,13488,6195,4506,11802,11079,
5393,18929,8916,9713,3265,18926,16840,20182,12111,19451,
9903,5049,5111,14700,10972,16036,2393,4955,1589,1022,
7776,7651,20091,18940,10605,8520,15760,18650,867,11504,
7110,5845,1116,8194,12545,9928,12921,5643,3841,20318,
18204,13238,19601,960,17932,1771,8970,19926,14747,4364,
2852,7346,14909,20431,11946,14044,10659,19239,20850,5974,
20610,16790,9719,15289,6729,5507,9158,1344,3256,8428,
1382,19476,21101,7935,19729,2984,15688,3289,19914,11945,
3485,15185,18326,2604,15643,14578,20640,19479,20066,4325,
5873,3293,16405,11551,18564,2762,18130,15319,3697,2606,
19915,15129,10690,5651,20481,14676,1935,2663,15138,4176,
3706,10285,2611,3230,13708,12888,17976,19777,18823,4338,
9873,14684,10736,6552,20408,15607,4409,1559,1562,9524,
19907,19493,10629,9573,15848,12757,14166,19560,13860,16260,
4814,8642,1684,17628,14411,19856,3214,6876,1191,8281,
1435,16210,8899,5703,14517,8818,20586,17542,10318,21750,
3151,5132,6598,12337,17718,21461,6868,21706,11576,18882,
15589,3326,14655,1895,2637,6931,8799,3502,9370,20309,
850,18528,4815,4950,18900,3314,9586,4292,1409,1123,
5818,13233,19180,20090,8543,17061,5581,10117,3920,11820,
4183,11582,19435,14925,8901,6943,14417,6681,3264,9910,
18784,17400,1442,2999,5673,6747,17758,18738,12025,8868,
4210,7137,11214,11052,20359,11868,5321,11412,10702,2555,
9320,5347,16709,20315,15274,20211,16839,21776,6946,4782,
20238,11943,11187,9954,21323,20528,15565,6332,3197,14146,
5053,6082,7036,6304,17702,16949,5718,11935,9289,18254,
2499,3995,10489,4958,16708,9272,7269,5346,1818,17024,
13518,17466,12627,13250,21096,21641,12465,9149,11651,19471,
1926,17322,8225,19380,13058,18742,10905,13963,1316,14743,
19672,20060,6311,8966,17325,17326,15059,15483,11301,16880,
13894,2835,21505,21647,18689,16691,17331,20019,13059,19367,
10874,2343,4840,9898,21306,6425,13062,10771,13063,17859,
3585,1529,18097,1502,20291,16409,20782,10882,9965,3384,
11013,18703,2046,8876,4755,11014,8939,9778,20154,2198,
19444,6999,18407,2206,20157,6522,19358,3419,1787,3901,
9268,9621,14832,2855,3837,3268,11550,9488,8969,7742,
19393,9001,8117,15060,19107,2652,7743,10276,8839,16639,
6762,13205,996,15121,4019,8730,11777,6072,2397,15262,
5284,855,11638,6020,3714,880,897,14908,5881,15890,
2566,12158,9460,2030,12411,12642,19238,1370,15082,3605,
11126,12188,8388,9863,12568,2856,7720,11960,13209,10317,
2082,3571,6013,7952,8453,18754,14004,12276,13875,1930,
6913,11565,16377,7396,11538,10575,6346,10031,19526,19664,
13251,19669,19897,16382,20910,12149,15515,2718,20239,5844,
16941,20162,9694,19586,18317,21721,10837,3376,4004,20636,
19871,4833,15711,12831,12507,2732,20129,2987,19540,19211,
12582,21727,5888,16412,10443,9242,18234,15575,20439,15418,
21388,17219,4021,15445,13412,2964,20079,4431,8698,15074,
2757,3234,20080,19431,986,20372,7599,12405,2244,19800,
9521,20194,18761,7601,15430,12509,11883,19069,18416,19070,
11745,13887,2747,18424,10104,11081,11082,11746,17673,7732,
14551,11084,18430,1587,14653,14692,9525,7875,5043,18856,
9897,3508,20527,3884,12504,13388,1081,20632,20839,1067,
10559,4961,11527,3807,14187,13116,16394,16658,10774,20514,
4934,4464,7027,12759,12853,12662,13426,18156,17267,1028,
2078,9189,1057,6413,8709,3921,7266,17785,3324,5427,
10852,11237,18914,3953,7703,18081,20732,9321,9145,15025,
18219,5548,17467,5824,8776,8417,13797,18606,16225,20122,
16399,19599,3237,10299,21498,10908,14503,15029,7114,20513,
9968,3588,1704,18831,3725,2636,4562,3128,18119,18466,
6307,9146,16981,2288,6622,18559,20756,7684,13499,14165,
13587,13368,964,5690,10683,11857,20039,17075,12106,4623,
13787,8869,14707,15230,1450,8369,9615,19584,17237,19143,
8806,2885,21551,4488,19590,16690,5966,5171,12696,10810,
13781,3688,15000,17028,18967,2147,14525,16022,16866,11918,
12871,13394,7481,12267,18653,19185,1092,4550,2423,17712,
3993,19967,12874,4837,1922,11509,17641,4265,8435,4172,
5418,19186,12925,1165,13989,13722,2336,11864,4662,20045,
18865,13202,12268,5827,6253,19156,8500,3809,18980,21043,
16987,5083,13782,6878,15380,8649,19877,10336,11639,16569,
4202,21515,11660,16003,14670,11257,5484,8689,10076,1752,
3020,5523,1837,12269,19757,15006,21762,1889,19483,3763,
7299,20649,14607,14671,15818,8307,15157,18740,5859,10610,
11656,14322,3131,11059,6361,2123,16451,16504,10911,11588,
20478,8061,8447,9871,17605,18063,6525,2877,6880,15233,
19161,20865,14554,15476,16094,17014,13753,19703,2641,18783,
17361,1786,19587,6844,2107,15068,11330,17768,7911,14030,
21331,11571,12328,16736,5743,12105,17759,17350,16170,929,
19670,1455,5338,999,7906,2191,17602,10000,19257,17626,
3504,3224,2251,16738,20904,11993,2677,16737,8579,2316,
2906,15016,1582,11854,6414,2821,12176,3279,18517,21771,
11645,4868,2330,18916,18778,15943,18213,2053,8562,18082,
12926,14535,15302,17994,20529,1269,6115,1489,14477,2784,
14583,1838,21279,2659,20096,12522,15918,12927,4925,20385,
10859,12879,4926,9645,19969,12270,18447,1180,1794,7803,
5420,14817,20753,11448,11683,11779,3698,7256,11473,15440,
14409,18866,14939,8937,8551,1296,15921,17713,6259,7678,
2633,4405,5315,1753,14587,11421,5877,19165,8506,21107,
2708,17365,15922,11389,9448,6972,19769,17908,13724,21753,
20984,14226,2664,16991,17714,13571,12271,15820,21181,6292,
11308,8854,18571,17157,17209,17770,8507,2108,9351,7073,
12334,13871,11101,18752,19120,5685,8722,20058,1309,15037,
12864,8953,9061,18939,15681,13532,13153,17727,4611,2308,
16323,2720,6333,3199,20064,9003,4320,9472,21377,13117,
1466,15125,12951,19371,8020,13100,2688,2844,10002,11041,
15741,6714,14842,18244,16385,6228,11267,8646,15315,10475,
9063,8115,9297,19730,2267,17029,16568,6834,4317,13520,
13617,6116,15731,13622,8618,21353,12035,12992,14874,12786,
14975,2136,4727,19859,11454,11163,4164,11108,5498,1585,
16600,6010,16383,9376,5101,14798,10208,10326,18441,14985,
4227,10038,10853,10648,17980,12057,16138,6230,11269,7970,
963,3917,19512,14087,8662,12931,14947,11640,3812,5979,
13947,14678,8765,13411,17437,20591,17797,20187,15627,3261,
5575,6279,19375,4009,10504,10925,9292,16298,17646,20030,
1334,15144,19778,2189,15882,1850,5980,7282,6263,8347,
4756,2170,16287,20995,14957,8348,6468,19685,15784,8938,
21458,10568,17715,13230,14452,5939,10569,18654,2790,20305,
8209,17303,4271,10814,12570,9512,12067,13948,2532,5239,
9565,15596,1733,21286,20718,15979,10183,21732,8328,2315,
19847,7369,5177,3817,15577,2298,10597,8737,10087,12277,
10447,9518,13017,12144,8362,11261,6534,16432,9921,7238,
20621,19092,6724,21164,7141,17873,6748,15561,18083,7586,
10124,6392,18084,13899,15108,16713,9147,16392,21434,8342,
2080,1190,16848,10940,6577,21228,12689,16857,15027,4026,
21416,12342,14482,5143,4601,3099,14423,5644,10407,14846,
17587,18224,11174,7664,15064,6625,17892,12169,7338,17990,
16660,10909,18389,13207,8732,14351,10821,19301,12599,9642,
13902,15301,6858,1477,17791,4969,15487,12077,11303,6632,
19303,17430,9240,2032,6340,10660,6594,9798,21179,18750,
10430,17967,5129,14822,14953,14196,14320,15925,2193,9175,
21733,12219,977,12278,17307,18149,21369,9452,854,8783,
15330,9054,4034,16521,2928,21524,20759,1348,11791,21636,
2965,15422,3910,12729,12936,21389,6991,19785,7914,5632,
10845,2273,15758,16918,9802,15578,5559,3262,14826,20663,
10448,11040,10449,6452,1659,5046,9164,8749,4551,16762,
11537,16300,6399,3563,17164,17165,6866,9851,4451,10981,
8575,18450,3609,9804,5835,17255,4081,16011,16414,16288,
5031,13848,7090,4348,8510,20665,15660,20344,6435,18486,
4105,17109,19641,8766,14479,6646,16479,5032,20532,2112,
13167,14545,6217,8983,11953,13078,15179,9567,3440,20406,
9743,13878,12585,1522,6030,21464,5990,17616,19322,19978,
4719,6061,1107,11143,5740,3477,11110,19528,2411,11846,
12880,12883,16804,9865,12889,6549,7441,7440,2977,18191,
16739,8086,20235,18782,4397,7235,8035,3328,6309,12082,
1886,9557,13387,17410,15683,13640,8965,16347,6583,10410,
2870,6627,13401,17094,1003,5453,15320,10137,17159,9971,
8327,17609,11205,15222,9110,7121,6759,16053,20957,8651,
20883,6948,4250,2176,16988,8319,2257,8033,11909,11090,
4909,1464,19811,2377,14901,4577,18246,16735,19701,1410,
13079,6297,15951,21624,6555,18714,11263,7523,4089,7516,
14960,8984,6381,17949,20606,7821,20666,1560,21050,21527,
17773,18655,10949,12029,865,5072,12938,10928,2113,3302,
1218,17111,9756,15284,8587,18584,18718,11898,16614,13825,
15510,15285,13021,5300,14916,2929,1863,12051,3273,1397,
14048,5178,21528,16699,19260,6677,15790,10162,8576,15250,
14138,15075,16302,5225,20722,20723,9293,19055,19905,15523,
11796,16968,7262,5266,10694,8350,15056,21691,15286,15287,
4759,16553,11489,10388,15288,11982,21680,16047,17777,5656,
18002,9805,14721,10766,11405,10623,7921,21540,5700,11850,
19563,14980,3278,21118,14174,13145,18195,13703,14730,9784,
7608,12424,2141,9554,12448,16195,17193,15255,3676,16433,
4281,8047,1655,7786,2263,1454,2174,11911,1024,19925,
15854,16794,5449,11329,12345,899,12434,2567,9500,18229,
13027,12412,2295,9389,20474,16902,14233,1512,11757,10674,
14853,5047,5042,4859,11903,21497,7761,8395,1222,20180,
14987,4988,21639,18924,11904,15343,17402,6457,12366,9483,
12697,8728,21366,1966,20962,16799,1036,10139,14227,1627,
3075,20460,7215,17339,14920,19544,21130,5243,16245,8921,
1534,16530,10165,3611,14036,21625,18838,10462,8767,13022,
3183,12656,2303,15472,10788,19385,2246,4760,8071,1644,
14827,10315,17801,3090,10234,20160,7530,2038,9529,17131,
16935,8635,14869,1388,20487,12897,2488,10467,6470,7094,
12591,6820,13023,12510,9987,14102,17802,17315,2489,9025,
14965,10167,11598,6651,12422,15226,4507,13112,13538,18489,
15473,17392,8471,7642,21744,9892,13169,9336,4139,17656,
20136,7007,7452,21053,3593,18153,19347,4118,8472,11899,
15705,12610,15822,15823,20499,3893,14246,8558,7453,4644,
15228,10390,8352,6823,19807,9762,20008,12248,14725,5140,
17567,4872,21135,4873,2823,3327,8834,6001,7587,5351,
17408,15631,10062,12774,4584,14283,5797,4215,14712,10178,
13593,16274,21493,8729,17329,15641,11201,6766,14935,1597,
5417,21379,11252,7937,20690,13903,5214,9496,18989,7353,
1692,12388,10778,9390,11322,14057,17545,9872,20294,7553,
12958,13076,6551,21699,18526,6977,2858,20111,19363,3877,
6937,16431,4653,11242,8408,8672,10212,3753,3334,12530,
11244,7239,4402,5400,17813,18160,6187,18549,10655,16980,
6690,9767,12703,19234,12702,6395,9040,18325,3100,16279,
21468,13085,12901,21472,9404,1541,15824,6562,17553,4207,
5871,2491,8337,4698,3304,19073,921,21609,18136,3819,
21292,6196,21394,7016,11691,6135,6924,13263,1710,19275,
9027,11838,17842,7534,7535,12961,2134,21023,11231,9541,
9407,7018,21695,8949,14276,12230,9139,4052,14918,2997,
10529,1652,1281,10391,17226,8888,10253,4356,10359,7536,
9232,1872,7394,18640,2218,17345,7537,16947,5664,2023,
11812,9438,3156,13502,12070,10633,21697,10553,20196,11814,
8486,15529,21220,9233,13985,18463,17706,1265,17711,10811,
18146,20953,17150,19675,12711,2272,2396,8198,10879,19615,
19927,17097,11610,904,15493,7913,6636,19248,3186,3081,
17969,20484,12584,1997,13484,10450,1528,20161,16609,16463,
20070,15549,16778,1613,12764,2098,10698,9593,12289,11196,
18594,13941,7398,2802,2497,3062,17397,4543,12003,21248,
11530,20922,20608,10211,8148,12468,10328,17078,17401,19462,
20886,16180,20799,10043,5430,3652,9601,16142,2464,8658,
9346,18143,13696,20930,20627,5678,12625,15873,9082,8151,
6479,6185,6755,7781,10533,8368,927,17852,4526,5549,
4900,8420,21550,15259,10057,2806,4679,4027,12974,20547,
20973,19237,6634,21516,1851,15522,13815,1386,10153,6556,
9136,2215,2283,2284,8140,1025,3852,8457,9901,11080,
10975,10700,14844,14209,6889,10976,18265,1460,5967,1461,
14188,8557,8650,1367,6254,13953,14039,17204,7492,7344,
11278,17066,14877,4006,20342,11616,20402,12186,17115,10077,
1599,1490,13954,6119,5615,5291,5260,4445,2840,6275,
5721,11282,14113,9073,9304,10477,15862,14156,8237,19970,
19971,2239,13523,10019,2274,14137,9074,18235,16578,18280,
4346,6841,19786,16579,6280,1231,6281,13525,18611,16581,
1168,944,16415,19129,9095,13632,10614,2923,9817,5862,
7484,3690,8197,3119,14448,11553,20321,9795,9239,7065,
12444,8260,13347,4096,2925,2451,10476,2125,8259,17993,
10914,19300,20651,4614,15322,15247,17594,5196,3178,5216,
14912,1693,13808,21178,17593,7912,13029,12645,2768,15496,
21182,6370,5131,19973,13279,16159,8455,13103,13214,10381,
21740,16907,8238,19898,9394,18282,10005,1879,2130,19482,
1001,11363,3129,14254,15742,20043,9788,12402,3379,7059,
1714,19028,13751,4298,5468,8675,10330,20889,18936,20677,
6330,9607,18546,14648,20936,13549,10402,20580,11726,16329,
9210,4022,13576,12241,15738,11797,15335,8577,6129,13634,
2904,5619,4012,12782,8959,15512,5621,12401,8621,17058,
6821,2247,12283,3499,6561,15337,16583,16584,5952,8563,
4018,6768,15321,6548,9368,17659,18890,20900,19087,18454,
3986,4291,14456,12134,5157,20036,20871,12286,2461,4295,
13428,3645,10110,16135,1737,4228,14729,4229,4374,5747,
19548,8517,13121,17707,2949,4997,17081,14208,14469,12564,
20703,17276,3514,12136,18950,4127,10581,19100,8189,2415,
10403,14471,17239,19105,21227,18473,13777,17091,2696,18378,
19106,19591,3602,16348,11774,4128,2986,21504,3121,10442,
9976,16496,7315,12993,7273,7113,7056,8595,3581,5084,
7431,20175,11970,10045,1921,1385,20306,12353,12556,5038,
9111,5136,6037,15401,5210,20272,17633,20010,5770,6084,
20140,10855,19707,2307,11695,12679,14495,18678,2339,18370,
6688,1888,5927,5757,17935,8974,903,11306,16089,18065,
18630,16938,11575,1341,14641,8928,18792,20935,21488,5060,
7933,20710,9170,13393,6962,15454,5020,2163,7149,16953,
3624,19618,5457,7950,13521,7466,7597,12446,10832,5503,
16749,5550,6959,8305,7340,12362,8661,13151,15258,1110,
959,7741,5064,18327,6697,20046,16797,15489,7171,3523,
995,17040,19188,13991,13704,9966,16060,3586,12314,15187,
19770,17250,4683,11687,4388,6992,3528,19195,20999,10262,
16936,9658,9665,6141,20812,18968,13203,12875,6543,5454,
8379,6341,20103,19629,2737,15181,5989,6909,14852,5655,
2797,20106,19384,7002,16929,10197,9526,11556,18027,20108,
7099,7100,11492,4810,14081,11466,4663,12076,20020,2660,
18448,953,11006,3764,3486,6337,3813,11478,2429,20343,
10083,12653,21110,6266,20409,19125,21290,16101,10088,3973,
19252,16810,10094,10095,6268,19130,5288,1878,10868,11430,
3202,7485,14018,14748,2314,10473,12604,13494,12415,3506,
17140,2860,3925,18199,19099,8727,20022,12557,2649,7669,
4028,3851,19514,19862,5854,19945,16652,13785,6606,8013,
13913,15374,5373,21397,11498,18542,12948,10213,3959,8549,
10329,7290,14439,21140,21775,5566,20676,13467,20804,8038,
5681,3963,18217,8870,13987,5885,12367,20706,11095,16096,
10611,3247,12101,16275,11759,7988,18225,4603,19607,21584,
3904,7487,3120,11561,11177,16217,4331,14816,2525,19352,
5290,10501,1715,15606,20991,20371,5534,11020,14059,14201,
10737,10738,20051,10196,11049,1707,16812,16531,9099,16969,
19060,3449,15620,19808,10235,3360,7095,12079,18491,16420,
16421,17059,7222,11050,11029,9408,9706,6925,890,4645,
3363,10254,10105,923,4765,9708,1259,6160,6161,6163,
1774,13244,15712,20650,2476,13296,8066,8069,15714,4588,
11180,1271,15759,6824,18721,3885,2124,7345,13766,3625,
4077,16798,13767,13208,11865,19189,13981,11512,11390,21690,
1181,19004,18625,15574,1133,7754,6260,12114,1754,19123,
5293,15576,7081,940,6171,5402,12832,15842,19354,15180,
15785,17998,8788,1379,15334,20498,9753,10018,19566,16856,
18746,14151,17644,16909,1616,13986,8308,15069,1634,1635,
14723,5450,5483,6380,4612,6983,9203,19569,12152,10834,
20393,7981,11680,10134,18868,18458,16430,4165,13050,14569,
6329,21258,17982,15353,18680,18470,16792,5930,10984,2334,
18383,6365,19751,16364,4097,1227,17936,1552,16077,10120,
10781,14265,20072,19010,19782,4495,15215,17256,8474,3169,
1612,3536,17897,16911,9592,6415,8077,6422,4586,14611,
14982,17142,20881,13436,6418,4886,21774,11056,20800,3010,
20631,15769,12704,2179,17037,21454,16997,13679,15588,15434,
1525,9096,9140,17615,1196,4365,13357,13358,6130,13136,
11480,7371,3610,11966,15555,15336,17551,12052,5303,1535,
9100,15474,10297,5791,13113,18009,7011,7390,7563,2258,
3305,6440,17263,12905,4053,16220,7395,9234,16390,13768,
4933,10965,13602,5294,16474,13133,5940,2327,9097,13856,
20083,14356,16482,5301,1136,15556,5426,20084,5205,1536,
16485,6825,4050,16221,4054,4890,8141,17160,17600,17168,
7004,20102,9381,12220,6650,19258,20086,12226,949,19131,
17372,6441,18676,3888,13285,8967,17384,14890,5907,17822,
18817,17825,5557,15053,8995,12712,4126,7271,6753,11920,
13757,18519,21565,13612,12877,11279,15595,12819,4132,10884,
10988,5185,11762,19698,3280,18018,11199,6940,5139,3478,
17809,2368,4167,18197,21431,1547,4734,4450,894,9617,
10215,20349,15907,3654,9112,16143,4896,17709,10809,17087,
13057,20387,3966,11586,5312,16662,12811,4129,1325,3905,
2438,21121,7807,3703,17995,1574,20589,5806,14045,13298,
13481,4154,3590,7560,1933,11024,1871,8592,20896,4946,
4976,17807,11167,8792,4158,11197,3369,14491,19829,18799,
15174,21569,2561,11419,9171,7417,3691,15261,18169,11706,
6009,19758,16259,1148,4174,3631,3385,12066,12538,10113,
2386,8065,9449,6123,13070,4339,4272,16475,7815,9091,
14427,18828,18829,8697,4116,1603,12457,9450,15808,7283,
15957,6800,8980,7284,10606,15883,2483,19344,19996,6379,
5985,8028,16062,16063,12436,9177,16064,21529,21530,2930,
3912,9178,15424,5986,12891,8699,3212,8103,13184,18833,
14006,15663,4275,4351,18283,16608,8611,19395,21315,18284,
17257,17672,18876,19934,14049,3726,3727,7579,8960,9456,
9337,12407,16227,10740,3149,18588,6062,13114,5562,18135,
18352,6827,2259,13888,11031,1711,15177,12348,13946,15083,
8978,10880,8694,11310,12403,2481,8619,9978,5538,15835,
1439,13591,15719,4523,20678,14324,16281,16052,4887,5168,
5505,9636,18330,12311,9241,9517,6997,20300,6095,5653,
8353,7872,5041,18847,12499,20520,9896,16021,2884,14176,
10974,2146,11916,1913,15375,8289,1162,12914,4545,8648,
3989,6877,1091,19716,20738,5508,8678,12520,1887,1824,
19960,11463,15437,3754,14904,14650,17986,15298,1453,11652,
12262,4194,8660,9349,4403,19507,2516,7275,11587,18651,
2470,3808,19104,8564,21173,15877,3915,6459,13556,5876,
17264,12442,10360,10008,11813,13586,15879,8094,12541,19337,
19394,9455,4735,3916,5571,4927,17069,20437,1626,13993,
1086,15360,9939,5576,17999,14300,8330,1637,14963,16483,
18488,18586,15077,8578,14061,4471,10166,16971,10198,12396,
12397,10169,1647,1648,1649,9894,1650,14104,4766,17778,
18464,20425,14940,18572,10142,4579,4473,4599,14565,1965,
6951,3900,14997,16128,20397,16098,13769,19746,8382,2654,
19190,4531,4532,15237,19187,21280,18819,21782,1491,7834,
15550,1248,3026,15828,15007,1249,14672,4241,5895,13771,
15755,7679,7281,1755,18573,15923,14128,15803,20746,14080,
2706,15463,958,13867,9325,9162,15594,8762,20304,9560,
5234,4266,3258,10564,10179,8556,7421,9285,13227,8202,
853,13008,11947,1347,3559,8733,9043,5556,6864,12140,
8360,15411,21512,13161,8574,14948,4335,2109,15071,6547,
864,10312,13015,4636,10923,11397,5292,8349,11488,10147,
19015,7258,1698,1633,15470,10784,10619,19381,21679,17997,
3607,2199,8460,12588,10383,4135,9209,12607,3152,13019,
3591,6912,21467,19056,2133,1646,21046,14418,3241,20974,
1415,21546,11374,14765,10495,6956,4835,9284,8687,13733,
3027,17366,18510,8385,4406,9387,16898,1799,11629,4341,
1891,8535,4010,15145,19630,16905,18580,6847,5870,14685,
7517,21390,1756,17308,1928,18709,3442,4594,20485,16522,
5633,4347,11931,20081,6382,6647,6807,7372,6298,914,
15509,4665,16526,5535,2114,15055,15511,1864,5203,17055,
9021,10163,15076,15581,18719,16554,11344,15513,10752,1530,
19803,17776,7916,14037,9026,21336,14247,2672,3450,19071,
7008,13700,2490,16534,17373,20416,4666,5899,11030,18425,
11351,2219,17374,10634,20170,11573,3896,16112,4230,6090,
9386,16838,3999,8523,5861,5520,20691,7184,14094,11721,
5035,13681,5704,7659,6048,16886,12515,3831,6423,19398,
8112,19824,1241,20704,5472,3927,10332,13472,2559,14931,
4383,20954,5567,17765,10534,1833,9491,5521,19748,17205,
15644,16755,11192,937,1291,2960,6369,4336,3023,10924,
16807,18627,7365,19254,20615,10194,9882,7638,8164,19794,
6437,10459,5662,11619,3879,7734,9595,14217,9602,19463,
5105,8676,3401,20365,12120,21260,17961,7243,18179,18803,
20960,9324,16796,3239,17202,14129,21206,4635,5554,16460,
19681,19555,3380,9123,19000,6290,2159,10311,7302,14070,
18693,1839,4682,1847,11684,1503,1854,16010,5911,4595,
7373,945,918,17170,19997,4699,12428,17653,10687,19747,
4774,5973,3699,16153,16129,2607,18096,21281,20822,12159,
17670,13783,13992,20049,16573,20851,3405,10478,19486,1848,
1251,8440,16155,19005,13448,12567,13452,8080,12523,20530,
19846,12189,21151,8316,21287,11906,8210,12274,20181,7313,
10084,20692,15346,5026,18511,14608,1509,16157,16158,15009,
10148,10709,12375,15579,21000,13820,15610,3972,18060,13536,
14401,8081,4407,5896,1855,21185,19126,10663,21111,3443,
5897,10156,8240,15046,13185,10815,2666,11394,1149,7076,
6640,1632,10642,19342,20390,10225,19194,2712,1153,9179,
19051,3771,12339,3728,13497,18959,15040,16830,13309,21398,
1570,18602,15797,4007,8688,19621,18055,8314,19684,18730,
2131,11500,13756,7880,10956,12063,3453,7248,5252,8752,
9722,2524,9769,7419,1656,2809,15693,1486,8203,4190,
3269,1330,1250,10503,1576,9201,2634,20605,13048,13883,
12069,18173,17810,8498,3216,7877,9415,21547,2362,14999,
6863,9359,15520,11990,10288,7576,11895,11410,3844,3882,
3374,10065,11824,5826,9015,1010,15408,5903,12684,6005,
9294,5987,16012,17950,16081,8538,4284,2549,17693,15012,
10458,21370,21116,14357,12376,9057,15582,9165,21602,8739,
12738,12739,18408,4596,14062,18409,5304,18612,16815,12383,
3091,12384,12942,4597,6652,12940,6869,19648,15666,13537,
17113,21604,8985,13851,14964,5578,16163,5735,15078,12900,
2541,21015,10168,12228,15614,16972,2044,4045,18417,19908,
21655,14063,14248,12751,21019,14856,10468,16973,10626,20488,
11407,1046,1973,1651,3092,13461,1542,21020,19810,17841,
6471,1802,15154,17462,9989,20467,4157,10172,16165,2087,
3773,7643,15825,18426,10635,20418,7794,6109,19336,8684,
5972,4340,21311,11792,10739,14047,6060,13886,12441,6320,
12916,13374,7107,2156,6686,5310,10996,4898,12296,13942,
17238,6017,7856,5377,3991,19182,2558,5905,5476,6104,
9629,19474,13657,20366,13344,10068,2469,19536,13320,7277,
11589,20961,14936,13444,15859,9087,12705,7619,18477,10839,
14450,20562,14296,16721,9499,2782,4923,13007,13259,12722,
16895,19767,4591,5867,5834,19003,12313,15783,13570,16236,
9290,11039,2942,13813,11562,4936,8979,8696,5024,15073,
19627,19488,10289,13410,1557,10843,13217,1011,10763,10822,
8003,19078,18722,16131,12429,21158,18431,10255,10485,15619,
17346,7226,14862,8249,16976,6529,9544,1653,13779,19096,
1617,17678,13176,21577,15116,8972,14854,16446,16454,16455,
19609,5146,18981,980,1272,1332,3005,15673,13071,8858,
16074,5357,12373,19644,15191,1867,17455,12096,1868,3235,
11348,9893,10298,17459,20178,15675,1723,8889,10361,5192,
13128,8652,13118,9338,14073,9041,3627,4573,17771,13659,
3435,9050,1716,4429,12275,4455,15697,1274,1510,10844,
4937,4389,13821,13454,5389,9092,12221,21297,14301,15271,
15700,9666,1718,15703,12224,15035,10680,19901,16916,2574,
15503,12087,14687,6645,2037,12394,15506,16923,17391,21049,
20486,14840,10846,12223,6813,12049,14242,6918,11042,2205,
9759,11229,9536,4083,13501,4805,19244,13301,17129,14647,
21197,19577,7044,4059,6950,7405,20544,21549,6419,13313,
12521,3288,14472,20240,5434,9625,14998,15778,7245,1548,
2562,8808,1470,17241,18269,13559,20749,8502,14666,5183,
12008,14294,17474,13295,20248,13159,21283,13970,12930,16185,
1498,3382,8780,19843,17431,20658,9014,6637,6293,5423,
4618,9657,1514,2612,15150,11227,3982,10451,4104,5763,
20760,21605,14896,7447,4223,6384,9133,12750,9761,20696,
12229,10711,14023,10754,10755,14112,17843,9947,12902,12903,
11570,9101,11839,1724,13683,4000,4008,11617,6282,17056,
4014,5947,4015,4016,8125,19818,19819,18404,4974,17655,
5734,21606,10199,5737,14269,10962,12713,12714,5050,17829,
19793,16065,12655,9838,5117,12398,1539,12752,17840,2759,
18356,20419,19594,3510,13723,7804,1070,6261,16130,3632,
7116,19631,4274,13162,14135,5994,16100,11398,7866,14428,
1167,19896,12315,10379,16574,6375,10338,20097,4559,4687,
11513,19489,12382,11337,6127,17107,3772,20134,3576,1876,
9183,21155,19571,19578,2683,17032,11770,11922,2865,14181,
18854,1420,21040,1164,4571,5307,10334,21205,20241,16879,
14295,16462,11038,14704,2036,2691,11026,13175,11750,7247,
13405,14132,1532,3601,13042,15263,7812,15467,16915,17146,
11092,1063,9627,15802,16876,21502,1992,9964,21632,14028,
6294,20133,3024,17860,13844,13420,7600,5323,7173,18934,
10064,16877,21284,4615,7434,12364,6125,19046,11107,20846,
12718,12778,18581,3553,4834,13459,8114,8200,9937,21511,
20147,11557,20604,7544,2628,3883,5106,21144,18802,5482,
13455,5912,12279,10089,16160,1102,13413,12495,4942,1520,
7201,16523,8211,3791,1856,19491,5810,12317,11718,17690,
15362,1276,5029,20354,8321,5490,14590,3936,3352,15309,
7822,14759,6316,17370,4390,946,16416,20558,21186,19216,
9941,10664,15935,18834,19050,1773,16480,7636,8828,5730,
17169,5298,6734,9354,4945,8665,17774,4206,8511,15664,
11179,14302,20355,15272,13186,19645,11630,20597,5811,5358,
15096,16725,13415,14202,12572,6602,15789,9569,14139,14140,
8666,11025,2538,9527,21659,16930,19427,14403,21531,12742,
13262,17371,11631,2966,7216,3795,3133,16151,17152,11317,
20897,18395,14537,2531,16009,9447,9053,12133,6378,15657,
17861,5889,15508,9335,1893,7729,16934,8335,9571,18073,
14598,3244,4159,13304,18021,3145,1679,1264,15297,7412,
4832,13000,20847,4836,14189,9637,16150,7253,1874,15356,
8994,13061,1487,17247,17151,6967,7620,9823,7180,2975,
6503,2610,20994,3743,1849,20855,7510,3861,2857,21066,
8266,4205,3233,12374,13846,11793,12047,12654,2799,8465,
12609,4503,3147,21210,10023,2214,9946,21694,17625,20906,
3785,11388,17767,11402,12320,6354,8424,14257,5478,21508,
13168,5561,21129,3938,9166,4598,11667,19061,9058,10463,
8165,2276,7998,10598,10099,21653,9530,11043,21607,21016,
11722,6400,19649,3662,14546,14405,6603,15667,6299,17695,
21193,9137,21608,7205,1564,1565,6604,13581,20281,16375,
16376,19650,2946,13852,3865,6653,9807,18344,13360,13361,
7448,1399,4353,18490,5036,14007,7383,17072,16178,6385,
14693,13973,17957,16555,7387,6063,16700,12091,14064,10170,
10696,14594,14547,5622,21534,15616,15312,18589,5305,19396,
12945,12753,16556,13974,14410,9763,1017,9385,6716,11290,
7223,15792,13462,7391,14406,10756,5384,15136,20992,21555,
13289,8057,19593,9638,16570,15863,7181,12161,4592,14157,
19173,889,17316,10717,2448,8262,1228,15781,21517,19166,
19686,2991,16670,11164,19878,16164,21364,15244,8371,8204,
10662,8331,2743,13305,10537,16808,20153,11424,1045,10161,
1338,17652,19480,4558,1100,12489,11717,10337,15093,5017,
6314,15357,5722,7810,16468,4387,7182,7624,17367,18098,
5356,9513,9742,7363,14589,15787,5809,14136,6597,7186,
13261,10090,21652,4593,9055,2275,5560,11666,11719,3792,
14543,21526,4718,3862,4349,13355,5033,6648,1561,14060,
16975,13418,1664,7224,7220,21211,7564,13363,21316,19390,
20489,8636,18035,1667,19813,13463,17393,1803,7700,18109,
15155,6654,21746,14251,14252,4474,5792,9991,18110,11195,
17005,20303,17344,4720,5624,6317,8883,20282,14065,20420,
5135,5793,14489,9574,2304,9410,14791,922,13889,7225,
17916,6442,14793,9707,9949,10668,11232,20668,17375,4358,
10362,5666,9545,17181,3509,7111,16099,1069,6117,19484,
20351,1840,12310,8663,15924,20279,6315,8873,20352,8508,
19425,12730,14402,1396,2302,15661,16552,16372,13577,7558,
12088,7377,16532,16970,6439,5134,1015,12740,15310,5620,
18585,9384,1663,18034,10753,11288,19386,5790,14249,21745,
9572,3296,18449,3298,13102,10751,7376,8214,13849,5425,
1337,7862,15955,8827,5493,3661,6296,5295,8700,1526,
10296,12841,8887,1721,4051,10966,1087,18336,9837,17442,
16335,2578,17363,18398,15829,15557,19389,1618,9044,10842,
13661,15786,7194,21525,17772,13578,8124,1722,6563,9948,
11335,6712,11068,7115,8509,21235,11070,12745,1016,14361,
9990,3356,2849,19516,17112,18762,13460,4046,9532,13280,
1989,978,4693,19542,16726,18357,16943,13414,5913,20330,
20417,5635,11751,18867,4928,9646,8121,1900,18390,4891,
3787,6968,4792,13905,5114,14538,4793,11309,1252,19844,
20823,6433,13212,4845,4688,16575,7364,14541,19779,4811,
18537,8451,8452,12336,6519,20721,1254,18399,18148,20784,
4552,4794,16576,11978,3353,5261,13874,10091,11223,4938,
16161,11262,9659,1578,21001,5262,19848,3031,13483,17443,
2575,3444,8212,18610,5491,21048,19787,18451,19788,18150,
15821,19789,15736,19253,4117,16698,4391,5577,915,20825,
18406,6193,17450,7285,9942,21187,18487,15662,6269,10453,
13880,11425,5265,13725,7637,17775,22349,22350,22351,22352,
22353,22354,22355,22356,22357,22358,22359,22360,22361,22362,
22363,22364,22365,22366,22367,22368,22369,22370,22371,22372,
22373,22374,22375,22376,22377,22378,22379,22380,22381,22382,
22383,22384,22385,22386,22387,22388,22389,22390,22391,22392,
22393,22394,22395,22396,22397,22398,22399,22400,22401,22402,
22403,22404,22405,22406,22407,22408,22409,22410,22411,22412,
22413,22414,22415,22416,22417,22418,22419,22420,22421,22422,
22423,22424,22425,22426,22427,22428,22429,22430,22431,22432,
22433,22434,22435,22436,22437,22438,22439,22440,22441,22442,
21115,2576,10665,6194,11720,4285,10538,7286,7206,16013,
6521,16177,1902,16724,8351,19801,1865,8539,8540,1398,
16931,8541,8241,15980,7997,15665,4276,4277,8915,5539,
16766,14404,9180,7693,12068,10464,12323,14763,4948,948,
21469,12227,13416,12898,1293,3796,10465,13635,7381,8243,
16029,18152,19850,12743,9531,18720,21371,8784,4246,9059,
14481,12744,7999,19062,19063,8000,21532,9167,3939,12657,
2967,5345,8215,8467,19064,21743,7005,14828,14829,2673,
11194,13853,950,13362,15668,6386,15669,4354,7758,10847,
4949,2947,16014,18345,6133,19909,22443,22444,22445,22446,
22447,22448,22449,22450,22451,22452,22453,22454,22455,22456,
22457,22458,22459,22460,22461,22462,22463,22464,22465,22466,
22467,22468,22469,22470,22471,22472,22473,22474,22475,22476,
22477,22478,22479,22480,22481,22482,22483,22484,22485,22486,
22487,22488,22489,22490,22491,22492,22493,22494,22495,22496,
22497,22498,22499,22500,22501,22502,22503,22504,22505,22506,
22507,22508,22509,22510,22511,22512,22513,22514,22515,22516,
22517,22518,22519,22520,22521,22522,22523,22524,22525,22526,
22527,22528,22529,22530,22531,22532,22533,22534,22535,22536,
12365,9060,10932,6387,19262,2887,16816,8246,3940,2018,
4574,6388,19274,19910,17177,16615,14548,6158,2800,15514,
17114,13975,10171,7096,5494,7388,15251,5992,3035,3036,
19074,18638,18418,7012,9695,15739,8814,15628,15629,19075,
16015,10695,17460,5206,15740,2435,7097,16049,20617,1018,
18614,18764,11983,2674,21022,10200,19391,10484,1543,14859,
21474,19651,16727,8480,19176,15433,14966,7644,19079,6472,
1544,19278,15156,6655,4509,7645,9895,18427,5208,8169,
17227,17228,16016,10723,21747,19814,19280,10472,16050,17229,
18028,19081,12356,14792,10631,16945,22537,22538,22539,22540,
22541,22542,22543,22544,22545,22546,22547,22548,22549,22550,
22551,22552,22553,22554,22555,22556,22557,22558,22559,22560,
22561,22562,22563,22564,22565,22566,22567,22568,22569,22570,
22571,22572,22573,22574,22575,22576,22577,22578,22579,22580,
22581,22582,22583,22584,22585,22586,22587,22588,22589,22590,
22591,22592,22593,22594,22595,22596,22597,22598,22599,22600,
22601,22602,22603,22604,22605,22606,22607,22608,22609,22610,
22611,22612,22613,22614,22615,22616,22617,22618,22619,22620,
22621,22622,22623,22624,22625,22626,22627,22628,22629,22630,
18842,7021,20267,19652,20421,18723,18492,12357,11840,6443,
11083,19281,11032,3640,19985,19815,9439,1903,10363,6162,
10256,14863,19988,19282,5665,13503,9546,10556,14518,2005,
17411,10053,18020,6189,21102,16718,9045,12881,5339,19842,
15130,6120,13349,19016,16612,10149,7082,19017,18757,6557,
20413,11027,14860,10370,7892,10092,7449,17223,3245,7454,
7457,18298,19440,3125,1631,3126,12116,21291,7374,11069,
19691,10164,2433,8512,9983,11668,8166,8513,8001,9682,
17340,18290,7263,11074,9696,20490,8004,12755,10108,18299,
3127,10732,6121,2358,4846,11183,22631,22632,22633,22634,
22635,22636,22637,22638,22639,22640,22641,22642,22643,22644,
22645,22646,22647,22648,22649,22650,22651,22652,22653,22654,
22655,22656,22657,22658,22659,22660,22661,22662,22663,22664,
22665,22666,22667,22668,22669,22670,22671,22672,22673,22674,
22675,22676,22677,22678,22679,22680,22681,22682,22683,22684,
22685,22686,22687,22688,22689,22690,22691,22692,22693,22694,
22695,22696,22697,22698,22699,22700,22701,22702,22703,22704,
22705,22706,22707,22708,22709,22710,22711,22712,22713,22714,
22715,22716,22717,22718,22719,22720,22721,22722,22723,22724,
11184,4848,12124,13524,13457,11426,4849,17310,9168,11186,
2581,4767,13453,11185,11334,11354,21654,11933,4700,6616,
7893,5686,15713,15963,6494,8941,6270,2583,6164,19018,
3408,17051,16090,11399,12939,3744,18341,10950,18346,19980,
3469,18240,18350,18351,20724,20697,3362,1990,18765,10934,
20444,18359,4055,10364,4703,11281,19904,3146,13528,2352,
16206,21192,20828,11044,1019,1668,16166,1545,2344,11133,
3891,21519,5525,3937,4695,19852,2277,5207,2048,19853,
15475,15599,14778,4641,16582,1089,3794,16162,21051,13487,
14480,14591,14593,15867,8247,8002,22725,22726,22727,22728,
22729,22730,22731,22732,22733,22734,22735,22736,22737,22738,
22739,22740,22741,22742,22743,22744,22745,22746,22747,22748,
22749,22750,22751,22752,22753,22754,22755,22756,22757,22758,
22759,22760,22761,22762,22763,22764,22765,22766,22767,22768,
22769,22770,22771,22772,22773,22774,22775,22776,22777,22778,
22779,22780,22781,22782,22783,22784,22785,22786,22787,22788,
22789,22790,22791,22792,22793,22794,22795,22796,22797,22798,
22799,22800,22801,22802,22803,22804,22805,22806,22807,22808,
22809,22810,22811,22812,22813,22814,22815,22816,22817,22818,
6850,8248,18353,15981,14967,17317,9413,18629,16811,16813,
6283,17622,6159,17803,16629,20331,11890,11579,12723,20381,
7207,21533,7013,7019,2635,2453,2454,6131,18172,19174,
17620,1233,20265,14694,21535,2579,18347,8269,15791,10102,
10096,2770,13583,17621,19175,11804,8168,18613,2996,20052,
19693,2815,18878,11669,20266,2998,13512,20053,18358,11984,
4357,16671,19083,3246,21656,3733,2816,7965,18211,6105,
19157,10228,12089,5391,12090,18348,10245,10250,5392,8596,
3306,10109,3307,5731,13364,1670,2914,6136,8483,17557,
19987,9271,9814,5122,9564,9967,22819,22820,22821,22822,
22823,22824,22825,22826,22827,22828,22829,22830,22831,22832,
22833,22834,22835,22836,22837,22838,22839,22840,22841,22842,
22843,22844,22845,22846,22847,22848,22849,22850,22851,22852,
22853,22854,22855,22856,22857,22858,22859,22860,22861,22862,
22863,22864,22865,22866,22867,22868,22869,22870,22871,22872,
22873,22874,22875,22876,22877,22878,22879,22880,22881,22882,
22883,22884,22885,22886,22887,22888,22889,22890,22891,22892,
22893,22894,22895,22896,22897,22898,22899,22900,22901,22902,
22903,22904,22905,22906,22907,22908,22909,22910,22911,22912,
16769,6900,14850,19718,12706,4918,8263,9548,886,5739,
14473,3992,7037,17500,17731,3521,23854,23855,23856,23857,
23858,23859,23860,23861,23862,23863,23864,23865,23866,23867,
23868,23869,23870,23871,23872,23873,23874,23875,23876,23877,
23878,23879,23880,23881,23882,23883,23884,23885,23886,23887,
23888,23889,23890,23891,23892,23893,23894,23895,23896,23897,
23898,23899,23900,23901,23902,23903,23904,23905,23906,23907,
23908,23909,23910,23911,23912,23913,23914,23915,23916,23917,
23918,23919,23920,23921,23922,23923,23924,23925,23926,23927,
23928,23929,23930,23931,23932,23933,22913,22914,22915,22916,
22917,22918,22919,22920,22921,22922,22923,22924,22925,22926,
22927,22928,22929,22930,22931,22932,22933,22934,22935,22936,
22937,22938,22939,22940,22941,22942,22943,22944,22945,22946,
22947,22948,22949,22950,22951,22952,22953,22954,22955,22956,
22957,22958,22959,22960,22961,22962,22963,22964,22965,22966,
22967,22968,22969,22970,22971,22972,22973,22974,22975,22976,
22977,22978,22979,22980,22981,22982,22983,22984,22985,22986,
22987,22988,22989,22990,22991,22992,22993,22994,22995,22996,
22997,22998,22999,23000,23001,23002,23003,23004,23005,23006
};

static uint16 gbksortorder(uint16 i)
{
  uint idx=gbktail(i);
  if (idx>0x7f) idx-=0x41;
  else idx-=0x40;
  idx+=(gbkhead(i)-0x81)*0xbe;
  return 0x8100+gbk_order[idx];
}


int my_strnncoll_gbk(const uchar * s1, int len1, const uchar * s2, int len2)
{
  uint len,c1,c2; 

  len = min(len1,len2);
  while (len--)
  {
    if ((len > 0) && isgbkcode(*s1,*(s1+1)) && isgbkcode(*s2, *(s2+1)))
    {
      c1=gbkcode(*s1,*(s1+1));
      c2=gbkcode(*s2,*(s2+1));
      if (c1!=c2)
        return ((int) gbksortorder((uint16) c1) -
		(int) gbksortorder((uint16) c2));
      s1+=2;
      s2+=2;
      --len;
    } else if (sort_order_gbk[(uchar) *s1++] != sort_order_gbk[(uchar) *s2++])
      return ((int) sort_order_gbk[(uchar) s1[-1]] -
	      (int) sort_order_gbk[(uchar) s2[-1]]);
  }
  return (int) (len1-len2);
}

int my_strcoll_gbk(const uchar * s1, const uchar * s2)
{
  return my_strnncoll_gbk(s1, (uint) strlen((char*) s1),
			  s2, (uint) strlen((char*) s2));
}

int my_strnxfrm_gbk(uchar * dest, uchar * src, int len, int srclen)
{
  uint16 e;

  len = srclen;
  while (len--)
  {
    if ((len > 0) && isgbkcode(*src, *(src+1)))
    {
      e = gbksortorder((uint16) gbkcode(*src, *(src+1)));
      *dest++ = gbkhead(e);
      *dest++ = gbktail(e);
      src+=2;
      len--;
    } else 
      *dest++ = sort_order_gbk[(uchar) *src++];
  }
  return srclen;
}
  
int my_strxfrm_gbk(uchar * dest, uchar * src, int len)
{
  return my_strnxfrm_gbk(dest,src,len,(uint) strlen((char*) src));
}
 
/*
** Calculate min_str and max_str that ranges a LIKE string.
** Arguments:
** ptr		Pointer to LIKE string.
** ptr_length	Length of LIKE string.
** escape	Escape character in LIKE.  (Normally '\').
**		All escape characters should be removed from min_str and max_str
** res_length   Length of min_str and max_str.
** min_str      Smallest case sensitive string that ranges LIKE.
**		Should be space padded to res_length.
** max_str	Largest case sensitive string that ranges LIKE.
**		Normally padded with the biggest character sort value.
**
** The function should return 0 if ok and 1 if the LIKE string can't be
** optimized !
*/

#define max_sort_char ((uchar) 255)
#define wild_one '_'
#define wild_many '%'

extern my_bool my_like_range_gbk(const char *ptr,uint ptr_length,pchar escape,
                                 uint res_length, char *min_str,char *max_str,
                                 uint *min_length,uint *max_length)
{
  const char *end=ptr+ptr_length;
  char *min_org=min_str;
  char *min_end=min_str+res_length;

  for (; ptr != end && min_str != min_end ; ptr++)
  {
    if (ptr+1 != end && isgbkcode(ptr[0],ptr[1]))
    {
      *min_str++= *max_str++ = *ptr++;
      *min_str++= *max_str++ = *ptr;
      continue;
    }
    if (*ptr == escape && ptr+1 != end)
    {
      ptr++;				/* Skipp escape */
      *min_str++= *max_str++ = *ptr;
      continue;
    }
    if (*ptr == wild_one)		/* '_' in SQL */
    {
      *min_str++='\0';			/* This should be min char */
      *max_str++=max_sort_char;
      continue;
    }
    if (*ptr == wild_many)		/* '%' in SQL */
    {
      *min_length= (uint) (min_str - min_org);
      *max_length= res_length;
      do {
	*min_str++ = '\0';		/* Because if key compression */
	*max_str++ = max_sort_char;
      } while (min_str != min_end);
      return 0;
    }
    *min_str++= *max_str++ = *ptr;
  }
  *min_length= *max_length = (uint) (min_str - min_org);
  while (min_str != min_end)
  {
    *min_str++ = ' ';			/* Because if key compression */
    *max_str++ = ' ';
  }
  return 0;
}


int ismbchar_gbk(const char* p, const char *e)
{
  return (isgbkhead(*(p)) && (e)-(p)>1 && isgbktail(*((p)+1))? 2: 0);
}

my_bool ismbhead_gbk(uint c)
{
  return isgbkhead(c);
}

int mbcharlen_gbk(uint c)
{
  return (isgbkhead(c)? 2:0);
}
