/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#ifndef _SWSTPROV_H_
#define _SWSTPROV_H_



// Defines -------------------------------------------------------------------
#ifdef DBINITCONSTANTS
# define GLOBAL_(type, name, val) 	type name = val
#else
# define GLOBAL_(type, name, val)	extern type name
#endif

#ifdef DBINITCONSTANTS
# define GLOBALSTRUCT_(type, name) 	type name 
#else
# define GLOBALSTRUCT_(type, name)	extern type name
#endif


#define OBJECT_CONSTRUCTED()		InterlockedIncrement(&g_cObj);
#define OBJECT_DESTRUCTED()			InterlockedDecrement(&g_cObj);

#ifndef  MAX
# define MIN(a,b)  ( (a) < (b) ? (a) : (b) )
# define MAX(a,b)  ( (a) > (b) ? (a) : (b) )
#endif


#ifndef NUMELEM
# define NUMELEM(x) (sizeof(x)/sizeof(*x))
#endif

#define MAX_HEAP_SIZE          	128000
#define MAX_TOTAL_ROWBUFF_SIZE 	(10*1024*1024)				// Max for all row buffers.
#define MAX_IBUFFER_SIZE       	2000000
#define MAX_BIND_LEN      		(MAX_IBUFFER_SIZE/10)
#define ACTIVE_ROWS_LIMIT		200


#define STAT_ENDOFCURSOR            0x00000100	// for forward-only means fully materialized


//-----------------------------------------------------------------------------
// Memory alignment
//-----------------------------------------------------------------------------

//++
// Useful rounding macros.
// Rounding amount is always a power of two.
//--
#define ROUND_DOWN( Size, Amount )  ((DWORD)(Size) & ~((Amount) - 1))
#define ROUND_UP(   Size, Amount ) (((DWORD)(Size) +  ((Amount) - 1)) & ~((Amount) - 1))

//++
// These macros are for aligment of ColumnData within the internal row buffer.
// COLUMN_ALIGN takes a ptr where you think data ought to go,
// and rounds up to the next appropriate address boundary.
//
// Rule of thumb is "natural" boundary, i.e. 4-byte member should be
// aligned on address that is multiple of 4.
//
// Most everything should be aligned to 32-bit boundary.
// But doubles should be aligned to 64-bit boundary, so let's play it safe.
// Also have __int64.
//--



// make these symbols a little easier to type\read
#if   defined(_M_IX86)
#     define X86
#elif defined(_M_MRX000)
#     define MIPS
#elif defined(_M_ALPHA)
#     define ALPHA
#elif defined(_M_PPC)
#     define PPC
#else
#     error: Unknown machine type: Not one of {X86,MIPS,ALPHA,PPC}.
#endif

#ifdef MIPS
# define COLUMN_ALIGNVAL 8
#elif  defined(ALPHA)
# define COLUMN_ALIGNVAL 8
#else
# define COLUMN_ALIGNVAL 8		// venerable 80x86
#endif


// Typedefs ------------------------------------------------------------------
typedef VOID**	LPLPVOID;

typedef long int            SDWORD;
typedef short int           SWORD;
typedef unsigned long int   UDWORD;
typedef unsigned short int  UWORD;
typedef signed long 		SLONG;
typedef unsigned long		ULONG;
typedef unsigned short		USHORT;



// Accessor Structure
typedef struct tagACCESSOR
{
    DBACCESSORFLAGS dwAccessorFlags;
	LONG			cRef;
	ULONG			cBindings;
	bool			bNullAccessor;
	DBBINDING		rgBindings[1];
} ACCESSOR, *PACCESSOR;




//-----------------------------------------------------------------------------
// Macros for interface classes -- IUnknown methods and constructor\destructor
// Use these in the class definition for an interface.
// The code is defined in the header (definition) part because
// it is easier to do so here, and easier to use.


// Globals -------------------------------------------------------------------

GLOBAL_(LONG, g_cObj, 0L);						// # of outstanding objects
GLOBAL_(LONG, g_cLock, 0L);						// # of explicit locks set
GLOBAL_(DWORD, g_cAttachedProcesses, 0L);		// # of attached processes
GLOBAL_(DWORD, g_dwPageSize, 0L);				// System page size
GLOBAL_(IMalloc *, g_pIMalloc, NULL);			// OLE2 task memory allocator
GLOBAL_(HINSTANCE, g_hInstance, 0L);			// Instance Handle
GLOBAL_(IDataConvert *, g_pIDataConvert, NULL);	// IDataConvert pointer

GLOBALSTRUCT_(CRITICAL_SECTION, g_CriticalSection);

#define	LICLENGTH	25
GLOBAL_( char, g_szLicense[LICLENGTH], "");

#endif

