/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"
#include "myver.h"
#include "multiset.h"

#define __T(x)      L ## x
#define _TEXT(x)      __T(x)

WCHAR* getOwnersPart( WCHAR* str );


const GUID DBPROPSET_BTRIEVE_ROWSET = { 0x2f3c1290, 0x5710, 0x11d3, { 0xbd, 0x41, 0x0, 0x10, 0x4b, 0xaa, 0xc9, 0xb1 } };

#define ALL_NOTIFY DBPROPVAL_NP_OKTODO|DBPROPVAL_NP_ABOUTTODO|DBPROPVAL_NP_FAILEDTODO|DBPROPVAL_NP_DIDEVENT
#define DBPROPAL_CB_PRESERVE 1
#define DBPROPVAL_SQ DBPROPVAL_SQ_CORRELATEDSUBQUERIES | DBPROPVAL_SQ_COMPARISON | DBPROPVAL_SQ_EXISTS | DBPROPVAL_SQ_IN | DBPROPVAL_SQ_QUANTIFIED

// Struct containing the properties we know about. The GUID and string fields are
// initialized in the constructor, because C++ makes it awkward to do so at declaration
// time. So, if you change this table, be sure to make parallel changes in CUtilProp::CUtilProp.

PROPSTRUCT s_rgprop[ NUMBER_OF_SUPPORTED_PROPERTIES ] =
{
/* 1  **/{DBPROP_IAccessor,			FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"IAccessor"},
/* 2  */ {DBPROP_IChapteredRowset,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"IChapteredRowset"},
/* 3  **/{DBPROP_IColumnsInfo,		FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"IColumnsInfo"},
/* 4  */ {DBPROP_IColumnsRowset,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"IColumnsRowset"},
/* 5  */ {DBPROP_IConnectionPointContainer, FLAGS_ROWSETRO, VT_BOOL, TRUE, 0, NULL, L"IConnectionPointContainer"},
/* 6  **/{DBPROP_IConvertType,		FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"IConvertType"},
/* 7  */ {DBPROP_IDBAsynchStatus,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"IDBAsynchStatus"},
/* 8  */ {DBPROP_IMultipleResults,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"IMultipleResults"},
/* 9  **/{DBPROP_IRowset,			FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"IRowset"},
/* 10 */ {DBPROP_IRowsetView,		FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"IRowsetView"},
/* 11 */ {DBPROP_IRowsetChange,		FLAGS_ROWSETRW,	VT_BOOL, TRUE,	0, NULL, L"IRowsetChange"},
/* 12 */ {DBPROP_IRowsetFind,		FLAGS_ROWSETRW,	VT_BOOL, TRUE,	0, NULL, L"IRowsetFind"},
/* 13 */ {DBPROP_IRowsetIdentity,	FLAGS_ROWSETRW,	VT_BOOL, TRUE,	0, NULL, L"IRowsetIdentity"},
/* 14 */ {DBPROP_IRowsetIndex,		FLAGS_ROWSETRW,	VT_BOOL, TRUE,	0, NULL, L"IRowsetIndex"},
/* 15 **/{DBPROP_IRowsetInfo,		FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"IRowsetInfo"},
/* 16 */ {DBPROP_IRowsetLocate,		FLAGS_ROWSETRW,	VT_BOOL, TRUE,	0, NULL, L"IRowsetLocate"},
/* 17 */ {DBPROP_IRowsetResynch,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"IRowsetResynch"},
/* 18 */ {DBPROP_IRowsetRefresh,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"IRowsetRefresh"},
/* 19 */ {DBPROP_IRowsetScroll,		FLAGS_ROWSETRW,	VT_BOOL, TRUE,	0, NULL, L"IRowsetScroll"},
/* 20 */ {DBPROP_IRowsetUpdate,		FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"IRowsetUpdate"},
#ifdef _DEBUG
/* 21 */ {DBPROP_ISupportErrorInfo,	FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"ISupportErrorInfo"},
#else
/* 21 */ {DBPROP_ISupportErrorInfo,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"ISupportErrorInfo"},
#endif


// Rowset properties
/* 22 */ {DBPROP_TRANSACTEDOBJECT,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Objects Transacted"},
/* 23 */ {DBPROP_OWNINSERT,			FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"Own Inserts Visible"},
/* 24 */ {DBPROP_IMMOBILEROWS,		FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"Immobile Rows"},
/* 25 */ {DBPROP_CANHOLDROWS,		FLAGS_ROWSETRW,	VT_BOOL, TRUE,	0, NULL, L"Hold Rows"},
/* 26 */ {DBPROP_OWNUPDATEDELETE,	FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"Own Changes Visible"},
/* 27 */ {DBPROP_OTHERINSERT,		FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"Others' Inserts Visible"},
/* 28 */ {DBPROP_OTHERUPDATEDELETE,	FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"Others' Changes Visible"},
/* 29 */ {DBPROP_REMOVEDELETED,		FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"Remove Deleted Rows"},
/* 30 */ {DBPROP_CHANGEINSERTEDROWS,FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"Change Inserted Rows"},
/* 31 */ {DBPROP_BOOKMARKS,			FLAGS_ROWSETRW,	VT_BOOL, TRUE,	0, NULL, L"Use Bookmarks"},
/* 32 */ {DBPROP_ORDEREDBOOKMARKS,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"Bookmarks Ordered"},
/* 33 */ {DBPROP_LITERALBOOKMARKS,	FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"Literal Bookmarks"},
/* 34 */ {DBPROP_CANFETCHBACKWARDS,	FLAGS_ROWSETRW,	VT_BOOL, TRUE, 0, NULL, L"Fetch Backwards"},
/* 35 */ {DBPROP_CANSCROLLBACKWARDS,FLAGS_ROWSETRW,	VT_BOOL, TRUE,	0, NULL, L"Scroll Backwards"},
/* 36 */ {DBPROP_BOOKMARKSKIPPED,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0, NULL, L"Skip Deleted Bookmarks"},
/* 37 */ {DBPROP_STRONGIDENTITY,	FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"Strong Row Identity"},
/* 38 */ {DBPROP_MAXOPENROWS,		FLAGS_ROWSETRO,	VT_I4,	 FALSE, ACTIVE_ROWS_LIMIT, NULL, L"Maximum Open Rows"},

/* 39 */ {DBPROP_NOTIFICATIONGRANULARITY,FLAGS_ROWSETRO,VT_I4,FALSE, DBPROPVAL_NT_SINGLEROW, NULL, L"Notification Granularity"},
/* 40 */ {DBPROP_NOTIFICATIONPHASES,	FLAGS_ROWSETRO,	VT_I4,	 FALSE, DBPROPVAL_NP_OKTODO|DBPROPVAL_NP_ABOUTTODO|DBPROPVAL_NP_FAILEDTODO|DBPROPVAL_NP_DIDEVENT, NULL, L"Notification Phases"},
/* 41 */ {DBPROP_REENTRANTEVENTS,		FLAGS_ROWSETRO,	VT_BOOL, FALSE, 0, NULL, L"Reentrant Events"},

/* 42 */ {DBPROP_NOTIFYCOLUMNSET,		FLAGS_ROWSETRO,	VT_I4,	 FALSE, ALL_NOTIFY,	NULL, L"Column Set Notification"},
/* 43 */ {DBPROP_NOTIFYROWDELETE,		FLAGS_ROWSETRO,	VT_I4,	 FALSE, ALL_NOTIFY,	NULL, L"Row Delete Notification"},
/* 44 */ {DBPROP_NOTIFYROWFIRSTCHANGE,	FLAGS_ROWSETRO, VT_I4,	 FALSE, ALL_NOTIFY,	NULL, L"Row First Change Notification"},
/* 45 */ {DBPROP_NOTIFYROWINSERT,		FLAGS_ROWSETRO,	VT_I4,	 FALSE, ALL_NOTIFY,	NULL, L"Row Insert Notification"},
/* 46 */ {DBPROP_NOTIFYROWRESYNCH,		FLAGS_ROWSETRO,	VT_I4,	 FALSE, ALL_NOTIFY,	NULL, L"Row Resynchronization Notification"},
/* 47 */ {DBPROP_NOTIFYROWUNDOCHANGE,	FLAGS_ROWSETRO,	VT_I4,	 FALSE, ALL_NOTIFY,	NULL, L"Row Undo Change Notification"},
/* 48 */ {DBPROP_NOTIFYROWUNDOINSERT,	FLAGS_ROWSETRO,	VT_I4,	 FALSE, ALL_NOTIFY,	NULL, L"Row Undo Insert Notification"},
/* 49 */ {DBPROP_NOTIFYROWUNDODELETE,	FLAGS_ROWSETRO,	VT_I4,	 FALSE, ALL_NOTIFY,	NULL, L"Row Undo Delete Notification"},
/* 50 */ {DBPROP_NOTIFYROWUPDATE,		FLAGS_ROWSETRO,	VT_I4,	 FALSE, ALL_NOTIFY,	NULL, L"Row Update Notification"},
/* 51 */ {DBPROP_NOTIFYROWSETRELEASE,	FLAGS_ROWSETRO,	VT_I4,	 FALSE, DBPROPVAL_NP_DIDEVENT,							NULL, L"Rowset Release Notification"},
/* 52 */ {DBPROP_NOTIFYROWSETFETCHPOSITIONCHANGE,FLAGS_ROWSETRO,VT_I4,FALSE,	ALL_NOTIFY,NULL,L"Rowset Fetch Position Change Notification"},

/* 53 */ {DBPROP_ROWTHREADMODEL,		FLAGS_ROWSETRO, VT_I4,	 FALSE, DBPROPVAL_RT_APTMTTHREAD | DBPROPVAL_RT_SINGLETHREAD, NULL, L"Row Threading Model"},
/* 54 */ {DBPROP_UPDATABILITY,			FLAGS_ROWSETRO,	VT_I4,	 FALSE, DBPROPVAL_UP_CHANGE|DBPROPVAL_UP_DELETE|DBPROPVAL_UP_INSERT, NULL, L"Updatability"},

/* 55 */ {DBPROP_SERVERCURSOR,			FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0,	NULL, L"Server Cursor"},
/* 56 */ {DBPROP_LITERALIDENTITY,		FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0, NULL, L"Literal Row Identity"},

/* 57 */ {DBPROP_BLOCKINGSTORAGEOBJECTS,FLAGS_ROWSETRW,	VT_BOOL, FALSE,	0,	NULL, L"Blocking Storage Objects"},

/* 58 */ {DBPROP_MAXROWS,				FLAGS_ROWSETRW,	VT_I4,	 FALSE,	0,	NULL, L"Maximum Rows"},
/* 59 */ {DBPROP_COMMANDTIMEOUT,		FLAGS_ROWSETRO,	VT_I4,	 FALSE,	0,	NULL, L"Command Time Out"},
/* 60 */ {DBPROP_ILockBytes,			FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"ILockBytes"},
/* 61 */ {DBPROP_ISequentialStream,		FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"ISequentialStream"},
/* 62 */ {DBPROP_IStorage,				FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"IStorage"},
/* 63 */ {DBPROP_IStream,				FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"IStream"},

/* 64 */ {DBPROP_ABORTPRESERVE,			FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Preserve on Abort"},
/* 65 */ {DBPROP_APPENDONLY,			FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Append-Only Rowset"},
/* 66 */ {DBPROP_BOOKMARKTYPE,			FLAGS_ROWSETRO,	VT_I4,	 FALSE,	DBPROPVAL_BMK_NUMERIC,	NULL, L"Bookmark Type"},
/* 67 */ {DBPROP_CACHEDEFERRED,			FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Cache Deferred Columns"},
/* 68 */ {DBPROP_COLUMNRESTRICT,		FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Column Privileges"},
/* 69 */ {DBPROP_COMMITPRESERVE,		FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Preserve on Commit"},
/* 70 */ {DBPROP_DEFERRED,				FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Defer Column"},
/* 71 */ {DBPROP_DELAYSTORAGEOBJECTS,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Delay Storage Object Updates"},
/* 72 */ {DBPROP_MAXPENDINGROWS,		FLAGS_ROWSETRO,	VT_I4,	 FALSE,	0,	NULL, L"Maximum Pending Rows"},
/* 73 */ {DBPROP_MEMORYUSAGE,			FLAGS_ROWSETRO,	VT_I4,	 FALSE,	0,	NULL, L"Memory Usage"},
/* 74 */ {DBPROP_QUICKRESTART,			FLAGS_ROWSETRO,	VT_BOOL, TRUE,	0,	NULL, L"Quick Restart"},
/* 75 */ {DBPROP_REPORTMULTIPLECHANGES,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Report Multiple Changes"},
/* 76 */ {DBPROP_RETURNPENDINGINSERTS,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Return Pending Inserts"},
/* 77 */ {DBPROP_ROWRESTRICT,			FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Row Privileges"},
/* 78 */ {DBPROP_SERVERDATAONINSERT,	FLAGS_ROWSETRO,	VT_BOOL, FALSE,	0,	NULL, L"Server Data on Insert"},
/* 79 */ {DBPROP_ROW_BULKOPS,			FLAGS_ROWSETRO,	VT_I4,	 FALSE,	0,	NULL, L"Bulk Operations"},
	


// DataSourceInfo properties
/* 1  */ {DBPROP_ACTIVESESSIONS,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	NUM_SUPPORTED_SESSIONS_PER_DATASOURCE, NULL, L"Active Sessions"},
/* 2  */ {DBPROP_ALTERCOLUMN,				FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	0, NULL, L"Alter Column Support"},
/* 3  */ {DBPROP_ASYNCTXNABORT,				FLAGS_DATASOURCEINFORO,	VT_BOOL, FALSE,	0, NULL, L"Asynchable Abort"},
/* 4  */ {DBPROP_ASYNCTXNCOMMIT,			FLAGS_DATASOURCEINFORO,	VT_BOOL, FALSE,	0, NULL, L"Asynchable Commit"},
/* 5  */ {DBPROP_BYREFACCESSORS,			FLAGS_DATASOURCEINFORO,	VT_BOOL, FALSE,	0, NULL, L"Pass By Ref Accessors"},
/* 6  */ {DBPROP_CATALOGLOCATION,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_CL_START, NULL, L"Catalog Location"},
/* 7  */ {DBPROP_CATALOGTERM,				FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"directory", L"Catalog Term"},	 
/* 8  */ {DBPROP_CATALOGUSAGE,				FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_CU_DML_STATEMENTS, NULL, L"Catalog Usage"},
/* 9  */ {DBPROP_COLUMNDEFINITION,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_CD_NOTNULL, NULL, L"Column Definition"},
/* 10 */ {DBPROP_CONCATNULLBEHAVIOR,		FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_CB_NON_NULL, NULL, L"NULL Concatenation Behavior"},
/* 11 */ {DBPROP_DATASOURCENAME,			FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"", L"Data Source Name"},
/* 12 */ {DBPROP_DATASOURCEREADONLY,		FLAGS_DATASOURCEINFORO,	VT_BOOL, FALSE,	0, NULL, L"Read-Only Data Source"}, 
/* 13 */ {DBPROP_DBMSNAME,					FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"MySQL", L"DBMS Name"},
/* 14 */ {DBPROP_DBMSVER,					FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"03.23.0000", L"DBMS Version"},
/* 15 */ {DBPROP_DSOTHREADMODEL,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_RT_APTMTTHREAD | DBPROPVAL_RT_SINGLETHREAD, NULL, L"Data Source Object Threading Model"},
/* 16 */ {DBPROP_GROUPBY,					FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_GB_EQUALS_SELECT, NULL, L"GROUP BY Support"},
/* 17 */ {DBPROP_HETEROGENEOUSTABLES,		FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	0, NULL, L"Heterogeneous Table Support"},
/* 18 */ {DBPROP_IDENTIFIERCASE,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_IC_MIXED, NULL, L"Identifier Case Sensitivity"},
/* 19 */ {DBPROP_MAXINDEXSIZE,				FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	0, NULL, L"Maximum Index Size"},
/* 20 */ {DBPROP_MAXOPENCHAPTERS,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	0, NULL, L"Maximum Open Chapters"},
/* 21 */ {DBPROP_MAXORSINFILTER,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	0, NULL, L"Maximum OR Conditions"},
/* 22 */ {DBPROP_MAXROWSIZE,				FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	32761, NULL, L"Maximum Row Size"},
/* 23 */ {DBPROP_MAXROWSIZEINCLUDESBLOB,	FLAGS_DATASOURCEINFORO,	VT_BOOL, TRUE,	0, NULL, L"Maximum Row Size Includes BLOB"}, 
/* 24 */ {DBPROP_MAXSORTCOLUMNS,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	0, NULL, L"Maximum Sort Columns"},
/* 25 */ {DBPROP_MAXTABLESINSELECT,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	0, NULL, L"Maximum Tables in SELECT"},
/* 26 */ {DBPROP_MULTIPLEPARAMSETS,			FLAGS_DATASOURCEINFORO,	VT_BOOL, FALSE,	0, NULL, L"Multiple Parameter Sets"}, 
/* 27 */ {DBPROP_MULTIPLERESULTS,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_MR_NOTSUPPORTED, NULL, L"Multiple Results"},
/* 28 */ {DBPROP_MULTIPLESTORAGEOBJECTS,	FLAGS_DATASOURCEINFORO,	VT_BOOL, TRUE,	0, NULL, L"Multiple Storage Objects"},
/* 29 */ {DBPROP_MULTITABLEUPDATE,			FLAGS_DATASOURCEINFORO,	VT_BOOL, FALSE,	0, NULL, L"Multi-Table Update"},
/* 30 */ {DBPROP_NULLCOLLATION,				FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_NC_START, NULL, L"NULL Collation Order"},
/* 31 */ {DBPROP_OLEOBJECTS,				FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, 0, NULL, L"OLE Object Support"},
/* 32 */ {DBPROP_ORDERBYCOLUMNSINSELECT,	FLAGS_DATASOURCEINFORO,	VT_BOOL, FALSE,	0, NULL, L"ORDER BY Columns in Select List"},
/* 33 */ {DBPROP_OUTPUTPARAMETERAVAILABILITY, FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, DBPROPVAL_OA_NOTSUPPORTED, NULL, L"Output Parameter Availability"},
/* 34 */ {DBPROP_PERSISTENTIDTYPE,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, DBPROPVAL_PT_NAME, NULL, L"Persistent ID Type"},
/* 35 */ {DBPROP_PREPAREABORTBEHAVIOR,		FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, DBPROPAL_CB_PRESERVE, NULL, L"Prepare Abort Behavior"},
/* 36 */ {DBPROP_PREPARECOMMITBEHAVIOR,		FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, DBPROPAL_CB_PRESERVE, NULL, L"Prepare Commit Behavior"},
/* 37 */ {DBPROP_PROCEDURETERM,				FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"stored procedure", L"Procedure Term"},
/* 38 */ {DBPROP_PROVIDERFRIENDLYNAME,		FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"MySQL.OLEDB Provider", L"Provider Friendly Name"},
/* 39 */ {DBPROP_PROVIDERNAME,				FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"MYPROV.DLL", L"Provider Name"},
/* 40 */ {DBPROP_PROVIDEROLEDBVER,			FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE, 0, VER_LFILEVERSION_STR, L"OLE DB Version"},
/* 41 */ {DBPROP_PROVIDERVER,				FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE, 0, _TEXT(VER_PRODUCTVERSION_STR), L"Provider Version"},
/* 42 */ {DBPROP_QUOTEDIDENTIFIERCASE,		FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, DBPROPVAL_IC_MIXED, NULL, L"Quoted Identifier Sensitivity"},
/* 43 */ {DBPROP_ROWSETCONVERSIONSONCOMMAND, FLAGS_DATASOURCEINFORO,	VT_BOOL, TRUE,	0, NULL, L"Rowset Conversions on Command"},
/* 44 */ {DBPROP_SCHEMATERM,				FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"owner", L"Schema Term"},	 
/* 45 */ {DBPROP_SCHEMAUSAGE,				FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE,	DBPROPVAL_SU_DML_STATEMENTS, NULL, L"Schema Usage"},
/* 46 */ {DBPROP_SERVERNAME,				FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L".", L"Server Name"},
/* 47 */ {DBPROP_SORTONINDEX,				FLAGS_DATASOURCEINFORO,	VT_BOOL, FALSE,	0, NULL, L"Sort on Index"},
/* 48 */ {DBPROP_SQLSUPPORT,				FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, DBPROPVAL_SQL_ANSI92_INTERMEDIATE, NULL, L"SQL Support"},
/* 49 */ {DBPROP_STRUCTUREDSTORAGE,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, 0, NULL, L"Structured Storage"},
/* 50 */ {DBPROP_SUBQUERIES,				FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, DBPROPVAL_SQ, NULL, L"Subquery Support"},
/* 51 */ {DBPROP_SUPPORTEDTXNDDL,			FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, DBPROPVAL_TC_NONE, NULL, L"Transaction DDL"},
/* 52 */ {DBPROP_SUPPORTEDTXNISOLEVELS,		FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, 0, NULL, L"Isolation Levels"},
/* 53 */ {DBPROP_SUPPORTEDTXNISORETAIN,		FLAGS_DATASOURCEINFORO,	VT_I4,	 FALSE, 0, NULL, L"Isolation Retention"},
/* 54 */ {DBPROP_USERNAME,					FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"", L"User Name"},
/* 55 */ {DBPROP_TABLETERM,					FLAGS_DATASOURCEINFORO,	VT_BSTR, FALSE,	0, L"table", L"Table Term"},


// DbInit properties
/* 1 */ {DBPROP_INIT_DATASOURCE,	FLAGS_DBINITRW,		VT_BSTR, FALSE,  0,					L"",	L"Data Source"},
/* 2 */ {DBPROP_INIT_HWND,			FLAGS_DBINITRW,		VT_I4,	 FALSE,  NULL,					NULL,	L"Window Handle"},
/* 3 */ {DBPROP_INIT_PROMPT,		FLAGS_DBINITRW,		VT_I2,   FALSE,  DBPROMPT_COMPLETE, NULL,	L"Prompt"},

/* 4 */ {DBPROP_AUTH_CACHE_AUTHINFO,FLAGS_DBINITRO,		VT_BOOL, FALSE,  0, NULL,	L"Cache Authentication"},
/* 5 */ {DBPROP_AUTH_ENCRYPT_PASSWORD,FLAGS_DBINITRO,	VT_BOOL, FALSE,  0, NULL,	L"Encrypt Password"},
/* 6 */ {DBPROP_AUTH_INTEGRATED,	FLAGS_DBINITRW,		VT_BSTR, FALSE,  0, L"",	L"Integrated Security"},
/* 7 */ {DBPROP_AUTH_MASK_PASSWORD, FLAGS_DBINITRO,		VT_BOOL, FALSE,  0, NULL,	L"Mask Password"},
/* 8 */ {DBPROP_AUTH_PASSWORD,		FLAGS_DBINITRW,		VT_BSTR, FALSE,  0, L"",	L"Password"},
/* 9 */ {DBPROP_AUTH_PERSIST_ENCRYPTED,		FLAGS_DBINITRO,		VT_BOOL, FALSE,  0, NULL,	L"Persist Encrypted"},
/* 10 */ {DBPROP_AUTH_PERSIST_SENSITIVE_AUTHINFO,	FLAGS_DBINITRO,		VT_BOOL, TRUE,  0, NULL,	L"Persist Security Info"},
/* 11 */ {DBPROP_AUTH_USERID,		FLAGS_DBINITRW,		VT_BSTR, FALSE,  0, L"",	L"User ID"},
/* 12 */ {DBPROP_INIT_IMPERSONATION_LEVEL,		FLAGS_DBINITRO,		VT_I4, FALSE,  DB_IMP_LEVEL_IMPERSONATE, NULL,	L"Impersonation Level"},
/* 13 */ {DBPROP_INIT_LCID,			FLAGS_DBINITRO,		VT_I4, FALSE,  0x0409, NULL,	L"Locale Identifier"},
/* 14 */ {DBPROP_INIT_LOCATION,		FLAGS_DBINITRW,		VT_BSTR, FALSE,  0, L"",	L"Location"},
/* 15 */ {DBPROP_INIT_MODE,			FLAGS_DBINITRO,		VT_I4, FALSE,  DB_MODE_READWRITE, NULL,	L"Mode"},
/* 16 */ {DBPROP_INIT_PROTECTION_LEVEL,		FLAGS_DBINITRO,		VT_I4, FALSE,  DB_PROT_LEVEL_NONE, NULL,	L"Protection Level"},
/* 17 */ {DBPROP_INIT_PROVIDERSTRING,		FLAGS_DBINITRW,		VT_BSTR, FALSE,  0, L"",	L"Extended Properties"},
/* 18 */ {DBPROP_INIT_TIMEOUT,		FLAGS_DBINITRO,		VT_I4, FALSE,  0, NULL,	L"Connect Timeout"},

// DataSource properties
/* 1  */ {DBPROP_CURRENTCATALOG,		FLAGS_DATASOURCERW,	VT_BSTR, FALSE,	0, L"", L"Current Catalog"},

// Session properties
/* 1  */ {DBPROP_SESS_AUTOCOMMITISOLEVELS,		FLAGS_SESSIONRO,	VT_I4, FALSE,	0, NULL, L"Autocommit Isolation Levels"},

// Spec rowset properties
/* 1 */ {DBPROP_SWSTTABLEOWNER,		FLAGS_BTRIEVE_ROWSETRW,	VT_BSTR, FALSE,	0, L"", L"Table Owner"},

// Index properties
/* 1 */ {DBPROP_INDEX_AUTOUPDATE,	FLAGS_INDEXRO,	VT_BOOL, TRUE,	0, NULL, L"Auto-Update"},
/* 2 */ {DBPROP_INDEX_CLUSTERED,	FLAGS_INDEXRO,	VT_BOOL, FALSE,	0, NULL, L"Clustered"},
/* 3 */ {DBPROP_INDEX_FILLFACTOR,	FLAGS_INDEXRO,	VT_I4,	 FALSE,	100, NULL, L"Fill Factor"},
/* 4 */ {DBPROP_INDEX_INITIALSIZE,	FLAGS_INDEXRO,	VT_I4,	 FALSE,	0, NULL, L"Initial Size"},
/* 5 */ {DBPROP_INDEX_NULLCOLLATION,FLAGS_INDEXRO,	VT_I4,   FALSE,	0/*DBPROPVAL_NC_HIGH*/, NULL, L"NULL Collation"},
/* 6 */ {DBPROP_INDEX_NULLS,		FLAGS_INDEXRO,	VT_I4,	 FALSE,	0/*DBPROPVAL_IN_IGNORENULL*/, NULL, L"NULL Keys"},
/* 7 */ {DBPROP_INDEX_PRIMARYKEY,	FLAGS_INDEXRO,	VT_BOOL, FALSE,	0, NULL, L"Primary Key"},
/* 8 */ {DBPROP_INDEX_SORTBOOKMARKS,FLAGS_INDEXRO,	VT_BOOL, TRUE,	0, NULL, L"Sort Bookmarks"},
/* 9 */ {DBPROP_INDEX_TEMPINDEX,	FLAGS_INDEXRO,	VT_BOOL, FALSE,	0, NULL, L"Temporary Index"},
/* 10 */ {DBPROP_INDEX_TYPE,		FLAGS_INDEXRO,	VT_I4,	 FALSE,	DBPROPVAL_IT_BTREE, NULL, L"Index Type"},
/* 11 */ {DBPROP_INDEX_UNIQUE,		FLAGS_INDEXRW,	VT_BOOL, FALSE,	0, NULL, L"Unique"}
};

// Change some values in some specific cases
void CUtilProp::calcDefaultPropValue( PROPSTRUCT& prop )
{
	switch( prop.dwPropertyID )
	{
	case DBPROP_CANFETCHBACKWARDS:
	case DBPROP_CANSCROLLBACKWARDS:
		
		break;
	}
}


// Get calculated value
PROPSTRUCT& CUtilProp::getDefaultPropValue( ULONG ulPropIdx, PROPSTRUCT& prop )
{	
	memcpy( &prop, s_rgprop + ulPropIdx, sizeof(prop) );
	calcDefaultPropValue( prop );
	return prop;
}

// Get calculated value
PROPSTRUCT* CUtilProp::loadDefaultPropValues( PROPSTRUCT* props )
{	
	memcpy(props, s_rgprop, sizeof(s_rgprop));
	for( int i = 0; i < sizeof(s_rgprop)/sizeof(s_rgprop[0]); i++ )
		calcDefaultPropValue( props[ i ] );
	return props;
}

// Code ----------------------------------------------------------------------

// CUtilProp::CUtilProp ----------------------------------------------------------
//
// @mfunc Constructor for this class
//
// @rdesc NONE
//
CUtilProp::CUtilProp( CDataSource* pCDataSource, CUtilProp* pUtilProp )
{
	if( pUtilProp == NULL )
	{
		CLEAR_CONSTRUCT( CUtilProp );
		loadDefaultPropValues( m_rgproperties );
	}
	else
	{
		COPY_CONSTRUCT( CUtilProp, pUtilProp );
	}

	m_pCDataSource = pCDataSource; // parent object
}


// CUtilProp::~CUtilProp ---------------------------------------------------------
//
// @mfunc Destructor for this class
//
// @rdesc NONE
//
CUtilProp:: ~CUtilProp(void)
{
	return;
}


// CUtilProp::GetPropIndex ----------------------------------------------------
//
// @mfunc Returns index of the given property in our global table of properties
//
// @rdesc BOOL
//      @flag TRUE      | found match, copied it to pulIndex out-param
//      @flag FALSE     | no match. In this case, pulIndex has no meaning
//
BOOL CUtilProp::GetPropIndex
    (
		DBPROPID	dwPropertyID,   //@parm IN  | PROPID of desired property
	    ULONG*		pulIndex		//@parm OUT | index of desired property if return was TRUE
    )
{

	ULONG cNumberOfProperties;
    assert( pulIndex );

    for (	cNumberOfProperties = 0; 
			cNumberOfProperties < NUMBER_OF_SUPPORTED_PROPERTIES; 
			cNumberOfProperties++)
    {
        if (dwPropertyID == m_rgproperties[cNumberOfProperties].dwPropertyID )
        {
            // found a match
            *pulIndex = cNumberOfProperties;
			TRACE3( "CUtilProp::GetPropIndex %x => %d", (int)dwPropertyID, (int)*pulIndex );
            return TRUE;
         }
    }

	// found no matches
	TRACE2( "CUtilProp::GetPropIndex %x => not found", (int)dwPropertyID );
    return FALSE;
}



// CUtilProp::LoadDBPROPINFO  ----------------------------------------------------
//
// @mfunc Helper for GetPropertyInfo. Loads field of DBPROPINFO structure.
//
// @rdesc BOOL
//      @flag TRUE          | Method succeeded
//      @flag FALSE         | Method failed (couldn't allocate memory)
//
BOOL CUtilProp::LoadDBPROPINFO
    (
    PROPSTRUCT*		pPropStruct,
    DBPROPINFO*		pPropInfo
    )
{
	// asserts
    assert( pPropStruct );
    assert( pPropInfo );

    // init the variant
    VariantInit( &pPropInfo->vValues );

    // set the easy fields..
    pPropInfo->dwPropertyID	= pPropStruct->dwPropertyID;
    pPropInfo->dwFlags		= pPropStruct->dwFlags;
    pPropInfo->vtType		= pPropStruct->vtType;

	// fill in the description
	if ( pPropInfo->pwszDescription )
		wcscpy(pPropInfo->pwszDescription, pPropStruct->pwstrDescBuffer);

	TRACE3( "CUtilProp::LoadDBPROPINFO (%d) %S", pPropInfo->dwPropertyID, pPropInfo->pwszDescription );

    // all went well
    return TRUE;
}


// CUtilProp::LoadDBPROP  ----------------------------------------------------
//
// @mfunc Helper for GetProperties. Loads field of DBPROP structure.
//
// @rdesc BOOL
//      @flag TRUE          | Method succeeded
//      @flag FALSE         | Method failed (couldn't allocate memory)
//
BOOL CUtilProp::LoadDBPROP
    (
    PROPSTRUCT*	pPropStruct,
    DBPROP*		pPropSupport
    )
{
	TRACE3( "CUtilProp::LoadDBPROP (%d) %S", pPropStruct->dwPropertyID, pPropStruct->pwstrDescBuffer );

	// asserts
    assert( pPropStruct );
    assert( pPropSupport );

    // init the variant
    VariantInit( &pPropSupport->vValue );

    // set the easy fields..
    pPropSupport->dwPropertyID  = pPropStruct->dwPropertyID;
    pPropSupport->colid			= DB_NULLID;
	pPropSupport->dwStatus		= DBPROPSTATUS_OK;

    // set pPropSupport->vValue based on Variant type
    switch (pPropStruct->vtType)
    {
	    case VT_BOOL:
			V_VT( &pPropSupport->vValue ) = VT_BOOL;

			if( pPropStruct->boolVal ) 
				V_BOOL( &pPropSupport->vValue ) = VARIANT_TRUE;
			else
				V_BOOL( &pPropSupport->vValue ) = VARIANT_FALSE;

			break;
        
	    case VT_I2:
		    V_VT( &pPropSupport->vValue ) = VT_I2;
			V_I2( &pPropSupport->vValue ) = (SHORT)pPropStruct->longVal;
			break;

		case VT_I4:
		    V_VT( &pPropSupport->vValue ) = VT_I4;
			V_I4( &pPropSupport->vValue ) = pPropStruct->longVal;
			break;
        
	    case VT_BSTR:
			if( pPropStruct->pwstrVal  )
			{
				V_VT( &pPropSupport->vValue ) = VT_BSTR;
				V_BSTR( &pPropSupport->vValue ) = SysAllocString( pPropStruct->pwstrVal );
			}
			else
				VariantClear( &pPropSupport->vValue );
			break;
        
		default:
			assert( L"LoadDBPROP unknown variant type!\n\r" );
			break;
    }
    // all went well
    return TRUE;
}

// CUtilProp::SetDataSourceName  ----------------------------------------------------
//
// @mfunc Helper for CImpIDBInitialize. Sets datasource name. It is alias for database with its path
//								 Buffer must have no more than MAXDATASOURCE + 1 symbols.
//
// @rdesc BOOL
//      @flag TRUE          | Method succeeded
//      @flag FALSE         | Method failed 
//
BOOL CUtilProp::SetDataSourceName
(
	CHAR*	pszDataSourceName,
	CHAR*   pszDataSourceInfo
)
{
	// Check if arg is valid
	if( pszDataSourceName == NULL )
		return FALSE;
	
	WCHAR wszDataSourceName[ MAXDATASOURCENAME+1 ];
	WCHAR wszDataSourceInfo[ MYSQL_MAXDATASOURCENAME+1 ];

	// Truncate pszDataSourceName to MAXDATASOURCE. May be useful if it is huge path
	pszDataSourceName[ MAXDATASOURCENAME ] = '\0';
	if( pszDataSourceInfo )
		pszDataSourceInfo[ MYSQL_MAXDATASOURCENAME ] = '\0';
	
	// Convert to WCHAR string. 0 if all right.
	if( MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED, pszDataSourceName, -1, 
		wszDataSourceName, MAXDATASOURCENAME ) == 0 )
			return FALSE;
	if( pszDataSourceInfo &&
		MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED, pszDataSourceInfo, -1, 
		wszDataSourceInfo, MYSQL_MAXDATASOURCENAME ) == 0 )
			return FALSE;

	// Set datasource name and current catalog to current name
	ULONG dsn;
	if( GetPropIndex(DBPROP_DATASOURCENAME, &dsn ) )
	{
		// Set data source name to new name
		wcscpy0( m_wszDataSourceName, wszDataSourceName, MAXDATASOURCENAME );
		if( pszDataSourceInfo )
			wcscpy0( m_wszDataSourceName + MAXDATASOURCENAME + 1, wszDataSourceInfo, MYSQL_MAXDATASOURCENAME );
		m_rgproperties[dsn].pwstrVal = m_wszDataSourceName;

		return TRUE;
	}

	return FALSE;
}


//---------------------------------------------------------------------------
// CUtilProp::GetPropertiesArgChk
//
// @mfunc Initialize the buffers and check for E_INVALIDARG cases
//
// NOTE: This routine is used by RowsetInfo and IDBProperties
//
// @rdesc HRESULT indicating the status of the method
//		@flag S_OK | Properties gathered
//		@flag E_INVALIDARG | Invalid parameter values
//
HRESULT CUtilProp::GetPropertiesArgChk
	(
	DWORD				dwBitMask,			//@parm IN  | Mask for object
	const ULONG			cPropertySets,		//@parm IN | Number of property Sets
	const DBPROPIDSET	rgPropertySets[],	//@parm IN | Property Classes and Ids
	ULONG*				pcProperties,		//@parm OUT | Count of structs returned
	DBPROPSET**			prgProperties		//@parm OUT | Array of Properties
	)
{
	TRACE( "CUtilProp::GetPropertiesArgChk" );

	// Initialize values
	if( pcProperties )
		*pcProperties = 0;
	if( prgProperties )
		*prgProperties = NULL;	

	// Check Arguments
	if( ((cPropertySets > 0) && !rgPropertySets) ||
		!pcProperties || !prgProperties )
		return E_INVALIDARG;

	// New argument check for > 1 cPropertyIDs and NULL pointer for 
	// array of property ids.
	for(ULONG ul=0; ul<cPropertySets; ul++)
	{
		if( rgPropertySets[ul].cPropertyIDs && !(rgPropertySets[ul].rgPropertyIDs) )
			return E_INVALIDARG;
	
		// Check for propper formation of DBPROPSET_PROPERTIESINERROR
		//if( (dwBitMask & PROPSET_DSOINFO) &&
		if( !(dwBitMask & PROPSET_SESSION) &&
			(rgPropertySets[ul].guidPropertySet == DBPROPSET_PROPERTIESINERROR) )
		{
			if( (cPropertySets > 1) ||
				(rgPropertySets[ul].cPropertyIDs != 0) ||
				(rgPropertySets[ul].rgPropertyIDs != NULL) )
				return E_INVALIDARG;
		}
	}
	
	return S_OK;
}


// CUtilProp::IsValidValue  -----------------------------------------
// @mfunc Validate that the variant contains legal values for it's particalur
// type and for the particular PROPID in this propset.
//
// @devnote This routine only has to apply to writable properties
//
// @rdesc HRESULT indicating status
//        
HRESULT CUtilProp::IsValidValue
	(
	DBPROP*		pDBProp
	)
{
	TRACE( "CUtilProp::IsValidValue" );

	// Check validity of type

	
	// Check BOOLEAN values
	if( (pDBProp->vValue.vt == VT_BOOL) &&
		!((V_BOOL(&(pDBProp->vValue)) == VARIANT_TRUE) ||
		  (V_BOOL(&(pDBProp->vValue)) == VARIANT_FALSE)) )
		return S_FALSE;

	if( pDBProp->vValue.vt != VT_EMPTY )
	{
		switch( pDBProp->dwPropertyID )
		{
			/*case DBPROP_SWSTTABLEOWNER:
			case DBPROP_INIT_DATASOURCE:
			case DBPROP_AUTH_PASSWORD:
			case DBPROP_AUTH_USERID:
			case DBPROP_INIT_LOCATION:
			case DBPROP_INIT_PROVIDERSTRING:
			case DBPROP_CURRENTCATALOG:
				if( pDBProp->vValue.vt != VT_BSTR )
					return S_FALSE;
				break;				

			case DBPROP_INIT_HWND:
				if( pDBProp->vValue.vt != VT_I4 )
					return S_FALSE;
				break; -- not well...*/
			
			case DBPROP_INIT_PROMPT:
				// These are the only values we support (from spec).
				if ( (pDBProp->vValue.vt == VT_I2) &&
					 !(V_I2(&pDBProp->vValue) == DBPROMPT_PROMPT || 
					   V_I2(&pDBProp->vValue) == DBPROMPT_COMPLETE ||
					   V_I2(&pDBProp->vValue) == DBPROMPT_COMPLETEREQUIRED ||
					   V_I2(&pDBProp->vValue) == DBPROMPT_NOPROMPT))
					return S_FALSE;
				break;
		}
	}
	return S_OK;	// Is valid
}


// CUtilProp::GetPropertyInfo  -----------------------------------------
//
// @mfunc	Returns information about rowset and data source properties 
//			supported by the provider
//
// @rdesc HRESULT
//      @flag S_OK          | The method succeeded
//      @flag E_INVALIDARG  | pcPropertyIDSets or prgPropertyInfo was NULL
//      @flag E_OUTOFMEMORY | Out of memory
//

STDMETHODIMP CUtilProp::GetPropertyInfo
    (
	BOOL				fDSOInitialized,	//@parm IN  | if Initialized
    ULONG				cPropertyIDSets,	//@parm IN  | # properties
    const DBPROPIDSET	rgPropertyIDSets[],	//@parm IN  | Array of property sets
	ULONG*				pcPropertyInfoSets,	//@parm OUT | # DBPROPSET structures
	DBPROPINFOSET**		prgPropertyInfoSets,//@parm OUT | DBPROPSET structures property 
											//			| information returned
	WCHAR**				ppDescBuffer		//@parm OUT	| Property descriptions
    )
{
	TRACE( "CUtilProp::GetPropertyInfo" );

	BOOL			fRet				= TRUE;
	BOOL			fPropsinError		= FALSE;
	BOOL			fPropsSucceed		= FALSE;
	BOOL			fIsSpecialGUID		= FALSE;
	BOOL			fIsNotSpecialGUID	= FALSE;
	BOOL			fShouldAppendBtrieveRowsetPropSet	= FALSE;
    ULONG			cProps				= 0;
	ULONG			cCount				= 0;
    ULONG			ulPropertySets		= 0;
	WCHAR*			pDescBuffer			= NULL;
    DBPROPINFO*		pPropInfo;
    DBPROPINFOSET*	pPropInfoSet;

    // init out params
	if (pcPropertyInfoSets)
		*pcPropertyInfoSets	 = 0;
	if (prgPropertyInfoSets)
		*prgPropertyInfoSets = NULL;
	if (ppDescBuffer)
		*ppDescBuffer = NULL;

	// Check Arguments, on failure post HRESULT to error queue
	if( ((cPropertyIDSets > 0) && !rgPropertyIDSets) ||
		!pcPropertyInfoSets || !prgPropertyInfoSets )
        return E_INVALIDARG;

	// New argument check for > 1 cPropertyIDs and NULL pointer for 
	// array of property ids.
	for(ULONG ul=0; ul<cPropertyIDSets; ul++)
	{
		if( rgPropertyIDSets[ul].cPropertyIDs && !(rgPropertyIDSets[ul].rgPropertyIDs) )
			return E_INVALIDARG;
		
		if (DBPROPSET_ROWSETALL == rgPropertyIDSets[ul].guidPropertySet			 ||
			DBPROPSET_DATASOURCEALL == rgPropertyIDSets[ul].guidPropertySet		 ||
			DBPROPSET_DATASOURCEINFOALL == rgPropertyIDSets[ul].guidPropertySet	 ||
			DBPROPSET_SESSIONALL == rgPropertyIDSets[ul].guidPropertySet		 ||
			DBPROPSET_DBINITALL == rgPropertyIDSets[ul].guidPropertySet			 
			// ||	DBPROPSET_INDEXALL == rgPropertyIDSets[ul].guidPropertySet 
			)
			fIsSpecialGUID = TRUE;
		else
			fIsNotSpecialGUID = TRUE;

		if(fIsSpecialGUID && fIsNotSpecialGUID)
			return E_INVALIDARG;
	}

	// save the count of PropertyIDSets
	cProps = cPropertyIDSets;

	// If the consumer does not restrict the property sets
	// by specify an array of property sets and a cPropertySets
	// greater than 0, then we need to make sure we 
	// have some to return
	if ( (cPropertyIDSets == 0) )
	{
		if( fDSOInitialized )
			cProps = NUMBER_OF_SUPPORTED_PROPERTY_SETS;
		else
			cProps = 1;
	}

    // use task memory allocater to alloc a DBPROPINFOSET struct
	// Note that we may have a need to return BTRIEVE_ROWSET spec prop set if fIsSpecialGUID is TRUE
    pPropInfoSet = (DBPROPINFOSET*) g_pIMalloc->
		Alloc( (cProps + (fIsSpecialGUID ? 1 : 0) )*sizeof( DBPROPINFOSET ));
    if ( !pPropInfoSet )
        return E_OUTOFMEMORY;

    memset( pPropInfoSet, 0, ((cProps + (fIsSpecialGUID ? 1 : 0)) * sizeof( DBPROPINFOSET )));

	// Alloc memory for ppDescBuffer
	if ( ppDescBuffer )
	{
		pDescBuffer = (WCHAR*)g_pIMalloc->Alloc(NUMBER_OF_SUPPORTED_PROPERTIES * 
			CCH_GETPROPERTYINFO_DESCRIP_BUFFER_SIZE * sizeof(WCHAR) );
		
		if( pDescBuffer )
		{
			memset(pDescBuffer, 0, (NUMBER_OF_SUPPORTED_PROPERTIES * 
				CCH_GETPROPERTYINFO_DESCRIP_BUFFER_SIZE * sizeof(WCHAR)));
		
			*ppDescBuffer = pDescBuffer;
		}
		else
		{
			g_pIMalloc->Free( pPropInfoSet );
			return E_OUTOFMEMORY;
		}
	}

	// For each supported Property Set
	for (ulPropertySets=0; ulPropertySets < cProps + (fIsSpecialGUID ? 1 : 0); ulPropertySets++)
	{
		BOOL fGetAllProps = FALSE;

		// No need to append BTRIEVE_ROWSET property
		if( ulPropertySets >= cProps && !fShouldAppendBtrieveRowsetPropSet )
			break;
		else if( ulPropertySets >= cProps )
			goto NoNeedToPrepare;
		
		// If no restrictions return all properties from the three supported property sets
		if( cPropertyIDSets == 0 )
		{
			fGetAllProps = TRUE;

			// only do this once
			if (ulPropertySets == 0)
			{
				pPropInfoSet[0].guidPropertySet = DBPROPSET_DBINIT;
				pPropInfoSet[0].cPropertyInfos  = NUMBER_OF_SUPPORTED_DBINIT_PROPERTIES;

				if ( fDSOInitialized )
				{
					pPropInfoSet[1].guidPropertySet = DBPROPSET_DATASOURCEINFO;
					pPropInfoSet[1].cPropertyInfos  = NUMBER_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES;
					pPropInfoSet[2].guidPropertySet = DBPROPSET_ROWSET;
					pPropInfoSet[2].cPropertyInfos  = NUMBER_OF_SUPPORTED_ROWSET_PROPERTIES;
					pPropInfoSet[3].guidPropertySet = DBPROPSET_DATASOURCE;
					pPropInfoSet[3].cPropertyInfos  = NUMBER_OF_SUPPORTED_DATASOURCE_PROPERTIES;
					pPropInfoSet[4].guidPropertySet = DBPROPSET_SESSION;
					pPropInfoSet[4].cPropertyInfos  = NUMBER_OF_SUPPORTED_SESSION_PROPERTIES;
					pPropInfoSet[5].guidPropertySet = DBPROPSET_BTRIEVE_ROWSET;
					pPropInfoSet[5].cPropertyInfos  = NUMBER_OF_SUPPORTED_BTRIEVE_ROWSET_PROPERTIES;
					pPropInfoSet[6].guidPropertySet = DBPROPSET_INDEX;
					pPropInfoSet[6].cPropertyInfos  = NUMBER_OF_SUPPORTED_INDEX_PROPERTIES;
				}
			}
		}
		else
		{
			pPropInfoSet[ulPropertySets].guidPropertySet = rgPropertyIDSets[ulPropertySets].guidPropertySet;
			pPropInfoSet[ulPropertySets].cPropertyInfos  = rgPropertyIDSets[ulPropertySets].cPropertyIDs;

			if ((rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DBINITALL) ||
				(rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DBINIT	  &&
				 rgPropertyIDSets[ulPropertySets].cPropertyIDs == 0))
			{
				fGetAllProps = TRUE;
				pPropInfoSet[ulPropertySets].guidPropertySet = DBPROPSET_DBINIT;
				pPropInfoSet[ulPropertySets].cPropertyInfos  = NUMBER_OF_SUPPORTED_DBINIT_PROPERTIES;
			}
			else if( fDSOInitialized )
			{
				if( (rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCEINFOALL) ||
					((rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCEINFO)	&&
					 (rgPropertyIDSets[ulPropertySets].cPropertyIDs == 0)) )
				{
					fGetAllProps = TRUE;
					pPropInfoSet[ulPropertySets].guidPropertySet = DBPROPSET_DATASOURCEINFO;
					pPropInfoSet[ulPropertySets].cPropertyInfos  = NUMBER_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES;
				}
				else if ( (rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCEALL) ||
					 ((rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCE) &&
					 (rgPropertyIDSets[ulPropertySets].cPropertyIDs == 0)) )
				{
					fGetAllProps = TRUE;
					pPropInfoSet[ulPropertySets].guidPropertySet = DBPROPSET_DATASOURCE;
					pPropInfoSet[ulPropertySets].cPropertyInfos  = NUMBER_OF_SUPPORTED_DATASOURCE_PROPERTIES;
				}
				else if ( (rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_SESSIONALL) ||
					 ((rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_SESSION) &&
					 (rgPropertyIDSets[ulPropertySets].cPropertyIDs == 0)) )
				{
					fGetAllProps = TRUE;
					pPropInfoSet[ulPropertySets].guidPropertySet = DBPROPSET_SESSION;
					pPropInfoSet[ulPropertySets].cPropertyInfos  = NUMBER_OF_SUPPORTED_SESSION_PROPERTIES;
				}
				else if ( //(rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_INDEXALL) ||
					 ((rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_INDEX) &&
					 (rgPropertyIDSets[ulPropertySets].cPropertyIDs == 0)) )
				{
					fGetAllProps = TRUE;
					pPropInfoSet[ulPropertySets].guidPropertySet = DBPROPSET_INDEX;
					pPropInfoSet[ulPropertySets].cPropertyInfos  = NUMBER_OF_SUPPORTED_INDEX_PROPERTIES;
				}
				else if( (rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_ROWSET) &&
						  (rgPropertyIDSets[ulPropertySets].cPropertyIDs == 0))
				{
					fGetAllProps = TRUE;
					pPropInfoSet[ulPropertySets].guidPropertySet = DBPROPSET_ROWSET;
					pPropInfoSet[ulPropertySets].cPropertyInfos  = NUMBER_OF_SUPPORTED_ROWSET_PROPERTIES;
				}
				else if( rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_ROWSETALL) 
				{
					fGetAllProps = TRUE;
					pPropInfoSet[ulPropertySets].guidPropertySet = DBPROPSET_ROWSET;
					pPropInfoSet[ulPropertySets].cPropertyInfos  = NUMBER_OF_SUPPORTED_ROWSET_PROPERTIES;
					
					// Surgery! We should append spec prop set,too.
					pPropInfoSet[cProps].guidPropertySet = DBPROPSET_BTRIEVE_ROWSET;
					pPropInfoSet[cProps].cPropertyInfos  = NUMBER_OF_SUPPORTED_BTRIEVE_ROWSET_PROPERTIES;
					fShouldAppendBtrieveRowsetPropSet = TRUE;
				}
				else if (rgPropertyIDSets[ulPropertySets].cPropertyIDs == 0)
					fPropsinError = TRUE;
			}
			else if (rgPropertyIDSets[ulPropertySets].cPropertyIDs == 0)
			{
				// Since we do not support it should return a error with 0 & NULL
				fPropsinError = TRUE;
			}
		}
		
NoNeedToPrepare:
		if (pPropInfoSet[ulPropertySets].cPropertyInfos)
		{
		    // use task memory allocater to alloc array of DBPROPINFO structs
			pPropInfo = (DBPROPINFO*) g_pIMalloc->Alloc(sizeof( DBPROPINFO ) *
									pPropInfoSet[ulPropertySets].cPropertyInfos);

			if (!pPropInfo)
			{
				if ( ppDescBuffer ) 
					*ppDescBuffer = NULL;
				g_pIMalloc->Free( pPropInfoSet );
				g_pIMalloc->Free( pDescBuffer );
				
				return E_OUTOFMEMORY;
			}
		
			pPropInfoSet[ulPropertySets].rgPropertyInfos = &pPropInfo[0];

			memset( pPropInfo, 0, 
				(pPropInfoSet[ulPropertySets].cPropertyInfos * sizeof( DBPROPINFO )));
		}

	    // for each prop in our table..
		for (cCount=0; cCount < pPropInfoSet[ulPropertySets].cPropertyInfos; cCount++)
		{
			// init the Variant right up front
			// that way we can VariantClear with no worried (if we need to)
			VariantInit( &pPropInfo[cCount].vValues );

			// set the description pointer
			pPropInfo[cCount].pwszDescription = pDescBuffer;

			// Check supported property sets
			if ( (pPropInfoSet[ulPropertySets].guidPropertySet == DBPROPSET_DBINIT) && 
				 (fGetAllProps) )
			{
				// load up their DBPROPINFO from our table
				fPropsSucceed = TRUE;
				fRet = LoadDBPROPINFO( &m_rgproperties[START_OF_SUPPORTED_DBINIT_PROPERTIES + cCount], 
							&pPropInfo[cCount] );
			}
			else if ( (pPropInfoSet[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCEINFO) && 
				  fGetAllProps && fDSOInitialized)
			{
				// load up their DBPROPINFO from our table
				fPropsSucceed = TRUE;
				fRet = LoadDBPROPINFO( &m_rgproperties[START_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES + cCount], 
							&pPropInfo[cCount] );
			}

			else if ( (pPropInfoSet[ulPropertySets].guidPropertySet == DBPROPSET_ROWSET) &&
					  fGetAllProps && fDSOInitialized)
			{
				// load up their DBPROPINFO from our table
				fPropsSucceed = TRUE;
				fRet = LoadDBPROPINFO( &m_rgproperties[START_OF_SUPPORTED_ROWSET_PROPERTIES + cCount], 
							&pPropInfo[cCount] );
			}

			else if ( pPropInfoSet[ulPropertySets].guidPropertySet == DBPROPSET_BTRIEVE_ROWSET ) 
			{
				// Please note that we cannot be here if database is not initialized.
				// No matters what value has fGetAllProps
				
				// load up their DBPROPINFO from our table
				fPropsSucceed = TRUE;
				fRet = LoadDBPROPINFO( &m_rgproperties[START_OF_SUPPORTED_BTRIEVE_ROWSET_PROPERTIES + cCount], 
							&pPropInfo[cCount] );
			}

			else if ( (pPropInfoSet[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCE) &&
					  fGetAllProps && fDSOInitialized)
			{
				// load up their DBPROPINFO from our table
				fPropsSucceed = TRUE;
				fRet = LoadDBPROPINFO( &m_rgproperties[START_OF_SUPPORTED_DATASOURCE_PROPERTIES + cCount], 
							&pPropInfo[cCount] );
			}

			else if ( (pPropInfoSet[ulPropertySets].guidPropertySet == DBPROPSET_SESSION) &&
					  fGetAllProps && fDSOInitialized)
			{
				// load up their DBPROPINFO from our table
				fPropsSucceed = TRUE;
				fRet = LoadDBPROPINFO( &m_rgproperties[START_OF_SUPPORTED_SESSION_PROPERTIES + cCount], 
							&pPropInfo[cCount] );
			}

			else if ( (pPropInfoSet[ulPropertySets].guidPropertySet == DBPROPSET_INDEX) &&
					  fGetAllProps && fDSOInitialized)
			{
				// load up their DBPROPINFO from our table
				fPropsSucceed = TRUE;
				fRet = LoadDBPROPINFO( &m_rgproperties[START_OF_SUPPORTED_INDEX_PROPERTIES + cCount], 
							&pPropInfo[cCount] );
			}

			else
			{
				ULONG ulIndex;

				pPropInfo[cCount].dwPropertyID	= rgPropertyIDSets[ulPropertySets].rgPropertyIDs[cCount];
				pPropInfo[cCount].dwFlags		= DBPROPFLAGS_NOTSUPPORTED;

				if ( (GetPropIndex(rgPropertyIDSets[ulPropertySets].rgPropertyIDs[cCount], &ulIndex)) &&
					 (fDSOInitialized || (pPropInfoSet[ulPropertySets].guidPropertySet == DBPROPSET_DBINIT)) )
				{
					fPropsSucceed = TRUE;
					fRet = LoadDBPROPINFO( &m_rgproperties[ulIndex], &pPropInfo[cCount] );
				}
				else
				{
					TRACE3( "!!! Init: %d, INITPROPSET: %d", fDSOInitialized, (pPropInfoSet[ulPropertySets].guidPropertySet == DBPROPSET_DBINIT ) );
					fPropsinError = TRUE;
					pPropInfo[cCount].pwszDescription = NULL;
				}
			}

			if (!fRet)
			{
				ULONG ulFor;

				// something went wrong
				// clear all variants used so far..
				for (ulFor = 0; ulFor < cCount; ulFor++)
					VariantClear( &pPropInfo[ulFor].vValues );

				// .. delete the pPropInfo array, return failure
				if ( ppDescBuffer ) *ppDescBuffer = NULL;
				g_pIMalloc->Free( pPropInfo );
				g_pIMalloc->Free( pPropInfoSet );
				g_pIMalloc->Free( pDescBuffer );
				return E_FAIL;
			}

			// move the description pointer to the next
			if ( pPropInfo[cCount].pwszDescription )
				pDescBuffer += (wcslen(pPropInfo[cCount].pwszDescription) + sizeof(CHAR));
		}
		// Set local back to FALSE
		fGetAllProps = FALSE;
	}

    // we have append spec prop set
	if( fShouldAppendBtrieveRowsetPropSet )
		cProps++;
	// set count of properties and property information
	*pcPropertyInfoSets	 = cProps;
    *prgPropertyInfoSets = pPropInfoSet;

	if (!fPropsSucceed && fPropsinError)
	{
		if ( ppDescBuffer ) *ppDescBuffer = NULL;
		g_pIMalloc->Free( pDescBuffer );
		TRACE( "<<< GetPropertyInfo DB_E_ERRORSOCCURRED" );
		return DB_E_ERRORSOCCURRED;
	}

	if (fPropsSucceed && fPropsinError)
	{
		TRACE( "<<< GetPropertyInfo DB_S_ERRORSOCCURRED" );
		return DB_S_ERRORSOCCURRED;
	}

	TRACE( "<<< GetPropertyInfo S_OK" );
	return S_OK;
}

// CUtilProp::GetProperties ----------------------------------------------------
//
// @mfunc Returns current settings of all properties supported by the DSO/rowset
//
// @rdesc HRESULT
//      @flag S_OK          | The method succeeded
//      @flag E_INVALIDARG  | pcProperties or prgPropertyInfo was NULL
//      @flag E_OUTOFMEMORY | Out of memory
//
STDMETHODIMP CUtilProp::GetProperties
    (
		DWORD				dwBitMask,			//@parm IN  | Mask if Initialized
		ULONG				cPropertyIDSets,	//@parm IN  | # of restiction property IDs
		const DBPROPIDSET	rgPropertyIDSets[],	//@parm IN  | restriction guids
		ULONG*              pcPropertySets,		//@parm OUT | count of properties returned
		DBPROPSET**			prgPropertySets		//@parm OUT | property information returned
    )
{
	TRACE2( "CUtilProp::GetProperties with bit mask %d", (int)dwBitMask );

	BOOL			fRet		  = TRUE;
	BOOL			fProblems = FALSE; // there are problems
	BOOL			fSuccesses = FALSE; // there are successes
	BOOL			fPropInErrSet = FALSE; // there is PROPERTIESINERROR prop. set
    ULONG			cProps		  = 0;
	ULONG			cCount		  = 0;
    ULONG			ulPropertySets= 0;
    DBPROP*			pProp;
    DBPROPSET*		pPropSet;

	// save the count of PropertyIDSets
	cProps = cPropertyIDSets;

	// If the consumer does not restrict the property sets
	// by specify an array of property sets and a cPropertySets
	// greater than 0, then we need to make sure we 
	// have some to return
	if( cPropertyIDSets == 0 )
	{
		// Count number of bits==1
		for( DWORD one = 1; one != 0; one <<= 1 )
			if( dwBitMask & one )
			   cProps++;
	}

    // use task memory allocater to alloc a DBPROPSET struct
    pPropSet = (DBPROPSET*) g_pIMalloc->Alloc(cProps *
											  sizeof( DBPROPSET ));
    if ( !pPropSet )
        return E_OUTOFMEMORY;

    memset( pPropSet, 0, (cProps * sizeof( DBPROPSET )));

	// Below -- well
	// Set up array
	if( cPropertyIDSets == 0 )
	{
		int nPropSet = 0;
		for( DWORD one = 1; one != 0; one <<= 1 )
		{
			switch( dwBitMask & one )
			{
			case PROPSET_INIT:
				pPropSet[nPropSet].guidPropertySet = DBPROPSET_DBINIT;
				pPropSet[nPropSet].cProperties  = NUMBER_OF_SUPPORTED_DBINIT_PROPERTIES;
				nPropSet++;
				continue;
			case PROPSET_DSOINFO:
				pPropSet[nPropSet].guidPropertySet = DBPROPSET_DATASOURCEINFO;
				pPropSet[nPropSet].cProperties  = NUMBER_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES;
				nPropSet++;
				continue;
			case PROPSET_DATASOURCE:
				pPropSet[nPropSet].guidPropertySet = DBPROPSET_DATASOURCE;
				pPropSet[nPropSet].cProperties  = NUMBER_OF_SUPPORTED_DATASOURCE_PROPERTIES;
				nPropSet++;
				continue;
			case PROPSET_SESSION:
				pPropSet[nPropSet].guidPropertySet = DBPROPSET_SESSION;
				pPropSet[nPropSet].cProperties  = NUMBER_OF_SUPPORTED_SESSION_PROPERTIES;
				nPropSet++;
				continue;
			case PROPSET_INDEX:
				pPropSet[nPropSet].guidPropertySet = DBPROPSET_INDEX;
				pPropSet[nPropSet].cProperties  = NUMBER_OF_SUPPORTED_INDEX_PROPERTIES;
				nPropSet++;
				continue;
			case PROPSET_ROWSET:
				pPropSet[nPropSet].guidPropertySet = DBPROPSET_ROWSET;
				pPropSet[nPropSet].cProperties  = NUMBER_OF_SUPPORTED_ROWSET_PROPERTIES;
				nPropSet++;
				continue;
			// there is default branch! -- if dwBitMask & one == 0
			default:;
			}
		}
	}

	// For each supported Property Set
	for (ulPropertySets=0; ulPropertySets < cProps; ulPropertySets++)
	{
		BOOL fGetAllProps = TRUE; // -- well
		/*BOOL fGetAllProps = FALSE;

		// If no restrictions return all properties from the 5 supported property sets
		if ( cPropertyIDSets == 0 )
		{
				fGetAllProps = TRUE;
				
				// only do this once
				if ( ulPropertySets == 0 )
				{
					if( !(dwBitMask & PROPSET_SESSION) )
					{						
						if ( !(dwBitMask & PROPSET_ROWSET) )
						{
								pPropSet[0].guidPropertySet = DBPROPSET_DBINIT;
								pPropSet[0].cProperties  = NUMBER_OF_SUPPORTED_DBINIT_PROPERTIES;

							if( dwBitMask & PROPSET_INIT )
							{
								pPropSet[1].guidPropertySet = DBPROPSET_DATASOURCEINFO;
								pPropSet[1].cProperties  = NUMBER_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES;
							}
						}
						else
						{
							pPropSet[0].guidPropertySet = DBPROPSET_ROWSET;
							pPropSet[0].cProperties  = NUMBER_OF_SUPPORTED_ROWSET_PROPERTIES;
						}
					}
				}
		}
		else  -- not well... I've placed it out of cycle */
		if( cPropertyIDSets )  // -- well
		{
			if( rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_PROPERTIESINERROR )
				fPropInErrSet = TRUE;

			fGetAllProps = FALSE;  // -- well

			pPropSet[ulPropertySets].guidPropertySet = rgPropertyIDSets[ulPropertySets].guidPropertySet;
			pPropSet[ulPropertySets].cProperties  = rgPropertyIDSets[ulPropertySets].cPropertyIDs;

			if( rgPropertyIDSets[ulPropertySets].cPropertyIDs == 0 )
			{
				fGetAllProps = TRUE;

				if( rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DBINIT )
				{
					pPropSet[ulPropertySets].cProperties  = NUMBER_OF_SUPPORTED_DBINIT_PROPERTIES;
				}
				else if( (rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCEINFO) &&
						 (dwBitMask & PROPSET_DSOINFO) )
				{
					pPropSet[ulPropertySets].cProperties  = NUMBER_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES;
				}
				else if( (rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCE) &&
						 (dwBitMask & PROPSET_DATASOURCE))
				{
					pPropSet[ulPropertySets].cProperties  = NUMBER_OF_SUPPORTED_DATASOURCE_PROPERTIES;
				}
				else if( (rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_SESSION) &&
						 (dwBitMask & PROPSET_SESSION))
				{
					pPropSet[ulPropertySets].cProperties  = NUMBER_OF_SUPPORTED_SESSION_PROPERTIES;
				}
				else if( (rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_INDEX) &&
						 (dwBitMask & PROPSET_INDEX))
				{
					pPropSet[ulPropertySets].cProperties  = NUMBER_OF_SUPPORTED_INDEX_PROPERTIES;
				}
				else if( (rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_ROWSET) &&
						 (dwBitMask & PROPSET_ROWSET))
				{
					pPropSet[ulPropertySets].cProperties  = NUMBER_OF_SUPPORTED_ROWSET_PROPERTIES;
				}
				else
				{
					fGetAllProps = FALSE;
				}
			}
		}
		
		if( pPropSet[ulPropertySets].cProperties )
		{
		    // use task memory allocater to alloc array of DBPROP structs
			pProp = (DBPROP*) g_pIMalloc->Alloc(sizeof( DBPROP ) *
										 pPropSet[ulPropertySets].cProperties);

			if (!pProp)
			{
				for(ULONG ul=0; ul<ulPropertySets; ul++)
				{
					for(ULONG ul2=0; ul2<pPropSet[ul].cProperties; ul2++)
						VariantClear( &pPropSet[ul].rgProperties[ul2].vValue );

					g_pIMalloc->Free( pPropSet[ul].rgProperties );
				}
				g_pIMalloc->Free( pPropSet );

				return E_OUTOFMEMORY;
			}
		
			pPropSet[ulPropertySets].rgProperties = &pProp[0];

			memset( pProp, 0, (pPropSet[ulPropertySets].cProperties * sizeof( DBPROP )));
		}

	    // for each prop in our table..
		for (cCount=0; cCount < pPropSet[ulPropertySets].cProperties; cCount++)
		{
			// init the Variant right up front
			// that way we can VariantClear with no worried (if we need to)
			VariantInit( &pProp[cCount].vValue );

			// Check supported property sets
			if ( pPropSet[ulPropertySets].guidPropertySet == DBPROPSET_DBINIT &&
				 fGetAllProps )
			{
				fSuccesses = TRUE;
				// load up their DBPROP from our table
				fRet = LoadDBPROP( &m_rgproperties[START_OF_SUPPORTED_DBINIT_PROPERTIES + cCount], 
							&pProp[cCount] );
			}
			else if ( pPropSet[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCEINFO &&
					  fGetAllProps )
			{
				fSuccesses = TRUE;
				// load up their DBPROPINFO from our table
				fRet = LoadDBPROP( &m_rgproperties[START_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES + cCount], 
							&pProp[cCount] );
			}
			else if ( pPropSet[ulPropertySets].guidPropertySet == DBPROPSET_ROWSET &&
					  fGetAllProps )
			{
				fSuccesses = TRUE;
				// load up their DBPROPINFO from our table
				fRet = LoadDBPROP( &m_rgproperties[START_OF_SUPPORTED_ROWSET_PROPERTIES + cCount], 
							&pProp[cCount] );
			}
			else if ( pPropSet[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCE &&
					  fGetAllProps )
			{
				fSuccesses = TRUE;
				// load up their DBPROPINFO from our table
				fRet = LoadDBPROP( &m_rgproperties[START_OF_SUPPORTED_DATASOURCE_PROPERTIES + cCount], 
							&pProp[cCount] );
			}
			else if ( pPropSet[ulPropertySets].guidPropertySet == DBPROPSET_SESSION &&
					  fGetAllProps )
			{
				fSuccesses = TRUE;
				// load up their DBPROPINFO from our table
				fRet = LoadDBPROP( &m_rgproperties[START_OF_SUPPORTED_SESSION_PROPERTIES + cCount], 
							&pProp[cCount] );
			}
			else if ( pPropSet[ulPropertySets].guidPropertySet == DBPROPSET_INDEX &&
					  fGetAllProps )
			{
				fSuccesses = TRUE;
				// load up their DBPROPINFO from our table
				fRet = LoadDBPROP( &m_rgproperties[START_OF_SUPPORTED_INDEX_PROPERTIES + cCount], 
							&pProp[cCount] );
			}
			else
			{
				ULONG ulIndex;

				pProp[cCount].dwPropertyID	= rgPropertyIDSets[ulPropertySets].rgPropertyIDs[cCount];
				pProp[cCount].dwStatus		= DBPROPSTATUS_NOTSUPPORTED;

				if( !GetPropIndex(rgPropertyIDSets[ulPropertySets].rgPropertyIDs[cCount], &ulIndex) )
					fProblems = TRUE;
				else   if ( (dwBitMask & PROPSET_INIT) && rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DBINIT )
				{
					fSuccesses = TRUE;
					fRet = LoadDBPROP( &m_rgproperties[ulIndex], &pProp[cCount] );
				}
				else   if ( (dwBitMask & PROPSET_SESSION) && rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_SESSION )
				{
					fSuccesses = TRUE;
					fRet = LoadDBPROP( &m_rgproperties[ulIndex], &pProp[cCount] );
				}
				else   if ( (dwBitMask & PROPSET_INDEX) && rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_INDEX )
				{
					fSuccesses = TRUE;
					fRet = LoadDBPROP( &m_rgproperties[ulIndex], &pProp[cCount] );
				}
				else   if ( (dwBitMask & PROPSET_ROWSET) && rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_ROWSET )
				{
					fSuccesses = TRUE;
					fRet = LoadDBPROP( &m_rgproperties[ulIndex], &pProp[cCount] );
				}
				else   if ( (dwBitMask & PROPSET_DATASOURCE) && rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCE )
				{
					fSuccesses = TRUE;
					fRet = LoadDBPROP( &m_rgproperties[ulIndex], &pProp[cCount] );
				}
				else   if ( (dwBitMask & PROPSET_DSOINFO) && rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCEINFO )
				{
					fSuccesses = TRUE;
					fRet = LoadDBPROP( &m_rgproperties[ulIndex], &pProp[cCount] );
				}
				else
				{
					fProblems = TRUE;
				}

			}

			if (!fRet)
			{
				ULONG ulFor;

				// something went wrong
				// clear all variants used so far..
				for (ulFor = 0; ulFor < cCount; ulFor++)
					VariantClear( &pProp[ulFor].vValue );

				// .. delete the pPropInfo array, return failure
				g_pIMalloc->Free( pProp );
				g_pIMalloc->Free( pPropSet );
				return E_FAIL;
			}
		}
		// Set local back to FALSE
		fGetAllProps = FALSE;
	}

	// set count of properties and property information
    *pcPropertySets	 = cProps;
    *prgPropertySets = pPropSet;

	// No successes and either problems or some info is required
	if ( !fSuccesses && (cPropertyIDSets || fProblems ) )
	{
		TRACE( "<<< GetProperties DB_E_ERRORSOCCURRED" );
		return DB_E_ERRORSOCCURRED;
	}

	// Problems and successes, too
	if (fSuccesses && fProblems)
	{
		TRACE( "<<< GetProperties DB_S_ERRORSOCCURRED" );
		return DB_S_ERRORSOCCURRED;
	}

	// We do not support PROPERTIESINERROR prop. set yet!
	if( fPropInErrSet )
	{
		TRACE( "<<< GetProperties INERROR" );
		return fSuccesses ? DB_S_ERRORSOCCURRED : DB_E_ERRORSOCCURRED;
	}

	// Full success or no information is required
	TRACE( "<<< GetProperties S_OK" );
	return S_OK;
}


// CUtilProp::SetPropertiesArgChk -------------------------------------------
//
// @mfunc Initialize the buffers and check for E_INVALIDARG cases
//
// @rdesc HRESULT indicating the status of the method
//		@flag S_OK | Properties gathered
//		@flag E_INVALIDARG | Invalid parameter values
//
HRESULT CUtilProp::SetPropertiesArgChk
	(
	const ULONG				cPropertySets,		//@parm IN | Count of structs returned
	const DBPROPSET			rgPropertySets[]	//@parm IN | Array of Properties Sets
	)
{
	TRACE( "CUtilProp::SetPropertiesArgChk" );

	// Argument Checking
	if( cPropertySets > 0 && !rgPropertySets )
		return E_INVALIDARG;

	// New argument check for > 1 cPropertyIDs and NULL pointer for 
	// array of property ids.
	for(ULONG ul=0; ul<cPropertySets; ul++)
	{
		if( rgPropertySets[ul].cProperties && !(rgPropertySets[ul].rgProperties) )
			return E_INVALIDARG;
	}
	
	return S_OK;
}


// CUtilProp::SetProperties ----------------------------------------------------
//
// @mfunc Set current settings of properties supported by the DSO/rowset
//
// @rdesc HRESULT
//      @flag S_OK          | The method succeeded
//      @flag E_INVALIDARG  | pcProperties or prgPropertyInfo was NULL
//      @flag E_OUTOFMEMORY | Out of memory
//
STDMETHODIMP CUtilProp::SetProperties
    (
		DWORD				dwBitMask,			//@parm IN		Type of PropSet
		ULONG				cPropertyIDSets,	//@parm IN		# of DBPROPSET
		DBPROPSET			rgPropertyIDSets[]	//@parm INOUT	Array of property sets
	)
{
	TRACE( "CUtilProp::SetProperties" );

	ULONG ulPropertySets  = 0;
	ULONG cCount		  = 0;
	BOOL  fSetAllProps	  = TRUE;
	BOOL  fOnePropSet	  = FALSE;
	
	BOOL  blnVTBOOL = FALSE, blnVTI4 = FALSE, blnVTBSTR = FALSE;

	// For each supported Property Set
	for (ulPropertySets=0; ulPropertySets < cPropertyIDSets; ulPropertySets++)
	{
		ULONG ulIndex = 0;

	    // for each prop in the propset
		for (cCount=0; cCount < rgPropertyIDSets[ulPropertySets].cProperties; cCount++)
		{
			rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_OK;
			
			// only allow the DBINIT and DATASOURCEINFO with DATASOURCE
			if ( (dwBitMask & (PROPSET_DSOINFO|PROPSET_DATASOURCE)) &&
				 ((rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DBINIT) && 
				  (dwBitMask & PROPSET_INIT)) )
			{
				 rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_NOTSETTABLE;
				 fSetAllProps = FALSE;
			}
			else if ( ((dwBitMask & (PROPSET_DSOINFO|PROPSET_DATASOURCE)) &&
					   (rgPropertyIDSets[ulPropertySets].guidPropertySet != DBPROPSET_DATASOURCE &&
					    rgPropertyIDSets[ulPropertySets].guidPropertySet != DBPROPSET_DATASOURCEINFO &&
					    rgPropertyIDSets[ulPropertySets].guidPropertySet != DBPROPSET_DBINIT))   ||
					  ((rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCE ||
					    rgPropertyIDSets[ulPropertySets].guidPropertySet == DBPROPSET_DATASOURCEINFO) && 
					   !(dwBitMask & PROPSET_INIT)) )
			{
				 rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_NOTSUPPORTED;
				 fSetAllProps = FALSE;
			}
			// only allow the SESSION
			else if ( (dwBitMask & PROPSET_SESSION) &&
					  (rgPropertyIDSets[ulPropertySets].guidPropertySet != DBPROPSET_SESSION) )
			{
				 rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_NOTSUPPORTED;
				 fSetAllProps = FALSE;
			}
			// only allow the INDEX
			else if ( (dwBitMask & PROPSET_INDEX) &&
					  (rgPropertyIDSets[ulPropertySets].guidPropertySet != DBPROPSET_INDEX) )
			{
				 rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_NOTSUPPORTED;
				 fSetAllProps = FALSE;
			}
			// only allow the ROWSET
			else if ( (dwBitMask & PROPSET_ROWSET) &&
					  (rgPropertyIDSets[ulPropertySets].guidPropertySet != DBPROPSET_ROWSET) &&
					  (rgPropertyIDSets[ulPropertySets].guidPropertySet != DBPROPSET_BTRIEVE_ROWSET ) )
			{
				 rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_NOTSUPPORTED;
				 fSetAllProps = FALSE;
			}
			else
			{
				// get the index in the array
				if ( GetPropIndex(rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwPropertyID, &ulIndex) )
				{
					// arg checking for the prop
					if (DBPROPOPTIONS_SETIFCHEAP != rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwOptions &&
						DBPROPOPTIONS_REQUIRED   != rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwOptions)
					{
						rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_BADOPTION;
		 				fSetAllProps = FALSE;
					}
					else if ( ((m_rgproperties[ulIndex].vtType != rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue.vt) &&
							   (VT_EMPTY != rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue.vt)) ||
							  (IsValidValue(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount]) == S_FALSE)) 
					{
						rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_BADVALUE;
		 				fSetAllProps = FALSE;
					}
					else if ( !(m_rgproperties[ulIndex].dwFlags & DBPROPFLAGS_WRITE) )
					{
						////////////////////////////////////////////
						//Check if new value is the same as old one.
						//If so let's it would be like value is set successfully, otherwise return failure
						blnVTBOOL = ((rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue.vt == VT_BOOL) && 
							((rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue.boolVal == VARIANT_TRUE) != m_rgproperties[ulIndex].boolVal));
						blnVTI4   = ((rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue.vt == VT_I4) && 
							(rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue.lVal != m_rgproperties[ulIndex].longVal));
						blnVTBSTR = ((rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue.vt == VT_BSTR) && 
							(wcscmp(rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue.bstrVal,m_rgproperties[ulIndex].pwstrVal)));
						
						if (blnVTBOOL || blnVTI4 || blnVTBSTR)
						{
							rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_NOTSETTABLE;
							fSetAllProps = FALSE;
						}
						else
							fOnePropSet = TRUE;
						////////////////////////////////////////////
					}
					else
					{
						fOnePropSet = TRUE;
							
						ULONG i;
						
						switch (rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue.vt)
						{
						case VT_EMPTY:
							getDefaultPropValue(ulIndex, m_rgproperties[ulIndex]);
							break;
							
						case VT_BSTR:
							// switch on the propid
							switch (m_rgproperties[ulIndex].dwPropertyID)
							{
							case DBPROP_INIT_DATASOURCE:
								wcscpy0(m_wszFilePath, V_BSTR(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue), MAXSTR(m_wszFilePath) );
								m_rgproperties[ulIndex].pwstrVal = m_wszFilePath;
								break;

							case DBPROP_CURRENTCATALOG:
								wcscpy0(m_wszCurrentCatalog, V_BSTR(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue), MAXSTR(m_wszCurrentCatalog));
								m_rgproperties[ulIndex].pwstrVal = m_wszCurrentCatalog;
								
								// Catalogs: Load on call. No actions now if it fails.
								if( m_pCDataSource )
									m_pCDataSource->CheckAndTrackOneDatabase( m_wszCurrentCatalog, getOwnersPart(m_wszProviderString) );
								break;

							case DBPROP_INIT_PROVIDERSTRING:
								wcscpy0(m_wszProviderString, V_BSTR(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue), MAXSTR(m_wszProviderString));
								m_rgproperties[ulIndex].pwstrVal = m_wszProviderString;
								break;

							case DBPROP_INIT_LOCATION:
								wcscpy0(m_wszServer, V_BSTR(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue), MAXSTR(m_wszServer));
								m_rgproperties[ulIndex].pwstrVal = m_wszServer;

								// Set ServerName to current name
								if( GetPropIndex(DBPROP_SERVERNAME, &i ) )
									   m_rgproperties[i].pwstrVal = m_wszServer;
								break;

							case DBPROP_AUTH_PASSWORD:
								wcscpy0(m_wszPassword, V_BSTR(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue), MAXSTR(m_wszPassword));
								m_rgproperties[ulIndex].pwstrVal = m_wszPassword;
								break;

							case DBPROP_AUTH_USERID:
								wcscpy0(m_wszUserID, V_BSTR(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue), MAXSTR(m_wszUserID));
								m_rgproperties[ulIndex].pwstrVal = m_wszUserID;
/*
								// Set UserName to current name
								if( GetPropIndex(DBPROP_USERNAME, &i ) )
									   m_rgproperties[i].pwstrVal = m_wszUserID;*/
								break;

							case DBPROP_AUTH_INTEGRATED:
								wcscpy0(m_wszAuthService, V_BSTR(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue), MAXSTR(m_wszAuthService));
								m_rgproperties[ulIndex].pwstrVal = m_wszAuthService;
								break;

							case DBPROP_SWSTTABLEOWNER:
								wcscpy0(m_wszSwstTableOwner, V_BSTR(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue), MAXSTR(m_wszSwstTableOwner));
								m_rgproperties[ulIndex].pwstrVal = m_wszSwstTableOwner;
								break;

							default:
								TRACE("Invalid propid while set BSTR property");
							}
							break;

						case VT_I4:
						case VT_I2:
							m_rgproperties[ulIndex].longVal = V_I4(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue);
							break;

						case VT_BOOL:
							m_rgproperties[ulIndex].boolVal = V_BOOL(&rgPropertyIDSets[ulPropertySets].rgProperties[cCount].vValue);
							break;

						default:
							TRACE("Invalid type while set property");
						}
					}
				}
				else
				{
					rgPropertyIDSets[ulPropertySets].rgProperties[cCount].dwStatus = DBPROPSTATUS_NOTSUPPORTED;
					fSetAllProps = FALSE;
				}
			}
		}
	}

	// Figure out the retcode
	if (fSetAllProps)
		return S_OK;

	if (fOnePropSet && !fSetAllProps)
		return DB_S_ERRORSOCCURRED;
	
	return DB_E_ERRORSOCCURRED;
}


// Get NULL symbol for CHARACTER fields
char CUtilProp::GetNullCharSymbol()
{
	ULONG ulProvString;
	
	// Try to get some information from provider string
	if( GetPropIndex(DBPROP_INIT_PROVIDERSTRING, &ulProvString ) )
	{
		WCHAR* lpwszNullValue = wcsstr( m_rgproperties[ulProvString].pwstrVal, L"NULLCHARSYMBOL=" );
		if( lpwszNullValue != NULL )
			return _wtoi( lpwszNullValue + wcslen(L"NULLCHARSYMBOL=") );
	}
	
	return ' ';
}


// Treat string data (STRING, LSTRING, ZSTRING) as coded in OEM
bool CUtilProp::OEM2ANSI()
{
	ULONG ulProvString;
	
	// Try to get some information from provider string
	if( GetPropIndex(DBPROP_INIT_PROVIDERSTRING, &ulProvString ) )
	{
		WCHAR* lpwszOEM2ANSI = wcsstr( m_rgproperties[ulProvString].pwstrVal, L"OEM2ANSI" );
		if( lpwszOEM2ANSI != NULL )
			return true;
	}
	
	return false;
}


// Disable bound directories
bool CUtilProp::NoBound()
{
	ULONG ulProvString;
	
	// Try to get some information from provider string
	if( GetPropIndex(DBPROP_INIT_PROVIDERSTRING, &ulProvString ) )
	{
		WCHAR* lpwszNoBound = wcsstr( m_rgproperties[ulProvString].pwstrVal, L"NOBOUND" );
		if( lpwszNoBound != NULL )
			return true;
	}
	
	return false;
}

// Connected in MySQL mode?
bool CUtilProp::MySqlMode()
{
	return true;
}

/////
bool CUtilProp::not_cache_files_opening()
{
	ULONG ulProvString;

	// Try to get some information from provider string
	if( GetPropIndex(DBPROP_INIT_PROVIDERSTRING, &ulProvString ) )
	{
        if( wcsstr( m_rgproperties[ulProvString].pwstrVal, L"NOT_CACHE_FILES_OPENING" ) ) {
            return true;
        }
    }
    return false;
}

// Version of internal sql support to be used
InternalSqlSupportVersions CUtilProp::InternalSqlSupport()
{
	return MySqlMode() ? ISS_MYSQL : ISS_WRONG;
}