<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 encoding=utf-8: */
// +----------------------------------------------------------------------+
// | Eventum - Issue Tracking System                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2003, 2004, 2005, 2006, 2007 MySQL AB                              |
// |                                                                      |
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// |                                                                      |
// | This program is distributed in the hope that it will be useful,      |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        |
// | GNU General Public License for more details.                         |
// |                                                                      |
// | You should have received a copy of the GNU General Public License    |
// | along with this program; if not, write to:                           |
// |                                                                      |
// | Free Software Foundation, Inc.                                       |
// | 59 Temple Place - Suite 330                                          |
// | Boston, MA 02111-1307, USA.                                          |
// +----------------------------------------------------------------------+
// | Authors: Bryan Alsdorf <bryan@mysql.com>                             |
// +----------------------------------------------------------------------+
//
require_once(dirname(__FILE__) . "/../init.php");
require_once(APP_INC_PATH . "class.template.php");
require_once(APP_INC_PATH . "class.auth.php");
require_once(APP_INC_PATH . "class.report.php");
require_once(APP_INC_PATH . "class.date.php");
require_once(APP_INC_PATH . "db_access.php");

$tpl = new Template_API();
$tpl->setTemplate("reports/weekly.tpl.html");

Auth::checkAuthentication(APP_COOKIE);

if (Auth::getCurrentRole() <= User::getRoleID("Customer")) {
    echo "Invalid role";
    exit;
}

$prj_id = Auth::getCurrentProject();

if (count(@$_POST["start"]) > 0 &&
        (@$_POST["start"]["Year"] != 0) &&
        (@$_POST["start"]["Month"] != 0) &&
        (@$_POST["start"]["Day"] != 0)) {
    $start_date = join("-", $_POST["start"]);
}
if (count(@$_POST["end"]) > 0 &&
        (@$_POST["end"]["Year"] != 0) &&
        (@$_POST["end"]["Month"] != 0) &&
        (@$_POST["end"]["Day"] != 0)) {
    $end_date = join("-", $_POST["end"]);
}

$tpl->assign(array(
    "weeks" => Date_API::getWeekOptions(3,0),
    "users" => Project::getUserAssocList($prj_id, 'active', User::getRoleID('Customer')),
    "start_date"    =>  @$start_date,
    "end_date"      =>  @$end_date,
    "report_type"   =>  @$_POST["report_type"]
));

if (!empty($_POST["developer"])) {

    //split date up
    if (@$_POST["report_type"] == "weekly") {
        $dates = explode("_", $_POST["week"]);
    } else {
        $dates = array($start_date, $end_date);
    }

    // print out emails
    $data = Report::getWeeklyReport($_POST["developer"], $dates[0], $dates[1], @$_REQUEST['separate_closed'], @$_REQUEST['ignore_statuses']);
    $tpl->assign("data", $data);
}

if (empty($_POST["week"])) {
    $tpl->assign("week", Date_API::getCurrentWeek());
} else {
    $tpl->assign("week", $_POST["week"]);
}
if (empty($_POST["developer"])) {
    $tpl->assign("developer", Auth::getUserID());
} else {
    $tpl->assign("developer", $_POST["developer"]);
}

$tpl->displayTemplate();
