/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AbstractAttributedCompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public abstract class AbstractDrawing
extends AbstractAttributedCompositeFigure
implements Drawing {
    private static final Object lock = new JPanel().getTreeLock();
    private transient FontRenderContext fontRenderContext;
    private LinkedList<InputFormat> inputFormats = new LinkedList();
    private LinkedList<OutputFormat> outputFormats = new LinkedList();
    private static final boolean DEBUG = false;

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(UndoableEditListener.class, undoableEditListener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(UndoableEditListener.class, undoableEditListener);
    }

    @Override
    public void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        UndoableEditEvent undoableEditEvent = null;
        if (this.listenerList.getListenerCount() > 0) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (undoableEditEvent == null) {
                    undoableEditEvent = new UndoableEditEvent(this, undoableEdit);
                }
                if (objectArray[i] != UndoableEditListener.class) continue;
                ((UndoableEditListener)objectArray[i + 1]).undoableEditHappened(undoableEditEvent);
            }
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public void setFontRenderContext(FontRenderContext fontRenderContext) {
        this.fontRenderContext = fontRenderContext;
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        dOMInput.openElement("figures");
        for (int i = 0; i < dOMInput.getElementCount(); ++i) {
            Figure figure = (Figure)dOMInput.readObject(i);
            this.add(figure);
        }
        dOMInput.closeElement();
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        dOMOutput.openElement("figures");
        for (Figure figure : this.getChildren()) {
            dOMOutput.writeObject(figure);
        }
        dOMOutput.closeElement();
    }

    @Override
    public Object getLock() {
        return lock;
    }

    @Override
    public void addInputFormat(InputFormat inputFormat) {
        this.inputFormats.add(inputFormat);
    }

    @Override
    public void addOutputFormat(OutputFormat outputFormat) {
        this.outputFormats.add(outputFormat);
    }

    @Override
    public void setOutputFormats(List<OutputFormat> list) {
        this.outputFormats = new LinkedList<OutputFormat>(list);
    }

    @Override
    public void setInputFormats(List<InputFormat> list) {
        this.inputFormats = new LinkedList<InputFormat>(list);
    }

    @Override
    public List<InputFormat> getInputFormats() {
        return this.inputFormats;
    }

    @Override
    public List<OutputFormat> getOutputFormats() {
        return this.outputFormats;
    }

    @Override
    public Drawing getDrawing() {
        return this;
    }

    @Override
    public AbstractDrawing clone() {
        AbstractDrawing abstractDrawing = (AbstractDrawing)super.clone();
        abstractDrawing.inputFormats = this.inputFormats == null ? null : (LinkedList)this.inputFormats.clone();
        abstractDrawing.outputFormats = this.outputFormats == null ? null : (LinkedList)this.outputFormats.clone();
        return abstractDrawing;
    }
}

