/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.internal.EC2MetadataClient;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceProfileCredentialsProvider
implements AWSCredentialsProvider {
    private static final Log LOG = LogFactory.getLog(InstanceProfileCredentialsProvider.class);
    private static final int REFRESH_THRESHOLD = 3600000;
    private static final int EXPIRATION_THRESHOLD = 900000;
    private static final String ACCESS_KEY_ID = "AccessKeyId";
    private static final String SECRET_ACCESS_KEY = "SecretAccessKey";
    private static final String TOKEN = "Token";
    private static final int ASYNC_REFRESH_INTERVAL_TIME_MINUTES = 1;
    protected volatile AWSCredentials credentials;
    protected volatile Date credentialsExpiration;
    protected volatile Date lastInstanceProfileCheck;
    private volatile ScheduledExecutorService executor;

    public InstanceProfileCredentialsProvider() {
        this(false);
    }

    public InstanceProfileCredentialsProvider(boolean refreshCredentialsAsync) {
        if (refreshCredentialsAsync) {
            this.executor = Executors.newScheduledThreadPool(1);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        InstanceProfileCredentialsProvider.this.getCredentials();
                    }
                    catch (AmazonClientException ace) {
                        InstanceProfileCredentialsProvider.this.handleError(ace);
                    }
                    catch (RuntimeException re) {
                        InstanceProfileCredentialsProvider.this.handleError(re);
                    }
                    catch (Error e) {
                        InstanceProfileCredentialsProvider.this.handleError(e);
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
    }

    private void handleError(Throwable t) {
        this.credentials = null;
        LOG.error((Object)t.getMessage(), t);
    }

    public AWSCredentials getCredentials() {
        if (this.needsToLoadCredentials()) {
            this.loadCredentials();
        }
        if (this.expired()) {
            throw new AmazonClientException("The credentials received from the Amazon EC2 metadata service have expired");
        }
        return this.credentials;
    }

    public void refresh() {
        this.credentials = null;
    }

    protected boolean needsToLoadCredentials() {
        if (this.credentials == null) {
            return true;
        }
        if (this.credentialsExpiration != null && this.isWithinExpirationThreshold()) {
            return true;
        }
        return this.lastInstanceProfileCheck != null && this.isPastRefreshThreshold();
    }

    private boolean isWithinExpirationThreshold() {
        return this.credentialsExpiration.getTime() - System.currentTimeMillis() < 900000L;
    }

    private boolean isPastRefreshThreshold() {
        return System.currentTimeMillis() - this.lastInstanceProfileCheck.getTime() > 3600000L;
    }

    private boolean expired() {
        return this.credentialsExpiration != null && this.credentialsExpiration.getTime() < System.currentTimeMillis();
    }

    private synchronized void loadCredentials() {
        if (!this.needsToLoadCredentials()) {
            return;
        }
        try {
            this.lastInstanceProfileCheck = new Date();
            String credentialsResponse = new EC2MetadataClient().getDefaultCredentials();
            JsonNode node = Jackson.jsonNodeOf(credentialsResponse);
            JsonNode accessKey = node.get(ACCESS_KEY_ID);
            JsonNode secretKey = node.get(SECRET_ACCESS_KEY);
            JsonNode token = node.get(TOKEN);
            if (null == accessKey || null == secretKey) {
                throw new AmazonClientException("Unable to load credentials.");
            }
            this.credentials = null != token ? new BasicSessionCredentials(accessKey.asText(), secretKey.asText(), token.asText()) : new BasicAWSCredentials(accessKey.asText(), secretKey.asText());
            JsonNode expirationJsonNode = node.get("Expiration");
            if (null != expirationJsonNode) {
                String expiration = expirationJsonNode.asText();
                expiration = expiration.replaceAll("\\+0000$", "Z");
                try {
                    this.credentialsExpiration = DateUtils.parseISO8601Date(expiration);
                }
                catch (Exception ex) {
                    this.handleError("Unable to parse credentials expiration date from Amazon EC2 metadata service", ex);
                }
            }
        }
        catch (JsonMappingException e) {
            this.handleError("Unable to parse credentials from Amazon EC2 metadata service", (Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleError("Unable to load credentials from Amazon EC2 metadata service", e);
        }
    }

    private void handleError(String errorMessage, Exception e) {
        if (this.credentials == null || this.expired()) {
            throw new AmazonClientException(errorMessage, e);
        }
        LOG.debug((Object)errorMessage, (Throwable)e);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected void finalize() throws Throwable {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

