/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.utils;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OldApiTest
extends TestCase {
    static /* synthetic */ Class class$org$apache$xml$security$test$utils$OldApiTest$OldTransform;
    static /* synthetic */ Class class$org$apache$xml$security$test$utils$OldApiTest$OldResourceResolverSpi;
    static /* synthetic */ Class class$org$apache$xml$security$test$utils$OldApiTest$OldKeyResolverSpi;

    public void testOldTransformSpiApi() throws Exception {
        Transform transform;
        Init.init();
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Transform.register((String)"old", (String)(class$org$apache$xml$security$test$utils$OldApiTest$OldTransform == null ? (class$org$apache$xml$security$test$utils$OldApiTest$OldTransform = OldApiTest.class$("org.apache.xml.security.test.utils.OldApiTest$OldTransform")) : class$org$apache$xml$security$test$utils$OldApiTest$OldTransform).getName());
        OldTransform.compare = transform = new Transform(document, "old", null);
        transform.performTransform(null);
    }

    public void testOldResourceResolverSpi() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Attr attr = document.createAttribute("id");
        attr.setNodeValue("!!!test=1");
        document.createElement("test").setAttributeNode(attr);
        Attr attr2 = document.createAttribute("id");
        attr2.setNodeValue("!!!test=2");
        document.createElement("test1").setAttributeNode(attr2);
        ResourceResolver.registerAtStart((String)(class$org$apache$xml$security$test$utils$OldApiTest$OldResourceResolverSpi == null ? (class$org$apache$xml$security$test$utils$OldApiTest$OldResourceResolverSpi = OldApiTest.class$("org.apache.xml.security.test.utils.OldApiTest$OldResourceResolverSpi")) : class$org$apache$xml$security$test$utils$OldApiTest$OldResourceResolverSpi).getName());
        ResourceResolver resourceResolver = ResourceResolver.getInstance((Attr)attr, (String)"test");
        ResourceResolver resourceResolver2 = ResourceResolver.getInstance((Attr)attr2, (String)"test1");
        ResourceResolver resourceResolver3 = ResourceResolver.getInstance((Attr)attr2, (String)"test2");
        resourceResolver3.resolve(attr2, "test2");
        resourceResolver.resolve(attr, "test");
        resourceResolver2.resolve(attr2, "test1");
    }

    public void testOldKeyResolverSpi() throws Exception {
        KeyResolver.register((String)(class$org$apache$xml$security$test$utils$OldApiTest$OldKeyResolverSpi == null ? (class$org$apache$xml$security$test$utils$OldApiTest$OldKeyResolverSpi = OldApiTest.class$("org.apache.xml.security.test.utils.OldApiTest$OldKeyResolverSpi")) : class$org$apache$xml$security$test$utils$OldApiTest$OldKeyResolverSpi).getName());
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("test");
        PublicKey publicKey = KeyResolver.getPublicKey((Element)element, (String)"!!!testUri", null);
        OldApiTest.assertNotNull((Object)publicKey);
        OldApiTest.assertTrue((boolean)(publicKey instanceof PublicKeyMock));
        OldApiTest.assertEquals((int)2, (int)OldKeyResolverSpi.number);
        PublicKey publicKey2 = KeyResolver.getPublicKey((Element)element, (String)"!!!testUri", null);
        OldApiTest.assertNotSame((Object)publicKey, (Object)publicKey2);
        OldApiTest.assertEquals((int)3, (int)OldKeyResolverSpi.number);
    }

    public void testOldKeyResolverSpiInKeyInfo() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        element.appendChild(document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"));
        KeyInfo keyInfo = new KeyInfo(element, "!!!testUri");
        PublicKeyMock publicKeyMock = new PublicKeyMock();
        keyInfo.registerInternalKeyResolver((KeyResolverSpi)new OldKeyResolverNoPublicConsSpi(publicKeyMock));
        OldApiTest.assertNotNull((Object)keyInfo.getPublicKey());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class OldKeyResolverNoPublicConsSpi
    extends OldKeyResolverSpi {
        protected OldKeyResolverNoPublicConsSpi() {
        }

        public OldKeyResolverNoPublicConsSpi(PublicKey publicKey) {
            this.pk = publicKey;
        }
    }

    public static class OldKeyResolverSpi
    extends KeyResolverSpi {
        static int number = 0;
        PublicKey pk = null;

        public OldKeyResolverSpi() {
            ++number;
        }

        public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
            return "!!!testUri".equals(string);
        }

        public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
            if (this.pk == null) {
                this.pk = new PublicKeyMock();
            }
            return this.pk;
        }

        public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
            return null;
        }

        public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
            return null;
        }
    }

    static class PublicKeyMock
    implements PublicKey {
        PublicKeyMock() {
        }

        public String getAlgorithm() {
            return null;
        }

        public byte[] getEncoded() {
            return null;
        }

        public String getFormat() {
            return null;
        }
    }

    public static class OldResourceResolverSpi
    extends ResourceResolverSpi {
        Attr uriCompare;
        String baseCompare;

        public boolean engineCanResolve(Attr attr, String string) {
            if (attr.getValue().indexOf("!!!test=") != 0) {
                return false;
            }
            this.uriCompare = attr;
            this.baseCompare = string;
            return true;
        }

        public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
            Assert.assertEquals((Object)this.uriCompare, (Object)attr);
            Assert.assertEquals((String)this.baseCompare, (String)string);
            return null;
        }
    }

    public static class OldTransform
    extends TransformSpi {
        static Transform compare;

        protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException, ParserConfigurationException, SAXException {
            Assert.assertEquals((Object)compare, (Object)this._transformObject);
            return null;
        }

        protected String engineGetURI() {
            return null;
        }
    }
}

