/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class StorePasswdCmd
extends Command {
    private static final Logger log = Logger.getLogger(StorePasswdCmd.class.getName());
    protected String _newPassword;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private char[] newStorePasswordChars;

    StorePasswdCmd() {
    }

    public void setNew(String password) {
        this._newPassword = password;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setNewKeystorePassword(this._newPassword);
        if (Configuration.DEBUG) {
            log.fine("-storepasswd handler will use the following options:");
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        this.saveKeyStore(this.newStorePasswordChars);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("storepasswd", true);
        result.setHeader(Messages.getString("StorePasswdCmd.18"));
        result.setFooter(Messages.getString("StorePasswdCmd.17"));
        OptionGroup options = new OptionGroup(Messages.getString("StorePasswdCmd.16"));
        options.add(new Option("new", Messages.getString("StorePasswdCmd.15"), Messages.getString("StorePasswdCmd.8")){

            public void parsed(String argument) throws OptionException {
                StorePasswdCmd.this._newPassword = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("StorePasswdCmd.13"), Messages.getString("StorePasswdCmd.12")){

            public void parsed(String argument) throws OptionException {
                StorePasswdCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("StorePasswdCmd.11"), Messages.getString("StorePasswdCmd.10")){

            public void parsed(String argument) throws OptionException {
                StorePasswdCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("StorePasswdCmd.9"), Messages.getString("StorePasswdCmd.8")){

            public void parsed(String argument) throws OptionException {
                StorePasswdCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("StorePasswdCmd.7"), Messages.getString("StorePasswdCmd.6")){

            public void parsed(String argument) throws OptionException {
                StorePasswdCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("StorePasswdCmd.5")){

            public void parsed(String argument) throws OptionException {
                StorePasswdCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    protected void setNewKeystorePassword(String password) throws IOException, UnsupportedCallbackException {
        if (password != null) {
            this.newStorePasswordChars = password.toCharArray();
        } else {
            boolean ok = false;
            Callback[] prompts = new Callback[1];
            Callback[] errors = new Callback[1];
            int i = 0;
            while (i < 3) {
                if (this.prompt4NewPassword(this.getCallbackHandler(), prompts, errors)) {
                    ok = true;
                    break;
                }
                ++i;
            }
            if (!ok) {
                throw new SecurityException(Messages.getString("StorePasswdCmd.19"));
            }
        }
    }

    private boolean prompt4NewPassword(CallbackHandler handler, Callback[] prompts, Callback[] errors) throws IOException, UnsupportedCallbackException {
        String p = Messages.getString("StorePasswdCmd.20");
        PasswordCallback pcb = new PasswordCallback(p, false);
        prompts[0] = pcb;
        handler.handle(prompts);
        char[] pwd1 = pcb.getPassword();
        pcb.clearPassword();
        String ls = SystemProperties.getProperty((String)"line.separator");
        if (pwd1 == null || pwd1.length < 6) {
            String m = String.valueOf(Messages.getString("StorePasswdCmd.21")) + ls;
            errors[0] = new TextOutputCallback(2, m);
            handler.handle(errors);
            return false;
        }
        if (Arrays.equals(this.storePasswordChars, pwd1)) {
            String m = String.valueOf(Messages.getString("StorePasswdCmd.22")) + ls;
            errors[0] = new TextOutputCallback(2, m);
            handler.handle(errors);
            return false;
        }
        pcb = new PasswordCallback(Messages.getString("StorePasswdCmd.23"), false);
        prompts[0] = pcb;
        handler.handle(prompts);
        char[] pwd2 = pcb.getPassword();
        pcb.clearPassword();
        if (!Arrays.equals(pwd1, pwd2)) {
            String m = String.valueOf(Messages.getString("StorePasswdCmd.24")) + ls;
            errors[0] = new TextOutputCallback(2, m);
            handler.handle(errors);
            return false;
        }
        this.newStorePasswordChars = pwd2;
        return true;
    }
}

