/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractContext;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import java.lang.reflect.Array;

class ArrayContext
extends AbstractContext {
    private Object array;

    ArrayContext(String id, Class klass, int length) {
        this.setId(id);
        this.array = Array.newInstance(klass, length);
    }

    public void addParameterObject(Object o) throws AssemblyException {
        throw new AssemblyException(new IllegalStateException("Adding objects without an index to a fixed array is not possible."));
    }

    public void notifyStatement(Context outerContext) {
    }

    public Object endContext(Context outerContext) throws AssemblyException {
        return this.array;
    }

    public boolean subContextFailed() {
        return false;
    }

    public void set(int index, Object o) throws AssemblyException {
        try {
            Array.set(this.array, index, o);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new AssemblyException(aioobe);
        }
    }

    public Object get(int index) throws AssemblyException {
        try {
            return Array.get(this.array, index);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new AssemblyException(aioobe);
        }
    }

    public Object getResult() {
        return this.array;
    }
}

