/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientHelloV2
implements Constructed {
    private final ByteBuffer buffer;

    ClientHelloV2(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int length() {
        return 9 + this.cipherSpecsLength() + this.sessionIdLength() + this.challengeLength();
    }

    ProtocolVersion version() {
        return ProtocolVersion.getInstance(this.buffer.getShort(1));
    }

    int cipherSpecsLength() {
        return this.buffer.getShort(3) & 0xFFFF;
    }

    int sessionIdLength() {
        return this.buffer.getShort(5) & 0xFFFF;
    }

    int challengeLength() {
        return this.buffer.getShort(7) & 0xFFFF;
    }

    public List<CipherSuite> cipherSpecs() {
        int n = this.cipherSpecsLength();
        ArrayList<CipherSuite> l = new ArrayList<CipherSuite>(n / 3);
        ByteBuffer b = (ByteBuffer)this.buffer.duplicate().position(9);
        int i = 0;
        while (i < n) {
            if (b.get() == 0) {
                l.add(CipherSuite.forValue(b.getShort()).resolve());
            } else {
                b.getShort();
            }
            i += 3;
        }
        return l;
    }

    byte[] sessionId() {
        byte[] id = new byte[this.sessionIdLength()];
        ((ByteBuffer)this.buffer.duplicate().position(9 + this.cipherSpecsLength())).get(id);
        return id;
    }

    byte[] challenge() {
        byte[] challenge = new byte[this.challengeLength()];
        ((ByteBuffer)this.buffer.duplicate().position(9 + this.cipherSpecsLength() + this.sessionIdLength())).get(challenge);
        return challenge;
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("CLIENT-HELLO-MSG");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  version: ");
        out.println(this.version());
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  suites: ");
        out.println(this.cipherSpecs());
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  sessionId: ");
        out.println(Util.toHexString(this.sessionId(), ':'));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  challenge: ");
        out.println(Util.toHexString(this.challenge(), ':'));
        return str.toString();
    }
}

