/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.AttributeSet;
import javax.swing.text.EmptyAttributeSet;
import javax.swing.text.MutableAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAttributeSet
implements MutableAttributeSet,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8267656273837665219L;
    public static final AttributeSet EMPTY = new EmptyAttributeSet();
    Hashtable tab = new Hashtable();

    public SimpleAttributeSet() {
    }

    public SimpleAttributeSet(AttributeSet a) {
        this.addAttributes(a);
    }

    @Override
    public void addAttribute(Object name, Object value) {
        this.tab.put(name, value);
    }

    @Override
    public void addAttributes(AttributeSet attributes) {
        Enumeration<?> e = attributes.getAttributeNames();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            Object val = attributes.getAttribute(name);
            this.tab.put(name, val);
        }
    }

    public Object clone() {
        SimpleAttributeSet attr;
        block2: {
            attr = null;
            try {
                attr = (SimpleAttributeSet)super.clone();
                attr.tab = (Hashtable)this.tab.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return attr;
    }

    @Override
    public boolean containsAttribute(Object name, Object value) {
        if (value == null) {
            throw new NullPointerException("Null 'value' argument.");
        }
        if (this.tab.containsKey(name)) {
            return this.tab.get(name).equals(value);
        }
        AttributeSet p = this.getResolveParent();
        if (p != null) {
            return p.containsAttribute(name, value);
        }
        return false;
    }

    boolean containsAttributeLocally(Object name, Object value) {
        return this.tab.containsKey(name) && this.tab.get(name).equals(value);
    }

    @Override
    public boolean containsAttributes(AttributeSet attributes) {
        Enumeration<?> e = attributes.getAttributeNames();
        while (e.hasMoreElements()) {
            Object val;
            Object name = e.nextElement();
            if (this.containsAttribute(name, val = attributes.getAttribute(name))) continue;
            return false;
        }
        return true;
    }

    @Override
    public AttributeSet copyAttributes() {
        return (AttributeSet)this.clone();
    }

    public boolean equals(Object obj) {
        return obj instanceof AttributeSet && this.isEqual((AttributeSet)obj);
    }

    @Override
    public Object getAttribute(Object name) {
        Object val = this.tab.get(name);
        if (val != null) {
            return val;
        }
        AttributeSet p = this.getResolveParent();
        if (p != null) {
            return p.getAttribute(name);
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return this.tab.size();
    }

    @Override
    public Enumeration<?> getAttributeNames() {
        return this.tab.keys();
    }

    @Override
    public AttributeSet getResolveParent() {
        return (AttributeSet)this.tab.get(ResolveAttribute);
    }

    public int hashCode() {
        return this.tab.hashCode();
    }

    @Override
    public boolean isDefined(Object attrName) {
        return this.tab.containsKey(attrName);
    }

    public boolean isEmpty() {
        return this.tab.isEmpty();
    }

    @Override
    public boolean isEqual(AttributeSet attr) {
        return this.getAttributeCount() == attr.getAttributeCount() && this.containsAttributes(attr);
    }

    @Override
    public void removeAttribute(Object name) {
        this.tab.remove(name);
    }

    @Override
    public void removeAttributes(AttributeSet attributes) {
        Enumeration<?> e = attributes.getAttributeNames();
        while (e.hasMoreElements()) {
            Object val;
            Object name = e.nextElement();
            if (!this.containsAttributeLocally(name, val = attributes.getAttribute(name))) continue;
            this.removeAttribute(name);
        }
    }

    @Override
    public void removeAttributes(Enumeration<?> names) {
        while (names.hasMoreElements()) {
            this.removeAttribute(names.nextElement());
        }
    }

    @Override
    public void setResolveParent(AttributeSet parent) {
        this.addAttribute(ResolveAttribute, parent);
    }

    public String toString() {
        return this.tab.toString();
    }
}

