#!/bin/sh
export PATH='/usr/obj/ports/hs-text-1.2.1.3/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: text
version: 1.2.1.3
id: text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ
key: text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ
license: BSD3
copyright: 2009-2011 Bryan O'\''Sullivan, 2008-2009 Tom Harper
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
homepage: https://github.com/bos/text
synopsis: An efficient packed Unicode text type.
description:
    .
    An efficient packed, immutable Unicode text type (both strict and
    lazy), with a powerful loop fusion optimization framework.
    .
    The '\''Text'\'' type represents Unicode character strings, in a time and
    space-efficient manner. This package provides text processing
    capabilities that are optimized for performance critical use, both
    in terms of large data quantities and high speed.
    .
    The '\''Text'\'' type provides character-encoding, type-safe case
    conversion via whole-string case conversion functions. It also
    provides a range of functions for converting '\''Text'\'' values to and from
    '\''ByteStrings'\'', using several standard encodings.
    .
    Efficient locale-sensitive support for text IO is also supported.
    .
    These modules are intended to be imported qualified, to avoid name
    clashes with Prelude functions, e.g.
    .
    > import qualified Data.Text as T
    .
    To use an extended and very rich family of functions for working
    with Unicode text (including normalization, regular expressions,
    non-standard encodings, text breaking, and locales), see
    the @text-icu@ package:
    <http://hackage.haskell.org/package/text-icu>
category: Data, Text
author: Bryan O'\''Sullivan <bos@serpentine.com>
exposed: True
indefinite: False
exposed-modules:
    Data.Text Data.Text.Array Data.Text.Encoding
    Data.Text.Encoding.Error Data.Text.Foreign Data.Text.IO
    Data.Text.Internal Data.Text.Internal.Builder
    Data.Text.Internal.Builder.Functions
    Data.Text.Internal.Builder.Int.Digits
    Data.Text.Internal.Builder.RealFloat.Functions
    Data.Text.Internal.Encoding.Fusion
    Data.Text.Internal.Encoding.Fusion.Common
    Data.Text.Internal.Encoding.Utf16 Data.Text.Internal.Encoding.Utf32
    Data.Text.Internal.Encoding.Utf8 Data.Text.Internal.Functions
    Data.Text.Internal.Fusion Data.Text.Internal.Fusion.CaseMapping
    Data.Text.Internal.Fusion.Common Data.Text.Internal.Fusion.Size
    Data.Text.Internal.Fusion.Types Data.Text.Internal.IO
    Data.Text.Internal.Lazy Data.Text.Internal.Lazy.Encoding.Fusion
    Data.Text.Internal.Lazy.Fusion Data.Text.Internal.Lazy.Search
    Data.Text.Internal.Private Data.Text.Internal.Read
    Data.Text.Internal.Search Data.Text.Internal.Unsafe
    Data.Text.Internal.Unsafe.Char Data.Text.Internal.Unsafe.Shift
    Data.Text.Lazy Data.Text.Lazy.Builder Data.Text.Lazy.Builder.Int
    Data.Text.Lazy.Builder.RealFloat Data.Text.Lazy.Encoding
    Data.Text.Lazy.IO Data.Text.Lazy.Internal Data.Text.Lazy.Read
    Data.Text.Read Data.Text.Unsafe
hidden-modules: Data.Text.Show
abi: 1770d0eed701b97060e4e6e9b6dfec87
trusted: False
import-dirs: /usr/local/lib/ghc/text-1.2.1.3
library-dirs: /usr/local/lib/ghc/text-1.2.1.3
              /usr/local/lib/x86_64-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-text-1.2.1.3
hs-libraries: HStext-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ
depends:
    array-0.5.2.0 base-4.10.1.0 binary-0.8.5.1 deepseq-1.4.3.0
    ghc-prim-0.5.1.1 bytestring-0.10.8.2 integer-gmp-1.0.1.0
abi-depends: array-0.5.2.0=d7fc51366d56ae3c8ffbfbecc21590f7
             base-4.10.1.0=3319c96bc0bdd0e7df6bb89e8bc8756b
             binary-0.8.5.1=c8530945bfa5054e7bdb63b11ca62ee8
             deepseq-1.4.3.0=d8f37714cac2d8647374ccf1a4b2ba8a
             ghc-prim-0.5.1.1=c8f3d173544d1472727fce7b0518abda
             bytestring-0.10.8.2=96a37efba3f680a6fd96553c4173d263
             integer-gmp-1.0.1.0=9c3d9ccbdd7bdea277cdecf74e14db2b
haddock-interfaces: /usr/local/share/doc/hs-text-1.2.1.3/html/text.haddock
haddock-html: /usr/local/share/doc/hs-text-1.2.1.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

