/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;

public class OsmTileLoader
implements TileLoader {
    private static final ThreadPoolExecutor jobDispatcher = (ThreadPoolExecutor)Executors.newFixedThreadPool(8);
    public Map<String, String> headers = new HashMap<String, String>();
    public int timeoutConnect;
    public int timeoutRead;
    protected TileLoaderListener listener;

    public OsmTileLoader(TileLoaderListener listener) {
        this(listener, null);
    }

    public OsmTileLoader(TileLoaderListener listener, Map<String, String> headers) {
        this.headers.put("Accept", "text/html, image/png, image/jpeg, image/gif, */*");
        if (headers != null) {
            this.headers.putAll(headers);
        }
        this.listener = listener;
    }

    @Override
    public TileJob createTileLoaderJob(Tile tile) {
        return new OsmTileJob(tile);
    }

    protected URLConnection loadTileFromOsm(Tile tile) throws IOException {
        URL url = new URL(tile.getUrl());
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            this.prepareHttpUrlConnection((HttpURLConnection)urlConn);
        }
        return urlConn;
    }

    protected void loadTileMetadata(Tile tile, URLConnection urlConn) {
        Long lng;
        block8: {
            String str = urlConn.getHeaderField("X-VE-TILEMETA-CaptureDatesRange");
            if (str != null) {
                tile.putValue("capture-date", str);
            }
            if ((str = urlConn.getHeaderField("X-VE-Tile-Info")) != null) {
                tile.putValue("tile-info", str);
            }
            if ((lng = Long.valueOf(urlConn.getExpiration())).equals(0L)) {
                try {
                    str = urlConn.getHeaderField("Cache-Control");
                    if (str != null) {
                        for (String token : str.split(",")) {
                            if (!token.startsWith("max-age=")) continue;
                            lng = Long.parseLong(token.substring(8)) * 1000L + System.currentTimeMillis();
                        }
                    }
                }
                catch (NumberFormatException e) {
                    if (!JMapViewer.debug) break block8;
                    System.err.println(e.getMessage());
                }
            }
        }
        if (!lng.equals(0L)) {
            tile.putValue("expires", lng.toString());
        }
    }

    protected void prepareHttpUrlConnection(HttpURLConnection urlConn) {
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            urlConn.setRequestProperty(e.getKey(), e.getValue());
        }
        if (this.timeoutConnect != 0) {
            urlConn.setConnectTimeout(this.timeoutConnect);
        }
        if (this.timeoutRead != 0) {
            urlConn.setReadTimeout(this.timeoutRead);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean hasOutstandingTasks() {
        return jobDispatcher.getTaskCount() > jobDispatcher.getCompletedTaskCount();
    }

    @Override
    public void cancelOutstandingTasks() {
        jobDispatcher.getQueue().clear();
    }

    public static void setConcurrentConnections(int num) {
        jobDispatcher.setMaximumPoolSize(num);
    }

    private final class OsmTileJob
    implements TileJob {
        private final Tile tile;
        private InputStream input;
        private boolean force;

        private OsmTileJob(Tile tile) {
            this.tile = tile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Tile tile = this.tile;
            synchronized (tile) {
                if (this.tile.isLoaded() && !this.tile.hasError() || this.tile.isLoading()) {
                    return;
                }
                this.tile.loaded = false;
                this.tile.error = false;
                this.tile.loading = true;
            }
            try {
                URLConnection conn = OsmTileLoader.this.loadTileFromOsm(this.tile);
                if (this.force) {
                    conn.setUseCaches(false);
                }
                OsmTileLoader.this.loadTileMetadata(this.tile, conn);
                if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                    this.tile.setError("No tile at this zoom level");
                } else {
                    this.input = conn.getInputStream();
                    try {
                        this.tile.loadImage(this.input);
                    }
                    finally {
                        this.input.close();
                        this.input = null;
                    }
                }
                this.tile.setLoaded(true);
                OsmTileLoader.this.listener.tileLoadingFinished(this.tile, true);
            }
            catch (IOException e) {
                this.tile.setError(e.getMessage());
                OsmTileLoader.this.listener.tileLoadingFinished(this.tile, false);
                if (this.input == null) {
                    try {
                        System.err.println("Failed loading " + this.tile.getUrl() + ": " + e.getClass() + ": " + e.getMessage());
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            finally {
                this.tile.loading = false;
                this.tile.setLoaded(true);
            }
        }

        @Override
        public void submit() {
            this.submit(false);
        }

        @Override
        public void submit(boolean force) {
            this.force = force;
            jobDispatcher.execute(this);
        }
    }
}

