/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class AbstractProj
implements Proj {
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double MLFN_TOL = 1.0E-11;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;
    protected double en0;
    protected double en1;
    protected double en2;
    protected double en3;
    protected double en4;
    protected double e;
    protected double e2;
    protected boolean spherical;

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        CheckParameterUtil.ensureParameterNotNull(params, "params");
        CheckParameterUtil.ensureParameterNotNull(params.ellps, "params.ellps");
        this.e2 = params.ellps.e2;
        this.e = params.ellps.e;
        this.spherical = params.ellps.spherical;
        this.en0 = 1.0 - this.e2 * (0.25 + this.e2 * (0.046875 + this.e2 * (0.01953125 + this.e2 * 0.01068115234375)));
        this.en1 = this.e2 * (0.75 - this.e2 * (0.046875 + this.e2 * (0.01953125 + this.e2 * 0.01068115234375)));
        double t = this.e2 * this.e2;
        this.en2 = t * (0.46875 - this.e2 * (0.013020833333333334 + this.e2 * 0.007120768229166667));
        this.en3 = (t *= this.e2) * (0.3645833333333333 - this.e2 * 0.005696614583333333);
        this.en4 = t * this.e2 * 0.3076171875;
    }

    @Override
    public boolean isGeographic() {
        return false;
    }

    protected final double mlfn(double phi, double sphi, double cphi) {
        cphi *= sphi;
        sphi *= sphi;
        return this.en0 * phi - cphi * (this.en1 + sphi * (this.en2 + sphi * (this.en3 + sphi * this.en4)));
    }

    protected final double invMlfn(double arg) {
        double t;
        double k = 1.0 / (1.0 - this.e2);
        double phi = arg;
        int i = 15;
        do {
            if (--i < 0) {
                throw new IllegalStateException("Too many iterations");
            }
            double s = Math.sin(phi);
            t = 1.0 - this.e2 * s * s;
            t = (this.mlfn(phi, s, Math.cos(phi)) - arg) * (t * Math.sqrt(t)) * k;
            phi -= t;
        } while (!(Math.abs(t) < 1.0E-11));
        return phi;
    }

    final double cphi2(double ts) {
        double eccnth = 0.5 * this.e;
        double phi = 1.5707963267948966 - 2.0 * Math.atan(ts);
        for (int i = 0; i < 15; ++i) {
            double con = this.e * Math.sin(phi);
            double dphi = 1.5707963267948966 - 2.0 * Math.atan(ts * Math.pow((1.0 - con) / (1.0 + con), eccnth)) - phi;
            phi += dphi;
            if (!(Math.abs(dphi) <= 1.0E-10)) continue;
            return phi;
        }
        throw new IllegalStateException("no convergence for ts=" + ts);
    }

    final double msfn(double s, double c) {
        return c / Math.sqrt(1.0 - s * s * this.e2);
    }

    final double tsfn(double lat, double sinlat) {
        return Math.tan(0.5 * (1.5707963267948966 - lat)) / Math.pow((1.0 - (sinlat *= this.e)) / (1.0 + sinlat), 0.5 * this.e);
    }
}

