/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class Addresses
extends Test {
    protected static final int HOUSE_NUMBER_WITHOUT_STREET = 2601;
    protected static final int DUPLICATE_HOUSE_NUMBER = 2602;
    protected static final int MULTIPLE_STREET_NAMES = 2603;
    protected static final int MULTIPLE_STREET_RELATIONS = 2604;
    protected static final int HOUSE_NUMBER_TOO_FAR = 2605;
    protected static final String ADDR_HOUSE_NUMBER = "addr:housenumber";
    protected static final String ADDR_INTERPOLATION = "addr:interpolation";
    protected static final String ADDR_NEIGHBOURHOOD = "addr:neighbourhood";
    protected static final String ADDR_PLACE = "addr:place";
    protected static final String ADDR_STREET = "addr:street";
    protected static final String ASSOCIATED_STREET = "associatedStreet";

    public Addresses() {
        super(I18n.tr("Addresses", new Object[0]), I18n.tr("Checks for errors in addresses and associatedStreet relations.", new Object[0]));
    }

    protected List<Relation> getAndCheckAssociatedStreets(OsmPrimitive p) {
        List<Relation> list = OsmPrimitive.getFilteredList(p.getReferrers(), Relation.class);
        list.removeIf(r -> !r.hasTag("type", ASSOCIATED_STREET));
        if (list.size() > 1) {
            String name = list.get(0).get("name");
            Severity level = name == null || SubclassFilteredCollection.filter(list, r -> r.hasTag("name", name)).size() < list.size() ? Severity.WARNING : Severity.OTHER;
            ArrayList<Relation> errorList = new ArrayList<Relation>(list);
            errorList.add(0, (Relation)p);
            this.errors.add(TestError.builder(this, level, 2604).message(I18n.tr("Multiple associatedStreet relations", new Object[0])).primitives(errorList).build());
        }
        return list;
    }

    protected void checkHouseNumbersWithoutStreet(OsmPrimitive p) {
        List<Relation> associatedStreets = this.getAndCheckAssociatedStreets(p);
        if (p.hasKey(ADDR_HOUSE_NUMBER) && !p.hasKey(ADDR_STREET, ADDR_PLACE, ADDR_NEIGHBOURHOOD)) {
            for (Relation r : associatedStreets) {
                if (!r.hasTag("type", ASSOCIATED_STREET)) continue;
                return;
            }
            for (Way w : OsmPrimitive.getFilteredList(p.getReferrers(), Way.class)) {
                if (!w.hasKey(ADDR_INTERPOLATION) || !w.hasKey(ADDR_STREET)) continue;
                return;
            }
            this.errors.add(TestError.builder(this, Severity.WARNING, 2601).message(I18n.tr("House number without street", new Object[0])).primitives(p).build());
        }
    }

    @Override
    public void visit(Node n) {
        this.checkHouseNumbersWithoutStreet(n);
    }

    @Override
    public void visit(Way w) {
        this.checkHouseNumbersWithoutStreet(w);
    }

    @Override
    public void visit(Relation r) {
        this.checkHouseNumbersWithoutStreet(r);
        if (r.hasTag("type", ASSOCIATED_STREET)) {
            HashMap<String, ArrayList<OsmPrimitive>> map = new HashMap<String, ArrayList<OsmPrimitive>>();
            String relationName = r.get("name");
            HashSet<OsmPrimitive> wrongStreetNames = new HashSet<OsmPrimitive>();
            HashSet<OsmPrimitive> houses = new HashSet<OsmPrimitive>();
            HashSet<Way> street = new HashSet<Way>();
            for (RelationMember relationMember : r.getMembers()) {
                String role = relationMember.getRole();
                OsmPrimitive p = relationMember.getMember();
                if ("house".equals(role)) {
                    houses.add(p);
                    String number = p.get(ADDR_HOUSE_NUMBER);
                    if (number != null) {
                        ArrayList<OsmPrimitive> list = (ArrayList<OsmPrimitive>)map.get(number = number.trim().toUpperCase(Locale.ENGLISH));
                        if (list == null) {
                            list = new ArrayList<OsmPrimitive>();
                            map.put(number, list);
                        }
                        list.add(p);
                    }
                    if (relationName == null || !p.hasKey(ADDR_STREET) || relationName.equals(p.get(ADDR_STREET))) continue;
                    if (wrongStreetNames.isEmpty()) {
                        wrongStreetNames.add(r);
                    }
                    wrongStreetNames.add(p);
                    continue;
                }
                if (!"street".equals(role)) continue;
                if (p instanceof Way) {
                    street.add((Way)p);
                }
                if (relationName == null || !p.hasTagDifferent("name", relationName)) continue;
                if (wrongStreetNames.isEmpty()) {
                    wrongStreetNames.add(r);
                }
                wrongStreetNames.add(p);
            }
            for (Map.Entry entry : map.entrySet()) {
                List list = (List)entry.getValue();
                if (list.size() <= 1) continue;
                this.errors.add(TestError.builder(this, Severity.WARNING, 2602).message(I18n.tr("Duplicate house numbers", new Object[0]), I18n.marktr("House number ''{0}'' duplicated"), entry.getKey()).primitives(list).build());
            }
            if (!wrongStreetNames.isEmpty()) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 2603).message(I18n.tr("Multiple street names in relation", new Object[0])).primitives(wrongStreetNames).build());
            }
            if (!street.isEmpty()) {
                for (OsmPrimitive osmPrimitive : houses) {
                    if (!osmPrimitive.isUsable()) continue;
                    this.checkDistance(osmPrimitive, street);
                }
            }
        }
    }

    protected void checkDistance(OsmPrimitive house, Collection<Way> street) {
        EastNorth centroid;
        if (house instanceof Node) {
            centroid = ((Node)house).getEastNorth();
        } else if (house instanceof Way) {
            List<Node> nodes = ((Way)house).getNodes();
            if (house.hasKey(ADDR_INTERPOLATION)) {
                for (Node n : nodes) {
                    if (!n.hasKey(ADDR_HOUSE_NUMBER)) continue;
                    this.checkDistance(n, street);
                }
                return;
            }
            centroid = Geometry.getCentroid(nodes);
        } else {
            return;
        }
        if (centroid == null) {
            return;
        }
        double maxDistance = Config.getPref().getDouble("validator.addresses.max_street_distance", 200.0);
        boolean hasIncompleteWays = false;
        for (Way streetPart : street) {
            for (Pair<Node, Node> chunk : streetPart.getNodePairs(false)) {
                EastNorth p1 = ((Node)chunk.a).getEastNorth();
                EastNorth p2 = ((Node)chunk.b).getEastNorth();
                if (p1 != null && p2 != null) {
                    EastNorth closest = Geometry.closestPointToSegment(p1, p2, centroid);
                    if (!(closest.distance(centroid) <= maxDistance)) continue;
                    return;
                }
                Logging.warn("Addresses test skipped chunck " + chunk + " for street part " + streetPart + " because p1 or p2 is null");
            }
            if (hasIncompleteWays || !streetPart.isIncomplete()) continue;
            hasIncompleteWays = true;
        }
        if (hasIncompleteWays) {
            return;
        }
        ArrayList<Way> errorList = new ArrayList<Way>(street);
        errorList.add(0, (Way)house);
        this.errors.add(TestError.builder(this, Severity.WARNING, 2605).message(I18n.tr("House number too far from street", new Object[0])).primitives(errorList).build());
    }
}

