/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class PowerLines
extends Test {
    protected static final int POWER_LINES = 2501;
    static final Collection<String> POWER_LINE_TAGS = Arrays.asList("line", "minor_line");
    static final Collection<String> POWER_TOWER_TAGS = Arrays.asList("tower", "pole");
    static final Collection<String> POWER_STATION_TAGS = Arrays.asList("station", "sub_station", "substation", "plant", "generator");
    static final Collection<String> BUILDING_STATION_TAGS = Arrays.asList("transformer_tower");
    static final Collection<String> POWER_ALLOWED_TAGS = Arrays.asList("switch", "transformer", "busbar", "generator", "switchgear", "portal", "terminal", "insulator");
    private final List<TestError> potentialErrors = new ArrayList<TestError>();
    private final List<OsmPrimitive> powerStations = new ArrayList<OsmPrimitive>();

    public PowerLines() {
        super(I18n.tr("Power lines", new Object[0]), I18n.tr("Checks for nodes in power lines that do not have a power=tower/pole tag.", new Object[0]));
    }

    @Override
    public void visit(Way w) {
        if (w.isUsable()) {
            if (PowerLines.isPowerLine(w) && !w.hasTag("location", "underground")) {
                for (Node n : w.getNodes()) {
                    if (PowerLines.isPowerTower(n) || PowerLines.isPowerAllowed(n) || !IN_DOWNLOADED_AREA.test(n) || w.isFirstLastNode(n) && PowerLines.isPowerStation(n)) continue;
                    this.potentialErrors.add(TestError.builder(this, Severity.WARNING, 2501).message(I18n.tr("Missing power tower/pole within power line", new Object[0])).primitives(n).build());
                }
            } else if (w.isClosed() && PowerLines.isPowerStation(w)) {
                this.powerStations.add(w);
            }
        }
    }

    @Override
    public void visit(Relation r) {
        if (r.isMultipolygon() && PowerLines.isPowerStation(r)) {
            this.powerStations.add(r);
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.powerStations.clear();
        this.potentialErrors.clear();
    }

    @Override
    public void endTest() {
        for (TestError e : this.potentialErrors) {
            e.getPrimitives().stream().map(Node.class::cast).filter(n -> !this.isInPowerStation((Node)n)).findAny().ifPresent(ignore -> this.errors.add(e));
        }
        this.potentialErrors.clear();
        super.endTest();
    }

    protected final boolean isInPowerStation(Node n) {
        for (OsmPrimitive station : this.powerStations) {
            Multipolygon polygon;
            ArrayList<List<Node>> nodesLists = new ArrayList<List<Node>>();
            if (station instanceof Way) {
                nodesLists.add(((Way)station).getNodes());
            } else if (station instanceof Relation && (polygon = MultipolygonCache.getInstance().get((Relation)station)) != null) {
                for (Multipolygon.JoinedWay outer : Multipolygon.joinWays(polygon.getOuterWays())) {
                    nodesLists.add(outer.getNodes());
                }
            }
            for (List list : nodesLists) {
                if (!Geometry.nodeInsidePolygon(n, list)) continue;
                return true;
            }
        }
        return false;
    }

    protected static final boolean isPowerLine(Way w) {
        return PowerLines.isPowerIn(w, POWER_LINE_TAGS);
    }

    protected static final boolean isPowerStation(OsmPrimitive p) {
        return PowerLines.isPowerIn(p, POWER_STATION_TAGS) || PowerLines.isBuildingIn(p, BUILDING_STATION_TAGS);
    }

    protected static final boolean isPowerTower(Node n) {
        return PowerLines.isPowerIn(n, POWER_TOWER_TAGS);
    }

    protected static final boolean isPowerAllowed(Node n) {
        return PowerLines.isPowerIn(n, POWER_ALLOWED_TAGS);
    }

    private static boolean isPowerIn(OsmPrimitive p, Collection<String> values) {
        return p.hasTag("power", values);
    }

    private static boolean isBuildingIn(OsmPrimitive p, Collection<String> values) {
        return p.hasTag("building", values);
    }
}

