/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.tagging.TagTableColumnModelBuilder;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;

public class PasteTagsConflictResolverDialog
extends JDialog
implements PropertyChangeListener {
    static final Map<OsmPrimitiveType, String> PANE_TITLES = new EnumMap<OsmPrimitiveType, String>(OsmPrimitiveType.class);
    private final TagConflictResolverModel model = new TagConflictResolverModel();
    private final transient Map<OsmPrimitiveType, TagConflictResolver> resolvers = new EnumMap<OsmPrimitiveType, TagConflictResolver>(OsmPrimitiveType.class);
    private final JTabbedPane tpResolvers = new JTabbedPane();
    private Mode mode;
    private boolean canceled;
    private final ImageIcon iconResolved = ImageProvider.get("dialogs/conflict", "tagconflictresolved");
    private final ImageIcon iconUnresolved = ImageProvider.get("dialogs/conflict", "tagconflictunresolved");
    private final StatisticsTableModel statisticsModel = new StatisticsTableModel();
    private final JPanel pnlTagResolver = new JPanel(new BorderLayout());

    public PasteTagsConflictResolverDialog(Component owner) {
        super((Window)GuiHelper.getFrameForComponent(owner), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    protected final void build() {
        this.setTitle(I18n.tr("Conflicts in pasted tags", new Object[0]));
        for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
            TagConflictResolverModel tagModel = new TagConflictResolverModel();
            this.resolvers.put(type, new TagConflictResolver(tagModel));
            tagModel.addPropertyChangeListener(this);
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.mode = null;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.getContentPane().add((Component)this.buildSourceAndTargetInfoPanel(), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlTagResolver, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.getContentPane().add((Component)this.buildButtonPanel(), gc);
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        ApplyAction applyAction = new ApplyAction();
        this.model.addPropertyChangeListener(applyAction);
        for (TagConflictResolver r : this.resolvers.values()) {
            r.getModel().addPropertyChangeListener(applyAction);
        }
        pnl.add(new JButton(applyAction));
        CancelAction cancelAction = new CancelAction();
        pnl.add(new JButton(cancelAction));
        return pnl;
    }

    protected JPanel buildSourceAndTargetInfoPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)new StatisticsInfoTable(this.statisticsModel), "Center");
        return pnl;
    }

    protected void initResolver(OsmPrimitiveType type, TagCollection tc, Map<OsmPrimitiveType, Integer> targetStatistics) {
        TagConflictResolver resolver = this.resolvers.get((Object)type);
        resolver.getModel().populate(tc, tc.getKeysWithMultipleValues());
        resolver.getModel().prepareDefaultTagDecisions();
        if (!tc.isEmpty() && targetStatistics.get((Object)type) != null && targetStatistics.get((Object)type) > 0) {
            this.tpResolvers.add(PANE_TITLES.get((Object)type), resolver);
        }
    }

    public void populate(TagCollection tagsForAllPrimitives, Map<OsmPrimitiveType, Integer> sourceStatistics, Map<OsmPrimitiveType, Integer> targetStatistics) {
        this.mode = Mode.RESOLVING_ONE_TAGCOLLECTION_ONLY;
        tagsForAllPrimitives = tagsForAllPrimitives == null ? new TagCollection() : tagsForAllPrimitives;
        sourceStatistics = sourceStatistics == null ? new HashMap() : sourceStatistics;
        targetStatistics = targetStatistics == null ? new HashMap() : targetStatistics;
        this.model.populate(tagsForAllPrimitives, tagsForAllPrimitives.getKeysWithMultipleValues());
        this.model.prepareDefaultTagDecisions();
        this.pnlTagResolver.removeAll();
        this.pnlTagResolver.add((Component)new TagConflictResolver(this.model), "Center");
        this.statisticsModel.reset();
        StatisticsInfo info = new StatisticsInfo();
        info.numTags = tagsForAllPrimitives.getKeys().size();
        info.sourceInfo.putAll(sourceStatistics);
        info.targetInfo.putAll(targetStatistics);
        this.statisticsModel.append(info);
        this.validate();
    }

    protected int getNumResolverTabs() {
        return this.tpResolvers.getTabCount();
    }

    protected TagConflictResolver getResolver(int idx) {
        return (TagConflictResolver)this.tpResolvers.getComponentAt(idx);
    }

    public void populate(TagCollection tagsForNodes, TagCollection tagsForWays, TagCollection tagsForRelations, Map<OsmPrimitiveType, Integer> sourceStatistics, Map<OsmPrimitiveType, Integer> targetStatistics) {
        int numTargets;
        StatisticsInfo info;
        tagsForNodes = tagsForNodes == null ? new TagCollection() : tagsForNodes;
        tagsForWays = tagsForWays == null ? new TagCollection() : tagsForWays;
        TagCollection tagCollection = tagsForRelations = tagsForRelations == null ? new TagCollection() : tagsForRelations;
        if (tagsForNodes.isEmpty() && tagsForWays.isEmpty() && tagsForRelations.isEmpty()) {
            this.populate(null, null, null);
            return;
        }
        this.tpResolvers.removeAll();
        this.initResolver(OsmPrimitiveType.NODE, tagsForNodes, targetStatistics);
        this.initResolver(OsmPrimitiveType.WAY, tagsForWays, targetStatistics);
        this.initResolver(OsmPrimitiveType.RELATION, tagsForRelations, targetStatistics);
        this.pnlTagResolver.removeAll();
        this.pnlTagResolver.add((Component)this.tpResolvers, "Center");
        this.mode = Mode.RESOLVING_TYPED_TAGCOLLECTIONS;
        this.validate();
        this.statisticsModel.reset();
        if (!tagsForNodes.isEmpty()) {
            info = new StatisticsInfo();
            info.numTags = tagsForNodes.getKeys().size();
            int n = numTargets = targetStatistics.get((Object)OsmPrimitiveType.NODE) == null ? 0 : targetStatistics.get((Object)OsmPrimitiveType.NODE);
            if (numTargets > 0) {
                info.sourceInfo.put(OsmPrimitiveType.NODE, sourceStatistics.get((Object)OsmPrimitiveType.NODE));
                info.targetInfo.put(OsmPrimitiveType.NODE, numTargets);
                this.statisticsModel.append(info);
            }
        }
        if (!tagsForWays.isEmpty()) {
            info = new StatisticsInfo();
            info.numTags = tagsForWays.getKeys().size();
            int n = numTargets = targetStatistics.get((Object)OsmPrimitiveType.WAY) == null ? 0 : targetStatistics.get((Object)OsmPrimitiveType.WAY);
            if (numTargets > 0) {
                info.sourceInfo.put(OsmPrimitiveType.WAY, sourceStatistics.get((Object)OsmPrimitiveType.WAY));
                info.targetInfo.put(OsmPrimitiveType.WAY, numTargets);
                this.statisticsModel.append(info);
            }
        }
        if (!tagsForRelations.isEmpty()) {
            info = new StatisticsInfo();
            info.numTags = tagsForRelations.getKeys().size();
            int n = numTargets = targetStatistics.get((Object)OsmPrimitiveType.RELATION) == null ? 0 : targetStatistics.get((Object)OsmPrimitiveType.RELATION);
            if (numTargets > 0) {
                info.sourceInfo.put(OsmPrimitiveType.RELATION, sourceStatistics.get((Object)OsmPrimitiveType.RELATION));
                info.targetInfo.put(OsmPrimitiveType.RELATION, numTargets);
                this.statisticsModel.append(info);
            }
        }
        for (int i = 0; i < this.getNumResolverTabs(); ++i) {
            if (this.getResolver(i).getModel().isResolvedCompletely()) continue;
            this.tpResolvers.setSelectedIndex(i);
            break;
        }
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerOnScreen(new Dimension(600, 400))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public TagCollection getResolution() {
        return this.model.getResolution();
    }

    public TagCollection getResolution(OsmPrimitiveType type) {
        if (type == null) {
            return null;
        }
        return this.resolvers.get((Object)type).getModel().getResolution();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
            TagConflictResolverModel tagModel = (TagConflictResolverModel)evt.getSource();
            for (int i = 0; i < this.tpResolvers.getTabCount(); ++i) {
                TagConflictResolver resolver = (TagConflictResolver)this.tpResolvers.getComponentAt(i);
                if (tagModel != resolver.getModel()) continue;
                this.tpResolvers.setIconAt(i, (Integer)evt.getNewValue() == 0 ? this.iconResolved : this.iconUnresolved);
            }
        }
    }

    static {
        PANE_TITLES.put(OsmPrimitiveType.NODE, I18n.tr("Tags from nodes", new Object[0]));
        PANE_TITLES.put(OsmPrimitiveType.WAY, I18n.tr("Tags from ways", new Object[0]));
        PANE_TITLES.put(OsmPrimitiveType.RELATION, I18n.tr("Tags from relations", new Object[0]));
    }

    static final class StatisticsInfoTable
    extends JPanel {
        StatisticsInfoTable(StatisticsTableModel model) {
            JTable infoTable = new JTable(model, new TagTableColumnModelBuilder(new StatisticsInfoRenderer(), I18n.tr("Paste ...", new Object[0]), I18n.tr("From ...", new Object[0]), I18n.tr("To ...", new Object[0])).build());
            infoTable.setShowHorizontalLines(true);
            infoTable.setShowVerticalLines(false);
            infoTable.setEnabled(false);
            this.setLayout(new BorderLayout());
            this.add((Component)infoTable, "Center");
        }

        @Override
        public Insets getInsets() {
            Insets insets = super.getInsets();
            insets.bottom = 20;
            return insets;
        }
    }

    static final class StatisticsInfoRenderer
    extends JLabel
    implements TableCellRenderer {
        StatisticsInfoRenderer() {
        }

        private void reset() {
            this.setIcon(null);
            this.setText("");
            this.setFont(UIManager.getFont("Table.font"));
        }

        private void renderNumTags(StatisticsInfo info) {
            if (info == null) {
                return;
            }
            this.setText(I18n.trn("{0} tag", "{0} tags", info.numTags, info.numTags));
        }

        private void renderStatistics(Map<OsmPrimitiveType, Integer> stat) {
            if (stat == null) {
                return;
            }
            if (stat.isEmpty()) {
                return;
            }
            if (stat.size() == 1) {
                this.setIcon(ImageProvider.get(stat.keySet().iterator().next()));
            } else {
                this.setIcon(ImageProvider.get("data", "object"));
            }
            StringBuilder text = new StringBuilder();
            for (Map.Entry<OsmPrimitiveType, Integer> entry : stat.entrySet()) {
                String msg;
                int numPrimitives;
                OsmPrimitiveType type = entry.getKey();
                int n = numPrimitives = entry.getValue() == null ? 0 : entry.getValue();
                if (numPrimitives == 0) continue;
                switch (type) {
                    case NODE: {
                        msg = I18n.trn("{0} node", "{0} nodes", numPrimitives, numPrimitives);
                        break;
                    }
                    case WAY: {
                        msg = I18n.trn("{0} way", "{0} ways", numPrimitives, numPrimitives);
                        break;
                    }
                    case RELATION: {
                        msg = I18n.trn("{0} relation", "{0} relations", numPrimitives, numPrimitives);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (text.length() > 0) {
                    text.append(", ");
                }
                text.append(msg);
            }
            this.setText(text.toString());
        }

        private void renderFrom(StatisticsInfo info) {
            this.renderStatistics(info.sourceInfo);
        }

        private void renderTo(StatisticsInfo info) {
            this.renderStatistics(info.targetInfo);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.reset();
            if (value == null) {
                return this;
            }
            if (row == 0) {
                this.setFont(this.getFont().deriveFont(1));
                this.setText((String)value);
            } else {
                StatisticsInfo info = (StatisticsInfo)value;
                switch (column) {
                    case 0: {
                        this.renderNumTags(info);
                        break;
                    }
                    case 1: {
                        this.renderFrom(info);
                        break;
                    }
                    case 2: {
                        this.renderTo(info);
                        break;
                    }
                }
            }
            return this;
        }
    }

    static final class StatisticsTableModel
    extends DefaultTableModel {
        private static final String[] HEADERS = new String[]{I18n.tr("Paste ...", new Object[0]), I18n.tr("From ...", new Object[0]), I18n.tr("To ...", new Object[0])};
        private final transient List<StatisticsInfo> data = new ArrayList<StatisticsInfo>();

        StatisticsTableModel() {
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row == 0) {
                return HEADERS[column];
            }
            if (row - 1 < this.data.size()) {
                return this.data.get(row - 1);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 1 : this.data.size() + 1;
        }

        void reset() {
            this.data.clear();
        }

        void append(StatisticsInfo info) {
            this.data.add(info);
            this.fireTableDataChanged();
        }
    }

    static final class StatisticsInfo {
        int numTags;
        final Map<OsmPrimitiveType, Integer> sourceInfo = new EnumMap<OsmPrimitiveType, Integer>(OsmPrimitiveType.class);
        final Map<OsmPrimitiveType, Integer> targetInfo = new EnumMap<OsmPrimitiveType, Integer>(OsmPrimitiveType.class);

        StatisticsInfo() {
        }
    }

    final class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        private ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts", new Object[0]));
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PasteTagsConflictResolverDialog.this.setVisible(false);
        }

        void updateEnabledState() {
            if (PasteTagsConflictResolverDialog.this.mode == null) {
                this.setEnabled(false);
            } else if (PasteTagsConflictResolverDialog.this.mode.equals((Object)Mode.RESOLVING_ONE_TAGCOLLECTION_ONLY)) {
                this.setEnabled(PasteTagsConflictResolverDialog.this.model.isResolvedCompletely());
            } else {
                this.setEnabled(PasteTagsConflictResolverDialog.this.resolvers.values().stream().allMatch(val -> val.getModel().isResolvedCompletely()));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    final class CancelAction
    extends AbstractAction {
        private CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PasteTagsConflictResolverDialog.this.setVisible(false);
            PasteTagsConflictResolverDialog.this.setCanceled(true);
        }
    }

    static enum Mode {
        RESOLVING_ONE_TAGCOLLECTION_ONLY,
        RESOLVING_TYPED_TAGCOLLECTIONS;

    }
}

