/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTable;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

abstract class AddFromSelectionAction
extends AbstractRelationEditorAction {
    protected final SelectionTable selectionTable;
    protected final SelectionTableModel selectionTableModel;

    protected AddFromSelectionAction(MemberTable memberTable, MemberTableModel memberTableModel, SelectionTable selectionTable, SelectionTableModel selectionTableModel, String actionMapKey, OsmDataLayer layer, IRelationEditor editor) {
        super(memberTable, memberTableModel, actionMapKey, layer, editor);
        this.selectionTable = selectionTable;
        this.selectionTableModel = selectionTableModel;
    }

    protected boolean isPotentialDuplicate(OsmPrimitive primitive) {
        return this.memberTableModel.hasMembersReferringTo(Collections.singleton(primitive));
    }

    protected List<OsmPrimitive> filterConfirmedPrimitives(List<OsmPrimitive> primitives) throws GenericRelationEditor.AddAbortException {
        if (primitives == null || primitives.isEmpty()) {
            return primitives;
        }
        ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>();
        ConditionalOptionPaneUtil.startBulkOperation("add_primitive_to_relation");
        for (OsmPrimitive primitive : primitives) {
            if (primitive instanceof Relation && this.editor.getRelation() != null && this.editor.getRelation().equals(primitive)) {
                GenericRelationEditor.warnOfCircularReferences(primitive);
                continue;
            }
            if (this.isPotentialDuplicate(primitive)) {
                if (!GenericRelationEditor.confirmAddingPrimitive(primitive)) continue;
                ret.add(primitive);
                continue;
            }
            ret.add(primitive);
        }
        ConditionalOptionPaneUtil.endBulkOperation("add_primitive_to_relation");
        return ret;
    }
}

