/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.display.GPXSettingsPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CustomizeDrawingAction
extends AbstractAction
implements Layer.LayerAction,
Layer.MultiLayerAction {
    private transient List<Layer> layers;

    public CustomizeDrawingAction(List<Layer> l) {
        this();
        this.layers = l;
    }

    public CustomizeDrawingAction(Layer l) {
        this();
        this.layers = new LinkedList<Layer>();
        this.layers.add(l);
    }

    private CustomizeDrawingAction() {
        super(I18n.tr("Customize track drawing", new Object[0]));
        new ImageProvider("mapmode/addsegment").getResource().attachImageIcon(this, true);
        this.putValue("help", HelpUtil.ht("/Action/GPXLayerCustomizeLineDrawing"));
    }

    @Override
    public boolean supportLayers(List<Layer> layers) {
        for (Layer layer : layers) {
            if (layer instanceof GpxLayer) continue;
            return false;
        }
        return true;
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public Action getMultiLayerAction(List<Layer> layers) {
        return new CustomizeDrawingAction(layers);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int answer;
        boolean hasLocal = false;
        boolean hasNonlocal = false;
        for (Layer layer : this.layers) {
            if (!(layer instanceof GpxLayer)) continue;
            if (((GpxLayer)layer).isLocalFile()) {
                hasLocal = true;
                continue;
            }
            hasNonlocal = true;
        }
        GPXSettingsPanel panel = new GPXSettingsPanel(this.layers.get(0).getName(), hasLocal, hasNonlocal);
        JScrollPane scrollpane = GuiHelper.embedInVerticalScrollPane(panel);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        int screenHeight = GuiHelper.getScreenSize().height;
        if (screenHeight < 700) {
            scrollpane.setPreferredSize(new Dimension(panel.getPreferredSize().width, Math.min(panel.getPreferredSize().height, 450)));
        }
        if ((answer = JOptionPane.showConfirmDialog(Main.parent, scrollpane, I18n.tr("Customize track drawing", new Object[0]), 2, 3)) == 2 || answer == -1) {
            return;
        }
        for (Layer layer : this.layers) {
            boolean f = false;
            if (layer instanceof GpxLayer) {
                f = ((GpxLayer)layer).isLocalFile();
            }
            panel.savePreferences(layer.getName(), f);
        }
        MainApplication.getMap().repaint();
    }
}

