/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;

public class OsmChangeReader
extends OsmReader {
    private static final String[] ACTIONS = new String[]{"create", "modify", "delete"};

    protected OsmChangeReader() {
    }

    @Override
    protected void parseRoot() throws XMLStreamException {
        if ("osmChange".equals(this.parser.getLocalName())) {
            this.parseOsmChange();
        } else {
            this.parseUnknown();
        }
    }

    private void parseOsmChange() throws XMLStreamException {
        String v = this.parser.getAttributeValue(null, "version");
        if (v == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
        }
        if (!"0.6".equals(v)) {
            this.throwException(I18n.tr("Unsupported version: {0}", v));
        }
        this.ds.setVersion(v);
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (Arrays.asList(ACTIONS).contains(this.parser.getLocalName())) {
                    this.parseCommon(this.parser.getLocalName());
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (event != 2) continue;
            return;
        }
    }

    private void parseCommon(String action) throws XMLStreamException {
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                OsmPrimitive p = null;
                switch (this.parser.getLocalName()) {
                    case "node": {
                        p = this.parseNode();
                        break;
                    }
                    case "way": {
                        p = this.parseWay();
                        break;
                    }
                    case "relation": {
                        p = this.parseRelation();
                        break;
                    }
                    default: {
                        this.parseUnknown();
                    }
                }
                if (p == null || action == null) continue;
                if ("modify".equals(action)) {
                    p.setModified(true);
                    continue;
                }
                if (!"delete".equals(action)) continue;
                p.setDeleted(true);
                continue;
            }
            if (event != 2) continue;
            return;
        }
    }

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return new OsmChangeReader().doParseDataSet(source, progressMonitor);
    }
}

