# shell include script

KOPANO_LANG="${KOPANO_USERSCRIPT_LOCALE:-${LC_MESSAGES:-C}}"
PATH=$PATH:/usr/local/bin
export KOPANO_LANG PATH

if [ -z "${KOPANO_USER_SCRIPTS}" ] ; then
    exec >&2
    echo "Do not execute this script directly"
    exit 1
fi

if [ ! -d "${KOPANO_USER_SCRIPTS}" ] ; then
    exec >&2
    echo "${KOPANO_USER_SCRIPTS} does not exist or is not a directory"
    exit 1
fi

if [ -z "${KOPANO_USER}" -a -z "${KOPANO_STOREGUID}" ] ; then
    exec >&2
    echo "KOPANO_USER and KOPANO_STOREGUID is not set."
    exit 1
fi

# Find cannot cope with unreadable cwd
cd "$KOPANO_USER_SCRIPTS"
find "${KOPANO_USER_SCRIPTS}" -maxdepth 1 -type f -perm -u=x -and ! -name \*~ -and ! -name \#\* -and ! -name \*.rpm\* -and ! -name \*.bak -and ! -name \*.old -exec {} \;
