/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.apache.log4j.Logger;
import org.logstash.beats.Batch;
import org.logstash.beats.Message;
import org.logstash.beats.Protocol;

public class BeatsParser
extends ByteToMessageDecoder {
    private static final int CHUNK_SIZE = 1024;
    public static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new AfterburnerModule());
    private static final Logger logger = Logger.getLogger(BeatsParser.class);
    private Batch batch = new Batch();
    private States currentState = States.READ_HEADER;
    private int requiredBytes = 0;
    private int sequence = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!this.hasEnoughBytes(in)) {
            return;
        }
        block9 : switch (1.$SwitchMap$org$logstash$beats$BeatsParser$States[this.currentState.ordinal()]) {
            case 1: {
                BeatsParser.logger.debug((Object)"Running: READ_HEADER");
                currentVersion = in.readByte();
                if (Protocol.isVersion2(currentVersion)) {
                    BeatsParser.logger.debug((Object)"Frame version 2 detected");
                    this.batch.setProtocol((byte)50);
                } else {
                    BeatsParser.logger.debug((Object)"Frame version 1 detected");
                    this.batch.setProtocol((byte)49);
                }
                this.transition(States.READ_FRAME_TYPE);
                break;
            }
            case 2: {
                frameType = in.readByte();
                switch (frameType) {
                    case 87: {
                        this.transition(States.READ_WINDOW_SIZE);
                        break block9;
                    }
                    case 74: {
                        this.transition(States.READ_JSON_HEADER);
                        break block9;
                    }
                    case 67: {
                        this.transition(States.READ_COMPRESSED_FRAME_HEADER);
                        break block9;
                    }
                    case 68: {
                        this.transition(States.READ_DATA_FIELDS);
                        break block9;
                    }
                }
                throw new InvalidFrameProtocolException("Invalid Frame Type, received: " + frameType);
            }
            case 3: {
                BeatsParser.logger.debug((Object)"Running: READ_WINDOW_SIZE");
                this.batch.setBatchSize((int)in.readUnsignedInt());
                if (!this.batch.isEmpty()) {
                    BeatsParser.logger.warn((Object)"New window size received but the current batch was not complete, sending the current batch");
                    out.add(this.batch);
                    this.batchComplete();
                }
                this.transition(States.READ_HEADER);
                break;
            }
            case 4: {
                BeatsParser.logger.debug((Object)"Running: READ_DATA_FIELDS");
                this.sequence = (int)in.readUnsignedInt();
                fieldsCount = (int)in.readUnsignedInt();
                if (fieldsCount <= 0) {
                    throw new InvalidFrameProtocolException("Invalid number of fields, received: " + fieldsCount);
                }
                dataMap = new HashMap<String, String>(fieldsCount);
                for (count = 0; count < fieldsCount; ++count) {
                    fieldLength = (int)in.readUnsignedInt();
                    fieldBuf = in.readBytes(fieldLength);
                    field = fieldBuf.toString(Charset.forName("UTF8"));
                    fieldBuf.release();
                    dataLength = (int)in.readUnsignedInt();
                    dataBuf = in.readBytes(dataLength);
                    data = dataBuf.toString(Charset.forName("UTF8"));
                    dataBuf.release();
                    dataMap.put(field, data);
                }
                message = new Message(this.sequence, dataMap);
                this.batch.addMessage(message);
                if (this.batch.complete()) {
                    out.add(this.batch);
                    this.batchComplete();
                }
                this.transition(States.READ_HEADER);
                break;
            }
            case 5: {
                BeatsParser.logger.debug((Object)"Running: READ_JSON_HEADER");
                this.sequence = (int)in.readUnsignedInt();
                jsonPayloadSize = (int)in.readUnsignedInt();
                if (jsonPayloadSize <= 0) {
                    throw new InvalidFrameProtocolException("Invalid json length, received: " + jsonPayloadSize);
                }
                this.transition(States.READ_JSON, jsonPayloadSize);
                break;
            }
            case 6: {
                BeatsParser.logger.debug((Object)"Running: READ_COMPRESSED_FRAME_HEADER");
                this.transition(States.READ_COMPRESSED_FRAME, in.readInt());
                break;
            }
            case 7: {
                BeatsParser.logger.debug((Object)"Running: READ_COMPRESSED_FRAME");
                buffer = ctx.alloc().buffer(this.requiredBytes);
                buffOutput = new ByteBufOutputStream(buffer);
                var6_14 = null;
                inflater = new InflaterOutputStream((OutputStream)buffOutput, new Inflater());
                var8_21 = null;
                try {
                    bytesRead = in.readBytes((OutputStream)inflater, this.requiredBytes);
                    this.transition(States.READ_HEADER);
                    try {
                        while (buffer.readableBytes() > 0) {
                            this.decode(ctx, buffer, out);
                        }
                    }
                    finally {
                        buffer.release();
                    }
                }
                catch (Throwable var9_25) {
                    var8_21 = var9_25;
                    throw var9_25;
                }
                finally {
                    if (inflater != null) {
                        if (var8_21 != null) {
                            try {
                                inflater.close();
                            }
                            catch (Throwable var9_24) {
                                var8_21.addSuppressed(var9_24);
                            }
                        } else {
                            inflater.close();
                        }
                    }
                }
                if (buffOutput == null) break;
                if (var6_14 == null) ** GOTO lbl124
                try {
                    buffOutput.close();
                }
                catch (Throwable var7_18) {
                    var6_14.addSuppressed(var7_18);
                }
                break;
lbl124:
                // 1 sources

                buffOutput.close();
                break;
                catch (Throwable var7_19) {
                    try {
                        var6_14 = var7_19;
                        throw var7_19;
                    }
                    catch (Throwable var16_32) {
                        if (buffOutput != null) {
                            if (var6_14 != null) {
                                try {
                                    buffOutput.close();
                                }
                                catch (Throwable var17_33) {
                                    var6_14.addSuppressed(var17_33);
                                }
                            } else {
                                buffOutput.close();
                            }
                        }
                        throw var16_32;
                    }
                }
            }
            case 8: {
                BeatsParser.logger.debug((Object)"Running: READ_JSON");
                bytes = new byte[this.requiredBytes];
                in.readBytes(bytes);
                message = new Message(this.sequence, (Map)BeatsParser.MAPPER.readValue(bytes, Object.class));
                this.batch.addMessage(message);
                if (this.batch.size() == this.batch.getBatchSize()) {
                    BeatsParser.logger.debug((Object)("Sending batch size: " + this.batch.size() + ", windowSize: " + this.batch.getBatchSize() + " , seq: " + this.sequence));
                    out.add(this.batch);
                    this.batchComplete();
                }
                this.transition(States.READ_HEADER);
                break;
            }
        }
    }

    private boolean hasEnoughBytes(ByteBuf in) {
        return in.readableBytes() >= this.requiredBytes;
    }

    private void transition(States next) {
        this.transition(next, next.length);
    }

    private void transition(States nextState, int requiredBytes) {
        logger.debug((Object)("Transition, from: " + (Object)((Object)this.currentState) + ", to: " + (Object)((Object)nextState) + ", requiring " + requiredBytes + " bytes"));
        this.currentState = nextState;
        this.requiredBytes = requiredBytes;
    }

    private void batchComplete() {
        this.requiredBytes = 0;
        this.sequence = 0;
        this.batch = new Batch();
    }

    public class InvalidFrameProtocolException
    extends Exception {
        InvalidFrameProtocolException(String message) {
            super(message);
        }
    }

    private static enum States {
        READ_HEADER(1),
        READ_FRAME_TYPE(1),
        READ_WINDOW_SIZE(4),
        READ_JSON_HEADER(8),
        READ_COMPRESSED_FRAME_HEADER(4),
        READ_COMPRESSED_FRAME(-1),
        READ_JSON(-1),
        READ_DATA_FIELDS(-1);

        private int length;

        private States(int length) {
            this.length = length;
        }
    }
}

