/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.io.IOException;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.BooleanValue;
import org.msgpack.type.FloatValue;
import org.msgpack.type.IntegerValue;
import org.msgpack.type.MapValue;
import org.msgpack.type.RawValue;
import org.msgpack.type.Value;
import org.msgpack.unpacker.MessagePackBufferUnpacker;

public class RubyObjectUnpacker {
    private final MessagePack msgPack;

    public RubyObjectUnpacker(MessagePack messagePack) {
        this.msgPack = messagePack;
    }

    public IRubyObject unpack(RubyString rubyString, RubyHash rubyHash) throws IOException {
        return this.unpack(rubyString.getRuntime(), rubyString.getBytes(), new CompiledOptions(rubyString.getRuntime(), rubyHash));
    }

    public IRubyObject unpack(Ruby ruby, byte[] byArray) throws IOException {
        return this.unpack(ruby, byArray, new CompiledOptions(ruby, null));
    }

    public IRubyObject unpack(Ruby ruby, byte[] byArray, RubyHash rubyHash) throws IOException {
        return this.unpack(ruby, byArray, new CompiledOptions(ruby, rubyHash));
    }

    IRubyObject unpack(Ruby ruby, byte[] byArray, CompiledOptions compiledOptions) throws IOException {
        MessagePackBufferUnpacker messagePackBufferUnpacker = new MessagePackBufferUnpacker(this.msgPack);
        messagePackBufferUnpacker.wrap(byArray);
        return this.valueToRubyObject(ruby, messagePackBufferUnpacker.readValue(), compiledOptions);
    }

    IRubyObject valueToRubyObject(Ruby ruby, Value value, RubyHash rubyHash) throws IOException {
        return this.valueToRubyObject(ruby, value, new CompiledOptions(ruby, rubyHash));
    }

    IRubyObject valueToRubyObject(Ruby ruby, Value value, CompiledOptions compiledOptions) {
        switch (value.getType()) {
            case NIL: {
                return ruby.getNil();
            }
            case BOOLEAN: {
                return this.convert(ruby, value.asBooleanValue());
            }
            case INTEGER: {
                return this.convert(ruby, value.asIntegerValue());
            }
            case FLOAT: {
                return this.convert(ruby, value.asFloatValue());
            }
            case ARRAY: {
                return this.convert(ruby, value.asArrayValue(), compiledOptions);
            }
            case MAP: {
                return this.convert(ruby, value.asMapValue(), compiledOptions);
            }
            case RAW: {
                return this.convert(ruby, value.asRawValue(), compiledOptions);
            }
        }
        throw ruby.newArgumentError(String.format("Unexpected value: %s", value.toString()));
    }

    private IRubyObject convert(Ruby ruby, BooleanValue booleanValue) {
        return RubyBoolean.newBoolean((Ruby)ruby, (boolean)booleanValue.asBooleanValue().getBoolean());
    }

    private IRubyObject convert(Ruby ruby, IntegerValue integerValue) {
        IntegerValue integerValue2 = integerValue.asIntegerValue();
        try {
            return RubyFixnum.newFixnum((Ruby)ruby, (long)integerValue2.getLong());
        }
        catch (MessageTypeException messageTypeException) {
            return RubyBignum.newBignum((Ruby)ruby, (BigInteger)integerValue2.getBigInteger());
        }
    }

    private IRubyObject convert(Ruby ruby, FloatValue floatValue) {
        return RubyFloat.newFloat((Ruby)ruby, (double)floatValue.asFloatValue().getDouble());
    }

    private IRubyObject convert(Ruby ruby, ArrayValue arrayValue, CompiledOptions compiledOptions) {
        Value[] valueArray = arrayValue.asArrayValue().getElementArray();
        int n = valueArray.length;
        IRubyObject[] iRubyObjectArray = new IRubyObject[n];
        for (int i = 0; i < n; ++i) {
            iRubyObjectArray[i] = this.valueToRubyObject(ruby, valueArray[i], compiledOptions);
        }
        return RubyArray.newArray((Ruby)ruby, (IRubyObject[])iRubyObjectArray);
    }

    private IRubyObject convert(Ruby ruby, MapValue mapValue, CompiledOptions compiledOptions) {
        Value[] valueArray = mapValue.asMapValue().getKeyValueArray();
        int n = valueArray.length;
        RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
        for (int i = 0; i < n; i += 2) {
            Value value = valueArray[i];
            Value value2 = valueArray[i + 1];
            IRubyObject iRubyObject = this.valueToRubyObject(ruby, value, compiledOptions);
            IRubyObject iRubyObject2 = this.valueToRubyObject(ruby, value2, compiledOptions);
            if (compiledOptions.symbolizeKeys) {
                iRubyObject = ruby.newSymbol(iRubyObject.asString().getByteList());
            }
            rubyHash.put((Object)iRubyObject, (Object)iRubyObject2);
        }
        return rubyHash;
    }

    private IRubyObject convert(Ruby ruby, RawValue rawValue, CompiledOptions compiledOptions) {
        RubyString rubyString = RubyString.newStringNoCopy((Ruby)ruby, (byte[])rawValue.getByteArray());
        rubyString.setEncoding(compiledOptions.encoding);
        rubyString.callMethod(ruby.getCurrentContext(), "encode!");
        return rubyString;
    }

    static class CompiledOptions {
        public final boolean symbolizeKeys;
        public final Encoding encoding;

        public CompiledOptions(Ruby ruby) {
            this(ruby, null);
        }

        public CompiledOptions(Ruby ruby, RubyHash rubyHash) {
            EncodingService encodingService = ruby.getEncodingService();
            Encoding encoding = null;
            if (rubyHash == null) {
                this.symbolizeKeys = false;
            } else {
                ThreadContext threadContext = ruby.getCurrentContext();
                RubySymbol rubySymbol = ruby.newSymbol("symbolize_keys");
                IRubyObject iRubyObject = rubyHash.fastARef((IRubyObject)rubySymbol);
                this.symbolizeKeys = iRubyObject != null && iRubyObject.isTrue();
                IRubyObject iRubyObject2 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("encoding"));
                encoding = encodingService.getEncodingFromObject(iRubyObject2);
            }
            this.encoding = encoding != null ? encoding : ruby.getDefaultExternalEncoding();
        }
    }
}

