/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * clamp(dvec2(-2.0lf, -0.66666666666666674lf), -1.5lf, -1.5lf) => dvec2(-1.5lf, -1.5lf)
 * clamp(dvec2(0.66666666666666652lf, 2.0lf), -1.5lf, -1.5lf) => dvec2(-1.5lf, -1.5lf)
 * clamp(dvec2(-2.0lf, -0.66666666666666674lf), -1.5lf, 0.0lf) => dvec2(-1.5lf, -0.66666666666666674lf)
 * clamp(dvec2(0.66666666666666652lf, 2.0lf), -1.5lf, 0.0lf) => dvec2(0.0lf, 0.0lf)
 * clamp(dvec2(-2.0lf, -0.66666666666666674lf), -1.5lf, 1.5lf) => dvec2(-1.5lf, -0.66666666666666674lf)
 * clamp(dvec2(0.66666666666666652lf, 2.0lf), -1.5lf, 1.5lf) => dvec2(0.66666666666666652lf, 1.5lf)
 * clamp(dvec2(-2.0lf, -0.66666666666666674lf), 0.0lf, 0.0lf) => dvec2(0.0lf, 0.0lf)
 * clamp(dvec2(0.66666666666666652lf, 2.0lf), 0.0lf, 0.0lf) => dvec2(0.0lf, 0.0lf)
 * clamp(dvec2(-2.0lf, -0.66666666666666674lf), 0.0lf, 1.5lf) => dvec2(0.0lf, 0.0lf)
 * clamp(dvec2(0.66666666666666652lf, 2.0lf), 0.0lf, 1.5lf) => dvec2(0.66666666666666652lf, 1.5lf)
 * clamp(dvec2(-2.0lf, -0.66666666666666674lf), 1.5lf, 1.5lf) => dvec2(1.5lf, 1.5lf)
 * clamp(dvec2(0.66666666666666652lf, 2.0lf), 1.5lf, 1.5lf) => dvec2(1.5lf, 1.5lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(clamp(dvec2(-2.0lf, -0.66666666666666674lf), -1.5lf, -1.5lf), dvec2(-1.5lf, -1.5lf)) <= 2.1213203435596428e-05lf ? 1 : -1] array0;
  double[distance(clamp(dvec2(0.66666666666666652lf, 2.0lf), -1.5lf, -1.5lf), dvec2(-1.5lf, -1.5lf)) <= 2.1213203435596428e-05lf ? 1 : -1] array1;
  double[distance(clamp(dvec2(-2.0lf, -0.66666666666666674lf), -1.5lf, 0.0lf), dvec2(-1.5lf, -0.66666666666666674lf)) <= 1.6414763002993509e-05lf ? 1 : -1] array2;
  double[distance(clamp(dvec2(0.66666666666666652lf, 2.0lf), -1.5lf, 0.0lf), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array3;
  double[distance(clamp(dvec2(-2.0lf, -0.66666666666666674lf), -1.5lf, 1.5lf), dvec2(-1.5lf, -0.66666666666666674lf)) <= 1.6414763002993509e-05lf ? 1 : -1] array4;
  double[distance(clamp(dvec2(0.66666666666666652lf, 2.0lf), -1.5lf, 1.5lf), dvec2(0.66666666666666652lf, 1.5lf)) <= 1.6414763002993509e-05lf ? 1 : -1] array5;
  double[distance(clamp(dvec2(-2.0lf, -0.66666666666666674lf), 0.0lf, 0.0lf), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array6;
  double[distance(clamp(dvec2(0.66666666666666652lf, 2.0lf), 0.0lf, 0.0lf), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array7;
  double[distance(clamp(dvec2(-2.0lf, -0.66666666666666674lf), 0.0lf, 1.5lf), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array8;
  double[distance(clamp(dvec2(0.66666666666666652lf, 2.0lf), 0.0lf, 1.5lf), dvec2(0.66666666666666652lf, 1.5lf)) <= 1.6414763002993509e-05lf ? 1 : -1] array9;
  double[distance(clamp(dvec2(-2.0lf, -0.66666666666666674lf), 1.5lf, 1.5lf), dvec2(1.5lf, 1.5lf)) <= 2.1213203435596428e-05lf ? 1 : -1] array10;
  double[distance(clamp(dvec2(0.66666666666666652lf, 2.0lf), 1.5lf, 1.5lf), dvec2(1.5lf, 1.5lf)) <= 2.1213203435596428e-05lf ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
