/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * floor(-2.0lf) => -2.0lf
 * floor(-0.66666666666666674lf) => -1.0lf
 * floor(0.66666666666666652lf) => 0.0lf
 * floor(2.0lf) => 2.0lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(floor(-2.0lf), -2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array0;
  double[distance(floor(-0.66666666666666674lf), -1.0lf) <= 1.0000000000000001e-05lf ? 1 : -1] array1;
  double[distance(floor(0.66666666666666652lf), 0.0lf) <= 0.0lf ? 1 : -1] array2;
  double[distance(floor(2.0lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
