/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * length(0.0lf) => 0.0lf
 * length(-1.3333333333333333lf) => 1.3333333333333333lf
 * length(0.84999999999999998lf) => 0.84999999999999998lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(length(0.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array0;
  double[distance(length(-1.3333333333333333lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array1;
  double[distance(length(0.84999999999999998lf), 0.84999999999999998lf) <= 8.4999999999999999e-06lf ? 1 : -1] array2;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length());
}
