/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.10000000000000001lf, -1.2lf) / -1.3333333333333333lf) => dvec2(0.075000000000000011lf, 0.90000000000000002lf)
 * (dvec2(-0.10000000000000001lf, -1.2lf) / 0.84999999999999998lf) => dvec2(-0.11764705882352942lf, -1.411764705882353lf)
 * (dvec2(-0.41999999999999998lf, 0.47999999999999998lf) / -1.3333333333333333lf) => dvec2(0.315lf, -0.35999999999999999lf)
 * (dvec2(-0.41999999999999998lf, 0.47999999999999998lf) / 0.84999999999999998lf) => dvec2(-0.49411764705882355lf, 0.56470588235294117lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.10000000000000001lf, -1.2lf) / -1.3333333333333333lf), dvec2(0.075000000000000011lf, 0.90000000000000002lf)) <= 9.031195934094223e-06lf ? 1 : -1] array0;
  double[distance((dvec2(-0.10000000000000001lf, -1.2lf) / 0.84999999999999998lf), dvec2(-0.11764705882352942lf, -1.411764705882353lf)) <= 1.4166581857402703e-05lf ? 1 : -1] array1;
  double[distance((dvec2(-0.41999999999999998lf, 0.47999999999999998lf) / -1.3333333333333333lf), dvec2(0.315lf, -0.35999999999999999lf)) <= 4.7835656157305927e-06lf ? 1 : -1] array2;
  double[distance((dvec2(-0.41999999999999998lf, 0.47999999999999998lf) / 0.84999999999999998lf), dvec2(-0.49411764705882355lf, 0.56470588235294117lf)) <= 7.5036323384009302e-06lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
