/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * reflect(dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf), dvec3(-0.72482205962243684lf, -0.46207406300930354lf, -0.51099955203381797lf)) => dvec3(1.3333333333333328lf, 0.84999999999999976lf, 0.93999999999999972lf)
 * reflect(dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf), dvec3(0.64414939069124011lf, 0.25457401069234642lf, 0.72129303029498149lf)) => dvec3(0.92540125569077802lf, 0.042673550153241702lf, 1.5892417254341846lf)
 * reflect(dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf), dvec3(-0.72482205962243684lf, -0.46207406300930354lf, -0.51099955203381797lf)) => dvec3(-1.9120574029138164lf, -1.6235615943575579lf, -0.65535046905424066lf)
 * reflect(dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf), dvec3(0.64414939069124011lf, 0.25457401069234642lf, 0.72129303029498149lf)) => dvec3(-1.669999999999999lf, -0.65999999999999981lf, -1.8699999999999992lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(reflect(dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf), dvec3(-0.72482205962243684lf, -0.46207406300930354lf, -0.51099955203381797lf)), dvec3(1.3333333333333328lf, 0.84999999999999976lf, 0.93999999999999972lf)) <= 1.8395319452996122e-05lf ? 1 : -1] array0;
  double[distance(reflect(dvec3(-1.3333333333333333lf, -0.84999999999999998lf, -0.93999999999999995lf), dvec3(0.64414939069124011lf, 0.25457401069234642lf, 0.72129303029498149lf)), dvec3(0.92540125569077802lf, 0.042673550153241702lf, 1.5892417254341846lf)) <= 1.8395319452996122e-05lf ? 1 : -1] array1;
  double[distance(reflect(dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf), dvec3(-0.72482205962243684lf, -0.46207406300930354lf, -0.51099955203381797lf)), dvec3(-1.9120574029138164lf, -1.6235615943575579lf, -0.65535046905424066lf)) <= 2.592566296162935e-05lf ? 1 : -1] array2;
  double[distance(reflect(dvec3(1.6699999999999999lf, 0.66000000000000003lf, 1.8700000000000001lf), dvec3(0.64414939069124011lf, 0.25457401069234642lf, 0.72129303029498149lf)), dvec3(-1.669999999999999lf, -0.65999999999999981lf, -1.8699999999999992lf)) <= 2.592566296162934e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
