/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sign(-1.5lf) => -1.0lf
 * sign(-0.75lf) => -1.0lf
 * sign(0.0lf) => 0.0lf
 * sign(0.75lf) => 1.0lf
 * sign(1.5lf) => 1.0lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(sign(-1.5lf), -1.0lf) <= 1.0000000000000001e-05lf ? 1 : -1] array0;
  double[distance(sign(-0.75lf), -1.0lf) <= 1.0000000000000001e-05lf ? 1 : -1] array1;
  double[distance(sign(0.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array2;
  double[distance(sign(0.75lf), 1.0lf) <= 1.0000000000000001e-05lf ? 1 : -1] array3;
  double[distance(sign(1.5lf), 1.0lf) <= 1.0000000000000001e-05lf ? 1 : -1] array4;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
