/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(vec2(-1.5, -0.75)) => vec2(1.5, 0.75)
 * abs(vec2(0.0, 0.75)) => vec2(0.0, 0.75)
 * abs(vec2(1.5, -1.5)) => vec2(1.5, 1.5)
 */
#version 120

void main()
{
  float[distance(abs(vec2(-1.5, -0.75)), vec2(1.5, 0.75)) <= 1.6770509e-05 ? 1 : -1] array0;
  float[distance(abs(vec2(0.0, 0.75)), vec2(0.0, 0.75)) <= 7.4999998e-06 ? 1 : -1] array1;
  float[distance(abs(vec2(1.5, -1.5)), vec2(1.5, 1.5)) <= 2.1213204e-05 ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
