/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * log2(0.0099999998) => -6.643856
 * log2(0.67333335) => -0.57060719
 * log2(1.3366667) => 0.41863978
 * log2(2.0) => 1.0
 */
#version 120

void main()
{
  float[distance(log2(0.0099999998), -6.643856) <= 6.6438559e-05 ? 1 : -1] array0;
  float[distance(log2(0.67333335), -0.57060719) <= 5.706072e-06 ? 1 : -1] array1;
  float[distance(log2(1.3366667), 0.41863978) <= 4.1863977e-06 ? 1 : -1] array2;
  float[distance(log2(2.0), 1.0) <= 9.9999997e-06 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
