/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0 + 0.0) => 0.0
 * (0.0 + -1.33) => -1.33
 * (0.0 + 0.85000002) => 0.85000002
 * (-1.33 + 0.0) => -1.33
 * (-1.33 + -1.33) => -2.6600001
 * (-1.33 + 0.85000002) => -0.48000002
 * (0.85000002 + 0.0) => 0.85000002
 * (0.85000002 + -1.33) => -0.48000002
 * (0.85000002 + 0.85000002) => 1.7
 */
#version 120

void main()
{
  float[distance((0.0 + 0.0), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance((0.0 + -1.33), -1.33) <= 1.33e-05 ? 1 : -1] array1;
  float[distance((0.0 + 0.85000002), 0.85000002) <= 8.5000001e-06 ? 1 : -1] array2;
  float[distance((-1.33 + 0.0), -1.33) <= 1.33e-05 ? 1 : -1] array3;
  float[distance((-1.33 + -1.33), -2.6600001) <= 2.6600001e-05 ? 1 : -1] array4;
  float[distance((-1.33 + 0.85000002), -0.48000002) <= 4.8000002e-06 ? 1 : -1] array5;
  float[distance((0.85000002 + 0.0), 0.85000002) <= 8.5000001e-06 ? 1 : -1] array6;
  float[distance((0.85000002 + -1.33), -0.48000002) <= 4.8000002e-06 ? 1 : -1] array7;
  float[distance((0.85000002 + 0.85000002), 1.7) <= 1.7e-05 ? 1 : -1] array8;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
