/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0 / vec2(-0.1, -1.2)) => vec2(-0.0, -0.0)
 * (0.0 / vec2(-0.41999999, 0.47999999)) => vec2(-0.0, 0.0)
 * (-1.33 / vec2(-0.1, -1.2)) => vec2(13.3, 1.1083333)
 * (-1.33 / vec2(-0.41999999, 0.47999999)) => vec2(3.166667, -2.7708335)
 * (0.85000002 / vec2(-0.1, -1.2)) => vec2(-8.5, -0.70833331)
 * (0.85000002 / vec2(-0.41999999, 0.47999999)) => vec2(-2.0238097, 1.7708334)
 */
#version 120

void main()
{
  float[distance((0.0 / vec2(-0.1, -1.2)), vec2(-0.0, -0.0)) <= 0.0 ? 1 : -1] array0;
  float[distance((0.0 / vec2(-0.41999999, 0.47999999)), vec2(-0.0, 0.0)) <= 0.0 ? 1 : -1] array1;
  float[distance((-1.33 / vec2(-0.1, -1.2)), vec2(13.3, 1.1083333)) <= 0.00013346101 ? 1 : -1] array2;
  float[distance((-1.33 / vec2(-0.41999999, 0.47999999)), vec2(3.166667, -2.7708335)) <= 4.2077663e-05 ? 1 : -1] array3;
  float[distance((0.85000002 / vec2(-0.1, -1.2)), vec2(-8.5, -0.70833331)) <= 8.5294632e-05 ? 1 : -1] array4;
  float[distance((0.85000002 / vec2(-0.41999999, 0.47999999)), vec2(-2.0238097, 1.7708334)) <= 2.6891739e-05 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
